/*
 * Decompiled with CFR 0.152.
 */
package android.view;

import android.annotation.NonNull;
import android.annotation.Nullable;
import android.graphics.Point;
import android.graphics.Rect;
import android.os.CancellationSignal;
import android.os.IBinder;
import android.os.ICancellationSignal;
import android.os.RemoteException;
import android.os.Trace;
import android.util.CloseGuard;
import android.util.Log;
import android.view.IScrollCaptureCallbacks;
import android.view.IScrollCaptureConnection;
import android.view.ScrollCaptureCallback;
import android.view.ScrollCaptureSession;
import android.view.ScrollCaptureTarget;
import android.view.Surface;
import com.android.internal.annotations.VisibleForTesting;
import java.lang.ref.Reference;
import java.util.Objects;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Consumer;

public class ScrollCaptureConnection
extends IScrollCaptureConnection.Stub
implements IBinder.DeathRecipient {
    private static final String TAG = "ScrollCaptureConnection";
    private static final String TRACE_TRACK = "Scroll Capture";
    private static final String START_CAPTURE = "startCapture";
    private static final String REQUEST_IMAGE = "requestImage";
    private static final String END_CAPTURE = "endCapture";
    private static final String SESSION = "Session";
    private final Object mLock = new Object();
    private final Rect mScrollBounds;
    private final Point mPositionInWindow;
    private final Executor mUiThread;
    private final CloseGuard mCloseGuard = new CloseGuard();
    @Nullable
    private ScrollCaptureCallback mLocal;
    @Nullable
    private IScrollCaptureCallbacks mRemote;
    @Nullable
    private ScrollCaptureSession mSession;
    @Nullable
    private CancellationSignal mCancellation;
    private volatile boolean mActive;
    private volatile boolean mConnected;
    private int mTraceId;

    public ScrollCaptureConnection(@NonNull Executor uiThread, @NonNull ScrollCaptureTarget selectedTarget) {
        this.mUiThread = Objects.requireNonNull(uiThread, "<uiThread> must non-null");
        Objects.requireNonNull(selectedTarget, "<selectedTarget> must non-null");
        this.mScrollBounds = Objects.requireNonNull(Rect.copyOrNull(selectedTarget.getScrollBounds()), "target.getScrollBounds() must be non-null to construct a client");
        this.mLocal = selectedTarget.getCallback();
        this.mPositionInWindow = new Point(selectedTarget.getPositionInWindow());
    }

    @Override
    public ICancellationSignal startCapture(@NonNull Surface surface, @NonNull IScrollCaptureCallbacks remote) throws RemoteException {
        this.mTraceId = System.identityHashCode(surface);
        Trace.asyncTraceForTrackBegin(2L, TRACE_TRACK, SESSION, this.mTraceId);
        Trace.asyncTraceForTrackBegin(2L, TRACE_TRACK, START_CAPTURE, this.mTraceId);
        this.mCloseGuard.open("ScrollCaptureConnection.close");
        if (!surface.isValid()) {
            throw new RemoteException((Throwable)new IllegalArgumentException("surface must be valid"));
        }
        this.mRemote = Objects.requireNonNull(remote, "<callbacks> must non-null");
        this.mRemote.asBinder().linkToDeath(this, 0);
        this.mConnected = true;
        ICancellationSignal cancellation = CancellationSignal.createTransport();
        this.mCancellation = CancellationSignal.fromTransport(cancellation);
        this.mSession = new ScrollCaptureSession(surface, this.mScrollBounds, this.mPositionInWindow);
        Runnable listener = SafeCallback.create(this.mCancellation, this.mUiThread, this::onStartCaptureCompleted);
        this.mUiThread.execute(() -> {
            if (this.mLocal != null && this.mCancellation != null) {
                this.mLocal.onScrollCaptureStart(this.mSession, this.mCancellation, listener);
            }
        });
        return cancellation;
    }

    private void onStartCaptureCompleted() {
        this.mActive = true;
        try {
            if (this.mRemote != null) {
                this.mRemote.onCaptureStarted();
            } else {
                this.close();
            }
        }
        catch (RemoteException e) {
            Log.w(TAG, "Shutting down due to error: ", e);
            this.close();
        }
        this.mCancellation = null;
        Trace.asyncTraceForTrackEnd(2L, TRACE_TRACK, this.mTraceId);
    }

    @Override
    public ICancellationSignal requestImage(Rect requestRect) throws RemoteException {
        Trace.asyncTraceForTrackBegin(2L, TRACE_TRACK, REQUEST_IMAGE, this.mTraceId);
        this.checkActive();
        this.cancelPendingAction();
        ICancellationSignal cancellation = CancellationSignal.createTransport();
        this.mCancellation = CancellationSignal.fromTransport(cancellation);
        Consumer<Rect> listener = SafeCallback.create(this.mCancellation, this.mUiThread, this::onImageRequestCompleted);
        this.mUiThread.execute(() -> {
            if (this.mLocal != null && this.mSession != null && this.mCancellation != null) {
                this.mLocal.onScrollCaptureImageRequest(this.mSession, this.mCancellation, new Rect(requestRect), listener);
            }
        });
        return cancellation;
    }

    void onImageRequestCompleted(Rect capturedArea) {
        try {
            if (this.mRemote != null) {
                this.mRemote.onImageRequestCompleted(0, capturedArea);
            } else {
                this.close();
            }
        }
        catch (RemoteException e) {
            Log.w(TAG, "Shutting down due to error: ", e);
            this.close();
        }
        finally {
            this.mCancellation = null;
        }
        Trace.asyncTraceForTrackEnd(2L, TRACE_TRACK, this.mTraceId);
    }

    @Override
    public ICancellationSignal endCapture() throws RemoteException {
        Trace.asyncTraceForTrackBegin(2L, TRACE_TRACK, END_CAPTURE, this.mTraceId);
        this.checkActive();
        this.cancelPendingAction();
        ICancellationSignal cancellation = CancellationSignal.createTransport();
        this.mCancellation = CancellationSignal.fromTransport(cancellation);
        Runnable listener = SafeCallback.create(this.mCancellation, this.mUiThread, this::onEndCaptureCompleted);
        this.mUiThread.execute(() -> {
            if (this.mLocal != null) {
                this.mLocal.onScrollCaptureEnd(listener);
            }
        });
        return cancellation;
    }

    private void onEndCaptureCompleted() {
        this.mActive = false;
        try {
            if (this.mRemote != null) {
                this.mRemote.onCaptureEnded();
            }
        }
        catch (RemoteException e) {
            Log.w(TAG, "Caught exception confirming capture end!", e);
        }
        finally {
            this.mCancellation = null;
            this.close();
        }
        Trace.asyncTraceForTrackEnd(2L, TRACE_TRACK, this.mTraceId);
        Trace.asyncTraceForTrackEnd(2L, TRACE_TRACK, this.mTraceId);
    }

    @Override
    public void binderDied() {
        Trace.instantForTrack(2L, TRACE_TRACK, "binderDied");
        Log.e(TAG, "Controlling process just died.");
        this.close();
    }

    @Override
    public synchronized void close() {
        Trace.instantForTrack(2L, TRACE_TRACK, "close");
        if (this.mActive) {
            Log.w(TAG, "close(): capture session still active! Ending now.");
            this.cancelPendingAction();
            ScrollCaptureCallback callback = this.mLocal;
            this.mUiThread.execute(() -> {
                if (callback != null) {
                    callback.onScrollCaptureEnd(() -> {});
                }
            });
            this.mActive = false;
        }
        if (this.mRemote != null) {
            this.mRemote.asBinder().unlinkToDeath(this, 0);
        }
        this.mActive = false;
        this.mConnected = false;
        this.mSession = null;
        this.mRemote = null;
        this.mLocal = null;
        this.mCloseGuard.close();
        Trace.endSection();
        Reference.reachabilityFence(this);
    }

    private void cancelPendingAction() {
        if (this.mCancellation != null) {
            Trace.instantForTrack(2L, TRACE_TRACK, "CancellationSignal.cancel");
            Log.w(TAG, "cancelling pending operation.");
            this.mCancellation.cancel();
            this.mCancellation = null;
        }
    }

    @VisibleForTesting
    public boolean isConnected() {
        return this.mConnected;
    }

    @VisibleForTesting
    public boolean isActive() {
        return this.mActive;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkActive() throws RemoteException {
        Object object = this.mLock;
        synchronized (object) {
            if (!this.mActive) {
                throw new RemoteException((Throwable)new IllegalStateException("Not started!"));
            }
        }
    }

    public String toString() {
        return "ScrollCaptureConnection{active=" + this.mActive + ", session=" + this.mSession + ", remote=" + this.mRemote + ", local=" + this.mLocal + "}";
    }

    protected void finalize() throws Throwable {
        try {
            this.mCloseGuard.warnIfOpen();
            this.close();
        }
        finally {
            super.finalize();
        }
    }

    private static class SafeCallback<T> {
        private final CancellationSignal mSignal;
        private final Executor mExecutor;
        private final AtomicReference<T> mValue;

        protected SafeCallback(CancellationSignal signal, Executor executor, T value) {
            this.mSignal = signal;
            this.mValue = new AtomicReference<T>(value);
            this.mExecutor = executor;
        }

        protected void maybeAccept(Consumer<T> consumer) {
            Object value = this.mValue.getAndSet(null);
            if (this.mSignal.isCanceled()) {
                Log.w(ScrollCaptureConnection.TAG, "callback ignored, operation already cancelled");
                return;
            }
            if (value != null) {
                this.mExecutor.execute(() -> consumer.accept(value));
            } else {
                Log.w(ScrollCaptureConnection.TAG, "callback ignored, value already delivered");
            }
        }

        static Runnable create(CancellationSignal signal, Executor executor, Runnable target) {
            return new RunnableCallback(signal, executor, target);
        }

        static <T> Consumer<T> create(CancellationSignal signal, Executor executor, Consumer<T> target) {
            return new ConsumerCallback<T>(signal, executor, target);
        }
    }

    private static class ConsumerCallback<T>
    extends SafeCallback<Consumer<T>>
    implements Consumer<T> {
        ConsumerCallback(CancellationSignal signal, Executor executor, Consumer<T> target) {
            super(signal, executor, target);
        }

        @Override
        public void accept(T value) {
            this.maybeAccept(target -> target.accept(value));
        }
    }

    private static class RunnableCallback
    extends SafeCallback<Runnable>
    implements Runnable {
        RunnableCallback(CancellationSignal signal, Executor executor, Runnable target) {
            super(signal, executor, target);
        }

        @Override
        public void run() {
            this.maybeAccept(Runnable::run);
        }
    }
}

