/*
 * Decompiled with CFR 0.152.
 */
package android.uwb;

import android.annotation.NonNull;
import android.annotation.Nullable;
import android.annotation.SystemApi;
import android.os.Parcel;
import android.os.Parcelable;
import java.util.Objects;

@SystemApi
public class UwbActivityEnergyInfo
implements Parcelable {
    private final long mTimeSinceBootMillis;
    private final int mStackState;
    private final long mControllerTxDurationMillis;
    private final long mControllerRxDurationMillis;
    private final long mControllerIdleDurationMillis;
    private final long mControllerWakeCount;
    @NonNull
    public static final Parcelable.Creator<UwbActivityEnergyInfo> CREATOR = new Parcelable.Creator<UwbActivityEnergyInfo>(){

        @Override
        public UwbActivityEnergyInfo createFromParcel(Parcel in) {
            Builder builder = new Builder();
            builder.setTimeSinceBootMillis(in.readLong());
            builder.setStackState(in.readInt());
            builder.setControllerTxDurationMillis(in.readLong());
            builder.setControllerRxDurationMillis(in.readLong());
            builder.setControllerIdleDurationMillis(in.readLong());
            builder.setControllerWakeCount(in.readLong());
            return builder.build();
        }

        public UwbActivityEnergyInfo[] newArray(int size) {
            return new UwbActivityEnergyInfo[size];
        }
    };

    private UwbActivityEnergyInfo(long timeSinceBootMillis, int stackState, long txDurationMillis, long rxDurationMillis, long idleDurationMillis, long wakeCount) {
        this.mTimeSinceBootMillis = timeSinceBootMillis;
        this.mStackState = stackState;
        this.mControllerTxDurationMillis = txDurationMillis;
        this.mControllerRxDurationMillis = rxDurationMillis;
        this.mControllerIdleDurationMillis = idleDurationMillis;
        this.mControllerWakeCount = wakeCount;
    }

    public boolean equals(@Nullable Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof UwbActivityEnergyInfo) {
            UwbActivityEnergyInfo other = (UwbActivityEnergyInfo)obj;
            return this.mTimeSinceBootMillis == other.getTimeSinceBootMillis() && this.mStackState == other.getStackState() && this.mControllerTxDurationMillis == other.getControllerTxDurationMillis() && this.mControllerRxDurationMillis == other.getControllerRxDurationMillis() && this.mControllerIdleDurationMillis == other.getControllerIdleDurationMillis() && this.mControllerWakeCount == other.getControllerWakeCount();
        }
        return false;
    }

    public int hashCode() {
        return Objects.hash(this.mTimeSinceBootMillis, this.mStackState, this.mControllerTxDurationMillis, this.mControllerRxDurationMillis, this.mControllerIdleDurationMillis, this.mControllerWakeCount);
    }

    public String toString() {
        return "UwbActivityEnergyInfo{ mTimeSinceBootMillis=" + this.mTimeSinceBootMillis + " mStackState=" + this.mStackState + " mControllerTxDurationMillis=" + this.mControllerTxDurationMillis + " mControllerRxDurationMillis=" + this.mControllerRxDurationMillis + " mControllerIdleDurationMillis=" + this.mControllerIdleDurationMillis + " mControllerWakeCount=" + this.mControllerWakeCount + " }";
    }

    @Override
    public void writeToParcel(@NonNull Parcel out, int flags) {
        out.writeLong(this.mTimeSinceBootMillis);
        out.writeInt(this.mStackState);
        out.writeLong(this.mControllerTxDurationMillis);
        out.writeLong(this.mControllerRxDurationMillis);
        out.writeLong(this.mControllerIdleDurationMillis);
        out.writeLong(this.mControllerWakeCount);
    }

    @Override
    public int describeContents() {
        return 0;
    }

    public long getTimeSinceBootMillis() {
        return this.mTimeSinceBootMillis;
    }

    public int getStackState() {
        return this.mStackState;
    }

    public long getControllerTxDurationMillis() {
        return this.mControllerTxDurationMillis;
    }

    public long getControllerRxDurationMillis() {
        return this.mControllerRxDurationMillis;
    }

    public long getControllerIdleDurationMillis() {
        return this.mControllerIdleDurationMillis;
    }

    public long getControllerWakeCount() {
        return this.mControllerWakeCount;
    }

    public static class Builder {
        private long mTimeSinceBootMillis = -1L;
        private int mStackState = -1;
        private long mControllerTxDurationMillis = -1L;
        private long mControllerRxDurationMillis = -1L;
        private long mControllerIdleDurationMillis = -1L;
        private long mControllerWakeCount = -1L;

        @NonNull
        public Builder setTimeSinceBootMillis(long timeSinceBootMillis) {
            if (timeSinceBootMillis < 0L) {
                throw new IllegalArgumentException("timeSinceBootMillis must be >= 0");
            }
            this.mTimeSinceBootMillis = timeSinceBootMillis;
            return this;
        }

        @NonNull
        public Builder setStackState(int stackState) {
            if (stackState != 0 && stackState != 1 && stackState != 2) {
                throw new IllegalArgumentException("invalid UWB stack state");
            }
            this.mStackState = stackState;
            return this;
        }

        @NonNull
        public Builder setControllerTxDurationMillis(long txDurationMillis) {
            if (txDurationMillis < 0L) {
                throw new IllegalArgumentException("txDurationMillis must be >= 0");
            }
            this.mControllerTxDurationMillis = txDurationMillis;
            return this;
        }

        @NonNull
        public Builder setControllerRxDurationMillis(long rxDurationMillis) {
            if (rxDurationMillis < 0L) {
                throw new IllegalArgumentException("rxDurationMillis must be >= 0");
            }
            this.mControllerRxDurationMillis = rxDurationMillis;
            return this;
        }

        @NonNull
        public Builder setControllerIdleDurationMillis(long idleDurationMillis) {
            if (idleDurationMillis < 0L) {
                throw new IllegalArgumentException("idleDurationMillis must be >= 0");
            }
            this.mControllerIdleDurationMillis = idleDurationMillis;
            return this;
        }

        @NonNull
        public Builder setControllerWakeCount(long wakeCount) {
            if (wakeCount < 0L) {
                throw new IllegalArgumentException("wakeCount must be >= 0");
            }
            this.mControllerWakeCount = wakeCount;
            return this;
        }

        @NonNull
        public UwbActivityEnergyInfo build() {
            if (this.mTimeSinceBootMillis < 0L) {
                throw new IllegalStateException("timeSinceBootMillis must be >= 0: " + this.mTimeSinceBootMillis);
            }
            if (this.mStackState != 0 && this.mStackState != 1 && this.mStackState != 2) {
                throw new IllegalStateException("invalid UWB stack state");
            }
            if (this.mControllerTxDurationMillis < 0L) {
                throw new IllegalStateException("txDurationMillis must be >= 0: " + this.mControllerTxDurationMillis);
            }
            if (this.mControllerRxDurationMillis < 0L) {
                throw new IllegalStateException("rxDurationMillis must be >= 0: " + this.mControllerRxDurationMillis);
            }
            if (this.mControllerIdleDurationMillis < 0L) {
                throw new IllegalStateException("idleDurationMillis must be >= 0: " + this.mControllerIdleDurationMillis);
            }
            if (this.mControllerWakeCount < 0L) {
                throw new IllegalStateException("wakeCount must be >= 0: " + this.mControllerWakeCount);
            }
            return new UwbActivityEnergyInfo(this.mTimeSinceBootMillis, this.mStackState, this.mControllerTxDurationMillis, this.mControllerRxDurationMillis, this.mControllerIdleDurationMillis, this.mControllerWakeCount);
        }
    }
}

