/*
 * Decompiled with CFR 0.152.
 */
package android.uwb;

import android.content.AttributionSource;
import android.os.Binder;
import android.os.IBinder;
import android.os.IInterface;
import android.os.Parcel;
import android.os.Parcelable;
import android.os.PersistableBundle;
import android.os.RemoteException;
import android.uwb.IChannelUsageCallback;
import android.uwb.IOnUwbActivityEnergyInfoListener;
import android.uwb.IUwbAdapterStateCallbacks;
import android.uwb.IUwbAdfProvisionStateCallbacks;
import android.uwb.IUwbOemExtensionCallback;
import android.uwb.IUwbRangingCallbacks;
import android.uwb.IUwbVendorUciCallback;
import android.uwb.LogicalLinkConnectionParams;
import android.uwb.LogicalLinkParams;
import android.uwb.SessionHandle;
import android.uwb.UwbAddress;
import java.util.ArrayList;
import java.util.List;

public interface IUwbAdapter
extends IInterface {
    public static final String DESCRIPTOR = "android.uwb.IUwbAdapter";
    public static final int RANGING_SESSION_OPEN_THRESHOLD_MS = 3000;
    public static final int RANGING_SESSION_START_THRESHOLD_MS = 3000;
    public static final int RANGING_SESSION_CLOSE_THRESHOLD_MS = 3000;
    public static final int RANGING_ROUNDS_UPDATE_DT_TAG_THRESHOLD_MS = 3000;
    public static final int SESSION_DATA_TRANSFER_PHASE_CONFIG_THRESHOLD_MS = 3000;
    public static final int SESSION_CONFIGURATION_THRESHOLD_MS = 3000;
    public static final int CLOSE_LOGICAL_LINK_THRESHOLD_MS = 3000;
    public static final int RF_TEST_OPERATION_THRESHOLD_MS = 3000;

    public void registerAdapterStateCallbacks(IUwbAdapterStateCallbacks var1) throws RemoteException;

    public void registerVendorExtensionCallback(IUwbVendorUciCallback var1) throws RemoteException;

    public void unregisterVendorExtensionCallback(IUwbVendorUciCallback var1) throws RemoteException;

    public void registerChannelUsageCallback(IChannelUsageCallback var1) throws RemoteException;

    public void unregisterChannelUsageCallback(IChannelUsageCallback var1) throws RemoteException;

    public void unregisterAdapterStateCallbacks(IUwbAdapterStateCallbacks var1) throws RemoteException;

    public void registerOemExtensionCallback(IUwbOemExtensionCallback var1) throws RemoteException;

    public void unregisterOemExtensionCallback(IUwbOemExtensionCallback var1) throws RemoteException;

    public long getTimestampResolutionNanos(String var1) throws RemoteException;

    public PersistableBundle getSpecificationInfo(String var1) throws RemoteException;

    public void openRanging(AttributionSource var1, SessionHandle var2, IUwbRangingCallbacks var3, PersistableBundle var4, String var5) throws RemoteException;

    public void startRanging(SessionHandle var1, PersistableBundle var2) throws RemoteException;

    public void reconfigureRanging(SessionHandle var1, PersistableBundle var2) throws RemoteException;

    public void stopRanging(SessionHandle var1) throws RemoteException;

    public void closeRanging(SessionHandle var1) throws RemoteException;

    public void addControlee(SessionHandle var1, PersistableBundle var2) throws RemoteException;

    public void removeControlee(SessionHandle var1, PersistableBundle var2) throws RemoteException;

    public void pause(SessionHandle var1, PersistableBundle var2) throws RemoteException;

    public void resume(SessionHandle var1, PersistableBundle var2) throws RemoteException;

    public void sendData(SessionHandle var1, UwbAddress var2, PersistableBundle var3, byte[] var4) throws RemoteException;

    public void setDataTransferPhaseConfig(SessionHandle var1, PersistableBundle var2) throws RemoteException;

    public void setEnabled(boolean var1) throws RemoteException;

    public int getAdapterState() throws RemoteException;

    public boolean isHwIdleTurnOffEnabled() throws RemoteException;

    public void requestHwEnabled(boolean var1, AttributionSource var2, IBinder var3) throws RemoteException;

    public boolean isHwEnableRequested(AttributionSource var1) throws RemoteException;

    public List<PersistableBundle> getChipInfos() throws RemoteException;

    public List<String> getChipIds() throws RemoteException;

    public String getDefaultChipId() throws RemoteException;

    public PersistableBundle addServiceProfile(PersistableBundle var1) throws RemoteException;

    public int removeServiceProfile(PersistableBundle var1) throws RemoteException;

    public PersistableBundle getAllServiceProfiles() throws RemoteException;

    public PersistableBundle getAdfProvisioningAuthorities(PersistableBundle var1) throws RemoteException;

    public PersistableBundle getAdfCertificateAndInfo(PersistableBundle var1) throws RemoteException;

    public void provisionProfileAdfByScript(PersistableBundle var1, IUwbAdfProvisionStateCallbacks var2) throws RemoteException;

    public int removeProfileAdf(PersistableBundle var1) throws RemoteException;

    public void updatePose(SessionHandle var1, PersistableBundle var2) throws RemoteException;

    public int sendVendorUciMessage(int var1, int var2, int var3, byte[] var4) throws RemoteException;

    public void setHybridSessionControllerConfiguration(SessionHandle var1, PersistableBundle var2) throws RemoteException;

    public void setHybridSessionControleeConfiguration(SessionHandle var1, PersistableBundle var2) throws RemoteException;

    public void updateRangingRoundsDtTag(SessionHandle var1, PersistableBundle var2) throws RemoteException;

    public void getUwbActivityEnergyInfoAsync(IOnUwbActivityEnergyInfoListener var1) throws RemoteException;

    public int queryMaxDataSizeBytes(SessionHandle var1) throws RemoteException;

    public int queryLogicalLinkMaxDataSizeBytes(SessionHandle var1, int var2) throws RemoteException;

    public void createLogicalLink(SessionHandle var1, LogicalLinkParams var2) throws RemoteException;

    public void closeLogicalLink(SessionHandle var1, int var2) throws RemoteException;

    public long queryUwbsTimestampMicros() throws RemoteException;

    public LogicalLinkConnectionParams getLogicalLinkParams(SessionHandle var1, int var2) throws RemoteException;

    public static class _Parcel {
        private static <T extends Parcelable> void writeTypedList(Parcel parcel, List<T> value, int parcelableFlags) {
            if (value == null) {
                parcel.writeInt(-1);
            } else {
                int N2 = value.size();
                parcel.writeInt(N2);
                for (int i = 0; i < N2; ++i) {
                    parcel.writeTypedObject((Parcelable)value.get(i), parcelableFlags);
                }
            }
        }
    }

    public static abstract class Stub
    extends Binder
    implements IUwbAdapter {
        static final int TRANSACTION_registerAdapterStateCallbacks = 1;
        static final int TRANSACTION_registerVendorExtensionCallback = 2;
        static final int TRANSACTION_unregisterVendorExtensionCallback = 3;
        static final int TRANSACTION_registerChannelUsageCallback = 4;
        static final int TRANSACTION_unregisterChannelUsageCallback = 5;
        static final int TRANSACTION_unregisterAdapterStateCallbacks = 6;
        static final int TRANSACTION_registerOemExtensionCallback = 7;
        static final int TRANSACTION_unregisterOemExtensionCallback = 8;
        static final int TRANSACTION_getTimestampResolutionNanos = 9;
        static final int TRANSACTION_getSpecificationInfo = 10;
        static final int TRANSACTION_openRanging = 11;
        static final int TRANSACTION_startRanging = 12;
        static final int TRANSACTION_reconfigureRanging = 13;
        static final int TRANSACTION_stopRanging = 14;
        static final int TRANSACTION_closeRanging = 15;
        static final int TRANSACTION_addControlee = 16;
        static final int TRANSACTION_removeControlee = 17;
        static final int TRANSACTION_pause = 18;
        static final int TRANSACTION_resume = 19;
        static final int TRANSACTION_sendData = 20;
        static final int TRANSACTION_setDataTransferPhaseConfig = 21;
        static final int TRANSACTION_setEnabled = 22;
        static final int TRANSACTION_getAdapterState = 23;
        static final int TRANSACTION_isHwIdleTurnOffEnabled = 24;
        static final int TRANSACTION_requestHwEnabled = 25;
        static final int TRANSACTION_isHwEnableRequested = 26;
        static final int TRANSACTION_getChipInfos = 27;
        static final int TRANSACTION_getChipIds = 28;
        static final int TRANSACTION_getDefaultChipId = 29;
        static final int TRANSACTION_addServiceProfile = 30;
        static final int TRANSACTION_removeServiceProfile = 31;
        static final int TRANSACTION_getAllServiceProfiles = 32;
        static final int TRANSACTION_getAdfProvisioningAuthorities = 33;
        static final int TRANSACTION_getAdfCertificateAndInfo = 34;
        static final int TRANSACTION_provisionProfileAdfByScript = 35;
        static final int TRANSACTION_removeProfileAdf = 36;
        static final int TRANSACTION_updatePose = 37;
        static final int TRANSACTION_sendVendorUciMessage = 38;
        static final int TRANSACTION_setHybridSessionControllerConfiguration = 39;
        static final int TRANSACTION_setHybridSessionControleeConfiguration = 40;
        static final int TRANSACTION_updateRangingRoundsDtTag = 41;
        static final int TRANSACTION_getUwbActivityEnergyInfoAsync = 42;
        static final int TRANSACTION_queryMaxDataSizeBytes = 43;
        static final int TRANSACTION_queryLogicalLinkMaxDataSizeBytes = 44;
        static final int TRANSACTION_createLogicalLink = 45;
        static final int TRANSACTION_closeLogicalLink = 46;
        static final int TRANSACTION_queryUwbsTimestampMicros = 47;
        static final int TRANSACTION_getLogicalLinkParams = 48;

        public Stub() {
            this.attachInterface(this, IUwbAdapter.DESCRIPTOR);
        }

        public static IUwbAdapter asInterface(IBinder obj) {
            if (obj == null) {
                return null;
            }
            IInterface iin = obj.queryLocalInterface(IUwbAdapter.DESCRIPTOR);
            if (iin != null && iin instanceof IUwbAdapter) {
                return (IUwbAdapter)iin;
            }
            return new Proxy(obj);
        }

        @Override
        public IBinder asBinder() {
            return this;
        }

        public static String getDefaultTransactionName(int transactionCode) {
            switch (transactionCode) {
                case 1: {
                    return "registerAdapterStateCallbacks";
                }
                case 2: {
                    return "registerVendorExtensionCallback";
                }
                case 3: {
                    return "unregisterVendorExtensionCallback";
                }
                case 4: {
                    return "registerChannelUsageCallback";
                }
                case 5: {
                    return "unregisterChannelUsageCallback";
                }
                case 6: {
                    return "unregisterAdapterStateCallbacks";
                }
                case 7: {
                    return "registerOemExtensionCallback";
                }
                case 8: {
                    return "unregisterOemExtensionCallback";
                }
                case 9: {
                    return "getTimestampResolutionNanos";
                }
                case 10: {
                    return "getSpecificationInfo";
                }
                case 11: {
                    return "openRanging";
                }
                case 12: {
                    return "startRanging";
                }
                case 13: {
                    return "reconfigureRanging";
                }
                case 14: {
                    return "stopRanging";
                }
                case 15: {
                    return "closeRanging";
                }
                case 16: {
                    return "addControlee";
                }
                case 17: {
                    return "removeControlee";
                }
                case 18: {
                    return "pause";
                }
                case 19: {
                    return "resume";
                }
                case 20: {
                    return "sendData";
                }
                case 21: {
                    return "setDataTransferPhaseConfig";
                }
                case 22: {
                    return "setEnabled";
                }
                case 23: {
                    return "getAdapterState";
                }
                case 24: {
                    return "isHwIdleTurnOffEnabled";
                }
                case 25: {
                    return "requestHwEnabled";
                }
                case 26: {
                    return "isHwEnableRequested";
                }
                case 27: {
                    return "getChipInfos";
                }
                case 28: {
                    return "getChipIds";
                }
                case 29: {
                    return "getDefaultChipId";
                }
                case 30: {
                    return "addServiceProfile";
                }
                case 31: {
                    return "removeServiceProfile";
                }
                case 32: {
                    return "getAllServiceProfiles";
                }
                case 33: {
                    return "getAdfProvisioningAuthorities";
                }
                case 34: {
                    return "getAdfCertificateAndInfo";
                }
                case 35: {
                    return "provisionProfileAdfByScript";
                }
                case 36: {
                    return "removeProfileAdf";
                }
                case 37: {
                    return "updatePose";
                }
                case 38: {
                    return "sendVendorUciMessage";
                }
                case 39: {
                    return "setHybridSessionControllerConfiguration";
                }
                case 40: {
                    return "setHybridSessionControleeConfiguration";
                }
                case 41: {
                    return "updateRangingRoundsDtTag";
                }
                case 42: {
                    return "getUwbActivityEnergyInfoAsync";
                }
                case 43: {
                    return "queryMaxDataSizeBytes";
                }
                case 44: {
                    return "queryLogicalLinkMaxDataSizeBytes";
                }
                case 45: {
                    return "createLogicalLink";
                }
                case 46: {
                    return "closeLogicalLink";
                }
                case 47: {
                    return "queryUwbsTimestampMicros";
                }
                case 48: {
                    return "getLogicalLinkParams";
                }
            }
            return null;
        }

        @Override
        public String getTransactionName(int transactionCode) {
            return Stub.getDefaultTransactionName(transactionCode);
        }

        @Override
        public boolean onTransact(int code, Parcel data, Parcel reply, int flags) throws RemoteException {
            String descriptor = IUwbAdapter.DESCRIPTOR;
            if (code >= 1 && code <= 0xFFFFFF) {
                data.enforceInterface(descriptor);
            }
            if (code == 1598968902) {
                reply.writeString(descriptor);
                return true;
            }
            switch (code) {
                case 1: {
                    IUwbAdapterStateCallbacks _arg0 = IUwbAdapterStateCallbacks.Stub.asInterface(data.readStrongBinder());
                    data.enforceNoDataAvail();
                    this.registerAdapterStateCallbacks(_arg0);
                    reply.writeNoException();
                    break;
                }
                case 2: {
                    IUwbVendorUciCallback _arg0 = IUwbVendorUciCallback.Stub.asInterface(data.readStrongBinder());
                    data.enforceNoDataAvail();
                    this.registerVendorExtensionCallback(_arg0);
                    reply.writeNoException();
                    break;
                }
                case 3: {
                    IUwbVendorUciCallback _arg0 = IUwbVendorUciCallback.Stub.asInterface(data.readStrongBinder());
                    data.enforceNoDataAvail();
                    this.unregisterVendorExtensionCallback(_arg0);
                    reply.writeNoException();
                    break;
                }
                case 4: {
                    IChannelUsageCallback _arg0 = IChannelUsageCallback.Stub.asInterface(data.readStrongBinder());
                    data.enforceNoDataAvail();
                    this.registerChannelUsageCallback(_arg0);
                    reply.writeNoException();
                    break;
                }
                case 5: {
                    IChannelUsageCallback _arg0 = IChannelUsageCallback.Stub.asInterface(data.readStrongBinder());
                    data.enforceNoDataAvail();
                    this.unregisterChannelUsageCallback(_arg0);
                    reply.writeNoException();
                    break;
                }
                case 6: {
                    IUwbAdapterStateCallbacks _arg0 = IUwbAdapterStateCallbacks.Stub.asInterface(data.readStrongBinder());
                    data.enforceNoDataAvail();
                    this.unregisterAdapterStateCallbacks(_arg0);
                    reply.writeNoException();
                    break;
                }
                case 7: {
                    IUwbOemExtensionCallback _arg0 = IUwbOemExtensionCallback.Stub.asInterface(data.readStrongBinder());
                    data.enforceNoDataAvail();
                    this.registerOemExtensionCallback(_arg0);
                    reply.writeNoException();
                    break;
                }
                case 8: {
                    IUwbOemExtensionCallback _arg0 = IUwbOemExtensionCallback.Stub.asInterface(data.readStrongBinder());
                    data.enforceNoDataAvail();
                    this.unregisterOemExtensionCallback(_arg0);
                    reply.writeNoException();
                    break;
                }
                case 9: {
                    String _arg0 = data.readString();
                    data.enforceNoDataAvail();
                    long _result = this.getTimestampResolutionNanos(_arg0);
                    reply.writeNoException();
                    reply.writeLong(_result);
                    break;
                }
                case 10: {
                    String _arg0 = data.readString();
                    data.enforceNoDataAvail();
                    PersistableBundle _result = this.getSpecificationInfo(_arg0);
                    reply.writeNoException();
                    reply.writeTypedObject(_result, 1);
                    break;
                }
                case 11: {
                    AttributionSource _arg0 = data.readTypedObject(AttributionSource.CREATOR);
                    SessionHandle _arg1 = data.readTypedObject(SessionHandle.CREATOR);
                    IUwbRangingCallbacks _arg2 = IUwbRangingCallbacks.Stub.asInterface(data.readStrongBinder());
                    PersistableBundle _arg3 = data.readTypedObject(PersistableBundle.CREATOR);
                    String _arg4 = data.readString();
                    data.enforceNoDataAvail();
                    this.openRanging(_arg0, _arg1, _arg2, _arg3, _arg4);
                    reply.writeNoException();
                    break;
                }
                case 12: {
                    SessionHandle _arg0 = data.readTypedObject(SessionHandle.CREATOR);
                    PersistableBundle _arg1 = data.readTypedObject(PersistableBundle.CREATOR);
                    data.enforceNoDataAvail();
                    this.startRanging(_arg0, _arg1);
                    reply.writeNoException();
                    break;
                }
                case 13: {
                    SessionHandle _arg0 = data.readTypedObject(SessionHandle.CREATOR);
                    PersistableBundle _arg1 = data.readTypedObject(PersistableBundle.CREATOR);
                    data.enforceNoDataAvail();
                    this.reconfigureRanging(_arg0, _arg1);
                    reply.writeNoException();
                    break;
                }
                case 14: {
                    SessionHandle _arg0 = data.readTypedObject(SessionHandle.CREATOR);
                    data.enforceNoDataAvail();
                    this.stopRanging(_arg0);
                    reply.writeNoException();
                    break;
                }
                case 15: {
                    SessionHandle _arg0 = data.readTypedObject(SessionHandle.CREATOR);
                    data.enforceNoDataAvail();
                    this.closeRanging(_arg0);
                    reply.writeNoException();
                    break;
                }
                case 16: {
                    SessionHandle _arg0 = data.readTypedObject(SessionHandle.CREATOR);
                    PersistableBundle _arg1 = data.readTypedObject(PersistableBundle.CREATOR);
                    data.enforceNoDataAvail();
                    this.addControlee(_arg0, _arg1);
                    reply.writeNoException();
                    break;
                }
                case 17: {
                    SessionHandle _arg0 = data.readTypedObject(SessionHandle.CREATOR);
                    PersistableBundle _arg1 = data.readTypedObject(PersistableBundle.CREATOR);
                    data.enforceNoDataAvail();
                    this.removeControlee(_arg0, _arg1);
                    reply.writeNoException();
                    break;
                }
                case 18: {
                    SessionHandle _arg0 = data.readTypedObject(SessionHandle.CREATOR);
                    PersistableBundle _arg1 = data.readTypedObject(PersistableBundle.CREATOR);
                    data.enforceNoDataAvail();
                    this.pause(_arg0, _arg1);
                    reply.writeNoException();
                    break;
                }
                case 19: {
                    SessionHandle _arg0 = data.readTypedObject(SessionHandle.CREATOR);
                    PersistableBundle _arg1 = data.readTypedObject(PersistableBundle.CREATOR);
                    data.enforceNoDataAvail();
                    this.resume(_arg0, _arg1);
                    reply.writeNoException();
                    break;
                }
                case 20: {
                    SessionHandle _arg0 = data.readTypedObject(SessionHandle.CREATOR);
                    UwbAddress _arg1 = data.readTypedObject(UwbAddress.CREATOR);
                    PersistableBundle _arg2 = data.readTypedObject(PersistableBundle.CREATOR);
                    byte[] _arg3 = data.createByteArray();
                    data.enforceNoDataAvail();
                    this.sendData(_arg0, _arg1, _arg2, _arg3);
                    reply.writeNoException();
                    break;
                }
                case 21: {
                    SessionHandle _arg0 = data.readTypedObject(SessionHandle.CREATOR);
                    PersistableBundle _arg1 = data.readTypedObject(PersistableBundle.CREATOR);
                    data.enforceNoDataAvail();
                    this.setDataTransferPhaseConfig(_arg0, _arg1);
                    reply.writeNoException();
                    break;
                }
                case 22: {
                    boolean _arg0 = data.readBoolean();
                    data.enforceNoDataAvail();
                    this.setEnabled(_arg0);
                    reply.writeNoException();
                    break;
                }
                case 23: {
                    int _result = this.getAdapterState();
                    reply.writeNoException();
                    reply.writeInt(_result);
                    break;
                }
                case 24: {
                    boolean _result = this.isHwIdleTurnOffEnabled();
                    reply.writeNoException();
                    reply.writeBoolean(_result);
                    break;
                }
                case 25: {
                    boolean _arg0 = data.readBoolean();
                    AttributionSource _arg1 = data.readTypedObject(AttributionSource.CREATOR);
                    IBinder _arg2 = data.readStrongBinder();
                    data.enforceNoDataAvail();
                    this.requestHwEnabled(_arg0, _arg1, _arg2);
                    reply.writeNoException();
                    break;
                }
                case 26: {
                    AttributionSource _arg0 = data.readTypedObject(AttributionSource.CREATOR);
                    data.enforceNoDataAvail();
                    boolean _result = this.isHwEnableRequested(_arg0);
                    reply.writeNoException();
                    reply.writeBoolean(_result);
                    break;
                }
                case 27: {
                    List<PersistableBundle> _result = this.getChipInfos();
                    reply.writeNoException();
                    _Parcel.writeTypedList(reply, _result, 1);
                    break;
                }
                case 28: {
                    List<String> _result = this.getChipIds();
                    reply.writeNoException();
                    reply.writeStringList(_result);
                    break;
                }
                case 29: {
                    String _result = this.getDefaultChipId();
                    reply.writeNoException();
                    reply.writeString(_result);
                    break;
                }
                case 30: {
                    PersistableBundle _arg0 = data.readTypedObject(PersistableBundle.CREATOR);
                    data.enforceNoDataAvail();
                    PersistableBundle _result = this.addServiceProfile(_arg0);
                    reply.writeNoException();
                    reply.writeTypedObject(_result, 1);
                    break;
                }
                case 31: {
                    PersistableBundle _arg0 = data.readTypedObject(PersistableBundle.CREATOR);
                    data.enforceNoDataAvail();
                    int _result = this.removeServiceProfile(_arg0);
                    reply.writeNoException();
                    reply.writeInt(_result);
                    break;
                }
                case 32: {
                    PersistableBundle _result = this.getAllServiceProfiles();
                    reply.writeNoException();
                    reply.writeTypedObject(_result, 1);
                    break;
                }
                case 33: {
                    PersistableBundle _arg0 = data.readTypedObject(PersistableBundle.CREATOR);
                    data.enforceNoDataAvail();
                    PersistableBundle _result = this.getAdfProvisioningAuthorities(_arg0);
                    reply.writeNoException();
                    reply.writeTypedObject(_result, 1);
                    break;
                }
                case 34: {
                    PersistableBundle _arg0 = data.readTypedObject(PersistableBundle.CREATOR);
                    data.enforceNoDataAvail();
                    PersistableBundle _result = this.getAdfCertificateAndInfo(_arg0);
                    reply.writeNoException();
                    reply.writeTypedObject(_result, 1);
                    break;
                }
                case 35: {
                    PersistableBundle _arg0 = data.readTypedObject(PersistableBundle.CREATOR);
                    IUwbAdfProvisionStateCallbacks _arg1 = IUwbAdfProvisionStateCallbacks.Stub.asInterface(data.readStrongBinder());
                    data.enforceNoDataAvail();
                    this.provisionProfileAdfByScript(_arg0, _arg1);
                    reply.writeNoException();
                    break;
                }
                case 36: {
                    PersistableBundle _arg0 = data.readTypedObject(PersistableBundle.CREATOR);
                    data.enforceNoDataAvail();
                    int _result = this.removeProfileAdf(_arg0);
                    reply.writeNoException();
                    reply.writeInt(_result);
                    break;
                }
                case 37: {
                    SessionHandle _arg0 = data.readTypedObject(SessionHandle.CREATOR);
                    PersistableBundle _arg1 = data.readTypedObject(PersistableBundle.CREATOR);
                    data.enforceNoDataAvail();
                    this.updatePose(_arg0, _arg1);
                    reply.writeNoException();
                    break;
                }
                case 38: {
                    int _arg0 = data.readInt();
                    int _arg1 = data.readInt();
                    int _arg2 = data.readInt();
                    byte[] _arg3 = data.createByteArray();
                    data.enforceNoDataAvail();
                    int _result = this.sendVendorUciMessage(_arg0, _arg1, _arg2, _arg3);
                    reply.writeNoException();
                    reply.writeInt(_result);
                    break;
                }
                case 39: {
                    SessionHandle _arg0 = data.readTypedObject(SessionHandle.CREATOR);
                    PersistableBundle _arg1 = data.readTypedObject(PersistableBundle.CREATOR);
                    data.enforceNoDataAvail();
                    this.setHybridSessionControllerConfiguration(_arg0, _arg1);
                    reply.writeNoException();
                    break;
                }
                case 40: {
                    SessionHandle _arg0 = data.readTypedObject(SessionHandle.CREATOR);
                    PersistableBundle _arg1 = data.readTypedObject(PersistableBundle.CREATOR);
                    data.enforceNoDataAvail();
                    this.setHybridSessionControleeConfiguration(_arg0, _arg1);
                    reply.writeNoException();
                    break;
                }
                case 41: {
                    SessionHandle _arg0 = data.readTypedObject(SessionHandle.CREATOR);
                    PersistableBundle _arg1 = data.readTypedObject(PersistableBundle.CREATOR);
                    data.enforceNoDataAvail();
                    this.updateRangingRoundsDtTag(_arg0, _arg1);
                    reply.writeNoException();
                    break;
                }
                case 42: {
                    IOnUwbActivityEnergyInfoListener _arg0 = IOnUwbActivityEnergyInfoListener.Stub.asInterface(data.readStrongBinder());
                    data.enforceNoDataAvail();
                    this.getUwbActivityEnergyInfoAsync(_arg0);
                    reply.writeNoException();
                    break;
                }
                case 43: {
                    SessionHandle _arg0 = data.readTypedObject(SessionHandle.CREATOR);
                    data.enforceNoDataAvail();
                    int _result = this.queryMaxDataSizeBytes(_arg0);
                    reply.writeNoException();
                    reply.writeInt(_result);
                    break;
                }
                case 44: {
                    SessionHandle _arg0 = data.readTypedObject(SessionHandle.CREATOR);
                    int _arg1 = data.readInt();
                    data.enforceNoDataAvail();
                    int _result = this.queryLogicalLinkMaxDataSizeBytes(_arg0, _arg1);
                    reply.writeNoException();
                    reply.writeInt(_result);
                    break;
                }
                case 45: {
                    SessionHandle _arg0 = data.readTypedObject(SessionHandle.CREATOR);
                    LogicalLinkParams _arg1 = data.readTypedObject(LogicalLinkParams.CREATOR);
                    data.enforceNoDataAvail();
                    this.createLogicalLink(_arg0, _arg1);
                    reply.writeNoException();
                    break;
                }
                case 46: {
                    SessionHandle _arg0 = data.readTypedObject(SessionHandle.CREATOR);
                    int _arg1 = data.readInt();
                    data.enforceNoDataAvail();
                    this.closeLogicalLink(_arg0, _arg1);
                    reply.writeNoException();
                    break;
                }
                case 47: {
                    long _result = this.queryUwbsTimestampMicros();
                    reply.writeNoException();
                    reply.writeLong(_result);
                    break;
                }
                case 48: {
                    SessionHandle _arg0 = data.readTypedObject(SessionHandle.CREATOR);
                    int _arg1 = data.readInt();
                    data.enforceNoDataAvail();
                    LogicalLinkConnectionParams _result = this.getLogicalLinkParams(_arg0, _arg1);
                    reply.writeNoException();
                    reply.writeTypedObject(_result, 1);
                    break;
                }
                default: {
                    return super.onTransact(code, data, reply, flags);
                }
            }
            return true;
        }

        @Override
        public int getMaxTransactionId() {
            return 47;
        }

        private static class Proxy
        implements IUwbAdapter {
            private IBinder mRemote;

            Proxy(IBinder remote) {
                this.mRemote = remote;
            }

            @Override
            public IBinder asBinder() {
                return this.mRemote;
            }

            public String getInterfaceDescriptor() {
                return IUwbAdapter.DESCRIPTOR;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void registerAdapterStateCallbacks(IUwbAdapterStateCallbacks adapterStateCallbacks) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IUwbAdapter.DESCRIPTOR);
                    _data.writeStrongInterface(adapterStateCallbacks);
                    boolean _status = this.mRemote.transact(1, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void registerVendorExtensionCallback(IUwbVendorUciCallback callbacks) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IUwbAdapter.DESCRIPTOR);
                    _data.writeStrongInterface(callbacks);
                    boolean _status = this.mRemote.transact(2, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void unregisterVendorExtensionCallback(IUwbVendorUciCallback callbacks) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IUwbAdapter.DESCRIPTOR);
                    _data.writeStrongInterface(callbacks);
                    boolean _status = this.mRemote.transact(3, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void registerChannelUsageCallback(IChannelUsageCallback callback) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IUwbAdapter.DESCRIPTOR);
                    _data.writeStrongInterface(callback);
                    boolean _status = this.mRemote.transact(4, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void unregisterChannelUsageCallback(IChannelUsageCallback callback) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IUwbAdapter.DESCRIPTOR);
                    _data.writeStrongInterface(callback);
                    boolean _status = this.mRemote.transact(5, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void unregisterAdapterStateCallbacks(IUwbAdapterStateCallbacks callbacks) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IUwbAdapter.DESCRIPTOR);
                    _data.writeStrongInterface(callbacks);
                    boolean _status = this.mRemote.transact(6, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void registerOemExtensionCallback(IUwbOemExtensionCallback callbacks) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IUwbAdapter.DESCRIPTOR);
                    _data.writeStrongInterface(callbacks);
                    boolean _status = this.mRemote.transact(7, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void unregisterOemExtensionCallback(IUwbOemExtensionCallback callbacks) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IUwbAdapter.DESCRIPTOR);
                    _data.writeStrongInterface(callbacks);
                    boolean _status = this.mRemote.transact(8, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public long getTimestampResolutionNanos(String chipId) throws RemoteException {
                long _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IUwbAdapter.DESCRIPTOR);
                    _data.writeString(chipId);
                    boolean _status = this.mRemote.transact(9, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readLong();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public PersistableBundle getSpecificationInfo(String chipId) throws RemoteException {
                PersistableBundle _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IUwbAdapter.DESCRIPTOR);
                    _data.writeString(chipId);
                    boolean _status = this.mRemote.transact(10, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readTypedObject(PersistableBundle.CREATOR);
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void openRanging(AttributionSource attributionSource, SessionHandle sessionHandle, IUwbRangingCallbacks rangingCallbacks, PersistableBundle parameters, String chipId) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IUwbAdapter.DESCRIPTOR);
                    _data.writeTypedObject(attributionSource, 0);
                    _data.writeTypedObject(sessionHandle, 0);
                    _data.writeStrongInterface(rangingCallbacks);
                    _data.writeTypedObject(parameters, 0);
                    _data.writeString(chipId);
                    boolean _status = this.mRemote.transact(11, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void startRanging(SessionHandle sessionHandle, PersistableBundle parameters) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IUwbAdapter.DESCRIPTOR);
                    _data.writeTypedObject(sessionHandle, 0);
                    _data.writeTypedObject(parameters, 0);
                    boolean _status = this.mRemote.transact(12, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void reconfigureRanging(SessionHandle sessionHandle, PersistableBundle parameters) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IUwbAdapter.DESCRIPTOR);
                    _data.writeTypedObject(sessionHandle, 0);
                    _data.writeTypedObject(parameters, 0);
                    boolean _status = this.mRemote.transact(13, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void stopRanging(SessionHandle sessionHandle) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IUwbAdapter.DESCRIPTOR);
                    _data.writeTypedObject(sessionHandle, 0);
                    boolean _status = this.mRemote.transact(14, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void closeRanging(SessionHandle sessionHandle) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IUwbAdapter.DESCRIPTOR);
                    _data.writeTypedObject(sessionHandle, 0);
                    boolean _status = this.mRemote.transact(15, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void addControlee(SessionHandle sessionHandle, PersistableBundle params) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IUwbAdapter.DESCRIPTOR);
                    _data.writeTypedObject(sessionHandle, 0);
                    _data.writeTypedObject(params, 0);
                    boolean _status = this.mRemote.transact(16, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void removeControlee(SessionHandle sessionHandle, PersistableBundle params) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IUwbAdapter.DESCRIPTOR);
                    _data.writeTypedObject(sessionHandle, 0);
                    _data.writeTypedObject(params, 0);
                    boolean _status = this.mRemote.transact(17, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void pause(SessionHandle sessionHandle, PersistableBundle params) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IUwbAdapter.DESCRIPTOR);
                    _data.writeTypedObject(sessionHandle, 0);
                    _data.writeTypedObject(params, 0);
                    boolean _status = this.mRemote.transact(18, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void resume(SessionHandle sessionHandle, PersistableBundle params) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IUwbAdapter.DESCRIPTOR);
                    _data.writeTypedObject(sessionHandle, 0);
                    _data.writeTypedObject(params, 0);
                    boolean _status = this.mRemote.transact(19, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void sendData(SessionHandle sessionHandle, UwbAddress remoteDeviceAddress, PersistableBundle params, byte[] data) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IUwbAdapter.DESCRIPTOR);
                    _data.writeTypedObject(sessionHandle, 0);
                    _data.writeTypedObject(remoteDeviceAddress, 0);
                    _data.writeTypedObject(params, 0);
                    _data.writeByteArray(data);
                    boolean _status = this.mRemote.transact(20, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void setDataTransferPhaseConfig(SessionHandle sessionHandle, PersistableBundle params) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IUwbAdapter.DESCRIPTOR);
                    _data.writeTypedObject(sessionHandle, 0);
                    _data.writeTypedObject(params, 0);
                    boolean _status = this.mRemote.transact(21, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void setEnabled(boolean enabled) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IUwbAdapter.DESCRIPTOR);
                    _data.writeBoolean(enabled);
                    boolean _status = this.mRemote.transact(22, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public int getAdapterState() throws RemoteException {
                int _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IUwbAdapter.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(23, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readInt();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean isHwIdleTurnOffEnabled() throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IUwbAdapter.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(24, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readBoolean();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void requestHwEnabled(boolean enabled, AttributionSource attributionSource, IBinder binder) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IUwbAdapter.DESCRIPTOR);
                    _data.writeBoolean(enabled);
                    _data.writeTypedObject(attributionSource, 0);
                    _data.writeStrongBinder(binder);
                    boolean _status = this.mRemote.transact(25, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean isHwEnableRequested(AttributionSource attributionSource) throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IUwbAdapter.DESCRIPTOR);
                    _data.writeTypedObject(attributionSource, 0);
                    boolean _status = this.mRemote.transact(26, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readBoolean();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public List<PersistableBundle> getChipInfos() throws RemoteException {
                ArrayList<PersistableBundle> _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IUwbAdapter.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(27, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.createTypedArrayList(PersistableBundle.CREATOR);
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public List<String> getChipIds() throws RemoteException {
                ArrayList<String> _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IUwbAdapter.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(28, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.createStringArrayList();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public String getDefaultChipId() throws RemoteException {
                String _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IUwbAdapter.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(29, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readString();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public PersistableBundle addServiceProfile(PersistableBundle parameters) throws RemoteException {
                PersistableBundle _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IUwbAdapter.DESCRIPTOR);
                    _data.writeTypedObject(parameters, 0);
                    boolean _status = this.mRemote.transact(30, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readTypedObject(PersistableBundle.CREATOR);
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public int removeServiceProfile(PersistableBundle parameters) throws RemoteException {
                int _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IUwbAdapter.DESCRIPTOR);
                    _data.writeTypedObject(parameters, 0);
                    boolean _status = this.mRemote.transact(31, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readInt();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public PersistableBundle getAllServiceProfiles() throws RemoteException {
                PersistableBundle _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IUwbAdapter.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(32, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readTypedObject(PersistableBundle.CREATOR);
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public PersistableBundle getAdfProvisioningAuthorities(PersistableBundle parameters) throws RemoteException {
                PersistableBundle _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IUwbAdapter.DESCRIPTOR);
                    _data.writeTypedObject(parameters, 0);
                    boolean _status = this.mRemote.transact(33, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readTypedObject(PersistableBundle.CREATOR);
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public PersistableBundle getAdfCertificateAndInfo(PersistableBundle parameters) throws RemoteException {
                PersistableBundle _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IUwbAdapter.DESCRIPTOR);
                    _data.writeTypedObject(parameters, 0);
                    boolean _status = this.mRemote.transact(34, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readTypedObject(PersistableBundle.CREATOR);
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void provisionProfileAdfByScript(PersistableBundle serviceProfileBundle, IUwbAdfProvisionStateCallbacks callback) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IUwbAdapter.DESCRIPTOR);
                    _data.writeTypedObject(serviceProfileBundle, 0);
                    _data.writeStrongInterface(callback);
                    boolean _status = this.mRemote.transact(35, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public int removeProfileAdf(PersistableBundle serviceProfileBundle) throws RemoteException {
                int _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IUwbAdapter.DESCRIPTOR);
                    _data.writeTypedObject(serviceProfileBundle, 0);
                    boolean _status = this.mRemote.transact(36, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readInt();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void updatePose(SessionHandle sessionHandle, PersistableBundle params) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IUwbAdapter.DESCRIPTOR);
                    _data.writeTypedObject(sessionHandle, 0);
                    _data.writeTypedObject(params, 0);
                    boolean _status = this.mRemote.transact(37, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public int sendVendorUciMessage(int mt, int gid, int oid, byte[] payload) throws RemoteException {
                int _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IUwbAdapter.DESCRIPTOR);
                    _data.writeInt(mt);
                    _data.writeInt(gid);
                    _data.writeInt(oid);
                    _data.writeByteArray(payload);
                    boolean _status = this.mRemote.transact(38, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readInt();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void setHybridSessionControllerConfiguration(SessionHandle sessionHandle, PersistableBundle params) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IUwbAdapter.DESCRIPTOR);
                    _data.writeTypedObject(sessionHandle, 0);
                    _data.writeTypedObject(params, 0);
                    boolean _status = this.mRemote.transact(39, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void setHybridSessionControleeConfiguration(SessionHandle sessionHandle, PersistableBundle params) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IUwbAdapter.DESCRIPTOR);
                    _data.writeTypedObject(sessionHandle, 0);
                    _data.writeTypedObject(params, 0);
                    boolean _status = this.mRemote.transact(40, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void updateRangingRoundsDtTag(SessionHandle sessionHandle, PersistableBundle parameters) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IUwbAdapter.DESCRIPTOR);
                    _data.writeTypedObject(sessionHandle, 0);
                    _data.writeTypedObject(parameters, 0);
                    boolean _status = this.mRemote.transact(41, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void getUwbActivityEnergyInfoAsync(IOnUwbActivityEnergyInfoListener listener) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IUwbAdapter.DESCRIPTOR);
                    _data.writeStrongInterface(listener);
                    boolean _status = this.mRemote.transact(42, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public int queryMaxDataSizeBytes(SessionHandle sessionHandle) throws RemoteException {
                int _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IUwbAdapter.DESCRIPTOR);
                    _data.writeTypedObject(sessionHandle, 0);
                    boolean _status = this.mRemote.transact(43, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readInt();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public int queryLogicalLinkMaxDataSizeBytes(SessionHandle sessionHandle, int connectId) throws RemoteException {
                int _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IUwbAdapter.DESCRIPTOR);
                    _data.writeTypedObject(sessionHandle, 0);
                    _data.writeInt(connectId);
                    boolean _status = this.mRemote.transact(44, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readInt();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void createLogicalLink(SessionHandle sessionHandle, LogicalLinkParams params) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IUwbAdapter.DESCRIPTOR);
                    _data.writeTypedObject(sessionHandle, 0);
                    _data.writeTypedObject(params, 0);
                    boolean _status = this.mRemote.transact(45, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void closeLogicalLink(SessionHandle sessionHandle, int connectId) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IUwbAdapter.DESCRIPTOR);
                    _data.writeTypedObject(sessionHandle, 0);
                    _data.writeInt(connectId);
                    boolean _status = this.mRemote.transact(46, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public long queryUwbsTimestampMicros() throws RemoteException {
                long _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IUwbAdapter.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(47, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readLong();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public LogicalLinkConnectionParams getLogicalLinkParams(SessionHandle sessionHandle, int connectId) throws RemoteException {
                LogicalLinkConnectionParams _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IUwbAdapter.DESCRIPTOR);
                    _data.writeTypedObject(sessionHandle, 0);
                    _data.writeInt(connectId);
                    boolean _status = this.mRemote.transact(48, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readTypedObject(LogicalLinkConnectionParams.CREATOR);
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }
        }
    }

    public static class Default
    implements IUwbAdapter {
        @Override
        public void registerAdapterStateCallbacks(IUwbAdapterStateCallbacks adapterStateCallbacks) throws RemoteException {
        }

        @Override
        public void registerVendorExtensionCallback(IUwbVendorUciCallback callbacks) throws RemoteException {
        }

        @Override
        public void unregisterVendorExtensionCallback(IUwbVendorUciCallback callbacks) throws RemoteException {
        }

        @Override
        public void registerChannelUsageCallback(IChannelUsageCallback callback) throws RemoteException {
        }

        @Override
        public void unregisterChannelUsageCallback(IChannelUsageCallback callback) throws RemoteException {
        }

        @Override
        public void unregisterAdapterStateCallbacks(IUwbAdapterStateCallbacks callbacks) throws RemoteException {
        }

        @Override
        public void registerOemExtensionCallback(IUwbOemExtensionCallback callbacks) throws RemoteException {
        }

        @Override
        public void unregisterOemExtensionCallback(IUwbOemExtensionCallback callbacks) throws RemoteException {
        }

        @Override
        public long getTimestampResolutionNanos(String chipId) throws RemoteException {
            return 0L;
        }

        @Override
        public PersistableBundle getSpecificationInfo(String chipId) throws RemoteException {
            return null;
        }

        @Override
        public void openRanging(AttributionSource attributionSource, SessionHandle sessionHandle, IUwbRangingCallbacks rangingCallbacks, PersistableBundle parameters, String chipId) throws RemoteException {
        }

        @Override
        public void startRanging(SessionHandle sessionHandle, PersistableBundle parameters) throws RemoteException {
        }

        @Override
        public void reconfigureRanging(SessionHandle sessionHandle, PersistableBundle parameters) throws RemoteException {
        }

        @Override
        public void stopRanging(SessionHandle sessionHandle) throws RemoteException {
        }

        @Override
        public void closeRanging(SessionHandle sessionHandle) throws RemoteException {
        }

        @Override
        public void addControlee(SessionHandle sessionHandle, PersistableBundle params) throws RemoteException {
        }

        @Override
        public void removeControlee(SessionHandle sessionHandle, PersistableBundle params) throws RemoteException {
        }

        @Override
        public void pause(SessionHandle sessionHandle, PersistableBundle params) throws RemoteException {
        }

        @Override
        public void resume(SessionHandle sessionHandle, PersistableBundle params) throws RemoteException {
        }

        @Override
        public void sendData(SessionHandle sessionHandle, UwbAddress remoteDeviceAddress, PersistableBundle params, byte[] data) throws RemoteException {
        }

        @Override
        public void setDataTransferPhaseConfig(SessionHandle sessionHandle, PersistableBundle params) throws RemoteException {
        }

        @Override
        public void setEnabled(boolean enabled) throws RemoteException {
        }

        @Override
        public int getAdapterState() throws RemoteException {
            return 0;
        }

        @Override
        public boolean isHwIdleTurnOffEnabled() throws RemoteException {
            return false;
        }

        @Override
        public void requestHwEnabled(boolean enabled, AttributionSource attributionSource, IBinder binder) throws RemoteException {
        }

        @Override
        public boolean isHwEnableRequested(AttributionSource attributionSource) throws RemoteException {
            return false;
        }

        @Override
        public List<PersistableBundle> getChipInfos() throws RemoteException {
            return null;
        }

        @Override
        public List<String> getChipIds() throws RemoteException {
            return null;
        }

        @Override
        public String getDefaultChipId() throws RemoteException {
            return null;
        }

        @Override
        public PersistableBundle addServiceProfile(PersistableBundle parameters) throws RemoteException {
            return null;
        }

        @Override
        public int removeServiceProfile(PersistableBundle parameters) throws RemoteException {
            return 0;
        }

        @Override
        public PersistableBundle getAllServiceProfiles() throws RemoteException {
            return null;
        }

        @Override
        public PersistableBundle getAdfProvisioningAuthorities(PersistableBundle parameters) throws RemoteException {
            return null;
        }

        @Override
        public PersistableBundle getAdfCertificateAndInfo(PersistableBundle parameters) throws RemoteException {
            return null;
        }

        @Override
        public void provisionProfileAdfByScript(PersistableBundle serviceProfileBundle, IUwbAdfProvisionStateCallbacks callback) throws RemoteException {
        }

        @Override
        public int removeProfileAdf(PersistableBundle serviceProfileBundle) throws RemoteException {
            return 0;
        }

        @Override
        public void updatePose(SessionHandle sessionHandle, PersistableBundle params) throws RemoteException {
        }

        @Override
        public int sendVendorUciMessage(int mt, int gid, int oid, byte[] payload) throws RemoteException {
            return 0;
        }

        @Override
        public void setHybridSessionControllerConfiguration(SessionHandle sessionHandle, PersistableBundle params) throws RemoteException {
        }

        @Override
        public void setHybridSessionControleeConfiguration(SessionHandle sessionHandle, PersistableBundle params) throws RemoteException {
        }

        @Override
        public void updateRangingRoundsDtTag(SessionHandle sessionHandle, PersistableBundle parameters) throws RemoteException {
        }

        @Override
        public void getUwbActivityEnergyInfoAsync(IOnUwbActivityEnergyInfoListener listener) throws RemoteException {
        }

        @Override
        public int queryMaxDataSizeBytes(SessionHandle sessionHandle) throws RemoteException {
            return 0;
        }

        @Override
        public int queryLogicalLinkMaxDataSizeBytes(SessionHandle sessionHandle, int connectId) throws RemoteException {
            return 0;
        }

        @Override
        public void createLogicalLink(SessionHandle sessionHandle, LogicalLinkParams params) throws RemoteException {
        }

        @Override
        public void closeLogicalLink(SessionHandle sessionHandle, int connectId) throws RemoteException {
        }

        @Override
        public long queryUwbsTimestampMicros() throws RemoteException {
            return 0L;
        }

        @Override
        public LogicalLinkConnectionParams getLogicalLinkParams(SessionHandle sessionHandle, int connectId) throws RemoteException {
            return null;
        }

        @Override
        public IBinder asBinder() {
            return null;
        }
    }
}

