/*
 * Decompiled with CFR 0.152.
 */
package android.util;

import android.annotation.NonNull;
import android.os.Handler;
import android.ravenwood.annotation.RavenwoodKeepWholeClass;
import android.util.ArrayMap;
import java.util.Objects;
import java.util.concurrent.Executor;
import java.util.function.Consumer;

@RavenwoodKeepWholeClass
public class ListenerGroup<T> {
    private final ArrayMap<Consumer<T>, Executor> mListeners = new ArrayMap();
    @NonNull
    private T mLastValue;
    @NonNull
    private final Handler mHandler;

    public ListenerGroup(@NonNull T value, @NonNull Handler handler) {
        this.mLastValue = Objects.requireNonNull(value);
        this.mHandler = Objects.requireNonNull(handler);
    }

    public void accept(@NonNull T value) {
        Objects.requireNonNull(value);
        this.mHandler.post(() -> {
            this.mLastValue = value;
            for (int i = 0; i < this.mListeners.size(); ++i) {
                Consumer consumer = this.mListeners.keyAt(i);
                Executor executor = this.mListeners.get(consumer);
                executor.execute(() -> consumer.accept(value));
            }
        });
    }

    public void addListener(@NonNull Executor executor, @NonNull Consumer<T> consumer) {
        Objects.requireNonNull(executor, "Executor must not be null.");
        Objects.requireNonNull(consumer, "Consumer must not be null.");
        this.mHandler.post(() -> {
            if (this.mListeners.containsKey(consumer)) {
                return;
            }
            this.mListeners.put(consumer, executor);
            executor.execute(() -> consumer.accept(this.mLastValue));
        });
    }

    public void removeListener(@NonNull Consumer<T> consumer) {
        this.mHandler.post(() -> this.mListeners.remove(consumer));
    }
}

