/*
 * Decompiled with CFR 0.152.
 */
package android.text.style;

import android.ravenwood.annotation.RavenwoodKeepWholeClass;
import android.text.TextPaint;
import android.text.style.MetricAffectingSpan;

@RavenwoodKeepWholeClass
public abstract class CharacterStyle {
    public abstract void updateDrawState(TextPaint var1);

    public static CharacterStyle wrap(CharacterStyle cs) {
        if (cs instanceof MetricAffectingSpan) {
            return new MetricAffectingSpan.Passthrough((MetricAffectingSpan)cs);
        }
        return new Passthrough(cs);
    }

    public CharacterStyle getUnderlying() {
        return this;
    }

    private static class Passthrough
    extends CharacterStyle {
        private CharacterStyle mStyle;

        public Passthrough(CharacterStyle cs) {
            this.mStyle = cs;
        }

        @Override
        public void updateDrawState(TextPaint tp) {
            this.mStyle.updateDrawState(tp);
        }

        @Override
        public CharacterStyle getUnderlying() {
            return this.mStyle.getUnderlying();
        }
    }
}

