/*
 * Decompiled with CFR 0.152.
 */
package android.text;

import android.app.ActivityThread;
import android.app.Application;
import android.app.Application_Delegate;
import android.compat.annotation.UnsupportedAppUsage;
import android.content.res.Resources;
import android.graphics.drawable.Drawable;
import android.ravenwood.annotation.RavenwoodKeepWholeClass;
import android.ravenwood.annotation.RavenwoodReplace;
import android.text.Editable;
import android.text.HtmlToSpannedConverter;
import android.text.Layout;
import android.text.Spanned;
import android.text.TextDirectionHeuristics;
import android.text.TextUtils;
import android.text.style.AbsoluteSizeSpan;
import android.text.style.AlignmentSpan;
import android.text.style.BackgroundColorSpan;
import android.text.style.BulletSpan;
import android.text.style.CharacterStyle;
import android.text.style.ForegroundColorSpan;
import android.text.style.ImageSpan;
import android.text.style.ParagraphStyle;
import android.text.style.QuoteSpan;
import android.text.style.RelativeSizeSpan;
import android.text.style.StrikethroughSpan;
import android.text.style.StyleSpan;
import android.text.style.SubscriptSpan;
import android.text.style.SuperscriptSpan;
import android.text.style.TypefaceSpan;
import android.text.style.URLSpan;
import android.text.style.UnderlineSpan;
import org.ccil.cowan.tagsoup.HTMLSchema;
import org.ccil.cowan.tagsoup.Parser;
import org.xml.sax.SAXNotRecognizedException;
import org.xml.sax.SAXNotSupportedException;
import org.xml.sax.XMLReader;

@RavenwoodKeepWholeClass
public class Html {
    public static final int TO_HTML_PARAGRAPH_LINES_CONSECUTIVE = 0;
    public static final int TO_HTML_PARAGRAPH_LINES_INDIVIDUAL = 1;
    public static final int FROM_HTML_SEPARATOR_LINE_BREAK_PARAGRAPH = 1;
    public static final int FROM_HTML_SEPARATOR_LINE_BREAK_HEADING = 2;
    public static final int FROM_HTML_SEPARATOR_LINE_BREAK_LIST_ITEM = 4;
    public static final int FROM_HTML_SEPARATOR_LINE_BREAK_LIST = 8;
    public static final int FROM_HTML_SEPARATOR_LINE_BREAK_DIV = 16;
    public static final int FROM_HTML_SEPARATOR_LINE_BREAK_BLOCKQUOTE = 32;
    public static final int FROM_HTML_OPTION_USE_CSS_COLORS = 256;
    public static final int FROM_HTML_MODE_LEGACY = 0;
    public static final int FROM_HTML_MODE_COMPACT = 63;
    private static final int TO_HTML_PARAGRAPH_FLAG = 1;

    private Html() {
    }

    @Deprecated
    public static Spanned fromHtml(String source) {
        return Html.fromHtml(source, 0, null, null);
    }

    public static Spanned fromHtml(String source, int flags) {
        return Html.fromHtml(source, flags, null, null);
    }

    @Deprecated
    public static Spanned fromHtml(String source, ImageGetter imageGetter, TagHandler tagHandler) {
        return Html.fromHtml(source, 0, imageGetter, tagHandler);
    }

    public static Spanned fromHtml(String source, int flags, ImageGetter imageGetter, TagHandler tagHandler) {
        Parser parser = new Parser();
        try {
            parser.setProperty("http://www.ccil.org/~cowan/tagsoup/properties/schema", HtmlParser.schema);
        }
        catch (SAXNotRecognizedException e) {
            throw new RuntimeException(e);
        }
        catch (SAXNotSupportedException e) {
            throw new RuntimeException(e);
        }
        HtmlToSpannedConverter converter = new HtmlToSpannedConverter(source, imageGetter, tagHandler, parser, flags);
        return converter.convert();
    }

    @Deprecated
    public static String toHtml(Spanned text) {
        return Html.toHtml(text, 0);
    }

    public static String toHtml(Spanned text, int option) {
        StringBuilder out = new StringBuilder();
        Html.withinHtml(out, text, option);
        return out.toString();
    }

    public static String escapeHtml(CharSequence text) {
        StringBuilder out = new StringBuilder();
        Html.withinStyle(out, text, 0, text.length());
        return out.toString();
    }

    private static void withinHtml(StringBuilder out, Spanned text, int option) {
        if ((option & 1) == 0) {
            Html.encodeTextAlignmentByDiv(out, text, option);
            return;
        }
        Html.withinDiv(out, text, 0, text.length(), option);
    }

    private static void encodeTextAlignmentByDiv(StringBuilder out, Spanned text, int option) {
        int len = text.length();
        int i = 0;
        while (i < len) {
            int next = text.nextSpanTransition(i, len, ParagraphStyle.class);
            ParagraphStyle[] style2 = text.getSpans(i, next, ParagraphStyle.class);
            String elements = " ";
            boolean needDiv = false;
            for (int j = 0; j < style2.length; ++j) {
                if (!(style2[j] instanceof AlignmentSpan)) continue;
                Layout.Alignment align = ((AlignmentSpan)style2[j]).getAlignment();
                needDiv = true;
                elements = align == Layout.Alignment.ALIGN_CENTER ? "align=\"center\" " + elements : (align == Layout.Alignment.ALIGN_OPPOSITE ? "align=\"right\" " + elements : "align=\"left\" " + elements);
            }
            if (needDiv) {
                out.append("<div ").append(elements).append(">");
            }
            Html.withinDiv(out, text, i, next, option);
            if (needDiv) {
                out.append("</div>");
            }
            i = next;
        }
    }

    private static void withinDiv(StringBuilder out, Spanned text, int start, int end, int option) {
        int i = start;
        while (i < end) {
            QuoteSpan[] quotes;
            int next = text.nextSpanTransition(i, end, QuoteSpan.class);
            for (QuoteSpan quote : quotes = text.getSpans(i, next, QuoteSpan.class)) {
                out.append("<blockquote>");
            }
            Html.withinBlockquote(out, text, i, next, option);
            for (QuoteSpan quote : quotes) {
                out.append("</blockquote>\n");
            }
            i = next;
        }
    }

    private static String getTextDirection(Spanned text, int start, int end) {
        if (TextDirectionHeuristics.FIRSTSTRONG_LTR.isRtl(text, start, end - start)) {
            return " dir=\"rtl\"";
        }
        return " dir=\"ltr\"";
    }

    private static String getTextStyles(Spanned text, int start, int end, boolean forceNoVerticalMargin, boolean includeTextAlign) {
        String margin = null;
        String textAlign = null;
        if (forceNoVerticalMargin) {
            margin = "margin-top:0; margin-bottom:0;";
        }
        if (includeTextAlign) {
            AlignmentSpan[] alignmentSpans = text.getSpans(start, end, AlignmentSpan.class);
            for (int i = alignmentSpans.length - 1; i >= 0; --i) {
                AlignmentSpan s = alignmentSpans[i];
                if ((text.getSpanFlags(s) & 0x33) != 51) continue;
                Layout.Alignment alignment = s.getAlignment();
                if (alignment == Layout.Alignment.ALIGN_NORMAL) {
                    textAlign = "text-align:start;";
                    break;
                }
                if (alignment == Layout.Alignment.ALIGN_CENTER) {
                    textAlign = "text-align:center;";
                    break;
                }
                if (alignment != Layout.Alignment.ALIGN_OPPOSITE) break;
                textAlign = "text-align:end;";
                break;
            }
        }
        if (margin == null && textAlign == null) {
            return "";
        }
        StringBuilder style2 = new StringBuilder(" style=\"");
        if (margin != null && textAlign != null) {
            style2.append(margin).append(" ").append(textAlign);
        } else if (margin != null) {
            style2.append(margin);
        } else if (textAlign != null) {
            style2.append(textAlign);
        }
        return style2.append("\"").toString();
    }

    private static void withinBlockquote(StringBuilder out, Spanned text, int start, int end, int option) {
        if ((option & 1) == 0) {
            Html.withinBlockquoteConsecutive(out, text, start, end);
        } else {
            Html.withinBlockquoteIndividual(out, text, start, end);
        }
    }

    private static void withinBlockquoteIndividual(StringBuilder out, Spanned text, int start, int end) {
        boolean isInList = false;
        int i = start;
        while (i <= end) {
            int next = TextUtils.indexOf((CharSequence)text, '\n', i, end);
            if (next < 0) {
                next = end;
            }
            if (next == i) {
                if (isInList) {
                    isInList = false;
                    out.append("</ul>\n");
                }
                out.append("<br>\n");
            } else {
                ParagraphStyle[] paragraphStyles;
                boolean isListItem = false;
                for (ParagraphStyle paragraphStyle : paragraphStyles = text.getSpans(i, next, ParagraphStyle.class)) {
                    int spanFlags = text.getSpanFlags(paragraphStyle);
                    if ((spanFlags & 0x33) != 51 || !(paragraphStyle instanceof BulletSpan)) continue;
                    isListItem = true;
                    break;
                }
                if (isListItem && !isInList) {
                    isInList = true;
                    out.append("<ul").append(Html.getTextStyles(text, i, next, true, false)).append(">\n");
                }
                if (isInList && !isListItem) {
                    isInList = false;
                    out.append("</ul>\n");
                }
                String tagType = isListItem ? "li" : "p";
                out.append("<").append(tagType).append(Html.getTextDirection(text, i, next)).append(Html.getTextStyles(text, i, next, !isListItem, true)).append(">");
                Html.withinParagraph(out, text, i, next);
                out.append("</");
                out.append(tagType);
                out.append(">\n");
                if (next == end && isInList) {
                    isInList = false;
                    out.append("</ul>\n");
                }
            }
            i = ++next;
        }
    }

    private static void withinBlockquoteConsecutive(StringBuilder out, Spanned text, int start, int end) {
        out.append("<p").append(Html.getTextDirection(text, start, end)).append(">");
        int i = start;
        while (i < end) {
            int next = TextUtils.indexOf((CharSequence)text, '\n', i, end);
            if (next < 0) {
                next = end;
            }
            int nl = 0;
            while (next < end && text.charAt(next) == '\n') {
                ++nl;
                ++next;
            }
            Html.withinParagraph(out, text, i, next - nl);
            if (nl == 1) {
                out.append("<br>\n");
            } else {
                for (int j = 2; j < nl; ++j) {
                    out.append("<br>");
                }
                if (next != end) {
                    out.append("</p>\n");
                    out.append("<p").append(Html.getTextDirection(text, start, end)).append(">");
                }
            }
            i = next;
        }
        out.append("</p>\n");
    }

    @RavenwoodReplace(blockedBy={ActivityThread.class})
    private static float getDisplayMetricsDensity() {
        return Application_Delegate.getResources((Application)ActivityThread.currentApplication()).getDisplayMetrics().density;
    }

    private static float getDisplayMetricsDensity$ravenwood() {
        return Resources.getSystem().getDisplayMetrics().density;
    }

    private static void withinParagraph(StringBuilder out, Spanned text, int start, int end) {
        int i = start;
        while (i < end) {
            int j;
            int next = text.nextSpanTransition(i, end, CharacterStyle.class);
            CharacterStyle[] style2 = text.getSpans(i, next, CharacterStyle.class);
            for (j = 0; j < style2.length; ++j) {
                int color2;
                String s;
                if (style2[j] instanceof StyleSpan) {
                    int s2 = ((StyleSpan)style2[j]).getStyle();
                    if ((s2 & 1) != 0) {
                        out.append("<b>");
                    }
                    if ((s2 & 2) != 0) {
                        out.append("<i>");
                    }
                }
                if (style2[j] instanceof TypefaceSpan && "monospace".equals(s = ((TypefaceSpan)style2[j]).getFamily())) {
                    out.append("<tt>");
                }
                if (style2[j] instanceof SuperscriptSpan) {
                    out.append("<sup>");
                }
                if (style2[j] instanceof SubscriptSpan) {
                    out.append("<sub>");
                }
                if (style2[j] instanceof UnderlineSpan) {
                    out.append("<u>");
                }
                if (style2[j] instanceof StrikethroughSpan) {
                    out.append("<span style=\"text-decoration:line-through;\">");
                }
                if (style2[j] instanceof URLSpan) {
                    out.append("<a href=\"");
                    out.append(((URLSpan)style2[j]).getURL());
                    out.append("\">");
                }
                if (style2[j] instanceof ImageSpan) {
                    out.append("<img src=\"");
                    out.append(((ImageSpan)style2[j]).getSource());
                    out.append("\">");
                    i = next;
                }
                if (style2[j] instanceof AbsoluteSizeSpan) {
                    AbsoluteSizeSpan s3 = (AbsoluteSizeSpan)style2[j];
                    float sizeDip = s3.getSize();
                    if (!s3.getDip()) {
                        sizeDip /= Html.getDisplayMetricsDensity();
                    }
                    out.append(String.format("<span style=\"font-size:%.0fpx\";>", Float.valueOf(sizeDip)));
                }
                if (style2[j] instanceof RelativeSizeSpan) {
                    float sizeEm = ((RelativeSizeSpan)style2[j]).getSizeChange();
                    out.append(String.format("<span style=\"font-size:%.2fem;\">", Float.valueOf(sizeEm)));
                }
                if (style2[j] instanceof ForegroundColorSpan) {
                    color2 = ((ForegroundColorSpan)style2[j]).getForegroundColor();
                    out.append(String.format("<span style=\"color:#%06X;\">", 0xFFFFFF & color2));
                }
                if (!(style2[j] instanceof BackgroundColorSpan)) continue;
                color2 = ((BackgroundColorSpan)style2[j]).getBackgroundColor();
                out.append(String.format("<span style=\"background-color:#%06X;\">", 0xFFFFFF & color2));
            }
            Html.withinStyle(out, text, i, next);
            for (j = style2.length - 1; j >= 0; --j) {
                String s;
                if (style2[j] instanceof BackgroundColorSpan) {
                    out.append("</span>");
                }
                if (style2[j] instanceof ForegroundColorSpan) {
                    out.append("</span>");
                }
                if (style2[j] instanceof RelativeSizeSpan) {
                    out.append("</span>");
                }
                if (style2[j] instanceof AbsoluteSizeSpan) {
                    out.append("</span>");
                }
                if (style2[j] instanceof URLSpan) {
                    out.append("</a>");
                }
                if (style2[j] instanceof StrikethroughSpan) {
                    out.append("</span>");
                }
                if (style2[j] instanceof UnderlineSpan) {
                    out.append("</u>");
                }
                if (style2[j] instanceof SubscriptSpan) {
                    out.append("</sub>");
                }
                if (style2[j] instanceof SuperscriptSpan) {
                    out.append("</sup>");
                }
                if (style2[j] instanceof TypefaceSpan && "monospace".equals(s = ((TypefaceSpan)style2[j]).getFamily())) {
                    out.append("</tt>");
                }
                if (!(style2[j] instanceof StyleSpan)) continue;
                int s2 = ((StyleSpan)style2[j]).getStyle();
                if ((s2 & 1) != 0) {
                    out.append("</b>");
                }
                if ((s2 & 2) == 0) continue;
                out.append("</i>");
            }
            i = next;
        }
    }

    @UnsupportedAppUsage(maxTargetSdk=30, trackingBug=170729553L)
    private static void withinStyle(StringBuilder out, CharSequence text, int start, int end) {
        for (int i = start; i < end; ++i) {
            char c = text.charAt(i);
            if (c == '<') {
                out.append("&lt;");
                continue;
            }
            if (c == '>') {
                out.append("&gt;");
                continue;
            }
            if (c == '&') {
                out.append("&amp;");
                continue;
            }
            if (c >= '\ud800' && c <= '\udfff') {
                char d;
                if (c >= '\udc00' || i + 1 >= end || (d = text.charAt(i + 1)) < '\udc00' || d > '\udfff') continue;
                ++i;
                int codepoint = 0x10000 | c - 55296 << 10 | d - 56320;
                out.append("&#").append(codepoint).append(";");
                continue;
            }
            if (c > '~' || c < ' ') {
                out.append("&#").append((int)c).append(";");
                continue;
            }
            if (c == ' ') {
                while (i + 1 < end && text.charAt(i + 1) == ' ') {
                    out.append("&nbsp;");
                    ++i;
                }
                out.append(' ');
                continue;
            }
            out.append(c);
        }
    }

    public static interface ImageGetter {
        public Drawable getDrawable(String var1);
    }

    public static interface TagHandler {
        public void handleTag(boolean var1, String var2, Editable var3, XMLReader var4);
    }

    private static class HtmlParser {
        private static final HTMLSchema schema = new HTMLSchema();

        private HtmlParser() {
        }
    }
}

