/*
 * Decompiled with CFR 0.152.
 */
package android.telephony.satellite;

import android.annotation.FlaggedApi;
import android.annotation.SystemApi;
import android.os.Parcel;
import android.os.ParcelUuid;
import android.os.Parcelable;
import android.telephony.satellite.EarfcnRange;
import android.telephony.satellite.SatellitePosition;
import com.android.layoutlib.androidx.annotation.NonNull;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.UUID;

@SystemApi
@FlaggedApi(value="com.android.internal.telephony.flags.satellite_system_apis")
public class SatelliteInfo
implements Parcelable {
    @NonNull
    private UUID mId;
    @NonNull
    private SatellitePosition mPosition;
    private List<Integer> mBandList;
    private final List<EarfcnRange> mEarfcnRangeList;
    @NonNull
    public static final Parcelable.Creator<SatelliteInfo> CREATOR = new Parcelable.Creator<SatelliteInfo>(){

        @Override
        public SatelliteInfo createFromParcel(Parcel in) {
            return new SatelliteInfo(in);
        }

        public SatelliteInfo[] newArray(int size) {
            return new SatelliteInfo[size];
        }
    };

    protected SatelliteInfo(Parcel in) {
        ParcelUuid parcelUuid = in.readParcelable(ParcelUuid.class.getClassLoader(), ParcelUuid.class);
        if (parcelUuid != null) {
            this.mId = parcelUuid.getUuid();
        }
        this.mPosition = in.readParcelable(SatellitePosition.class.getClassLoader(), SatellitePosition.class);
        this.mBandList = new ArrayList<Integer>();
        in.readList(this.mBandList, Integer.class.getClassLoader(), Integer.class);
        this.mEarfcnRangeList = in.createTypedArrayList(EarfcnRange.CREATOR);
    }

    public SatelliteInfo(@NonNull UUID satelliteId, @NonNull SatellitePosition satellitePosition, @NonNull List<Integer> bandList, @NonNull List<EarfcnRange> earfcnRanges) {
        this.mId = satelliteId;
        this.mPosition = satellitePosition;
        this.mBandList = bandList;
        this.mEarfcnRangeList = earfcnRanges;
    }

    @Override
    public int describeContents() {
        return 0;
    }

    @Override
    public void writeToParcel(@NonNull Parcel dest, int flags) {
        dest.writeParcelable(new ParcelUuid(this.mId), flags);
        dest.writeParcelable(this.mPosition, flags);
        dest.writeList(this.mBandList);
        dest.writeTypedList(this.mEarfcnRangeList);
    }

    @NonNull
    public UUID getSatelliteId() {
        return this.mId;
    }

    @NonNull
    public SatellitePosition getSatellitePosition() {
        return this.mPosition;
    }

    @NonNull
    public List<Integer> getBands() {
        return this.mBandList;
    }

    @NonNull
    public List<EarfcnRange> getEarfcnRanges() {
        return this.mEarfcnRangeList;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof SatelliteInfo)) {
            return false;
        }
        SatelliteInfo that = (SatelliteInfo)o;
        return ((Object)this.mId).equals(that.mId) && Objects.equals(this.mPosition, that.mPosition) && Objects.equals(this.mBandList, that.mBandList) && this.mEarfcnRangeList.equals(that.mEarfcnRangeList);
    }

    public int hashCode() {
        int result = Objects.hash(this.mId, this.mPosition, this.mEarfcnRangeList);
        result = 31 * result + Objects.hashCode(this.mBandList);
        return result;
    }

    @NonNull
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("SatelliteInfo{");
        sb.append("mId=").append(this.mId);
        sb.append(", mPosition=").append(this.mPosition);
        sb.append(", mBandList=").append(this.mBandList);
        sb.append(", mEarfcnRangeList=").append(this.mEarfcnRangeList);
        sb.append('}');
        return sb.toString();
    }
}

