/*
 * Decompiled with CFR 0.152.
 */
package android.telephony.ims.stub;

import android.annotation.NonNull;
import android.annotation.Nullable;
import android.annotation.SystemApi;
import android.os.Bundle;
import android.os.RemoteException;
import android.telephony.ims.ImsUtListener;
import android.util.Log;
import com.android.ims.internal.IImsUt;
import com.android.ims.internal.IImsUtListener;
import com.android.internal.telephony.util.TelephonyUtils;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.Objects;
import java.util.concurrent.CancellationException;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.function.Supplier;

@SystemApi
public class ImsUtImplBase {
    private static final String TAG = "ImsUtImplBase";
    public static final int CALL_BARRING_ALL_INCOMING = 1;
    public static final int CALL_BARRING_ALL_OUTGOING = 2;
    public static final int CALL_BARRING_OUTGOING_INTL = 3;
    public static final int CALL_BARRING_OUTGOING_INTL_EXCL_HOME = 4;
    public static final int CALL_BLOCKING_INCOMING_WHEN_ROAMING = 5;
    public static final int CALL_BARRING_ANONYMOUS_INCOMING = 6;
    public static final int CALL_BARRING_ALL = 7;
    public static final int CALL_BARRING_OUTGOING_ALL_SERVICES = 8;
    public static final int CALL_BARRING_INCOMING_ALL_SERVICES = 9;
    public static final int CALL_BARRING_SPECIFIC_INCOMING_CALLS = 10;
    public static final int INVALID_RESULT = -1;
    private Executor mExecutor = Runnable::run;
    private final IImsUt.Stub mServiceImpl = new IImsUt.Stub(){
        private final Object mLock = new Object();
        private ImsUtListener mUtListener;

        @Override
        public void close() throws RemoteException {
            this.executeMethodAsync(() -> ImsUtImplBase.this.close(), "close");
        }

        @Override
        public int queryCallBarring(int cbType) throws RemoteException {
            return this.executeMethodAsyncForResult(() -> ImsUtImplBase.this.queryCallBarring(cbType), "queryCallBarring");
        }

        @Override
        public int queryCallForward(int condition, String number) throws RemoteException {
            return this.executeMethodAsyncForResult(() -> ImsUtImplBase.this.queryCallForward(condition, number), "queryCallForward");
        }

        @Override
        public int queryCallWaiting() throws RemoteException {
            return this.executeMethodAsyncForResult(() -> ImsUtImplBase.this.queryCallWaiting(), "queryCallWaiting");
        }

        @Override
        public int queryCLIR() throws RemoteException {
            return this.executeMethodAsyncForResult(() -> ImsUtImplBase.this.queryCLIR(), "queryCLIR");
        }

        @Override
        public int queryCLIP() throws RemoteException {
            return this.executeMethodAsyncForResult(() -> ImsUtImplBase.this.queryCLIP(), "queryCLIP");
        }

        @Override
        public int queryCOLR() throws RemoteException {
            return this.executeMethodAsyncForResult(() -> ImsUtImplBase.this.queryCOLR(), "queryCOLR");
        }

        @Override
        public int queryCOLP() throws RemoteException {
            return this.executeMethodAsyncForResult(() -> ImsUtImplBase.this.queryCOLP(), "queryCOLP");
        }

        @Override
        public int transact(Bundle ssInfo) throws RemoteException {
            return this.executeMethodAsyncForResult(() -> ImsUtImplBase.this.transact(ssInfo), "transact");
        }

        @Override
        public int updateCallBarring(int cbType, int action, String[] barrList) throws RemoteException {
            return this.executeMethodAsyncForResult(() -> ImsUtImplBase.this.updateCallBarring(cbType, action, barrList), "updateCallBarring");
        }

        @Override
        public int updateCallForward(int action, int condition, String number, int serviceClass, int timeSeconds) throws RemoteException {
            return this.executeMethodAsyncForResult(() -> ImsUtImplBase.this.updateCallForward(action, condition, number, serviceClass, timeSeconds), "updateCallForward");
        }

        @Override
        public int updateCallWaiting(boolean enable, int serviceClass) throws RemoteException {
            return this.executeMethodAsyncForResult(() -> ImsUtImplBase.this.updateCallWaiting(enable, serviceClass), "updateCallWaiting");
        }

        @Override
        public int updateCLIR(int clirMode) throws RemoteException {
            return this.executeMethodAsyncForResult(() -> ImsUtImplBase.this.updateCLIR(clirMode), "updateCLIR");
        }

        @Override
        public int updateCLIP(boolean enable) throws RemoteException {
            return this.executeMethodAsyncForResult(() -> ImsUtImplBase.this.updateCLIP(enable), "updateCLIP");
        }

        @Override
        public int updateCOLR(int presentation) throws RemoteException {
            return this.executeMethodAsyncForResult(() -> ImsUtImplBase.this.updateCOLR(presentation), "updateCOLR");
        }

        @Override
        public int updateCOLP(boolean enable) throws RemoteException {
            return this.executeMethodAsyncForResult(() -> ImsUtImplBase.this.updateCOLP(enable), "updateCOLP");
        }

        @Override
        public void setListener(IImsUtListener listener) throws RemoteException {
            this.executeMethodAsync(() -> {
                if (this.mUtListener != null && !this.mUtListener.getListenerInterface().asBinder().isBinderAlive()) {
                    Log.w(ImsUtImplBase.TAG, "setListener: discarding dead Binder");
                    this.mUtListener = null;
                }
                if (this.mUtListener != null && listener != null && Objects.equals(this.mUtListener.getListenerInterface().asBinder(), listener.asBinder())) {
                    return;
                }
                if (listener == null) {
                    this.mUtListener = null;
                } else if (listener != null && this.mUtListener == null) {
                    this.mUtListener = new ImsUtListener(listener);
                } else {
                    Log.w(ImsUtImplBase.TAG, "setListener is being called when there is already an active listener");
                    this.mUtListener = new ImsUtListener(listener);
                }
                ImsUtImplBase.this.setListener(this.mUtListener);
            }, "setListener");
        }

        @Override
        public int queryCallBarringForServiceClass(int cbType, int serviceClass) throws RemoteException {
            return this.executeMethodAsyncForResult(() -> ImsUtImplBase.this.queryCallBarringForServiceClass(cbType, serviceClass), "queryCallBarringForServiceClass");
        }

        @Override
        public int updateCallBarringForServiceClass(int cbType, int action, String[] barrList, int serviceClass) throws RemoteException {
            return this.executeMethodAsyncForResult(() -> ImsUtImplBase.this.updateCallBarringForServiceClass(cbType, action, barrList, serviceClass), "updateCallBarringForServiceClass");
        }

        @Override
        public int updateCallBarringWithPassword(int cbType, int action, String[] barrList, int serviceClass, String password) throws RemoteException {
            return this.executeMethodAsyncForResult(() -> ImsUtImplBase.this.updateCallBarringWithPassword(cbType, action, barrList, serviceClass, password), "updateCallBarringWithPassword");
        }

        private void executeMethodAsync(Runnable r, String errorLogName) throws RemoteException {
            try {
                CompletableFuture.runAsync(() -> TelephonyUtils.runWithCleanCallingIdentity(r), ImsUtImplBase.this.mExecutor).join();
            }
            catch (CancellationException | CompletionException e) {
                Log.w(ImsUtImplBase.TAG, "ImsUtImplBase Binder - " + errorLogName + " exception: " + e.getMessage());
                throw new RemoteException(e.getMessage());
            }
        }

        private <T> T executeMethodAsyncForResult(Supplier<T> r, String errorLogName) throws RemoteException {
            CompletableFuture<Object> future = CompletableFuture.supplyAsync(() -> TelephonyUtils.runWithCleanCallingIdentity(r), ImsUtImplBase.this.mExecutor);
            try {
                return (T)future.get();
            }
            catch (InterruptedException | ExecutionException e) {
                Log.w(ImsUtImplBase.TAG, "ImsUtImplBase Binder - " + errorLogName + " exception: " + e.getMessage());
                throw new RemoteException(e.getMessage());
            }
        }
    };

    public void close() {
    }

    public int queryCallBarring(int cbType) {
        return -1;
    }

    public int queryCallBarringForServiceClass(int cbType, int serviceClass) {
        return -1;
    }

    public int queryCallForward(int condition, String number) {
        return -1;
    }

    public int queryCallWaiting() {
        return -1;
    }

    public int queryCLIR() {
        return this.queryClir();
    }

    public int queryCLIP() {
        return this.queryClip();
    }

    public int queryCOLR() {
        return this.queryColr();
    }

    public int queryCOLP() {
        return this.queryColp();
    }

    public int queryClir() {
        return -1;
    }

    public int queryClip() {
        return -1;
    }

    public int queryColr() {
        return -1;
    }

    public int queryColp() {
        return -1;
    }

    public int transact(Bundle ssInfo) {
        return -1;
    }

    public int updateCallBarring(int cbType, int action, String[] barrList) {
        return -1;
    }

    public int updateCallBarringForServiceClass(int cbType, int action, String[] barrList, int serviceClass) {
        return -1;
    }

    public int updateCallBarringWithPassword(int cbType, int action, @Nullable String[] barrList, int serviceClass, @NonNull String password) {
        return -1;
    }

    public int updateCallForward(int action, int condition, String number, int serviceClass, int timeSeconds) {
        return 0;
    }

    public int updateCallWaiting(boolean enable, int serviceClass) {
        return -1;
    }

    public int updateCLIR(int clirMode) {
        return this.updateClir(clirMode);
    }

    public int updateCLIP(boolean enable) {
        return this.updateClip(enable);
    }

    public int updateCOLR(int presentation) {
        return this.updateColr(presentation);
    }

    public int updateCOLP(boolean enable) {
        return this.updateColp(enable);
    }

    public int updateClir(int clirMode) {
        return -1;
    }

    public int updateClip(boolean enable) {
        return -1;
    }

    public int updateColr(int presentation) {
        return -1;
    }

    public int updateColp(boolean enable) {
        return -1;
    }

    public void setListener(ImsUtListener listener) {
    }

    public IImsUt getInterface() {
        return this.mServiceImpl;
    }

    public void setDefaultExecutor(@NonNull Executor executor) {
        this.mExecutor = executor;
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface CallBarringMode {
    }
}

