/*
 * Decompiled with CFR 0.152.
 */
package android.telephony.ims.feature;

import android.annotation.NonNull;
import android.annotation.SystemApi;
import android.os.Parcel;
import android.os.Parcelable;
import android.util.ArraySet;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;

@SystemApi
public class CapabilityChangeRequest
implements Parcelable {
    private final Set<CapabilityPair> mCapabilitiesToEnable;
    private final Set<CapabilityPair> mCapabilitiesToDisable;
    @NonNull
    public static final Parcelable.Creator<CapabilityChangeRequest> CREATOR = new Parcelable.Creator<CapabilityChangeRequest>(){

        @Override
        public CapabilityChangeRequest createFromParcel(Parcel in) {
            return new CapabilityChangeRequest(in);
        }

        public CapabilityChangeRequest[] newArray(int size) {
            return new CapabilityChangeRequest[size];
        }
    };

    public CapabilityChangeRequest() {
        this.mCapabilitiesToEnable = new ArraySet<CapabilityPair>();
        this.mCapabilitiesToDisable = new ArraySet<CapabilityPair>();
    }

    public void addCapabilitiesToEnableForTech(int capabilities, int radioTech) {
        this.addAllCapabilities(this.mCapabilitiesToEnable, capabilities, radioTech);
    }

    public void addCapabilitiesToDisableForTech(int capabilities, int radioTech) {
        this.addAllCapabilities(this.mCapabilitiesToDisable, capabilities, radioTech);
    }

    public List<CapabilityPair> getCapabilitiesToEnable() {
        return new ArrayList<CapabilityPair>(this.mCapabilitiesToEnable);
    }

    public List<CapabilityPair> getCapabilitiesToDisable() {
        return new ArrayList<CapabilityPair>(this.mCapabilitiesToDisable);
    }

    private void addAllCapabilities(Set<CapabilityPair> set, int capabilities, int tech) {
        long highestCapability = Long.highestOneBit(capabilities);
        int i = 1;
        while ((long)i <= highestCapability) {
            if ((i & capabilities) > 0) {
                set.add(new CapabilityPair(i, tech));
            }
            i *= 2;
        }
    }

    protected CapabilityChangeRequest(Parcel in) {
        int enableSize = in.readInt();
        this.mCapabilitiesToEnable = new ArraySet<CapabilityPair>(enableSize);
        for (int i = 0; i < enableSize; ++i) {
            this.mCapabilitiesToEnable.add(new CapabilityPair(in.readInt(), in.readInt()));
        }
        int disableSize = in.readInt();
        this.mCapabilitiesToDisable = new ArraySet<CapabilityPair>(disableSize);
        for (int i = 0; i < disableSize; ++i) {
            this.mCapabilitiesToDisable.add(new CapabilityPair(in.readInt(), in.readInt()));
        }
    }

    @Override
    public int describeContents() {
        return 0;
    }

    @Override
    public void writeToParcel(Parcel dest, int flags) {
        dest.writeInt(this.mCapabilitiesToEnable.size());
        for (CapabilityPair pair : this.mCapabilitiesToEnable) {
            dest.writeInt(pair.getCapability());
            dest.writeInt(pair.getRadioTech());
        }
        dest.writeInt(this.mCapabilitiesToDisable.size());
        for (CapabilityPair pair : this.mCapabilitiesToDisable) {
            dest.writeInt(pair.getCapability());
            dest.writeInt(pair.getRadioTech());
        }
    }

    @NonNull
    public String toString() {
        return "CapabilityChangeRequest{mCapabilitiesToEnable=" + this.mCapabilitiesToEnable + ", mCapabilitiesToDisable=" + this.mCapabilitiesToDisable + '}';
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof CapabilityChangeRequest)) {
            return false;
        }
        CapabilityChangeRequest that = (CapabilityChangeRequest)o;
        if (!this.mCapabilitiesToEnable.equals(that.mCapabilitiesToEnable)) {
            return false;
        }
        return this.mCapabilitiesToDisable.equals(that.mCapabilitiesToDisable);
    }

    public int hashCode() {
        int result = this.mCapabilitiesToEnable.hashCode();
        result = 31 * result + this.mCapabilitiesToDisable.hashCode();
        return result;
    }

    public static class CapabilityPair {
        private final int mCapability;
        private final int radioTech;

        public CapabilityPair(int capability, int radioTech) {
            this.mCapability = capability;
            this.radioTech = radioTech;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof CapabilityPair)) {
                return false;
            }
            CapabilityPair that = (CapabilityPair)o;
            if (this.getCapability() != that.getCapability()) {
                return false;
            }
            return this.getRadioTech() == that.getRadioTech();
        }

        public int hashCode() {
            int result = this.getCapability();
            result = 31 * result + this.getRadioTech();
            return result;
        }

        public int getCapability() {
            return this.mCapability;
        }

        public int getRadioTech() {
            return this.radioTech;
        }

        @NonNull
        public String toString() {
            return "CapabilityPair{mCapability=" + this.mCapability + ", radioTech=" + this.radioTech + '}';
        }
    }
}

