/*
 * Decompiled with CFR 0.152.
 */
package android.telephony.ims.aidl;

import android.net.Uri;
import android.os.Binder;
import android.os.IBinder;
import android.os.IInterface;
import android.os.Parcel;
import android.os.RemoteException;
import android.telephony.ims.ImsReasonInfo;
import android.telephony.ims.ImsRegistrationAttributes;
import android.telephony.ims.SipDetails;

public interface IImsRegistrationCallback
extends IInterface {
    public static final String DESCRIPTOR = "android.telephony.ims.aidl.IImsRegistrationCallback";

    public void onRegistered(ImsRegistrationAttributes var1) throws RemoteException;

    public void onRegistering(ImsRegistrationAttributes var1) throws RemoteException;

    public void onDeregistered(ImsReasonInfo var1, int var2, int var3) throws RemoteException;

    public void onDeregisteredWithDetails(ImsReasonInfo var1, int var2, int var3, SipDetails var4) throws RemoteException;

    public void onTechnologyChangeFailed(int var1, ImsReasonInfo var2) throws RemoteException;

    public void onSubscriberAssociatedUriChanged(Uri[] var1) throws RemoteException;

    public static abstract class Stub
    extends Binder
    implements IImsRegistrationCallback {
        static final int TRANSACTION_onRegistered = 1;
        static final int TRANSACTION_onRegistering = 2;
        static final int TRANSACTION_onDeregistered = 3;
        static final int TRANSACTION_onDeregisteredWithDetails = 4;
        static final int TRANSACTION_onTechnologyChangeFailed = 5;
        static final int TRANSACTION_onSubscriberAssociatedUriChanged = 6;

        public Stub() {
            this.attachInterface(this, IImsRegistrationCallback.DESCRIPTOR);
        }

        public static IImsRegistrationCallback asInterface(IBinder obj) {
            if (obj == null) {
                return null;
            }
            IInterface iin = obj.queryLocalInterface(IImsRegistrationCallback.DESCRIPTOR);
            if (iin != null && iin instanceof IImsRegistrationCallback) {
                return (IImsRegistrationCallback)iin;
            }
            return new Proxy(obj);
        }

        @Override
        public IBinder asBinder() {
            return this;
        }

        public static String getDefaultTransactionName(int transactionCode) {
            switch (transactionCode) {
                case 1: {
                    return "onRegistered";
                }
                case 2: {
                    return "onRegistering";
                }
                case 3: {
                    return "onDeregistered";
                }
                case 4: {
                    return "onDeregisteredWithDetails";
                }
                case 5: {
                    return "onTechnologyChangeFailed";
                }
                case 6: {
                    return "onSubscriberAssociatedUriChanged";
                }
            }
            return null;
        }

        @Override
        public String getTransactionName(int transactionCode) {
            return Stub.getDefaultTransactionName(transactionCode);
        }

        @Override
        public boolean onTransact(int code, Parcel data, Parcel reply, int flags) throws RemoteException {
            String descriptor = IImsRegistrationCallback.DESCRIPTOR;
            if (code >= 1 && code <= 0xFFFFFF) {
                data.enforceInterface(descriptor);
            }
            if (code == 1598968902) {
                reply.writeString(descriptor);
                return true;
            }
            switch (code) {
                case 1: {
                    ImsRegistrationAttributes _arg0 = data.readTypedObject(ImsRegistrationAttributes.CREATOR);
                    data.enforceNoDataAvail();
                    this.onRegistered(_arg0);
                    break;
                }
                case 2: {
                    ImsRegistrationAttributes _arg0 = data.readTypedObject(ImsRegistrationAttributes.CREATOR);
                    data.enforceNoDataAvail();
                    this.onRegistering(_arg0);
                    break;
                }
                case 3: {
                    ImsReasonInfo _arg0 = data.readTypedObject(ImsReasonInfo.CREATOR);
                    int _arg1 = data.readInt();
                    int _arg2 = data.readInt();
                    data.enforceNoDataAvail();
                    this.onDeregistered(_arg0, _arg1, _arg2);
                    break;
                }
                case 4: {
                    ImsReasonInfo _arg0 = data.readTypedObject(ImsReasonInfo.CREATOR);
                    int _arg1 = data.readInt();
                    int _arg2 = data.readInt();
                    SipDetails _arg3 = data.readTypedObject(SipDetails.CREATOR);
                    data.enforceNoDataAvail();
                    this.onDeregisteredWithDetails(_arg0, _arg1, _arg2, _arg3);
                    break;
                }
                case 5: {
                    int _arg0 = data.readInt();
                    ImsReasonInfo _arg1 = data.readTypedObject(ImsReasonInfo.CREATOR);
                    data.enforceNoDataAvail();
                    this.onTechnologyChangeFailed(_arg0, _arg1);
                    break;
                }
                case 6: {
                    Uri[] _arg0 = data.createTypedArray(Uri.CREATOR);
                    data.enforceNoDataAvail();
                    this.onSubscriberAssociatedUriChanged(_arg0);
                    break;
                }
                default: {
                    return super.onTransact(code, data, reply, flags);
                }
            }
            return true;
        }

        @Override
        public int getMaxTransactionId() {
            return 5;
        }

        private static class Proxy
        implements IImsRegistrationCallback {
            private IBinder mRemote;

            Proxy(IBinder remote) {
                this.mRemote = remote;
            }

            @Override
            public IBinder asBinder() {
                return this.mRemote;
            }

            public String getInterfaceDescriptor() {
                return IImsRegistrationCallback.DESCRIPTOR;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onRegistered(ImsRegistrationAttributes attr2) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(IImsRegistrationCallback.DESCRIPTOR);
                    _data.writeTypedObject(attr2, 0);
                    boolean bl = this.mRemote.transact(1, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onRegistering(ImsRegistrationAttributes attr2) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(IImsRegistrationCallback.DESCRIPTOR);
                    _data.writeTypedObject(attr2, 0);
                    boolean bl = this.mRemote.transact(2, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onDeregistered(ImsReasonInfo info, int suggestedAction, int imsRadioTech) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(IImsRegistrationCallback.DESCRIPTOR);
                    _data.writeTypedObject(info, 0);
                    _data.writeInt(suggestedAction);
                    _data.writeInt(imsRadioTech);
                    boolean bl = this.mRemote.transact(3, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onDeregisteredWithDetails(ImsReasonInfo info, int suggestedAction, int imsRadioTech, SipDetails detail) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(IImsRegistrationCallback.DESCRIPTOR);
                    _data.writeTypedObject(info, 0);
                    _data.writeInt(suggestedAction);
                    _data.writeInt(imsRadioTech);
                    _data.writeTypedObject(detail, 0);
                    boolean bl = this.mRemote.transact(4, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onTechnologyChangeFailed(int imsRadioTech, ImsReasonInfo info) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(IImsRegistrationCallback.DESCRIPTOR);
                    _data.writeInt(imsRadioTech);
                    _data.writeTypedObject(info, 0);
                    boolean bl = this.mRemote.transact(5, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onSubscriberAssociatedUriChanged(Uri[] uris) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(IImsRegistrationCallback.DESCRIPTOR);
                    _data.writeTypedArray(uris, 0);
                    boolean bl = this.mRemote.transact(6, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }
        }
    }

    public static class Default
    implements IImsRegistrationCallback {
        @Override
        public void onRegistered(ImsRegistrationAttributes attr2) throws RemoteException {
        }

        @Override
        public void onRegistering(ImsRegistrationAttributes attr2) throws RemoteException {
        }

        @Override
        public void onDeregistered(ImsReasonInfo info, int suggestedAction, int imsRadioTech) throws RemoteException {
        }

        @Override
        public void onDeregisteredWithDetails(ImsReasonInfo info, int suggestedAction, int imsRadioTech, SipDetails detail) throws RemoteException {
        }

        @Override
        public void onTechnologyChangeFailed(int imsRadioTech, ImsReasonInfo info) throws RemoteException {
        }

        @Override
        public void onSubscriberAssociatedUriChanged(Uri[] uris) throws RemoteException {
        }

        @Override
        public IBinder asBinder() {
            return null;
        }
    }
}

