/*
 * Decompiled with CFR 0.152.
 */
package android.telephony.ims;

import android.annotation.NonNull;
import android.annotation.Nullable;
import android.annotation.SystemApi;
import android.os.Parcel;
import android.os.Parcelable;
import android.telephony.ims.RcsContactPresenceTuple;
import android.telephony.ims.SipDetails;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;

@SystemApi
public class PublishAttributes
implements Parcelable {
    private final int mPublishState;
    private List<RcsContactPresenceTuple> mPresenceTuples;
    @Nullable
    private SipDetails mSipDetails;
    @NonNull
    public static final Parcelable.Creator<PublishAttributes> CREATOR = new Parcelable.Creator<PublishAttributes>(){

        @Override
        public PublishAttributes createFromParcel(Parcel source) {
            return new PublishAttributes(source);
        }

        public PublishAttributes[] newArray(int size) {
            return new PublishAttributes[size];
        }
    };

    private PublishAttributes(int publishState) {
        this.mPublishState = publishState;
    }

    public int getPublishState() {
        return this.mPublishState;
    }

    @NonNull
    public List<RcsContactPresenceTuple> getPresenceTuples() {
        if (this.mPresenceTuples == null) {
            return Collections.emptyList();
        }
        return this.mPresenceTuples;
    }

    @Nullable
    public SipDetails getSipDetails() {
        return this.mSipDetails;
    }

    @Override
    public int describeContents() {
        return 0;
    }

    @Override
    public void writeToParcel(@NonNull Parcel dest, int flags) {
        dest.writeInt(this.mPublishState);
        dest.writeList(this.mPresenceTuples);
        dest.writeParcelable(this.mSipDetails, 0);
    }

    private PublishAttributes(Parcel in) {
        this.mPublishState = in.readInt();
        this.mPresenceTuples = new ArrayList<RcsContactPresenceTuple>();
        in.readList(this.mPresenceTuples, null, RcsContactPresenceTuple.class);
        this.mSipDetails = in.readParcelable(SipDetails.class.getClassLoader(), SipDetails.class);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PublishAttributes that = (PublishAttributes)o;
        return this.mPublishState == that.mPublishState && Objects.equals(this.mPresenceTuples, that.mPresenceTuples) && Objects.equals(this.mSipDetails, that.mSipDetails);
    }

    public int hashCode() {
        return Objects.hash(this.mPublishState, this.mPresenceTuples, this.mSipDetails);
    }

    public String toString() {
        return "PublishAttributes { publishState= " + this.mPublishState + ", presenceTuples=[" + this.mPresenceTuples + "]SipDetails=" + this.mSipDetails + "}";
    }

    public static class Builder {
        private PublishAttributes mAttributes;

        public Builder(int publishState) {
            this.mAttributes = new PublishAttributes(publishState);
        }

        @NonNull
        public Builder setSipDetails(@Nullable SipDetails details) {
            this.mAttributes.mSipDetails = details;
            return this;
        }

        @NonNull
        public Builder setPresenceTuples(@NonNull List<RcsContactPresenceTuple> tuples) {
            this.mAttributes.mPresenceTuples = tuples;
            return this;
        }

        @NonNull
        public PublishAttributes build() {
            return this.mAttributes;
        }
    }
}

