/*
 * Decompiled with CFR 0.152.
 */
package android.telephony.ims;

import android.annotation.NonNull;
import android.annotation.SystemApi;
import android.os.Parcel;
import android.os.Parcelable;
import android.util.Range;

@SystemApi
public class AudioCodecAttributes
implements Parcelable {
    private float mBitrateKbps;
    private Range<Float> mBitrateRangeKbps;
    private float mBandwidthKhz;
    private Range<Float> mBandwidthRangeKhz;
    @NonNull
    public static final Parcelable.Creator<AudioCodecAttributes> CREATOR = new Parcelable.Creator<AudioCodecAttributes>(){

        @Override
        public AudioCodecAttributes createFromParcel(Parcel in) {
            return new AudioCodecAttributes(in);
        }

        public AudioCodecAttributes[] newArray(int size) {
            return new AudioCodecAttributes[size];
        }
    };

    public AudioCodecAttributes(float bitrateKbps, @NonNull Range<Float> bitrateRangeKbps, float bandwidthKhz, @NonNull Range<Float> bandwidthRangeKhz) {
        this.mBitrateKbps = bitrateKbps;
        this.mBitrateRangeKbps = bitrateRangeKbps;
        this.mBandwidthKhz = bandwidthKhz;
        this.mBandwidthRangeKhz = bandwidthRangeKhz;
    }

    private AudioCodecAttributes(Parcel in) {
        this.mBitrateKbps = in.readFloat();
        this.mBitrateRangeKbps = new Range<Float>(Float.valueOf(in.readFloat()), Float.valueOf(in.readFloat()));
        this.mBandwidthKhz = in.readFloat();
        this.mBandwidthRangeKhz = new Range<Float>(Float.valueOf(in.readFloat()), Float.valueOf(in.readFloat()));
    }

    @Override
    public void writeToParcel(@NonNull Parcel out, int flags) {
        out.writeFloat(this.mBitrateKbps);
        out.writeFloat(this.mBitrateRangeKbps.getLower().floatValue());
        out.writeFloat(this.mBitrateRangeKbps.getUpper().floatValue());
        out.writeFloat(this.mBandwidthKhz);
        out.writeFloat(this.mBandwidthRangeKhz.getLower().floatValue());
        out.writeFloat(this.mBandwidthRangeKhz.getUpper().floatValue());
    }

    @Override
    public int describeContents() {
        return 0;
    }

    public float getBitrateKbps() {
        return this.mBitrateKbps;
    }

    @NonNull
    public Range<Float> getBitrateRangeKbps() {
        return this.mBitrateRangeKbps;
    }

    public float getBandwidthKhz() {
        return this.mBandwidthKhz;
    }

    @NonNull
    public Range<Float> getBandwidthRangeKhz() {
        return this.mBandwidthRangeKhz;
    }

    @NonNull
    public String toString() {
        return "{ bitrateKbps=" + this.mBitrateKbps + ", bitrateRangeKbps=" + this.mBitrateRangeKbps + ", bandwidthKhz=" + this.mBandwidthKhz + ", bandwidthRangeKhz=" + this.mBandwidthRangeKhz + " }";
    }
}

