/*
 * Decompiled with CFR 0.152.
 */
package android.telephony;

import android.annotation.NonNull;
import android.app.SystemServiceRegistry;
import android.compat.Compatibility;
import android.content.Context;
import android.os.SystemProperties;
import android.os.TelephonyServiceManager;
import android.os._Original_Build;
import android.telephony.CarrierConfigManager;
import android.telephony.SmsManager;
import android.telephony.SubscriptionManager;
import android.telephony.TelephonyManager;
import android.telephony.euicc.EuiccCardManager;
import android.telephony.euicc.EuiccManager;
import android.telephony.ims.ImsManager;
import android.telephony.satellite.SatelliteManager;
import com.android.internal.util.Preconditions;

public class TelephonyFrameworkInitializer {
    static final long ENABLE_CHECKING_TELEPHONY_FEATURES = 330583731L;
    private static volatile TelephonyServiceManager sTelephonyServiceManager;

    private TelephonyFrameworkInitializer() {
    }

    public static void setTelephonyServiceManager(@NonNull TelephonyServiceManager telephonyServiceManager) {
        Preconditions.checkState(sTelephonyServiceManager == null, "setTelephonyServiceManager called twice!");
        sTelephonyServiceManager = Preconditions.checkNotNull(telephonyServiceManager);
    }

    private static boolean hasSystemFeature(Context context, String feature) {
        int vendorApiLevel = SystemProperties.getInt("ro.vendor.api_level", _Original_Build.VERSION.DEVICE_INITIAL_SDK_INT);
        if (vendorApiLevel < 202404) {
            return true;
        }
        if (!Compatibility.isChangeEnabled(330583731L)) {
            return true;
        }
        return context.getPackageManager().hasSystemFeature(feature);
    }

    public static void registerServiceWrappers() {
        SystemServiceRegistry.registerContextAwareService("phone", TelephonyManager.class, context -> new TelephonyManager(context));
        SystemServiceRegistry.registerContextAwareService("telephony_subscription_service", SubscriptionManager.class, context -> new SubscriptionManager(context));
        SystemServiceRegistry.registerContextAwareService("carrier_config", CarrierConfigManager.class, context -> TelephonyFrameworkInitializer.hasSystemFeature(context, "android.hardware.telephony.subscription") ? new CarrierConfigManager(context) : null);
        SystemServiceRegistry.registerContextAwareService("euicc", EuiccManager.class, context -> TelephonyFrameworkInitializer.hasSystemFeature(context, "android.hardware.telephony.euicc") ? new EuiccManager(context) : null);
        SystemServiceRegistry.registerContextAwareService("euicc_card", EuiccCardManager.class, context -> TelephonyFrameworkInitializer.hasSystemFeature(context, "android.hardware.telephony.euicc") ? new EuiccCardManager(context) : null);
        SystemServiceRegistry.registerContextAwareService("telephony_ims", ImsManager.class, context -> TelephonyFrameworkInitializer.hasSystemFeature(context, "android.hardware.telephony.ims") ? new ImsManager(context) : null);
        SystemServiceRegistry.registerContextAwareService("sms", SmsManager.class, context -> TelephonyFrameworkInitializer.hasSystemFeature(context, "android.hardware.telephony.messaging") ? SmsManager.getSmsManagerForContextAndSubscriptionId(context, Integer.MAX_VALUE) : null);
        SystemServiceRegistry.registerContextAwareService("satellite", SatelliteManager.class, context -> TelephonyFrameworkInitializer.hasSystemFeature(context, "android.hardware.telephony.satellite") ? new SatelliteManager(context) : null);
    }

    public static TelephonyServiceManager getTelephonyServiceManager() {
        return sTelephonyServiceManager;
    }
}

