/*
 * Decompiled with CFR 0.152.
 */
package android.telephony;

import android.annotation.NonNull;
import android.annotation.Nullable;
import android.os.Parcel;
import android.os.Parcelable;
import android.telephony.RadioAccessSpecifier;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Objects;

public class NetworkScanRequest
implements Parcelable {
    public static final int MAX_RADIO_ACCESS_NETWORKS = 8;
    public static final int MAX_BANDS = 8;
    public static final int MAX_CHANNELS = 32;
    public static final int MAX_MCC_MNC_LIST_SIZE = 20;
    public static final int MIN_SEARCH_PERIODICITY_SEC = 5;
    public static final int MAX_SEARCH_PERIODICITY_SEC = 300;
    public static final int MIN_SEARCH_MAX_SEC = 60;
    public static final int MAX_SEARCH_MAX_SEC = 3600;
    public static final int MIN_INCREMENTAL_PERIODICITY_SEC = 1;
    public static final int MAX_INCREMENTAL_PERIODICITY_SEC = 10;
    public static final int SCAN_TYPE_ONE_SHOT = 0;
    public static final int SCAN_TYPE_PERIODIC = 1;
    private int mScanType;
    private int mSearchPeriodicity;
    private int mMaxSearchTime;
    private boolean mIncrementalResults;
    private int mIncrementalResultsPeriodicity;
    @Nullable
    private RadioAccessSpecifier[] mSpecifiers;
    @NonNull
    private ArrayList<String> mMccMncs;
    @NonNull
    public static final Parcelable.Creator<NetworkScanRequest> CREATOR = new Parcelable.Creator<NetworkScanRequest>(){

        @Override
        public NetworkScanRequest createFromParcel(Parcel in) {
            return new NetworkScanRequest(in);
        }

        public NetworkScanRequest[] newArray(int size) {
            return new NetworkScanRequest[size];
        }
    };

    public NetworkScanRequest(int scanType, RadioAccessSpecifier[] specifiers, int searchPeriodicity, int maxSearchTime, boolean incrementalResults, int incrementalResultsPeriodicity, ArrayList<String> mccMncs) {
        this.mScanType = scanType;
        this.mSpecifiers = specifiers != null ? (RadioAccessSpecifier[])specifiers.clone() : null;
        this.mSearchPeriodicity = searchPeriodicity;
        this.mMaxSearchTime = maxSearchTime;
        this.mIncrementalResults = incrementalResults;
        this.mIncrementalResultsPeriodicity = incrementalResultsPeriodicity;
        this.mMccMncs = mccMncs != null ? (ArrayList)mccMncs.clone() : new ArrayList();
    }

    public int getScanType() {
        return this.mScanType;
    }

    public int getSearchPeriodicity() {
        return this.mSearchPeriodicity;
    }

    public int getMaxSearchTime() {
        return this.mMaxSearchTime;
    }

    public boolean getIncrementalResults() {
        return this.mIncrementalResults;
    }

    public int getIncrementalResultsPeriodicity() {
        return this.mIncrementalResultsPeriodicity;
    }

    public RadioAccessSpecifier[] getSpecifiers() {
        return this.mSpecifiers == null ? null : (RadioAccessSpecifier[])this.mSpecifiers.clone();
    }

    public ArrayList<String> getPlmns() {
        return (ArrayList)this.mMccMncs.clone();
    }

    @Override
    public int describeContents() {
        return 0;
    }

    @Override
    public void writeToParcel(Parcel dest, int flags) {
        dest.writeInt(this.mScanType);
        dest.writeParcelableArray(this.mSpecifiers, flags);
        dest.writeInt(this.mSearchPeriodicity);
        dest.writeInt(this.mMaxSearchTime);
        dest.writeBoolean(this.mIncrementalResults);
        dest.writeInt(this.mIncrementalResultsPeriodicity);
        dest.writeStringList(this.mMccMncs);
    }

    private NetworkScanRequest(Parcel in) {
        this.mScanType = in.readInt();
        Parcelable[] tempSpecifiers = in.readParcelableArray(Object.class.getClassLoader(), RadioAccessSpecifier.class);
        if (tempSpecifiers != null) {
            this.mSpecifiers = new RadioAccessSpecifier[tempSpecifiers.length];
            for (int i = 0; i < tempSpecifiers.length; ++i) {
                this.mSpecifiers[i] = (RadioAccessSpecifier)tempSpecifiers[i];
            }
        } else {
            this.mSpecifiers = null;
        }
        this.mSearchPeriodicity = in.readInt();
        this.mMaxSearchTime = in.readInt();
        this.mIncrementalResults = in.readBoolean();
        this.mIncrementalResultsPeriodicity = in.readInt();
        this.mMccMncs = new ArrayList();
        in.readStringList(this.mMccMncs);
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof NetworkScanRequest)) {
            return false;
        }
        NetworkScanRequest nsr = (NetworkScanRequest)other;
        return this.mScanType == nsr.mScanType && Arrays.equals(this.mSpecifiers, nsr.mSpecifiers) && this.mSearchPeriodicity == nsr.mSearchPeriodicity && this.mMaxSearchTime == nsr.mMaxSearchTime && this.mIncrementalResults == nsr.mIncrementalResults && this.mIncrementalResultsPeriodicity == nsr.mIncrementalResultsPeriodicity && Objects.equals(this.mMccMncs, nsr.mMccMncs);
    }

    public int hashCode() {
        return this.mScanType * 31 + Arrays.hashCode(this.mSpecifiers) * 37 + this.mSearchPeriodicity * 41 + this.mMaxSearchTime * 43 + (this.mIncrementalResults ? 1 : 0) * 47 + this.mIncrementalResultsPeriodicity * 53 + this.mMccMncs.hashCode() * 59;
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface ScanType {
    }
}

