/*
 * Decompiled with CFR 0.152.
 */
package android.telephony;

import android.os.Binder;
import android.os.IBinder;
import android.os.IInterface;
import android.os.Parcel;
import android.os.RemoteException;
import android.telephony.CellInfo;
import java.util.ArrayList;
import java.util.List;

public interface ICellInfoCallback
extends IInterface {
    public static final String DESCRIPTOR = "android.telephony.ICellInfoCallback";

    public void onCellInfo(List<CellInfo> var1) throws RemoteException;

    public void onError(int var1, String var2, String var3) throws RemoteException;

    public static abstract class Stub
    extends Binder
    implements ICellInfoCallback {
        static final int TRANSACTION_onCellInfo = 1;
        static final int TRANSACTION_onError = 2;

        public Stub() {
            this.attachInterface(this, ICellInfoCallback.DESCRIPTOR);
        }

        public static ICellInfoCallback asInterface(IBinder obj) {
            if (obj == null) {
                return null;
            }
            IInterface iin = obj.queryLocalInterface(ICellInfoCallback.DESCRIPTOR);
            if (iin != null && iin instanceof ICellInfoCallback) {
                return (ICellInfoCallback)iin;
            }
            return new Proxy(obj);
        }

        @Override
        public IBinder asBinder() {
            return this;
        }

        public static String getDefaultTransactionName(int transactionCode) {
            switch (transactionCode) {
                case 1: {
                    return "onCellInfo";
                }
                case 2: {
                    return "onError";
                }
            }
            return null;
        }

        @Override
        public String getTransactionName(int transactionCode) {
            return Stub.getDefaultTransactionName(transactionCode);
        }

        @Override
        public boolean onTransact(int code, Parcel data, Parcel reply, int flags) throws RemoteException {
            String descriptor = ICellInfoCallback.DESCRIPTOR;
            if (code >= 1 && code <= 0xFFFFFF) {
                data.enforceInterface(descriptor);
            }
            if (code == 1598968902) {
                reply.writeString(descriptor);
                return true;
            }
            switch (code) {
                case 1: {
                    ArrayList<CellInfo> _arg0 = data.createTypedArrayList(CellInfo.CREATOR);
                    data.enforceNoDataAvail();
                    this.onCellInfo(_arg0);
                    break;
                }
                case 2: {
                    int _arg0 = data.readInt();
                    String _arg1 = data.readString();
                    String _arg2 = data.readString();
                    data.enforceNoDataAvail();
                    this.onError(_arg0, _arg1, _arg2);
                    break;
                }
                default: {
                    return super.onTransact(code, data, reply, flags);
                }
            }
            return true;
        }

        @Override
        public int getMaxTransactionId() {
            return 1;
        }

        private static class Proxy
        implements ICellInfoCallback {
            private IBinder mRemote;

            Proxy(IBinder remote) {
                this.mRemote = remote;
            }

            @Override
            public IBinder asBinder() {
                return this.mRemote;
            }

            public String getInterfaceDescriptor() {
                return ICellInfoCallback.DESCRIPTOR;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onCellInfo(List<CellInfo> state) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(ICellInfoCallback.DESCRIPTOR);
                    _data.writeTypedList(state, 0);
                    boolean bl = this.mRemote.transact(1, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onError(int errorCode, String exceptionName, String message) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(ICellInfoCallback.DESCRIPTOR);
                    _data.writeInt(errorCode);
                    _data.writeString(exceptionName);
                    _data.writeString(message);
                    boolean bl = this.mRemote.transact(2, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }
        }
    }

    public static class Default
    implements ICellInfoCallback {
        @Override
        public void onCellInfo(List<CellInfo> state) throws RemoteException {
        }

        @Override
        public void onError(int errorCode, String exceptionName, String message) throws RemoteException {
        }

        @Override
        public IBinder asBinder() {
            return null;
        }
    }
}

