/*
 * Decompiled with CFR 0.152.
 */
package android.telephony;

import android.annotation.NonNull;
import android.annotation.SystemApi;
import android.os.Parcel;
import android.os.Parcelable;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;

@SystemApi
public class DataThrottlingRequest
implements Parcelable {
    @SystemApi
    public static final int DATA_THROTTLING_ACTION_NO_DATA_THROTTLING = 0;
    @SystemApi
    public static final int DATA_THROTTLING_ACTION_THROTTLE_SECONDARY_CARRIER = 1;
    @SystemApi
    public static final int DATA_THROTTLING_ACTION_THROTTLE_PRIMARY_CARRIER = 2;
    @SystemApi
    public static final int DATA_THROTTLING_ACTION_HOLD = 3;
    private int mDataThrottlingAction;
    private long mCompletionDurationMillis;
    @NonNull
    public static final Parcelable.Creator<DataThrottlingRequest> CREATOR = new Parcelable.Creator<DataThrottlingRequest>(){

        @Override
        public DataThrottlingRequest createFromParcel(Parcel in) {
            return new DataThrottlingRequest(in);
        }

        public DataThrottlingRequest[] newArray(int size) {
            return new DataThrottlingRequest[size];
        }
    };

    private DataThrottlingRequest(@NonNull int dataThrottlingAction, long completionDurationMillis) {
        this.mDataThrottlingAction = dataThrottlingAction;
        this.mCompletionDurationMillis = completionDurationMillis;
    }

    private DataThrottlingRequest(Parcel in) {
        this.mDataThrottlingAction = in.readInt();
        this.mCompletionDurationMillis = in.readLong();
    }

    @Override
    public void writeToParcel(@NonNull Parcel dest, int flags) {
        dest.writeInt(this.mDataThrottlingAction);
        dest.writeLong(this.mCompletionDurationMillis);
    }

    @Override
    public int describeContents() {
        return 0;
    }

    public String toString() {
        return "[DataThrottlingRequest , DataThrottlingAction=" + this.mDataThrottlingAction + ", completionDurationMillis=" + this.mCompletionDurationMillis + "]";
    }

    public int getDataThrottlingAction() {
        return this.mDataThrottlingAction;
    }

    public long getCompletionDurationMillis() {
        return this.mCompletionDurationMillis;
    }

    @SystemApi
    public static class Builder {
        private int mDataThrottlingAction;
        private long mCompletionDurationMillis;

        @NonNull
        public Builder setDataThrottlingAction(int dataThrottlingAction) {
            this.mDataThrottlingAction = dataThrottlingAction;
            return this;
        }

        @NonNull
        public Builder setCompletionDurationMillis(long completionDurationMillis) {
            this.mCompletionDurationMillis = completionDurationMillis;
            return this;
        }

        @NonNull
        public DataThrottlingRequest build() {
            if (this.mCompletionDurationMillis < 0L) {
                throw new IllegalArgumentException("completionDurationMillis cannot be a negative number");
            }
            if (this.mDataThrottlingAction == 3 && this.mCompletionDurationMillis != 0L) {
                throw new IllegalArgumentException("completionDurationMillis must be 0 for DataThrottlingRequest.DATA_THROTTLING_ACTION_HOLD");
            }
            return new DataThrottlingRequest(this.mDataThrottlingAction, this.mCompletionDurationMillis);
        }
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface DataThrottlingAction {
    }
}

