/*
 * Decompiled with CFR 0.152.
 */
package android.telephony;

import android.annotation.FlaggedApi;
import android.annotation.NonNull;
import android.annotation.SystemApi;
import android.os.Parcel;
import android.os.Parcelable;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.Objects;

@SystemApi
@FlaggedApi(value="com.android.internal.telephony.flags.cellular_identifier_disclosure_indications")
public class CellularIdentifierDisclosure
implements Parcelable {
    private static final String TAG = "CellularIdentifierDisclosure";
    public static final int NAS_PROTOCOL_MESSAGE_UNKNOWN = 0;
    public static final int NAS_PROTOCOL_MESSAGE_ATTACH_REQUEST = 1;
    public static final int NAS_PROTOCOL_MESSAGE_IDENTITY_RESPONSE = 2;
    public static final int NAS_PROTOCOL_MESSAGE_DETACH_REQUEST = 3;
    public static final int NAS_PROTOCOL_MESSAGE_TRACKING_AREA_UPDATE_REQUEST = 4;
    public static final int NAS_PROTOCOL_MESSAGE_LOCATION_UPDATE_REQUEST = 5;
    public static final int NAS_PROTOCOL_MESSAGE_AUTHENTICATION_AND_CIPHERING_RESPONSE = 6;
    public static final int NAS_PROTOCOL_MESSAGE_REGISTRATION_REQUEST = 7;
    public static final int NAS_PROTOCOL_MESSAGE_DEREGISTRATION_REQUEST = 8;
    public static final int NAS_PROTOCOL_MESSAGE_CM_REESTABLISHMENT_REQUEST = 9;
    public static final int NAS_PROTOCOL_MESSAGE_CM_SERVICE_REQUEST = 10;
    public static final int NAS_PROTOCOL_MESSAGE_IMSI_DETACH_INDICATION = 11;
    @FlaggedApi(value="com.android.internal.telephony.flags.vendor_specific_cellular_identifier_disclosure_indications")
    public static final int NAS_PROTOCOL_MESSAGE_THREAT_IDENTIFIER_FALSE = 12;
    @FlaggedApi(value="com.android.internal.telephony.flags.vendor_specific_cellular_identifier_disclosure_indications")
    public static final int NAS_PROTOCOL_MESSAGE_THREAT_IDENTIFIER_TRUE = 13;
    public static final int CELLULAR_IDENTIFIER_UNKNOWN = 0;
    public static final int CELLULAR_IDENTIFIER_IMSI = 1;
    public static final int CELLULAR_IDENTIFIER_IMEI = 2;
    public static final int CELLULAR_IDENTIFIER_SUCI = 3;
    private int mNasProtocolMessage;
    private int mCellularIdentifier;
    private String mPlmn;
    private boolean mIsEmergency;
    @NonNull
    public static final Parcelable.Creator<CellularIdentifierDisclosure> CREATOR = new Parcelable.Creator<CellularIdentifierDisclosure>(){

        @Override
        public CellularIdentifierDisclosure createFromParcel(Parcel in) {
            return new CellularIdentifierDisclosure(in);
        }

        public CellularIdentifierDisclosure[] newArray(int size) {
            return new CellularIdentifierDisclosure[size];
        }
    };

    public CellularIdentifierDisclosure(int nasProtocolMessage, int cellularIdentifier, @NonNull String plmn, boolean isEmergency) {
        this.mNasProtocolMessage = nasProtocolMessage;
        this.mCellularIdentifier = cellularIdentifier;
        this.mPlmn = plmn;
        this.mIsEmergency = isEmergency;
    }

    private CellularIdentifierDisclosure(Parcel in) {
        this.readFromParcel(in);
    }

    public int getNasProtocolMessage() {
        return this.mNasProtocolMessage;
    }

    public int getCellularIdentifier() {
        return this.mCellularIdentifier;
    }

    @NonNull
    public String getPlmn() {
        return this.mPlmn;
    }

    public boolean isEmergency() {
        return this.mIsEmergency;
    }

    @FlaggedApi(value="com.android.internal.telephony.flags.vendor_specific_cellular_identifier_disclosure_indications")
    public boolean isBenign() {
        return this.mNasProtocolMessage == 12;
    }

    @Override
    public int describeContents() {
        return 0;
    }

    @Override
    public void writeToParcel(@NonNull Parcel out, int flags) {
        out.writeInt(this.mNasProtocolMessage);
        out.writeInt(this.mCellularIdentifier);
        out.writeBoolean(this.mIsEmergency);
        out.writeString8(this.mPlmn);
    }

    public String toString() {
        return "CellularIdentifierDisclosure:{ mNasProtocolMessage = " + this.mNasProtocolMessage + " mCellularIdentifier = " + this.mCellularIdentifier + " mIsEmergency = " + this.mIsEmergency + " mPlmn = " + this.mPlmn;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof CellularIdentifierDisclosure)) {
            return false;
        }
        CellularIdentifierDisclosure that = (CellularIdentifierDisclosure)o;
        return this.mNasProtocolMessage == that.mNasProtocolMessage && this.mCellularIdentifier == that.mCellularIdentifier && this.mIsEmergency == that.mIsEmergency && this.mPlmn.equals(that.mPlmn);
    }

    public int hashCode() {
        return Objects.hash(this.mNasProtocolMessage, this.mCellularIdentifier, this.mIsEmergency, this.mPlmn);
    }

    private void readFromParcel(@NonNull Parcel in) {
        this.mNasProtocolMessage = in.readInt();
        this.mCellularIdentifier = in.readInt();
        this.mIsEmergency = in.readBoolean();
        this.mPlmn = in.readString8();
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface CellularIdentifier {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface NasProtocolMessage {
    }
}

