/*
 * Decompiled with CFR 0.152.
 */
package android.system.virtualmachine;

import android.annotation.NonNull;
import android.annotation.Nullable;
import android.annotation.SystemApi;
import android.os.Parcel;
import android.os.ParcelFileDescriptor;
import android.os.Parcelable;
import java.io.IOException;
import java.util.Objects;

@SystemApi
public class VirtualMachineDescriptor
implements Parcelable,
AutoCloseable {
    private volatile boolean mClosed = false;
    @NonNull
    private final ParcelFileDescriptor mConfigFd;
    @Nullable
    private final ParcelFileDescriptor mInstanceIdFd;
    @NonNull
    private final ParcelFileDescriptor mInstanceImgFd;
    @Nullable
    private final ParcelFileDescriptor mEncryptedStoreFd;
    @NonNull
    public static final Parcelable.Creator<VirtualMachineDescriptor> CREATOR = new Parcelable.Creator<VirtualMachineDescriptor>(){

        @Override
        public VirtualMachineDescriptor createFromParcel(Parcel in) {
            return new VirtualMachineDescriptor(in);
        }

        public VirtualMachineDescriptor[] newArray(int size) {
            return new VirtualMachineDescriptor[size];
        }
    };

    @Override
    public int describeContents() {
        return 1;
    }

    @Override
    public void writeToParcel(@NonNull Parcel out, int flags) {
        this.checkNotClosed();
        out.writeParcelable(this.mConfigFd, flags);
        out.writeParcelable(this.mInstanceIdFd, flags);
        out.writeParcelable(this.mInstanceImgFd, flags);
        out.writeParcelable(this.mEncryptedStoreFd, flags);
    }

    @NonNull
    ParcelFileDescriptor getConfigFd() {
        this.checkNotClosed();
        return this.mConfigFd;
    }

    @Nullable
    ParcelFileDescriptor getInstanceIdFd() {
        this.checkNotClosed();
        return this.mInstanceIdFd;
    }

    @NonNull
    ParcelFileDescriptor getInstanceImgFd() {
        this.checkNotClosed();
        return this.mInstanceImgFd;
    }

    @Nullable
    ParcelFileDescriptor getEncryptedStoreFd() {
        this.checkNotClosed();
        return this.mEncryptedStoreFd;
    }

    VirtualMachineDescriptor(@NonNull ParcelFileDescriptor configFd, @Nullable ParcelFileDescriptor instanceIdFd, @NonNull ParcelFileDescriptor instanceImgFd, @Nullable ParcelFileDescriptor encryptedStoreFd) {
        this.mConfigFd = Objects.requireNonNull(configFd);
        this.mInstanceIdFd = instanceIdFd;
        this.mInstanceImgFd = Objects.requireNonNull(instanceImgFd);
        this.mEncryptedStoreFd = encryptedStoreFd;
    }

    private VirtualMachineDescriptor(Parcel in) {
        this.mConfigFd = Objects.requireNonNull(this.readParcelFileDescriptor(in));
        this.mInstanceIdFd = this.readParcelFileDescriptor(in);
        this.mInstanceImgFd = Objects.requireNonNull(this.readParcelFileDescriptor(in));
        this.mEncryptedStoreFd = this.readParcelFileDescriptor(in);
    }

    private ParcelFileDescriptor readParcelFileDescriptor(Parcel in) {
        return in.readParcelable(ParcelFileDescriptor.class.getClassLoader(), ParcelFileDescriptor.class);
    }

    @Override
    public void close() {
        this.mClosed = true;
        try (ParcelFileDescriptor parcelFileDescriptor = this.mConfigFd;
             ParcelFileDescriptor parcelFileDescriptor2 = this.mInstanceIdFd;
             ParcelFileDescriptor parcelFileDescriptor3 = this.mInstanceImgFd;){
            ParcelFileDescriptor parcelFileDescriptor4 = this.mEncryptedStoreFd;
            if (parcelFileDescriptor4 != null) {
                parcelFileDescriptor4.close();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private void checkNotClosed() {
        if (this.mClosed) {
            throw new IllegalStateException("Descriptor has been closed");
        }
    }
}

