/*
 * Decompiled with CFR 0.152.
 */
package android.system.virtualmachine;

import android.annotation.FlaggedApi;
import android.annotation.NonNull;
import android.annotation.Nullable;
import android.annotation.RequiresPermission;
import android.annotation.SystemApi;
import android.content.Context;
import android.content.pm.ApplicationInfo;
import android.content.pm.PackageManager;
import android.net.LocalSocket;
import android.net.LocalSocketAddress;
import android.os.ParcelFileDescriptor;
import android.os.PersistableBundle;
import android.os._Original_Build;
import android.system.virtualizationservice.AssignedDevices;
import android.system.virtualizationservice.CpuOptions;
import android.system.virtualizationservice.CustomMemoryBackingFile;
import android.system.virtualizationservice.DiskImage;
import android.system.virtualizationservice.Partition;
import android.system.virtualizationservice.SharedPath;
import android.system.virtualizationservice.UsbConfig;
import android.system.virtualizationservice.VirtualMachineAppConfig;
import android.system.virtualizationservice.VirtualMachinePayloadConfig;
import android.system.virtualizationservice.VirtualMachineRawConfig;
import android.system.virtualmachine.BuildFlags;
import android.system.virtualmachine.VirtualMachineCustomImageConfig;
import android.system.virtualmachine.VirtualMachineException;
import android.text.TextUtils;
import android.util.Log;
import com.android.internal.lang.System_Delegate;
import com.android.system.virtualmachine.sysprop.HypervisorProperties;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.zip.ZipFile;

@SystemApi
public class VirtualMachineConfig {
    private static final String TAG = "VirtualMachineConfig";
    private static String[] EMPTY_STRING_ARRAY = new String[0];
    private static final String U_BOOT_PREBUILT_PATH_ARM = "/apex/com.android.virt/etc/u-boot.bin";
    private static final String U_BOOT_PREBUILT_PATH_X86 = "/apex/com.android.virt/etc/u-boot.rom";
    private static final int VERSION = 10;
    private static final String KEY_VERSION = "version";
    private static final String KEY_PACKAGENAME = "packageName";
    private static final String KEY_APKPATH = "apkPath";
    private static final String KEY_PAYLOADCONFIGPATH = "payloadConfigPath";
    private static final String KEY_CUSTOMIMAGECONFIG = "customImageConfig";
    private static final String KEY_PAYLOADBINARYNAME = "payloadBinaryPath";
    private static final String KEY_DEBUGLEVEL = "debugLevel";
    private static final String KEY_PROTECTED_VM = "protectedVm";
    private static final String KEY_MEMORY_BYTES = "memoryBytes";
    private static final String KEY_CPU_TOPOLOGY = "cpuTopology";
    private static final String KEY_CONSOLE_INPUT_DEVICE = "consoleInputDevice";
    private static final String KEY_ENCRYPTED_STORAGE_BYTES = "encryptedStorageBytes";
    private static final String KEY_VM_OUTPUT_CAPTURED = "vmOutputCaptured";
    private static final String KEY_VM_CONSOLE_INPUT_SUPPORTED = "vmConsoleInputSupported";
    private static final String KEY_CONNECT_VM_CONSOLE = "connectVmConsole";
    private static final String KEY_VENDOR_DISK_IMAGE_PATH = "vendorDiskImagePath";
    private static final String KEY_OS = "os";
    private static final String KEY_EXTRA_APKS = "extraApks";
    private static final String KEY_SHOULD_BOOST_UCLAMP = "shouldBoostUclamp";
    private static final String KEY_SHOULD_USE_HUGEPAGES = "shouldUseHugepages";
    private static final String KEY_ENCRYPTED_STORE_MODE = "encryptedStoreMode";
    @SystemApi
    public static final int DEBUG_LEVEL_NONE = 0;
    @SystemApi
    public static final int DEBUG_LEVEL_FULL = 1;
    @SystemApi
    public static final int CPU_TOPOLOGY_ONE_CPU = 0;
    @SystemApi
    public static final int CPU_TOPOLOGY_MATCH_HOST = 1;
    @Nullable
    private final String mPackageName;
    @Nullable
    private final String mApkPath;
    private final List<String> mExtraApks;
    private final int mDebugLevel;
    private final boolean mProtectedVm;
    private final long mMemoryBytes;
    private final int mCpuTopology;
    @Nullable
    private final String mConsoleInputDevice;
    @Nullable
    private final String mPayloadConfigPath;
    @Nullable
    private final String mPayloadBinaryName;
    @Nullable
    private final VirtualMachineCustomImageConfig mCustomImageConfig;
    private final long mEncryptedStorageBytes;
    private final boolean mVmOutputCaptured;
    private final boolean mVmConsoleInputSupported;
    private final boolean mConnectVmConsole;
    @Nullable
    private final File mVendorDiskImage;
    @NonNull
    private final String mOs;
    private final boolean mShouldBoostUclamp;
    private final boolean mShouldUseHugepages;
    private final int mEncryptedStoreMode;
    private static final String ENCRYPTED_STORE_MODE_PROP_NAME = "android.system.virtualmachine.ENCRYPTED_STORE_MODE";
    public static final int ENCRYPTED_STORE_MODE_DEFAULT = 0;
    public static final int ENCRYPTED_STORE_MODE_KEK_ON_CE = 1;
    public static final String MICRODROID = "microdroid";

    private VirtualMachineConfig(@Nullable String packageName, @Nullable String apkPath, List<String> extraApks, @Nullable String payloadConfigPath, @Nullable String payloadBinaryName, @Nullable VirtualMachineCustomImageConfig customImageConfig, int debugLevel, boolean protectedVm, long memoryBytes, int cpuTopology, @Nullable String consoleInputDevice, long encryptedStorageBytes, boolean vmOutputCaptured, boolean vmConsoleInputSupported, boolean connectVmConsole, @Nullable File vendorDiskImage, @NonNull String os, boolean shouldBoostUclamp, boolean shouldUseHugepages, int encryptedStoreMode) {
        this.mPackageName = packageName;
        this.mApkPath = apkPath;
        this.mExtraApks = extraApks.isEmpty() ? Collections.emptyList() : Collections.unmodifiableList(Arrays.asList(extraApks.toArray(new String[0])));
        this.mPayloadConfigPath = payloadConfigPath;
        this.mPayloadBinaryName = payloadBinaryName;
        this.mCustomImageConfig = customImageConfig;
        this.mDebugLevel = debugLevel;
        this.mProtectedVm = protectedVm;
        this.mMemoryBytes = memoryBytes;
        this.mCpuTopology = cpuTopology;
        this.mConsoleInputDevice = consoleInputDevice;
        this.mEncryptedStorageBytes = encryptedStorageBytes;
        this.mVmOutputCaptured = vmOutputCaptured;
        this.mVmConsoleInputSupported = vmConsoleInputSupported;
        this.mConnectVmConsole = connectVmConsole;
        this.mVendorDiskImage = vendorDiskImage;
        this.mOs = os;
        this.mShouldBoostUclamp = shouldBoostUclamp;
        this.mShouldUseHugepages = shouldUseHugepages;
        this.mEncryptedStoreMode = encryptedStoreMode;
    }

    @NonNull
    static VirtualMachineConfig from(@NonNull File file) throws VirtualMachineException {
        VirtualMachineConfig virtualMachineConfig;
        FileInputStream input = new FileInputStream(file);
        try {
            virtualMachineConfig = VirtualMachineConfig.fromInputStream(input);
        }
        catch (Throwable throwable) {
            try {
                try {
                    input.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                throw new VirtualMachineException("Failed to read VM config from file", e);
            }
        }
        input.close();
        return virtualMachineConfig;
    }

    @NonNull
    static VirtualMachineConfig from(@NonNull ParcelFileDescriptor fd) throws VirtualMachineException {
        VirtualMachineConfig virtualMachineConfig;
        ParcelFileDescriptor.AutoCloseInputStream input = new ParcelFileDescriptor.AutoCloseInputStream(fd);
        try {
            virtualMachineConfig = VirtualMachineConfig.fromInputStream(input);
        }
        catch (Throwable throwable) {
            try {
                try {
                    input.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                throw new VirtualMachineException("failed to read VM config from file descriptor", e);
            }
        }
        input.close();
        return virtualMachineConfig;
    }

    @NonNull
    private static VirtualMachineConfig fromInputStream(@NonNull InputStream input) throws IOException, VirtualMachineException {
        PersistableBundle b = PersistableBundle.readFromStream(input);
        try {
            return VirtualMachineConfig.fromPersistableBundle(b);
        }
        catch (IllegalArgumentException | IllegalStateException | NullPointerException e) {
            throw new VirtualMachineException("Persisted VM config is invalid", e);
        }
    }

    @NonNull
    private static VirtualMachineConfig fromPersistableBundle(PersistableBundle b) {
        long encryptedStorageBytes;
        int version = b.getInt(KEY_VERSION);
        if (version > 10) {
            throw new IllegalArgumentException("Version " + version + " too high; current is " + 10);
        }
        String packageName = b.getString(KEY_PACKAGENAME);
        Builder builder = new Builder(packageName);
        String apkPath = b.getString(KEY_APKPATH);
        if (apkPath != null) {
            builder.setApkPath(apkPath);
        }
        String payloadConfigPath = b.getString(KEY_PAYLOADCONFIGPATH);
        String payloadBinaryName = b.getString(KEY_PAYLOADBINARYNAME);
        PersistableBundle customImageConfigBundle = b.getPersistableBundle(KEY_CUSTOMIMAGECONFIG);
        if (customImageConfigBundle != null) {
            builder.setCustomImageConfig(VirtualMachineCustomImageConfig.from(customImageConfigBundle));
        } else if (payloadConfigPath != null) {
            builder.setPayloadConfigPath(payloadConfigPath);
        } else {
            builder.setPayloadBinaryName(payloadBinaryName);
        }
        int debugLevel = b.getInt(KEY_DEBUGLEVEL);
        if (debugLevel != 0 && debugLevel != 1) {
            throw new IllegalArgumentException("Invalid debugLevel: " + debugLevel);
        }
        builder.setDebugLevel(debugLevel);
        builder.setProtectedVm(b.getBoolean(KEY_PROTECTED_VM));
        long memoryBytes = b.getLong(KEY_MEMORY_BYTES);
        if (memoryBytes != 0L) {
            builder.setMemoryBytes(memoryBytes);
        }
        builder.setCpuTopology(b.getInt(KEY_CPU_TOPOLOGY));
        String consoleInputDevice = b.getString(KEY_CONSOLE_INPUT_DEVICE);
        if (consoleInputDevice != null) {
            builder.setConsoleInputDevice(consoleInputDevice);
        }
        if ((encryptedStorageBytes = b.getLong(KEY_ENCRYPTED_STORAGE_BYTES)) != 0L) {
            builder.setEncryptedStorageBytes(encryptedStorageBytes);
        }
        builder.setVmOutputCaptured(b.getBoolean(KEY_VM_OUTPUT_CAPTURED));
        builder.setVmConsoleInputSupported(b.getBoolean(KEY_VM_CONSOLE_INPUT_SUPPORTED));
        builder.setConnectVmConsole(b.getBoolean(KEY_CONNECT_VM_CONSOLE));
        String vendorDiskImagePath = b.getString(KEY_VENDOR_DISK_IMAGE_PATH);
        if (vendorDiskImagePath != null) {
            builder.setVendorDiskImage(new File(vendorDiskImagePath));
        }
        builder.setOs(b.getString(KEY_OS));
        String[] extraApks = b.getStringArray(KEY_EXTRA_APKS);
        if (extraApks != null) {
            for (String extraApk : extraApks) {
                builder.addExtraApk(extraApk);
            }
        }
        builder.setShouldBoostUclamp(b.getBoolean(KEY_SHOULD_BOOST_UCLAMP));
        builder.setShouldUseHugepages(b.getBoolean(KEY_SHOULD_USE_HUGEPAGES));
        builder.setEncryptedStoreMode(b.getInt(KEY_ENCRYPTED_STORE_MODE, 0));
        return builder.build();
    }

    void serialize(@NonNull File file) throws VirtualMachineException {
        try (FileOutputStream output = new FileOutputStream(file);){
            this.serializeOutputStream(output);
        }
        catch (IOException e) {
            throw new VirtualMachineException("failed to write VM config", e);
        }
    }

    private void serializeOutputStream(@NonNull OutputStream output) throws IOException {
        PersistableBundle b = new PersistableBundle();
        b.putInt(KEY_VERSION, 10);
        if (this.mPackageName != null) {
            b.putString(KEY_PACKAGENAME, this.mPackageName);
        }
        if (this.mApkPath != null) {
            b.putString(KEY_APKPATH, this.mApkPath);
        }
        b.putString(KEY_PAYLOADCONFIGPATH, this.mPayloadConfigPath);
        b.putString(KEY_PAYLOADBINARYNAME, this.mPayloadBinaryName);
        if (this.mCustomImageConfig != null) {
            b.putPersistableBundle(KEY_CUSTOMIMAGECONFIG, this.mCustomImageConfig.toPersistableBundle());
        }
        b.putInt(KEY_DEBUGLEVEL, this.mDebugLevel);
        b.putBoolean(KEY_PROTECTED_VM, this.mProtectedVm);
        b.putInt(KEY_CPU_TOPOLOGY, this.mCpuTopology);
        if (this.mConsoleInputDevice != null) {
            b.putString(KEY_CONSOLE_INPUT_DEVICE, this.mConsoleInputDevice);
        }
        if (this.mMemoryBytes > 0L) {
            b.putLong(KEY_MEMORY_BYTES, this.mMemoryBytes);
        }
        if (this.mEncryptedStorageBytes > 0L) {
            b.putLong(KEY_ENCRYPTED_STORAGE_BYTES, this.mEncryptedStorageBytes);
        }
        b.putBoolean(KEY_VM_OUTPUT_CAPTURED, this.mVmOutputCaptured);
        b.putBoolean(KEY_VM_CONSOLE_INPUT_SUPPORTED, this.mVmConsoleInputSupported);
        b.putBoolean(KEY_CONNECT_VM_CONSOLE, this.mConnectVmConsole);
        if (this.mVendorDiskImage != null) {
            b.putString(KEY_VENDOR_DISK_IMAGE_PATH, this.mVendorDiskImage.getAbsolutePath());
        }
        b.putString(KEY_OS, this.mOs);
        if (!this.mExtraApks.isEmpty()) {
            String[] extraApks = this.mExtraApks.toArray(new String[0]);
            b.putStringArray(KEY_EXTRA_APKS, extraApks);
        }
        b.putBoolean(KEY_SHOULD_BOOST_UCLAMP, this.mShouldBoostUclamp);
        b.putBoolean(KEY_SHOULD_USE_HUGEPAGES, this.mShouldUseHugepages);
        b.putInt(KEY_ENCRYPTED_STORE_MODE, this.mEncryptedStoreMode);
        b.writeToStream(output);
    }

    @SystemApi
    @Nullable
    public String getApkPath() {
        return this.mApkPath;
    }

    @NonNull
    public List<String> getExtraApks() {
        return this.mExtraApks;
    }

    @Nullable
    public String getPayloadConfigPath() {
        return this.mPayloadConfigPath;
    }

    @Nullable
    public VirtualMachineCustomImageConfig getCustomImageConfig() {
        return this.mCustomImageConfig;
    }

    @SystemApi
    @Nullable
    public String getPayloadBinaryName() {
        return this.mPayloadBinaryName;
    }

    @SystemApi
    public int getDebugLevel() {
        return this.mDebugLevel;
    }

    @SystemApi
    public boolean isProtectedVm() {
        return this.mProtectedVm;
    }

    @SystemApi
    public long getMemoryBytes() {
        return this.mMemoryBytes;
    }

    @SystemApi
    public int getCpuTopology() {
        return this.mCpuTopology;
    }

    @SystemApi
    public boolean isEncryptedStorageEnabled() {
        return this.mEncryptedStorageBytes > 0L;
    }

    public int getEncryptedStoreMode() {
        return this.mEncryptedStoreMode;
    }

    @SystemApi
    public long getEncryptedStorageBytes() {
        return this.mEncryptedStorageBytes;
    }

    @SystemApi
    public boolean isVmOutputCaptured() {
        return this.mVmOutputCaptured;
    }

    public boolean isVmConsoleInputSupported() {
        return this.mVmConsoleInputSupported;
    }

    public boolean isConnectVmConsole() {
        return this.mConnectVmConsole;
    }

    @NonNull
    public String getOs() {
        return this.mOs;
    }

    @SystemApi
    @FlaggedApi(value="com.android.system.virtualmachine.flags.promote_set_should_use_hugepages_to_system_api")
    public boolean shouldUseHugepages() {
        return this.mShouldUseHugepages;
    }

    @SystemApi
    public boolean isCompatibleWith(@NonNull VirtualMachineConfig other) {
        if (this == other) {
            return true;
        }
        return this.mDebugLevel == other.mDebugLevel && this.mProtectedVm == other.mProtectedVm && this.mVmOutputCaptured == other.mVmOutputCaptured && this.mVmConsoleInputSupported == other.mVmConsoleInputSupported && this.mConnectVmConsole == other.mConnectVmConsole && this.mVendorDiskImage == null == (other.mVendorDiskImage == null) && Objects.equals(this.mConsoleInputDevice, other.mConsoleInputDevice) && Objects.equals(this.mPayloadConfigPath, other.mPayloadConfigPath) && Objects.equals(this.mPayloadBinaryName, other.mPayloadBinaryName) && Objects.equals(this.mPackageName, other.mPackageName) && Objects.equals(this.mOs, other.mOs) && Objects.equals(this.mExtraApks, other.mExtraApks);
    }

    private ParcelFileDescriptor openOrNull(File file, int mode) {
        try {
            return ParcelFileDescriptor.open(file, mode);
        }
        catch (FileNotFoundException e) {
            Log.d(TAG, "cannot open", e);
            return null;
        }
    }

    private void startCrosvmVirtiofs(String sharedPath, int host_uid, int guest_uid, int guest_gid, String tagName, int mask, String socketPath) throws IOException {
        String ugidMapValue = String.format("%d %d %d %d %d /", guest_uid, guest_gid, host_uid, host_uid, mask);
        String cfgArg = String.format("ugid_map='%s'", ugidMapValue);
        ProcessBuilder pb = new ProcessBuilder("/apex/com.android.virt/bin/crosvm", "device", "fs", "--socket=" + socketPath, "--tag=" + tagName, "--shared-dir=" + sharedPath, "--cfg", cfgArg, "--disable-sandbox", "--skip-pivot-root=true");
        pb.start();
    }

    VirtualMachineRawConfig toVsRawConfig() throws IllegalStateException, IOException {
        int i;
        VirtualMachineRawConfig config = new VirtualMachineRawConfig();
        VirtualMachineCustomImageConfig customImageConfig = this.getCustomImageConfig();
        Objects.requireNonNull(customImageConfig);
        config.name = Optional.ofNullable(customImageConfig.getName()).orElse("");
        config.instanceId = new byte[64];
        config.kernel = Optional.ofNullable(customImageConfig.getKernelPath()).map(path -> {
            try {
                return ParcelFileDescriptor.open(new File((String)path), 0x10000000);
            }
            catch (FileNotFoundException e) {
                throw new RuntimeException(e);
            }
        }).orElse(null);
        config.initrd = Optional.ofNullable(customImageConfig.getInitrdPath()).map(path -> this.openOrNull(new File((String)path), 0x10000000)).orElse(null);
        config.bootloader = Optional.ofNullable(customImageConfig.getBootloaderPath()).map(path -> this.openOrNull(new File((String)path), 0x10000000)).orElse(null);
        if (config.kernel == null && config.bootloader == null) {
            config.bootloader = Arrays.stream(_Original_Build.SUPPORTED_ABIS).anyMatch("x86_64"::equals) ? this.openOrNull(new File(U_BOOT_PREBUILT_PATH_X86), 0x10000000) : this.openOrNull(new File(U_BOOT_PREBUILT_PATH_ARM), 0x10000000);
        }
        config.params = Optional.ofNullable(customImageConfig.getParams()).map(params -> TextUtils.join((CharSequence)" ", params)).orElse("");
        config.disks = new DiskImage[Optional.ofNullable(customImageConfig.getDisks()).map(arr -> ((VirtualMachineCustomImageConfig.Disk[])arr).length).orElse(0).intValue()];
        for (i = 0; i < config.disks.length; ++i) {
            config.disks[i] = new DiskImage();
            config.disks[i].writable = customImageConfig.getDisks()[i].isWritable();
            String diskImagePath = customImageConfig.getDisks()[i].getImagePath();
            if (diskImagePath != null) {
                config.disks[i].image = ParcelFileDescriptor.open(new File(diskImagePath), config.disks[i].writable ? 0x30000000 : 0x10000000);
            }
            ArrayList<Partition> partitions = new ArrayList<Partition>();
            for (VirtualMachineCustomImageConfig.Partition p : customImageConfig.getDisks()[i].getPartitions()) {
                Partition part = new Partition();
                part.label = p.name;
                part.image = ParcelFileDescriptor.open(new File(p.imagePath), p.writable ? 0x30000000 : 0x10000000);
                part.writable = p.writable;
                part.guid = TextUtils.isEmpty(p.guid) ? null : p.guid;
                partitions.add(part);
            }
            config.disks[i].partitions = partitions.toArray(new Partition[0]);
        }
        config.sharedPaths = new SharedPath[Optional.ofNullable(customImageConfig.getSharedPaths()).map(arr -> ((VirtualMachineCustomImageConfig.SharedPath[])arr).length).orElse(0).intValue()];
        for (i = 0; i < config.sharedPaths.length; ++i) {
            config.sharedPaths[i] = customImageConfig.getSharedPaths()[i].toParcelable();
            if (!config.sharedPaths[i].appDomain) continue;
            try {
                String socketPath = customImageConfig.getSharedPaths()[i].getSocketPath();
                this.startCrosvmVirtiofs(config.sharedPaths[i].sharedPath, config.sharedPaths[i].hostUid, config.sharedPaths[i].guestUid, config.sharedPaths[i].guestGid, config.sharedPaths[i].tag, config.sharedPaths[i].mask, socketPath);
                long startTime = System_Delegate.currentTimeMillis();
                long deadline = startTime + 5000L;
                while (!Files.exists(Path.of(socketPath, new String[0]), new LinkOption[0]) && System_Delegate.currentTimeMillis() < deadline) {
                    Thread.sleep(200L);
                }
                if (!Files.exists(Path.of(socketPath, new String[0]), new LinkOption[0])) {
                    throw new IOException("Timeout waiting for socket: " + socketPath);
                }
                LocalSocket socket = new LocalSocket();
                socket.connect(new LocalSocketAddress(socketPath, LocalSocketAddress.Namespace.FILESYSTEM));
                config.sharedPaths[i].socketFd = ParcelFileDescriptor.dup(socket.getFileDescriptor());
                continue;
            }
            catch (IOException | InterruptedException e) {
                Log.e(TAG, "startCrosvmVirtiofs failed", e);
                throw new RuntimeException(e);
            }
        }
        config.displayConfig = Optional.ofNullable(customImageConfig.getDisplayConfig()).map(dc -> dc.toParcelable()).orElse(null);
        config.gpuConfig = Optional.ofNullable(customImageConfig.getGpuConfig()).map(dc -> dc.toParcelable()).orElse(null);
        config.protectedVm = this.mProtectedVm;
        config.memoryMib = this.bytesToMebiBytes(this.mMemoryBytes);
        switch (this.mCpuTopology) {
            case 1: {
                config.cpuOptions = new CpuOptions();
                config.cpuOptions.cpuTopology = CpuOptions.CpuTopology.matchHost(true);
                break;
            }
            default: {
                config.cpuOptions = new CpuOptions();
                config.cpuOptions.cpuTopology = CpuOptions.CpuTopology.cpuCount(1);
            }
        }
        config.consoleInputDevice = this.mConsoleInputDevice;
        config.devices = AssignedDevices.devices(EMPTY_STRING_ARRAY);
        config.platformVersion = "~1.0";
        config.audioConfig = Optional.ofNullable(customImageConfig.getAudioConfig()).map(ac -> ac.toParcelable()).orElse(null);
        config.balloon = customImageConfig.useAutoMemoryBalloon();
        config.usbConfig = Optional.ofNullable(customImageConfig.getUsbConfig()).map(uc -> {
            UsbConfig usbConfig = new UsbConfig();
            usbConfig.controller = uc.getUsbController();
            return usbConfig;
        }).orElse(null);
        config.teeServices = EMPTY_STRING_ARRAY;
        config.customMemoryBackingFiles = new CustomMemoryBackingFile[0];
        config.hostServices = EMPTY_STRING_ARRAY;
        return config;
    }

    VirtualMachineAppConfig toVsConfig(@NonNull PackageManager packageManager) throws VirtualMachineException {
        VirtualMachineAppConfig vsConfig = new VirtualMachineAppConfig();
        String apkPath = this.mApkPath != null ? this.mApkPath : this.findPayloadApk(packageManager);
        try {
            vsConfig.apk = ParcelFileDescriptor.open(new File(apkPath), 0x10000000);
        }
        catch (FileNotFoundException e) {
            throw new VirtualMachineException("Failed to open APK", e);
        }
        if (this.mPayloadBinaryName != null) {
            VirtualMachinePayloadConfig payloadConfig = new VirtualMachinePayloadConfig();
            payloadConfig.payloadBinaryName = this.mPayloadBinaryName;
            payloadConfig.extraApks = Collections.emptyList();
            vsConfig.payload = VirtualMachineAppConfig.Payload.payloadConfig(payloadConfig);
        } else {
            vsConfig.payload = VirtualMachineAppConfig.Payload.configPath(this.mPayloadConfigPath);
        }
        vsConfig.osName = this.mOs;
        switch (this.mDebugLevel) {
            case 1: {
                vsConfig.debugLevel = 1;
                break;
            }
            default: {
                vsConfig.debugLevel = 0;
            }
        }
        vsConfig.protectedVm = this.mProtectedVm;
        vsConfig.memoryMib = this.bytesToMebiBytes(this.mMemoryBytes);
        switch (this.mCpuTopology) {
            case 1: {
                vsConfig.cpuOptions = new CpuOptions();
                vsConfig.cpuOptions.cpuTopology = CpuOptions.CpuTopology.matchHost(true);
                break;
            }
            default: {
                vsConfig.cpuOptions = new CpuOptions();
                vsConfig.cpuOptions.cpuTopology = CpuOptions.CpuTopology.cpuCount(1);
            }
        }
        if (this.mVendorDiskImage != null) {
            VirtualMachineAppConfig.CustomConfig customConfig = new VirtualMachineAppConfig.CustomConfig();
            customConfig.devices = EMPTY_STRING_ARRAY;
            customConfig.extraKernelCmdlineParams = EMPTY_STRING_ARRAY;
            customConfig.teeServices = EMPTY_STRING_ARRAY;
            try {
                customConfig.vendorImage = ParcelFileDescriptor.open(this.mVendorDiskImage, 0x10000000);
            }
            catch (FileNotFoundException e) {
                throw new VirtualMachineException("Failed to open vendor disk image " + this.mVendorDiskImage.getAbsolutePath(), e);
            }
            vsConfig.customConfig = customConfig;
        }
        vsConfig.boostUclamp = this.mShouldBoostUclamp;
        vsConfig.hugePages = this.mShouldUseHugepages;
        vsConfig.hostServices = EMPTY_STRING_ARRAY;
        if (this.mEncryptedStoreMode == 1) {
            vsConfig.shouldDelayEncryptedStoreSetup = true;
        }
        return vsConfig;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private String findPayloadApk(PackageManager packageManager) throws VirtualMachineException {
        ApplicationInfo appInfo;
        try {
            appInfo = packageManager.getApplicationInfo(this.mPackageName, PackageManager.ApplicationInfoFlags.of(0L));
        }
        catch (PackageManager.NameNotFoundException e) {
            throw new VirtualMachineException("Package not found", e);
        }
        String[] splitApkPaths = appInfo.splitSourceDirs;
        String[] abis = _Original_Build.SUPPORTED_64_BIT_ABIS;
        if (this.mPayloadBinaryName == null) return appInfo.sourceDir;
        if (splitApkPaths == null) return appInfo.sourceDir;
        if (abis.length == 0) return appInfo.sourceDir;
        String[] libraryNames = new String[abis.length];
        for (int i = 0; i < abis.length; ++i) {
            libraryNames[i] = "lib/" + abis[i] + "/" + this.mPayloadBinaryName;
        }
        String[] stringArray = splitApkPaths;
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String path = stringArray[n2];
            try (ZipFile zip = new ZipFile(path);){
                for (String name : libraryNames) {
                    if (zip.getEntry(name) == null) continue;
                    Log.i(TAG, "Found payload in " + path);
                    String string2 = path;
                    return string2;
                }
            }
            catch (IOException e) {
                Log.w(TAG, "Failed to scan split APK: " + path, e);
            }
            ++n2;
        }
        return appInfo.sourceDir;
    }

    private int bytesToMebiBytes(long mMemoryBytes) {
        long oneMebi = 0x100000L;
        if (mMemoryBytes > 0x7FFFFFFEL * oneMebi) {
            return Integer.MAX_VALUE;
        }
        return (int)((mMemoryBytes + oneMebi - 1L) / oneMebi);
    }

    @SystemApi
    public static class Builder {
        private final String DEFAULT_OS = "microdroid";
        @Nullable
        private final String mPackageName;
        @Nullable
        private String mApkPath;
        private final List<String> mExtraApks = new ArrayList<String>();
        @Nullable
        private String mPayloadConfigPath;
        @Nullable
        private VirtualMachineCustomImageConfig mCustomImageConfig;
        @Nullable
        private String mPayloadBinaryName;
        private int mDebugLevel = 0;
        private boolean mProtectedVm;
        private boolean mProtectedVmSet;
        private long mMemoryBytes;
        private int mCpuTopology = 0;
        @Nullable
        private String mConsoleInputDevice;
        private long mEncryptedStorageBytes;
        private boolean mVmOutputCaptured = false;
        private boolean mVmConsoleInputSupported = false;
        private boolean mConnectVmConsole = false;
        @Nullable
        private File mVendorDiskImage;
        @NonNull
        private String mOs = "microdroid";
        private boolean mShouldBoostUclamp = false;
        private boolean mShouldUseHugepages = false;
        private int mEncryptedStoreMode = 0;

        @SystemApi
        public Builder(@NonNull Context context) {
            this.mPackageName = Objects.requireNonNull(context, "context must not be null").getPackageName();
            if (BuildFlags.SUPPORT_LONG_RUNNING_VMS_ENABLED) {
                this.setEncryptedStoreMode(context);
            }
        }

        private Builder(@Nullable String packageName) {
            this.mPackageName = packageName;
        }

        @SystemApi
        @NonNull
        public VirtualMachineConfig build() {
            String apkPath = null;
            String packageName = null;
            if (this.mApkPath != null) {
                apkPath = this.mApkPath;
            } else if (this.mPackageName != null) {
                packageName = this.mPackageName;
            } else {
                throw new IllegalStateException("apkPath or packageName must be specified");
            }
            if (this.mCustomImageConfig != null) {
                if (this.mPayloadBinaryName != null || this.mPayloadConfigPath != null) {
                    throw new IllegalStateException("setCustomImageConfig and (setPayloadBinaryName or setPayloadConfigPath) may not both be called");
                }
            } else if (this.mPayloadBinaryName == null) {
                if (this.mPayloadConfigPath == null) {
                    throw new IllegalStateException("setPayloadBinaryName must be called");
                }
                if (!this.mExtraApks.isEmpty()) {
                    throw new IllegalStateException("setPayloadConfigPath and addExtraApk may not both be called");
                }
            } else if (this.mPayloadConfigPath != null) {
                throw new IllegalStateException("setPayloadBinaryName and setPayloadConfigPath may not both be called");
            }
            if (!this.mProtectedVmSet) {
                throw new IllegalStateException("setProtectedVm must be called explicitly");
            }
            if (this.mVmOutputCaptured && this.mDebugLevel != 1) {
                throw new IllegalStateException("debug level must be FULL to capture output");
            }
            if (this.mVmConsoleInputSupported && this.mDebugLevel != 1) {
                throw new IllegalStateException("debug level must be FULL to use console input");
            }
            if (this.mConnectVmConsole && this.mDebugLevel != 1) {
                throw new IllegalStateException("debug level must be FULL to connect to the console");
            }
            return new VirtualMachineConfig(packageName, apkPath, this.mExtraApks, this.mPayloadConfigPath, this.mPayloadBinaryName, this.mCustomImageConfig, this.mDebugLevel, this.mProtectedVm, this.mMemoryBytes, this.mCpuTopology, this.mConsoleInputDevice, this.mEncryptedStorageBytes, this.mVmOutputCaptured, this.mVmConsoleInputSupported, this.mConnectVmConsole, this.mVendorDiskImage, this.mOs, this.mShouldBoostUclamp, this.mShouldUseHugepages, this.mEncryptedStoreMode);
        }

        @SystemApi
        @NonNull
        public Builder setApkPath(@NonNull String apkPath) {
            Objects.requireNonNull(apkPath, "apkPath must not be null");
            if (!apkPath.startsWith("/")) {
                throw new IllegalArgumentException("APK path must be an absolute path");
            }
            this.mApkPath = apkPath;
            return this;
        }

        @NonNull
        public Builder addExtraApk(@NonNull String packageName) {
            this.mExtraApks.add(Objects.requireNonNull(packageName, "extra APK package name must not be null"));
            return this;
        }

        @RequiresPermission(value="android.permission.USE_CUSTOM_VIRTUAL_MACHINE")
        @NonNull
        public Builder setPayloadConfigPath(@NonNull String payloadConfigPath) {
            this.mPayloadConfigPath = Objects.requireNonNull(payloadConfigPath, "payloadConfigPath must not be null");
            return this;
        }

        @RequiresPermission(value="android.permission.USE_CUSTOM_VIRTUAL_MACHINE")
        @NonNull
        public Builder setCustomImageConfig(@NonNull VirtualMachineCustomImageConfig customImageConfig) {
            this.mCustomImageConfig = customImageConfig;
            return this;
        }

        @SystemApi
        @NonNull
        public Builder setPayloadBinaryName(@NonNull String payloadBinaryName) {
            Objects.requireNonNull(payloadBinaryName, "payloadBinaryName must not be null");
            if (payloadBinaryName.contains(File.separator)) {
                throw new IllegalArgumentException("Invalid binary file name: " + payloadBinaryName);
            }
            this.mPayloadBinaryName = payloadBinaryName;
            return this;
        }

        @SystemApi
        @NonNull
        public Builder setDebugLevel(int debugLevel) {
            if (debugLevel != 0 && debugLevel != 1) {
                throw new IllegalArgumentException("Invalid debugLevel: " + debugLevel);
            }
            this.mDebugLevel = debugLevel;
            return this;
        }

        @SystemApi
        @NonNull
        public Builder setProtectedVm(boolean protectedVm) {
            if (protectedVm) {
                if (!HypervisorProperties.hypervisor_protected_vm_supported().orElse(false).booleanValue()) {
                    throw new UnsupportedOperationException("Protected VMs are not supported on this device.");
                }
            } else if (!HypervisorProperties.hypervisor_vm_supported().orElse(false).booleanValue()) {
                throw new UnsupportedOperationException("Non-protected VMs are not supported on this device.");
            }
            this.mProtectedVm = protectedVm;
            this.mProtectedVmSet = true;
            return this;
        }

        @SystemApi
        @NonNull
        public Builder setMemoryBytes(long memoryBytes) {
            if (memoryBytes <= 0L) {
                throw new IllegalArgumentException("Memory size must be positive");
            }
            this.mMemoryBytes = memoryBytes;
            return this;
        }

        @SystemApi
        @NonNull
        public Builder setCpuTopology(int cpuTopology) {
            if (cpuTopology != 0 && cpuTopology != 1) {
                throw new IllegalArgumentException("Invalid cpuTopology: " + cpuTopology);
            }
            this.mCpuTopology = cpuTopology;
            return this;
        }

        public Builder setConsoleInputDevice(@Nullable String consoleInputDevice) {
            this.mConsoleInputDevice = consoleInputDevice;
            return this;
        }

        @SystemApi
        @NonNull
        public Builder setEncryptedStorageBytes(long encryptedStorageBytes) {
            if (encryptedStorageBytes <= 0L) {
                throw new IllegalArgumentException("Encrypted Storage size must be positive");
            }
            this.mEncryptedStorageBytes = encryptedStorageBytes;
            return this;
        }

        @SystemApi
        @NonNull
        public Builder setVmOutputCaptured(boolean captured) {
            this.mVmOutputCaptured = captured;
            return this;
        }

        @NonNull
        public Builder setVmConsoleInputSupported(boolean supported) {
            this.mVmConsoleInputSupported = supported;
            return this;
        }

        @NonNull
        public Builder setConnectVmConsole(boolean supported) {
            this.mConnectVmConsole = supported;
            return this;
        }

        @RequiresPermission(value="android.permission.USE_CUSTOM_VIRTUAL_MACHINE")
        @NonNull
        public Builder setVendorDiskImage(@NonNull File vendorDiskImage) {
            this.mVendorDiskImage = Objects.requireNonNull(vendorDiskImage, "vendor disk image must not be null");
            return this;
        }

        @RequiresPermission(value="android.permission.USE_CUSTOM_VIRTUAL_MACHINE")
        @NonNull
        public Builder setOs(@NonNull String os) {
            this.mOs = Objects.requireNonNull(os, "os must not be null");
            return this;
        }

        public Builder setShouldBoostUclamp(boolean shouldBoostUclamp) {
            this.mShouldBoostUclamp = shouldBoostUclamp;
            return this;
        }

        @SystemApi
        @FlaggedApi(value="com.android.system.virtualmachine.flags.promote_set_should_use_hugepages_to_system_api")
        @NonNull
        public Builder setShouldUseHugepages(boolean shouldUseHugepages) {
            this.mShouldUseHugepages = shouldUseHugepages;
            return this;
        }

        private Builder setEncryptedStoreMode(int encryptedStoreMode) {
            this.mEncryptedStoreMode = encryptedStoreMode;
            return this;
        }

        private Builder setEncryptedStoreMode(@NonNull Context context) {
            PackageManager pm = context.getPackageManager();
            try {
                PackageManager.Property prop = pm.getProperty(VirtualMachineConfig.ENCRYPTED_STORE_MODE_PROP_NAME, context.getPackageName());
                int value = prop.getInteger();
                if (value != 0 && value != 1) {
                    Log.w(VirtualMachineConfig.TAG, "android.system.virtualmachine.ENCRYPTED_STORE_MODE has unexpected value " + value);
                } else {
                    this.mEncryptedStoreMode = value;
                }
            }
            catch (PackageManager.NameNotFoundException nameNotFoundException) {
                // empty catch block
            }
            return this;
        }
    }

    @Retention(value=RetentionPolicy.SOURCE)
    private static @interface OsName {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    private static @interface EncryptedStoreMode {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface CpuTopology {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface DebugLevel {
    }
}

