/*
 * Decompiled with CFR 0.152.
 */
package android.service.voice;

import android.os.Binder;
import android.os.IBinder;
import android.os.IInterface;
import android.os.Parcel;
import android.os.RemoteException;
import android.service.voice.VisualQueryDetectedResult;
import android.service.voice.VisualQueryDetectionServiceFailure;

public interface IVisualQueryDetectionVoiceInteractionCallback
extends IInterface {
    public static final String DESCRIPTOR = "android.service.voice.IVisualQueryDetectionVoiceInteractionCallback";

    public void onQueryDetected(String var1) throws RemoteException;

    public void onResultDetected(VisualQueryDetectedResult var1) throws RemoteException;

    public void onQueryFinished() throws RemoteException;

    public void onQueryRejected() throws RemoteException;

    public void onVisualQueryDetectionServiceFailure(VisualQueryDetectionServiceFailure var1) throws RemoteException;

    public static abstract class Stub
    extends Binder
    implements IVisualQueryDetectionVoiceInteractionCallback {
        static final int TRANSACTION_onQueryDetected = 1;
        static final int TRANSACTION_onResultDetected = 2;
        static final int TRANSACTION_onQueryFinished = 3;
        static final int TRANSACTION_onQueryRejected = 4;
        static final int TRANSACTION_onVisualQueryDetectionServiceFailure = 5;

        public Stub() {
            this.attachInterface(this, IVisualQueryDetectionVoiceInteractionCallback.DESCRIPTOR);
        }

        public static IVisualQueryDetectionVoiceInteractionCallback asInterface(IBinder obj) {
            if (obj == null) {
                return null;
            }
            IInterface iin = obj.queryLocalInterface(IVisualQueryDetectionVoiceInteractionCallback.DESCRIPTOR);
            if (iin != null && iin instanceof IVisualQueryDetectionVoiceInteractionCallback) {
                return (IVisualQueryDetectionVoiceInteractionCallback)iin;
            }
            return new Proxy(obj);
        }

        @Override
        public IBinder asBinder() {
            return this;
        }

        public static String getDefaultTransactionName(int transactionCode) {
            switch (transactionCode) {
                case 1: {
                    return "onQueryDetected";
                }
                case 2: {
                    return "onResultDetected";
                }
                case 3: {
                    return "onQueryFinished";
                }
                case 4: {
                    return "onQueryRejected";
                }
                case 5: {
                    return "onVisualQueryDetectionServiceFailure";
                }
            }
            return null;
        }

        @Override
        public String getTransactionName(int transactionCode) {
            return Stub.getDefaultTransactionName(transactionCode);
        }

        @Override
        public boolean onTransact(int code, Parcel data, Parcel reply, int flags) throws RemoteException {
            String descriptor = IVisualQueryDetectionVoiceInteractionCallback.DESCRIPTOR;
            if (code >= 1 && code <= 0xFFFFFF) {
                data.enforceInterface(descriptor);
            }
            if (code == 1598968902) {
                reply.writeString(descriptor);
                return true;
            }
            switch (code) {
                case 1: {
                    String _arg0 = data.readString();
                    data.enforceNoDataAvail();
                    this.onQueryDetected(_arg0);
                    break;
                }
                case 2: {
                    VisualQueryDetectedResult _arg0 = data.readTypedObject(VisualQueryDetectedResult.CREATOR);
                    data.enforceNoDataAvail();
                    this.onResultDetected(_arg0);
                    break;
                }
                case 3: {
                    this.onQueryFinished();
                    break;
                }
                case 4: {
                    this.onQueryRejected();
                    break;
                }
                case 5: {
                    VisualQueryDetectionServiceFailure _arg0 = data.readTypedObject(VisualQueryDetectionServiceFailure.CREATOR);
                    data.enforceNoDataAvail();
                    this.onVisualQueryDetectionServiceFailure(_arg0);
                    break;
                }
                default: {
                    return super.onTransact(code, data, reply, flags);
                }
            }
            return true;
        }

        @Override
        public int getMaxTransactionId() {
            return 4;
        }

        private static class Proxy
        implements IVisualQueryDetectionVoiceInteractionCallback {
            private IBinder mRemote;

            Proxy(IBinder remote) {
                this.mRemote = remote;
            }

            @Override
            public IBinder asBinder() {
                return this.mRemote;
            }

            public String getInterfaceDescriptor() {
                return IVisualQueryDetectionVoiceInteractionCallback.DESCRIPTOR;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onQueryDetected(String partialQuery) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(IVisualQueryDetectionVoiceInteractionCallback.DESCRIPTOR);
                    _data.writeString(partialQuery);
                    boolean bl = this.mRemote.transact(1, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onResultDetected(VisualQueryDetectedResult partialResult) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(IVisualQueryDetectionVoiceInteractionCallback.DESCRIPTOR);
                    _data.writeTypedObject(partialResult, 0);
                    boolean bl = this.mRemote.transact(2, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            @Override
            public void onQueryFinished() throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(IVisualQueryDetectionVoiceInteractionCallback.DESCRIPTOR);
                    boolean bl = this.mRemote.transact(3, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            @Override
            public void onQueryRejected() throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(IVisualQueryDetectionVoiceInteractionCallback.DESCRIPTOR);
                    boolean bl = this.mRemote.transact(4, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onVisualQueryDetectionServiceFailure(VisualQueryDetectionServiceFailure visualQueryDetectionServiceFailure) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(IVisualQueryDetectionVoiceInteractionCallback.DESCRIPTOR);
                    _data.writeTypedObject(visualQueryDetectionServiceFailure, 0);
                    boolean bl = this.mRemote.transact(5, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }
        }
    }

    public static class Default
    implements IVisualQueryDetectionVoiceInteractionCallback {
        @Override
        public void onQueryDetected(String partialQuery) throws RemoteException {
        }

        @Override
        public void onResultDetected(VisualQueryDetectedResult partialResult) throws RemoteException {
        }

        @Override
        public void onQueryFinished() throws RemoteException {
        }

        @Override
        public void onQueryRejected() throws RemoteException {
        }

        @Override
        public void onVisualQueryDetectionServiceFailure(VisualQueryDetectionServiceFailure visualQueryDetectionServiceFailure) throws RemoteException {
        }

        @Override
        public IBinder asBinder() {
            return null;
        }
    }
}

