/*
 * Decompiled with CFR 0.152.
 */
package android.service.textclassifier;

import android.annotation.NonNull;
import android.annotation.Nullable;
import android.annotation.SystemApi;
import android.app.Service;
import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.pm.ResolveInfo;
import android.content.pm.ServiceInfo;
import android.os.Bundle;
import android.os.CancellationSignal;
import android.os.Handler;
import android.os.IBinder;
import android.os.Looper;
import android.os.Parcelable;
import android.os.RemoteException;
import android.service.textclassifier.ITextClassifierCallback;
import android.service.textclassifier.ITextClassifierService;
import android.text.TextUtils;
import android.util.Slog;
import android.view.textclassifier.ConversationActions;
import android.view.textclassifier.SelectionEvent;
import android.view.textclassifier.TextClassification;
import android.view.textclassifier.TextClassificationContext;
import android.view.textclassifier.TextClassificationManager;
import android.view.textclassifier.TextClassificationSessionId;
import android.view.textclassifier.TextClassifier;
import android.view.textclassifier.TextClassifierEvent;
import android.view.textclassifier.TextLanguage;
import android.view.textclassifier.TextLinks;
import android.view.textclassifier.TextSelection;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.Objects;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;

@SystemApi
public abstract class TextClassifierService
extends Service {
    private static final String LOG_TAG = "TextClassifierService";
    public static final String SERVICE_INTERFACE = "android.service.textclassifier.TextClassifierService";
    public static final int CONNECTED = 0;
    public static final int DISCONNECTED = 1;
    private static final String KEY_RESULT = "key_result";
    private final Handler mMainThreadHandler = new Handler(Looper.getMainLooper(), null, true);
    private final ExecutorService mSingleThreadExecutor = Executors.newSingleThreadExecutor();
    private final ITextClassifierService.Stub mBinder = new ITextClassifierService.Stub(){
        @NonNull
        private final CancellationSignal mCancellationSignal = new CancellationSignal();

        @Override
        public void onSuggestSelection(TextClassificationSessionId sessionId, TextSelection.Request request, ITextClassifierCallback callback) {
            Objects.requireNonNull(request);
            Objects.requireNonNull(callback);
            TextClassifierService.this.mMainThreadHandler.post(() -> TextClassifierService.this.onSuggestSelection(sessionId, request, this.mCancellationSignal, new ProxyCallback<TextSelection>(callback)));
        }

        @Override
        public void onClassifyText(TextClassificationSessionId sessionId, TextClassification.Request request, ITextClassifierCallback callback) {
            Objects.requireNonNull(request);
            Objects.requireNonNull(callback);
            TextClassifierService.this.mMainThreadHandler.post(() -> TextClassifierService.this.onClassifyText(sessionId, request, this.mCancellationSignal, new ProxyCallback<TextClassification>(callback)));
        }

        @Override
        public void onGenerateLinks(TextClassificationSessionId sessionId, TextLinks.Request request, ITextClassifierCallback callback) {
            Objects.requireNonNull(request);
            Objects.requireNonNull(callback);
            TextClassifierService.this.mMainThreadHandler.post(() -> TextClassifierService.this.onGenerateLinks(sessionId, request, this.mCancellationSignal, new ProxyCallback<TextLinks>(callback)));
        }

        @Override
        public void onSelectionEvent(TextClassificationSessionId sessionId, SelectionEvent event) {
            Objects.requireNonNull(event);
            TextClassifierService.this.mMainThreadHandler.post(() -> TextClassifierService.this.onSelectionEvent(sessionId, event));
        }

        @Override
        public void onTextClassifierEvent(TextClassificationSessionId sessionId, TextClassifierEvent event) {
            Objects.requireNonNull(event);
            TextClassifierService.this.mMainThreadHandler.post(() -> TextClassifierService.this.onTextClassifierEvent(sessionId, event));
        }

        @Override
        public void onDetectLanguage(TextClassificationSessionId sessionId, TextLanguage.Request request, ITextClassifierCallback callback) {
            Objects.requireNonNull(request);
            Objects.requireNonNull(callback);
            TextClassifierService.this.mMainThreadHandler.post(() -> TextClassifierService.this.onDetectLanguage(sessionId, request, this.mCancellationSignal, new ProxyCallback<TextLanguage>(callback)));
        }

        @Override
        public void onSuggestConversationActions(TextClassificationSessionId sessionId, ConversationActions.Request request, ITextClassifierCallback callback) {
            Objects.requireNonNull(request);
            Objects.requireNonNull(callback);
            TextClassifierService.this.mMainThreadHandler.post(() -> TextClassifierService.this.onSuggestConversationActions(sessionId, request, this.mCancellationSignal, new ProxyCallback<ConversationActions>(callback)));
        }

        @Override
        public void onCreateTextClassificationSession(TextClassificationContext context, TextClassificationSessionId sessionId) {
            Objects.requireNonNull(context);
            Objects.requireNonNull(sessionId);
            TextClassifierService.this.mMainThreadHandler.post(() -> TextClassifierService.this.onCreateTextClassificationSession(context, sessionId));
        }

        @Override
        public void onDestroyTextClassificationSession(TextClassificationSessionId sessionId) {
            TextClassifierService.this.mMainThreadHandler.post(() -> TextClassifierService.this.onDestroyTextClassificationSession(sessionId));
        }

        @Override
        public void onConnectedStateChanged(int connected) {
            TextClassifierService.this.mMainThreadHandler.post(connected == 0 ? TextClassifierService.this::onConnected : TextClassifierService.this::onDisconnected);
        }
    };

    @Override
    @Nullable
    public IBinder onBind(@NonNull Intent intent) {
        if (SERVICE_INTERFACE.equals(intent.getAction())) {
            return this.mBinder;
        }
        return null;
    }

    @Override
    public boolean onUnbind(@NonNull Intent intent) {
        this.onDisconnected();
        return super.onUnbind(intent);
    }

    public void onConnected() {
    }

    public void onDisconnected() {
    }

    public abstract void onSuggestSelection(@Nullable TextClassificationSessionId var1, @NonNull TextSelection.Request var2, @NonNull CancellationSignal var3, @NonNull Callback<TextSelection> var4);

    public abstract void onClassifyText(@Nullable TextClassificationSessionId var1, @NonNull TextClassification.Request var2, @NonNull CancellationSignal var3, @NonNull Callback<TextClassification> var4);

    public abstract void onGenerateLinks(@Nullable TextClassificationSessionId var1, @NonNull TextLinks.Request var2, @NonNull CancellationSignal var3, @NonNull Callback<TextLinks> var4);

    public void onDetectLanguage(@Nullable TextClassificationSessionId sessionId, @NonNull TextLanguage.Request request, @NonNull CancellationSignal cancellationSignal, @NonNull Callback<TextLanguage> callback) {
        this.mSingleThreadExecutor.submit(() -> callback.onSuccess(this.getLocalTextClassifier().detectLanguage(request)));
    }

    public void onSuggestConversationActions(@Nullable TextClassificationSessionId sessionId, @NonNull ConversationActions.Request request, @NonNull CancellationSignal cancellationSignal, @NonNull Callback<ConversationActions> callback) {
        this.mSingleThreadExecutor.submit(() -> callback.onSuccess(this.getLocalTextClassifier().suggestConversationActions(request)));
    }

    @Deprecated
    public void onSelectionEvent(@Nullable TextClassificationSessionId sessionId, @NonNull SelectionEvent event) {
    }

    public void onTextClassifierEvent(@Nullable TextClassificationSessionId sessionId, @NonNull TextClassifierEvent event) {
    }

    public void onCreateTextClassificationSession(@NonNull TextClassificationContext context, @NonNull TextClassificationSessionId sessionId) {
    }

    public void onDestroyTextClassificationSession(@NonNull TextClassificationSessionId sessionId) {
    }

    @Deprecated
    public TextClassifier getLocalTextClassifier() {
        return TextClassifier.NO_OP;
    }

    @NonNull
    public static TextClassifier getDefaultTextClassifierImplementation(@NonNull Context context) {
        String defaultTextClassifierPackageName = context.getPackageManager().getDefaultTextClassifierPackageName();
        if (TextUtils.isEmpty(defaultTextClassifierPackageName)) {
            return TextClassifier.NO_OP;
        }
        if (defaultTextClassifierPackageName.equals(context.getPackageName())) {
            throw new RuntimeException("The default text classifier itself should not call thegetDefaultTextClassifierImplementation() method.");
        }
        TextClassificationManager tcm = context.getSystemService(TextClassificationManager.class);
        return tcm.getTextClassifier(2);
    }

    public static <T extends Parcelable> T getResponse(Bundle bundle) {
        return bundle.getParcelable(KEY_RESULT);
    }

    public static <T extends Parcelable> void putResponse(Bundle bundle, T response) {
        bundle.putParcelable(KEY_RESULT, response);
    }

    @Nullable
    public static ComponentName getServiceComponentName(Context context, String packageName, int resolveFlags) {
        Intent intent = new Intent(SERVICE_INTERFACE).setPackage(packageName);
        ResolveInfo ri = context.getPackageManager().resolveService(intent, resolveFlags);
        if (ri == null || ri.serviceInfo == null) {
            Slog.w(LOG_TAG, String.format("Package or service not found in package %s for user %d", packageName, context.getUserId()));
            return null;
        }
        ServiceInfo si = ri.serviceInfo;
        String permission2 = si.permission;
        if ("android.permission.BIND_TEXTCLASSIFIER_SERVICE".equals(permission2)) {
            return si.getComponentName();
        }
        Slog.w(LOG_TAG, String.format("Service %s should require %s permission. Found %s permission", si.getComponentName(), "android.permission.BIND_TEXTCLASSIFIER_SERVICE", si.permission));
        return null;
    }

    public static interface Callback<T> {
        public void onSuccess(T var1);

        public void onFailure(@NonNull CharSequence var1);
    }

    private static class ProxyCallback<T extends Parcelable>
    implements Callback<T> {
        private ITextClassifierCallback mTextClassifierCallback;

        private ProxyCallback(ITextClassifierCallback textClassifierCallback) {
            this.mTextClassifierCallback = Objects.requireNonNull(textClassifierCallback);
        }

        @Override
        public void onSuccess(T result) {
            try {
                Bundle bundle = new Bundle(1);
                bundle.putParcelable(TextClassifierService.KEY_RESULT, (Parcelable)result);
                this.mTextClassifierCallback.onSuccess(bundle);
            }
            catch (RemoteException e) {
                Slog.d(TextClassifierService.LOG_TAG, "Error calling callback");
            }
        }

        @Override
        public void onFailure(CharSequence error) {
            try {
                Slog.w(TextClassifierService.LOG_TAG, "Request fail: " + error);
                this.mTextClassifierCallback.onFailure();
            }
            catch (RemoteException e) {
                Slog.d(TextClassifierService.LOG_TAG, "Error calling callback");
            }
        }
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface ConnectionState {
    }
}

