/*
 * Decompiled with CFR 0.152.
 */
package android.service.persistentdata;

import android.annotation.FlaggedApi;
import android.annotation.NonNull;
import android.annotation.Nullable;
import android.annotation.RequiresPermission;
import android.annotation.SuppressLint;
import android.annotation.SystemApi;
import android.os.RemoteException;
import android.service.persistentdata.IPersistentDataBlockService;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;

@FlaggedApi(value="android.security.frp_enforcement")
public class PersistentDataBlockManager {
    private static final String TAG = PersistentDataBlockManager.class.getSimpleName();
    private IPersistentDataBlockService sService;
    @SystemApi
    public static final int FLASH_LOCK_UNKNOWN = -1;
    @SystemApi
    public static final int FLASH_LOCK_UNLOCKED = 0;
    @SystemApi
    public static final int FLASH_LOCK_LOCKED = 1;

    public PersistentDataBlockManager(IPersistentDataBlockService service) {
        this.sService = service;
    }

    @SystemApi
    @SuppressLint(value={"RequiresPermission"})
    public int write(@Nullable byte[] data) {
        try {
            return this.sService.write(data);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @SystemApi
    @SuppressLint(value={"RequiresPermission"})
    @Nullable
    public byte[] read() {
        try {
            return this.sService.read();
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @SystemApi
    @RequiresPermission(value="android.permission.ACCESS_PDB_STATE")
    public int getDataBlockSize() {
        try {
            return this.sService.getDataBlockSize();
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @SystemApi
    @SuppressLint(value={"RequiresPermission"})
    public long getMaximumDataBlockSize() {
        try {
            return this.sService.getMaximumDataBlockSize();
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @SystemApi
    @RequiresPermission(value="android.permission.OEM_UNLOCK_STATE")
    public void wipe() {
        try {
            this.sService.wipe();
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @SystemApi
    @Deprecated
    @RequiresPermission(value="android.permission.OEM_UNLOCK_STATE")
    public void setOemUnlockEnabled(boolean enabled) {
        try {
            this.sService.setOemUnlockEnabled(enabled);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @SystemApi
    @Deprecated
    @RequiresPermission(anyOf={"android.permission.READ_OEM_UNLOCK_STATE", "android.permission.OEM_UNLOCK_STATE"})
    public boolean getOemUnlockEnabled() {
        try {
            return this.sService.getOemUnlockEnabled();
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @SystemApi
    @RequiresPermission(anyOf={"android.permission.READ_OEM_UNLOCK_STATE", "android.permission.OEM_UNLOCK_STATE"})
    public int getFlashLockState() {
        try {
            return this.sService.getFlashLockState();
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @SystemApi
    @NonNull
    @RequiresPermission(value="android.permission.ACCESS_PDB_STATE")
    public String getPersistentDataPackageName() {
        try {
            return this.sService.getPersistentDataPackageName();
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @FlaggedApi(value="android.security.frp_enforcement")
    public boolean isFactoryResetProtectionActive() {
        try {
            return this.sService.isFactoryResetProtectionActive();
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @SystemApi
    @FlaggedApi(value="android.security.frp_enforcement")
    @RequiresPermission(value="android.permission.CONFIGURE_FACTORY_RESET_PROTECTION")
    public boolean deactivateFactoryResetProtection(@NonNull byte[] secret) {
        try {
            return this.sService.deactivateFactoryResetProtection(secret);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @SystemApi
    @FlaggedApi(value="android.security.frp_enforcement")
    @SuppressLint(value={"RequiresPermission"})
    public boolean setFactoryResetProtectionSecret(@NonNull byte[] secret) {
        try {
            return this.sService.setFactoryResetProtectionSecret(secret);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @SystemApi
    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface FlashLockState {
    }
}

