/*
 * Decompiled with CFR 0.152.
 */
package android.service.notification;

import android.annotation.NonNull;
import android.annotation.Nullable;
import android.annotation.SuppressLint;
import android.os.Parcel;
import android.os.Parcelable;
import android.util.proto.ProtoOutputStream;
import com.android.layoutlib.androidx.annotation.VisibleForTesting;
import java.io.ByteArrayOutputStream;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;

public class ZenPolicy
implements Parcelable {
    public static final int FIELD_MESSAGES = 1;
    public static final int FIELD_CALLS = 2;
    public static final int FIELD_CONVERSATIONS = 4;
    public static final int FIELD_ALLOW_CHANNELS = 8;
    public static final int FIELD_PRIORITY_CATEGORY_REMINDERS = 16;
    public static final int FIELD_PRIORITY_CATEGORY_EVENTS = 32;
    public static final int FIELD_PRIORITY_CATEGORY_REPEAT_CALLERS = 64;
    public static final int FIELD_PRIORITY_CATEGORY_ALARMS = 128;
    public static final int FIELD_PRIORITY_CATEGORY_MEDIA = 256;
    public static final int FIELD_PRIORITY_CATEGORY_SYSTEM = 512;
    public static final int FIELD_VISUAL_EFFECT_FULL_SCREEN_INTENT = 1024;
    public static final int FIELD_VISUAL_EFFECT_LIGHTS = 2048;
    public static final int FIELD_VISUAL_EFFECT_PEEK = 4096;
    public static final int FIELD_VISUAL_EFFECT_STATUS_BAR = 8192;
    public static final int FIELD_VISUAL_EFFECT_BADGE = 16384;
    public static final int FIELD_VISUAL_EFFECT_AMBIENT = 32768;
    public static final int FIELD_VISUAL_EFFECT_NOTIFICATION_LIST = 65536;
    private List<Integer> mPriorityCategories;
    private List<Integer> mVisualEffects;
    private int mPriorityMessages = 0;
    private int mPriorityCalls = 0;
    private int mConversationSenders = 0;
    private int mAllowChannels = 0;
    public static final int PRIORITY_CATEGORY_REMINDERS = 0;
    public static final int PRIORITY_CATEGORY_EVENTS = 1;
    public static final int PRIORITY_CATEGORY_MESSAGES = 2;
    public static final int PRIORITY_CATEGORY_CALLS = 3;
    public static final int PRIORITY_CATEGORY_REPEAT_CALLERS = 4;
    public static final int PRIORITY_CATEGORY_ALARMS = 5;
    public static final int PRIORITY_CATEGORY_MEDIA = 6;
    public static final int PRIORITY_CATEGORY_SYSTEM = 7;
    public static final int PRIORITY_CATEGORY_CONVERSATIONS = 8;
    @VisibleForTesting
    public static final int NUM_PRIORITY_CATEGORIES = 9;
    public static final int VISUAL_EFFECT_FULL_SCREEN_INTENT = 0;
    public static final int VISUAL_EFFECT_LIGHTS = 1;
    public static final int VISUAL_EFFECT_PEEK = 2;
    public static final int VISUAL_EFFECT_STATUS_BAR = 3;
    public static final int VISUAL_EFFECT_BADGE = 4;
    public static final int VISUAL_EFFECT_AMBIENT = 5;
    public static final int VISUAL_EFFECT_NOTIFICATION_LIST = 6;
    @VisibleForTesting
    public static final int NUM_VISUAL_EFFECTS = 7;
    public static final int PEOPLE_TYPE_UNSET = 0;
    public static final int PEOPLE_TYPE_ANYONE = 1;
    public static final int PEOPLE_TYPE_CONTACTS = 2;
    public static final int PEOPLE_TYPE_STARRED = 3;
    public static final int PEOPLE_TYPE_NONE = 4;
    public static final int CONVERSATION_SENDERS_UNSET = 0;
    public static final int CONVERSATION_SENDERS_ANYONE = 1;
    public static final int CONVERSATION_SENDERS_IMPORTANT = 2;
    public static final int CONVERSATION_SENDERS_NONE = 3;
    public static final int STATE_UNSET = 0;
    public static final int STATE_ALLOW = 1;
    public static final int STATE_DISALLOW = 2;
    public static final int CHANNEL_POLICY_UNSET = 0;
    public static final int CHANNEL_POLICY_PRIORITY = 1;
    public static final int CHANNEL_POLICY_NONE = 2;
    @NonNull
    public static final Parcelable.Creator<ZenPolicy> CREATOR = new Parcelable.Creator<ZenPolicy>(){

        @Override
        public ZenPolicy createFromParcel(Parcel source) {
            return new ZenPolicy(ZenPolicy.trimList(source.readArrayList(Integer.class.getClassLoader(), Integer.class), 9), ZenPolicy.trimList(source.readArrayList(Integer.class.getClassLoader(), Integer.class), 7), source.readInt(), source.readInt(), source.readInt(), source.readInt());
        }

        public ZenPolicy[] newArray(int size) {
            return new ZenPolicy[size];
        }
    };

    public ZenPolicy() {
        this.mPriorityCategories = new ArrayList<Integer>(Collections.nCopies(9, 0));
        this.mVisualEffects = new ArrayList<Integer>(Collections.nCopies(7, 0));
    }

    public ZenPolicy(List<Integer> priorityCategories, List<Integer> visualEffects, int priorityMessages, int priorityCalls, int conversationSenders, int allowChannels) {
        this.mPriorityCategories = priorityCategories;
        this.mVisualEffects = visualEffects;
        this.mPriorityMessages = priorityMessages;
        this.mPriorityCalls = priorityCalls;
        this.mConversationSenders = conversationSenders;
        this.mAllowChannels = allowChannels;
    }

    public static ZenPolicy getBasePolicyInterruptionFilterAlarms() {
        return new Builder().disallowAllSounds().allowAlarms(true).allowMedia(true).allowPriorityChannels(false).build();
    }

    public static ZenPolicy getBasePolicyInterruptionFilterNone() {
        return new Builder().disallowAllSounds().allowPriorityChannels(false).build();
    }

    public int getPriorityConversationSenders() {
        return this.mConversationSenders;
    }

    public int getPriorityMessageSenders() {
        return this.mPriorityMessages;
    }

    public int getPriorityCallSenders() {
        return this.mPriorityCalls;
    }

    public int getPriorityCategoryConversations() {
        return this.mPriorityCategories.get(8);
    }

    public int getPriorityCategoryReminders() {
        return this.mPriorityCategories.get(0);
    }

    public int getPriorityCategoryEvents() {
        return this.mPriorityCategories.get(1);
    }

    public int getPriorityCategoryMessages() {
        return this.mPriorityCategories.get(2);
    }

    public int getPriorityCategoryCalls() {
        return this.mPriorityCategories.get(3);
    }

    public int getPriorityCategoryRepeatCallers() {
        return this.mPriorityCategories.get(4);
    }

    public int getPriorityCategoryAlarms() {
        return this.mPriorityCategories.get(5);
    }

    public int getPriorityCategoryMedia() {
        return this.mPriorityCategories.get(6);
    }

    public int getPriorityCategorySystem() {
        return this.mPriorityCategories.get(7);
    }

    public int getVisualEffectFullScreenIntent() {
        return this.mVisualEffects.get(0);
    }

    public int getVisualEffectLights() {
        return this.mVisualEffects.get(1);
    }

    public int getVisualEffectPeek() {
        return this.mVisualEffects.get(2);
    }

    public int getVisualEffectStatusBar() {
        return this.mVisualEffects.get(3);
    }

    public int getVisualEffectBadge() {
        return this.mVisualEffects.get(4);
    }

    public int getVisualEffectAmbient() {
        return this.mVisualEffects.get(5);
    }

    public int getVisualEffectNotificationList() {
        return this.mVisualEffects.get(6);
    }

    public int getAllowedChannels() {
        return this.mAllowChannels;
    }

    public int getPriorityChannelsAllowed() {
        switch (this.mAllowChannels) {
            case 1: {
                return 1;
            }
            case 2: {
                return 2;
            }
        }
        return 0;
    }

    public boolean shouldHideAllVisualEffects() {
        for (int i = 0; i < this.mVisualEffects.size(); ++i) {
            if (this.mVisualEffects.get(i) == 2) continue;
            return false;
        }
        return true;
    }

    public boolean shouldShowAllVisualEffects() {
        for (int i = 0; i < this.mVisualEffects.size(); ++i) {
            if (this.mVisualEffects.get(i) == 1) continue;
            return false;
        }
        return true;
    }

    @Override
    public int describeContents() {
        return 0;
    }

    @Override
    public void writeToParcel(Parcel dest, int flags) {
        dest.writeList(this.mPriorityCategories);
        dest.writeList(this.mVisualEffects);
        dest.writeInt(this.mPriorityMessages);
        dest.writeInt(this.mPriorityCalls);
        dest.writeInt(this.mConversationSenders);
        dest.writeInt(this.mAllowChannels);
    }

    public String toString() {
        return ZenPolicy.class.getSimpleName() + '{' + "priorityCategories=[" + this.priorityCategoriesToString() + "], visualEffects=[" + this.visualEffectsToString() + "], priorityCallsSenders=" + ZenPolicy.peopleTypeToString(this.mPriorityCalls) + ", priorityMessagesSenders=" + ZenPolicy.peopleTypeToString(this.mPriorityMessages) + ", priorityConversationSenders=" + ZenPolicy.conversationTypeToString(this.mConversationSenders) + ", allowChannels=" + ZenPolicy.channelTypeToString(this.mAllowChannels) + '}';
    }

    public static String fieldsToString(int bitmask) {
        ArrayList<String> modified = new ArrayList<String>();
        if ((bitmask & 1) != 0) {
            modified.add("FIELD_MESSAGES");
        }
        if ((bitmask & 2) != 0) {
            modified.add("FIELD_CALLS");
        }
        if ((bitmask & 4) != 0) {
            modified.add("FIELD_CONVERSATIONS");
        }
        if ((bitmask & 8) != 0) {
            modified.add("FIELD_ALLOW_CHANNELS");
        }
        if ((bitmask & 0x10) != 0) {
            modified.add("FIELD_PRIORITY_CATEGORY_REMINDERS");
        }
        if ((bitmask & 0x20) != 0) {
            modified.add("FIELD_PRIORITY_CATEGORY_EVENTS");
        }
        if ((bitmask & 0x40) != 0) {
            modified.add("FIELD_PRIORITY_CATEGORY_REPEAT_CALLERS");
        }
        if ((bitmask & 0x80) != 0) {
            modified.add("FIELD_PRIORITY_CATEGORY_ALARMS");
        }
        if ((bitmask & 0x100) != 0) {
            modified.add("FIELD_PRIORITY_CATEGORY_MEDIA");
        }
        if ((bitmask & 0x200) != 0) {
            modified.add("FIELD_PRIORITY_CATEGORY_SYSTEM");
        }
        if ((bitmask & 0x400) != 0) {
            modified.add("FIELD_VISUAL_EFFECT_FULL_SCREEN_INTENT");
        }
        if ((bitmask & 0x800) != 0) {
            modified.add("FIELD_VISUAL_EFFECT_LIGHTS");
        }
        if ((bitmask & 0x1000) != 0) {
            modified.add("FIELD_VISUAL_EFFECT_PEEK");
        }
        if ((bitmask & 0x2000) != 0) {
            modified.add("FIELD_VISUAL_EFFECT_STATUS_BAR");
        }
        if ((bitmask & 0x4000) != 0) {
            modified.add("FIELD_VISUAL_EFFECT_BADGE");
        }
        if ((bitmask & 0x8000) != 0) {
            modified.add("FIELD_VISUAL_EFFECT_AMBIENT");
        }
        if ((bitmask & 0x10000) != 0) {
            modified.add("FIELD_VISUAL_EFFECT_NOTIFICATION_LIST");
        }
        return "{" + String.join((CharSequence)",", modified) + "}";
    }

    private static ArrayList<Integer> trimList(ArrayList<Integer> list, int maxLength) {
        if (list == null || list.size() <= maxLength) {
            return list;
        }
        return new ArrayList<Integer>(list.subList(0, maxLength));
    }

    private String priorityCategoriesToString() {
        StringBuilder builder = new StringBuilder();
        for (int i = 0; i < this.mPriorityCategories.size(); ++i) {
            if (this.mPriorityCategories.get(i) == 0) continue;
            builder.append(this.indexToCategory(i)).append("=").append(this.stateToString(this.mPriorityCategories.get(i))).append(" ");
        }
        return builder.toString();
    }

    private String visualEffectsToString() {
        StringBuilder builder = new StringBuilder();
        for (int i = 0; i < this.mVisualEffects.size(); ++i) {
            if (this.mVisualEffects.get(i) == 0) continue;
            builder.append(this.indexToVisualEffect(i)).append("=").append(this.stateToString(this.mVisualEffects.get(i))).append(" ");
        }
        return builder.toString();
    }

    private String indexToVisualEffect(int visualEffectIndex) {
        switch (visualEffectIndex) {
            case 0: {
                return "fullScreenIntent";
            }
            case 1: {
                return "lights";
            }
            case 2: {
                return "peek";
            }
            case 3: {
                return "statusBar";
            }
            case 4: {
                return "badge";
            }
            case 5: {
                return "ambient";
            }
            case 6: {
                return "notificationList";
            }
        }
        return null;
    }

    private String indexToCategory(int categoryIndex) {
        switch (categoryIndex) {
            case 0: {
                return "reminders";
            }
            case 1: {
                return "events";
            }
            case 2: {
                return "messages";
            }
            case 3: {
                return "calls";
            }
            case 4: {
                return "repeatCallers";
            }
            case 5: {
                return "alarms";
            }
            case 6: {
                return "media";
            }
            case 7: {
                return "system";
            }
            case 8: {
                return "convs";
            }
        }
        return null;
    }

    private String stateToString(int state) {
        switch (state) {
            case 0: {
                return "unset";
            }
            case 2: {
                return "disallow";
            }
            case 1: {
                return "allow";
            }
        }
        return "invalidState{" + state + "}";
    }

    public static String peopleTypeToString(int peopleType) {
        switch (peopleType) {
            case 1: {
                return "anyone";
            }
            case 2: {
                return "contacts";
            }
            case 4: {
                return "none";
            }
            case 3: {
                return "starred_contacts";
            }
            case 0: {
                return "unset";
            }
        }
        return "invalidPeopleType{" + peopleType + "}";
    }

    public static String conversationTypeToString(int conversationType) {
        switch (conversationType) {
            case 1: {
                return "anyone";
            }
            case 2: {
                return "important";
            }
            case 3: {
                return "none";
            }
            case 0: {
                return "unset";
            }
        }
        return "invalidConversationType{" + conversationType + "}";
    }

    public static String channelTypeToString(int channelType) {
        switch (channelType) {
            case 0: {
                return "unset";
            }
            case 1: {
                return "priority";
            }
            case 2: {
                return "none";
            }
        }
        return "invalidChannelType{" + channelType + "}";
    }

    public boolean equals(@Nullable Object o) {
        if (!(o instanceof ZenPolicy)) {
            return false;
        }
        if (o == this) {
            return true;
        }
        ZenPolicy other = (ZenPolicy)o;
        return Objects.equals(other.mPriorityCategories, this.mPriorityCategories) && Objects.equals(other.mVisualEffects, this.mVisualEffects) && other.mPriorityCalls == this.mPriorityCalls && other.mPriorityMessages == this.mPriorityMessages && other.mConversationSenders == this.mConversationSenders && other.mAllowChannels == this.mAllowChannels;
    }

    public int hashCode() {
        return Objects.hash(this.mPriorityCategories, this.mVisualEffects, this.mPriorityCalls, this.mPriorityMessages, this.mConversationSenders, this.mAllowChannels);
    }

    private int getZenPolicyPriorityCategoryState(int category) {
        switch (category) {
            case 0: {
                return this.getPriorityCategoryReminders();
            }
            case 1: {
                return this.getPriorityCategoryEvents();
            }
            case 2: {
                return this.getPriorityCategoryMessages();
            }
            case 3: {
                return this.getPriorityCategoryCalls();
            }
            case 4: {
                return this.getPriorityCategoryRepeatCallers();
            }
            case 5: {
                return this.getPriorityCategoryAlarms();
            }
            case 6: {
                return this.getPriorityCategoryMedia();
            }
            case 7: {
                return this.getPriorityCategorySystem();
            }
            case 8: {
                return this.getPriorityCategoryConversations();
            }
        }
        return -1;
    }

    private int getZenPolicyVisualEffectState(int effect) {
        switch (effect) {
            case 0: {
                return this.getVisualEffectFullScreenIntent();
            }
            case 1: {
                return this.getVisualEffectLights();
            }
            case 2: {
                return this.getVisualEffectPeek();
            }
            case 3: {
                return this.getVisualEffectStatusBar();
            }
            case 4: {
                return this.getVisualEffectBadge();
            }
            case 5: {
                return this.getVisualEffectAmbient();
            }
            case 6: {
                return this.getVisualEffectNotificationList();
            }
        }
        return -1;
    }

    public static boolean stateToBoolean(int state, boolean defaultVal) {
        switch (state) {
            case 1: {
                return true;
            }
            case 2: {
                return false;
            }
        }
        return defaultVal;
    }

    public boolean isCategoryAllowed(int category, boolean defaultVal) {
        return ZenPolicy.stateToBoolean(this.getZenPolicyPriorityCategoryState(category), defaultVal);
    }

    public boolean isVisualEffectAllowed(int effect, boolean defaultVal) {
        return ZenPolicy.stateToBoolean(this.getZenPolicyVisualEffectState(effect), defaultVal);
    }

    public void apply(ZenPolicy policyToApply) {
        if (policyToApply == null) {
            return;
        }
        for (int category = 0; category < this.mPriorityCategories.size(); ++category) {
            int newState;
            if (this.mPriorityCategories.get(category) == 2 || (newState = policyToApply.mPriorityCategories.get(category).intValue()) == 0) continue;
            this.mPriorityCategories.set(category, newState);
            if (category == 2 && this.mPriorityMessages < policyToApply.mPriorityMessages) {
                this.mPriorityMessages = policyToApply.mPriorityMessages;
                continue;
            }
            if (category == 3 && this.mPriorityCalls < policyToApply.mPriorityCalls) {
                this.mPriorityCalls = policyToApply.mPriorityCalls;
                continue;
            }
            if (category != 8 || this.mConversationSenders >= policyToApply.mConversationSenders) continue;
            this.mConversationSenders = policyToApply.mConversationSenders;
        }
        for (int visualEffect = 0; visualEffect < this.mVisualEffects.size(); ++visualEffect) {
            if (this.mVisualEffects.get(visualEffect) == 2 || policyToApply.mVisualEffects.get(visualEffect) == 0) continue;
            this.mVisualEffects.set(visualEffect, policyToApply.mVisualEffects.get(visualEffect));
        }
        if (this.mAllowChannels != 2 && policyToApply.mAllowChannels != 0) {
            this.mAllowChannels = policyToApply.mAllowChannels;
        }
    }

    @NonNull
    public ZenPolicy overwrittenWith(@Nullable ZenPolicy newPolicy) {
        ZenPolicy result = this.copy();
        if (newPolicy == null) {
            return result;
        }
        for (int category = 0; category < this.mPriorityCategories.size(); ++category) {
            int newState = newPolicy.mPriorityCategories.get(category);
            if (newState == 0) continue;
            result.mPriorityCategories.set(category, newState);
            if (category == 2) {
                result.mPriorityMessages = newPolicy.mPriorityMessages;
                continue;
            }
            if (category == 3) {
                result.mPriorityCalls = newPolicy.mPriorityCalls;
                continue;
            }
            if (category != 8) continue;
            result.mConversationSenders = newPolicy.mConversationSenders;
        }
        for (int visualEffect = 0; visualEffect < this.mVisualEffects.size(); ++visualEffect) {
            if (newPolicy.mVisualEffects.get(visualEffect) == 0) continue;
            result.mVisualEffects.set(visualEffect, newPolicy.mVisualEffects.get(visualEffect));
        }
        if (newPolicy.mAllowChannels != 0) {
            result.mAllowChannels = newPolicy.mAllowChannels;
        }
        return result;
    }

    public void dumpDebug(ProtoOutputStream proto, long fieldId) {
        long token = proto.start(fieldId);
        proto.write(0x10E00000001L, this.getPriorityCategoryReminders());
        proto.write(1159641169922L, this.getPriorityCategoryEvents());
        proto.write(1159641169923L, this.getPriorityCategoryMessages());
        proto.write(1159641169924L, this.getPriorityCategoryCalls());
        proto.write(1159641169925L, this.getPriorityCategoryRepeatCallers());
        proto.write(1159641169926L, this.getPriorityCategoryAlarms());
        proto.write(1159641169927L, this.getPriorityCategoryMedia());
        proto.write(1159641169928L, this.getPriorityCategorySystem());
        proto.write(1159641169929L, this.getVisualEffectFullScreenIntent());
        proto.write(1159641169930L, this.getVisualEffectLights());
        proto.write(1159641169931L, this.getVisualEffectPeek());
        proto.write(1159641169932L, this.getVisualEffectStatusBar());
        proto.write(1159641169933L, this.getVisualEffectBadge());
        proto.write(0x10E0000000EL, this.getVisualEffectAmbient());
        proto.write(1159641169935L, this.getVisualEffectNotificationList());
        proto.write(0x10E00000011L, this.getPriorityMessageSenders());
        proto.write(0x10E00000010L, this.getPriorityCallSenders());
        proto.end(token);
    }

    public byte[] toProto() {
        ByteArrayOutputStream bytes = new ByteArrayOutputStream();
        ProtoOutputStream proto = new ProtoOutputStream(bytes);
        proto.write(0x10E00000001L, this.getPriorityCategoryCalls());
        proto.write(1159641169922L, this.getPriorityCategoryRepeatCallers());
        proto.write(1159641169923L, this.getPriorityCategoryMessages());
        proto.write(1159641169924L, this.getPriorityCategoryConversations());
        proto.write(1159641169925L, this.getPriorityCategoryReminders());
        proto.write(1159641169926L, this.getPriorityCategoryEvents());
        proto.write(1159641169927L, this.getPriorityCategoryAlarms());
        proto.write(1159641169928L, this.getPriorityCategoryMedia());
        proto.write(1159641169929L, this.getPriorityCategorySystem());
        proto.write(1159641169930L, this.getVisualEffectFullScreenIntent());
        proto.write(1159641169931L, this.getVisualEffectLights());
        proto.write(1159641169932L, this.getVisualEffectPeek());
        proto.write(1159641169933L, this.getVisualEffectStatusBar());
        proto.write(0x10E0000000EL, this.getVisualEffectBadge());
        proto.write(1159641169935L, this.getVisualEffectAmbient());
        proto.write(0x10E00000010L, this.getVisualEffectNotificationList());
        proto.write(0x10E00000011L, this.getPriorityCallSenders());
        proto.write(1159641169938L, this.getPriorityMessageSenders());
        proto.write(1159641169939L, this.getPriorityConversationSenders());
        proto.write(1159641169940L, this.getPriorityChannelsAllowed());
        proto.flush();
        return bytes.toByteArray();
    }

    @NonNull
    public ZenPolicy copy() {
        Parcel parcel = Parcel.obtain();
        try {
            this.writeToParcel(parcel, 0);
            parcel.setDataPosition(0);
            ZenPolicy zenPolicy = CREATOR.createFromParcel(parcel);
            return zenPolicy;
        }
        finally {
            parcel.recycle();
        }
    }

    public static class Builder {
        private ZenPolicy mZenPolicy;

        public Builder() {
            this.mZenPolicy = new ZenPolicy();
        }

        @SuppressLint(value={"UnflaggedApi"})
        public Builder(@Nullable ZenPolicy policy) {
            this.mZenPolicy = policy != null ? policy.copy() : new ZenPolicy();
        }

        @NonNull
        public ZenPolicy build() {
            return new ZenPolicy(new ArrayList<Integer>(this.mZenPolicy.mPriorityCategories), new ArrayList<Integer>(this.mZenPolicy.mVisualEffects), this.mZenPolicy.mPriorityMessages, this.mZenPolicy.mPriorityCalls, this.mZenPolicy.mConversationSenders, this.mZenPolicy.mAllowChannels);
        }

        @NonNull
        public Builder allowAllSounds() {
            for (int i = 0; i < this.mZenPolicy.mPriorityCategories.size(); ++i) {
                this.mZenPolicy.mPriorityCategories.set(i, 1);
            }
            this.mZenPolicy.mPriorityMessages = 1;
            this.mZenPolicy.mPriorityCalls = 1;
            this.mZenPolicy.mConversationSenders = 1;
            return this;
        }

        @NonNull
        public Builder disallowAllSounds() {
            for (int i = 0; i < this.mZenPolicy.mPriorityCategories.size(); ++i) {
                this.mZenPolicy.mPriorityCategories.set(i, 2);
            }
            this.mZenPolicy.mPriorityMessages = 4;
            this.mZenPolicy.mPriorityCalls = 4;
            this.mZenPolicy.mConversationSenders = 3;
            return this;
        }

        @NonNull
        public Builder showAllVisualEffects() {
            for (int i = 0; i < this.mZenPolicy.mVisualEffects.size(); ++i) {
                this.mZenPolicy.mVisualEffects.set(i, 1);
            }
            return this;
        }

        @NonNull
        public Builder hideAllVisualEffects() {
            for (int i = 0; i < this.mZenPolicy.mVisualEffects.size(); ++i) {
                this.mZenPolicy.mVisualEffects.set(i, 2);
            }
            return this;
        }

        @NonNull
        public Builder unsetPriorityCategory(int category) {
            this.mZenPolicy.mPriorityCategories.set(category, 0);
            if (category == 2) {
                this.mZenPolicy.mPriorityMessages = 0;
            } else if (category == 3) {
                this.mZenPolicy.mPriorityCalls = 0;
            } else if (category == 8) {
                this.mZenPolicy.mConversationSenders = 0;
            }
            return this;
        }

        @NonNull
        public Builder unsetVisualEffect(int effect) {
            this.mZenPolicy.mVisualEffects.set(effect, 0);
            return this;
        }

        @NonNull
        public Builder allowReminders(boolean allow) {
            this.mZenPolicy.mPriorityCategories.set(0, allow ? 1 : 2);
            return this;
        }

        @NonNull
        public Builder allowEvents(boolean allow) {
            this.mZenPolicy.mPriorityCategories.set(1, allow ? 1 : 2);
            return this;
        }

        @NonNull
        public Builder allowConversations(int audienceType) {
            if (audienceType == 0) {
                return this.unsetPriorityCategory(8);
            }
            if (audienceType == 3) {
                this.mZenPolicy.mPriorityCategories.set(8, 2);
            } else if (audienceType == 1 || audienceType == 2) {
                this.mZenPolicy.mPriorityCategories.set(8, 1);
            } else {
                return this;
            }
            this.mZenPolicy.mConversationSenders = audienceType;
            return this;
        }

        @NonNull
        public Builder allowMessages(int audienceType) {
            if (audienceType == 0) {
                return this.unsetPriorityCategory(2);
            }
            if (audienceType == 4) {
                this.mZenPolicy.mPriorityCategories.set(2, 2);
            } else if (audienceType == 1 || audienceType == 2 || audienceType == 3) {
                this.mZenPolicy.mPriorityCategories.set(2, 1);
            } else {
                return this;
            }
            this.mZenPolicy.mPriorityMessages = audienceType;
            return this;
        }

        @NonNull
        public Builder allowCalls(int audienceType) {
            if (audienceType == 0) {
                return this.unsetPriorityCategory(3);
            }
            if (audienceType == 4) {
                this.mZenPolicy.mPriorityCategories.set(3, 2);
            } else if (audienceType == 1 || audienceType == 2 || audienceType == 3) {
                this.mZenPolicy.mPriorityCategories.set(3, 1);
            } else {
                return this;
            }
            this.mZenPolicy.mPriorityCalls = audienceType;
            return this;
        }

        @NonNull
        public Builder allowRepeatCallers(boolean allow) {
            this.mZenPolicy.mPriorityCategories.set(4, allow ? 1 : 2);
            return this;
        }

        @NonNull
        public Builder allowAlarms(boolean allow) {
            this.mZenPolicy.mPriorityCategories.set(5, allow ? 1 : 2);
            return this;
        }

        @NonNull
        public Builder allowMedia(boolean allow) {
            this.mZenPolicy.mPriorityCategories.set(6, allow ? 1 : 2);
            return this;
        }

        @NonNull
        public Builder allowSystem(boolean allow) {
            this.mZenPolicy.mPriorityCategories.set(7, allow ? 1 : 2);
            return this;
        }

        @NonNull
        public Builder allowCategory(int category, boolean allow) {
            switch (category) {
                case 5: {
                    this.allowAlarms(allow);
                    break;
                }
                case 6: {
                    this.allowMedia(allow);
                    break;
                }
                case 7: {
                    this.allowSystem(allow);
                    break;
                }
                case 0: {
                    this.allowReminders(allow);
                    break;
                }
                case 1: {
                    this.allowEvents(allow);
                    break;
                }
                case 4: {
                    this.allowRepeatCallers(allow);
                }
            }
            return this;
        }

        @NonNull
        public Builder showFullScreenIntent(boolean show) {
            this.mZenPolicy.mVisualEffects.set(0, show ? 1 : 2);
            return this;
        }

        @NonNull
        public Builder showLights(boolean show) {
            this.mZenPolicy.mVisualEffects.set(1, show ? 1 : 2);
            return this;
        }

        @NonNull
        public Builder showPeeking(boolean show) {
            this.mZenPolicy.mVisualEffects.set(2, show ? 1 : 2);
            return this;
        }

        @NonNull
        public Builder showStatusBarIcons(boolean show) {
            this.mZenPolicy.mVisualEffects.set(3, show ? 1 : 2);
            return this;
        }

        @NonNull
        public Builder showBadges(boolean show) {
            this.mZenPolicy.mVisualEffects.set(4, show ? 1 : 2);
            return this;
        }

        @NonNull
        public Builder showInAmbientDisplay(boolean show) {
            this.mZenPolicy.mVisualEffects.set(5, show ? 1 : 2);
            return this;
        }

        @NonNull
        public Builder showInNotificationList(boolean show) {
            this.mZenPolicy.mVisualEffects.set(6, show ? 1 : 2);
            return this;
        }

        @NonNull
        public Builder showVisualEffect(int effect, boolean show) {
            switch (effect) {
                case 0: {
                    this.showFullScreenIntent(show);
                    break;
                }
                case 1: {
                    this.showLights(show);
                    break;
                }
                case 2: {
                    this.showPeeking(show);
                    break;
                }
                case 3: {
                    this.showStatusBarIcons(show);
                    break;
                }
                case 4: {
                    this.showBadges(show);
                    break;
                }
                case 5: {
                    this.showInAmbientDisplay(show);
                    break;
                }
                case 6: {
                    this.showInNotificationList(show);
                }
            }
            return this;
        }

        @SuppressLint(value={"BuilderSetStyle"})
        @NonNull
        public Builder allowPriorityChannels(boolean allow) {
            this.mZenPolicy.mAllowChannels = allow ? 1 : 2;
            return this;
        }

        @NonNull
        public Builder allowChannels(int channelType) {
            this.mZenPolicy.mAllowChannels = channelType;
            return this;
        }
    }

    @Retention(value=RetentionPolicy.SOURCE)
    private static @interface ChannelType {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface State {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface ConversationSenders {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface PeopleType {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface VisualEffect {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface PriorityCategory {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface ModifiableField {
    }
}

