/*
 * Decompiled with CFR 0.152.
 */
package android.service.notification;

import android.annotation.SuppressLint;
import android.app.Notification;
import android.os.Bundle;
import android.os.Parcel;
import android.os.Parcelable;
import android.os.SharedMemory;
import android.service.notification.NotificationListenerService;
import android.system.ErrnoException;
import android.system.OsConstants;
import android.util.Slog;
import com.android.layoutlib.androidx.annotation.NonNull;
import com.android.layoutlib.androidx.annotation.Nullable;
import com.android.layoutlib.androidx.annotation.VisibleForTesting;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;

@SuppressLint(value={"ParcelNotFinal", "ParcelCreator"})
public class NotificationRankingUpdate
implements Parcelable {
    private static final String TAG = "NotificationRankingUpdate";
    private final NotificationListenerService.RankingMap mRankingMap;
    private SharedMemory mRankingMapFd;
    private final String mSharedMemoryName = "NotificationRankingUpdatedSharedMemory";
    @NonNull
    public static final Parcelable.Creator<NotificationRankingUpdate> CREATOR = new Parcelable.Creator<NotificationRankingUpdate>(){

        @Override
        public NotificationRankingUpdate createFromParcel(Parcel parcel) {
            return new NotificationRankingUpdate(parcel);
        }

        public NotificationRankingUpdate[] newArray(int size) {
            return new NotificationRankingUpdate[size];
        }
    };

    public NotificationRankingUpdate(NotificationListenerService.Ranking[] rankings) {
        this.mRankingMapFd = null;
        this.mSharedMemoryName = "NotificationRankingUpdatedSharedMemory";
        this.mRankingMap = new NotificationListenerService.RankingMap(rankings);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public NotificationRankingUpdate(Parcel in) {
        Bundle smartActionsBundle;
        ByteBuffer buffer;
        Parcel mapParcel;
        block5: {
            this.mRankingMapFd = null;
            this.mSharedMemoryName = "NotificationRankingUpdatedSharedMemory";
            mapParcel = Parcel.obtain();
            buffer = null;
            this.mRankingMapFd = in.readParcelable(this.getClass().getClassLoader(), SharedMemory.class);
            smartActionsBundle = in.readBundle(this.getClass().getClassLoader());
            if (this.mRankingMapFd != null) break block5;
            this.mRankingMap = null;
            mapParcel.recycle();
            if (buffer == null || this.mRankingMapFd == null) return;
            SharedMemory.unmap(buffer);
            this.mRankingMapFd.close();
            return;
        }
        try {
            buffer = this.mRankingMapFd.mapReadOnly();
            byte[] payload = new byte[buffer.remaining()];
            buffer.get(payload);
            mapParcel.unmarshall(payload, 0, payload.length);
            mapParcel.setDataPosition(0);
            this.mRankingMap = mapParcel.readParcelable(this.getClass().getClassLoader(), NotificationListenerService.RankingMap.class);
            this.addSmartActionsFromBundleToRankingMap(smartActionsBundle);
            mapParcel.recycle();
            if (buffer == null || this.mRankingMapFd == null) return;
        }
        catch (ErrnoException e) {
            try {
                throw new RuntimeException(e);
            }
            catch (Throwable throwable) {
                mapParcel.recycle();
                if (buffer == null || this.mRankingMapFd == null) throw throwable;
                SharedMemory.unmap(buffer);
                this.mRankingMapFd.close();
                throw throwable;
            }
        }
        SharedMemory.unmap(buffer);
        this.mRankingMapFd.close();
        return;
    }

    private void addSmartActionsFromBundleToRankingMap(Bundle smartActionsBundle) {
        if (smartActionsBundle == null) {
            return;
        }
        String[] rankingMapKeys = this.mRankingMap.getOrderedKeys();
        for (int i = 0; i < rankingMapKeys.length; ++i) {
            String key = rankingMapKeys[i];
            ArrayList<Notification.Action> smartActions = smartActionsBundle.getParcelableArrayList(key, Notification.Action.class);
            NotificationListenerService.Ranking ranking = this.mRankingMap.getRawRankingObject(key);
            ranking.setSmartActions(smartActions);
        }
    }

    @VisibleForTesting(otherwise=5)
    public boolean isFdNotNullAndClosed() {
        return this.mRankingMapFd != null && this.mRankingMapFd.getFd() == -1;
    }

    public NotificationListenerService.RankingMap getRankingMap() {
        return this.mRankingMap;
    }

    @Override
    public int describeContents() {
        return 0;
    }

    public boolean equals(@Nullable Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        NotificationRankingUpdate other = (NotificationRankingUpdate)o;
        return this.mRankingMap.equals(other.mRankingMap);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void writeToParcel(@NonNull Parcel out, int flags) {
        Parcel mapParcel = Parcel.obtain();
        ArrayList<NotificationListenerService.Ranking> marshalableRankings = new ArrayList<NotificationListenerService.Ranking>();
        Bundle smartActionsBundle = new Bundle();
        String[] rankingMapKeys = this.mRankingMap.getOrderedKeys();
        for (int i = 0; i < rankingMapKeys.length; ++i) {
            String key = rankingMapKeys[i];
            NotificationListenerService.Ranking ranking = this.mRankingMap.getRawRankingObject(key);
            List<Notification.Action> smartActions = ranking.getSmartActions();
            if (smartActions != null && !smartActions.isEmpty()) {
                smartActionsBundle.putParcelableList(key, smartActions);
            }
            NotificationListenerService.Ranking rankingCopy = new NotificationListenerService.Ranking();
            rankingCopy.populate(ranking);
            rankingCopy.setSmartActions(null);
            marshalableRankings.add(rankingCopy);
        }
        NotificationListenerService.RankingMap marshalableRankingMap = new NotificationListenerService.RankingMap(marshalableRankings.toArray(new NotificationListenerService.Ranking[0]));
        ByteBuffer buffer = null;
        try {
            mapParcel.writeParcelable(marshalableRankingMap, flags);
            int mapSize = mapParcel.dataSize();
            this.mRankingMapFd = SharedMemory.create("NotificationRankingUpdatedSharedMemory", mapSize);
            buffer = this.mRankingMapFd.mapReadWrite();
            mapParcel.marshall(buffer);
            this.mRankingMapFd.setProtect(OsConstants.PROT_READ);
            out.writeParcelable(this.mRankingMapFd, flags);
            if (smartActionsBundle.size() > 0) {
                out.writeBundle(smartActionsBundle);
            } else {
                out.writeBundle(null);
            }
            mapParcel.recycle();
            if (buffer == null || this.mRankingMapFd == null) return;
        }
        catch (ErrnoException e) {
            try {
                Slog.wtf(TAG, "Failed to write ranking map to shared memory", e);
                mapParcel.recycle();
                if (buffer == null || this.mRankingMapFd == null) return;
            }
            catch (Throwable throwable) {
                mapParcel.recycle();
                if (buffer == null || this.mRankingMapFd == null) throw throwable;
                SharedMemory.unmap(buffer);
                this.mRankingMapFd.close();
                throw throwable;
            }
            SharedMemory.unmap(buffer);
            this.mRankingMapFd.close();
            return;
        }
        SharedMemory.unmap(buffer);
        this.mRankingMapFd.close();
        return;
    }
}

