/*
 * Decompiled with CFR 0.152.
 */
package android.security.keystore.recovery;

import android.annotation.NonNull;
import android.annotation.Nullable;
import android.annotation.SystemApi;
import android.os.Parcel;
import android.os.Parcelable;
import java.util.Objects;

@SystemApi
public class WrappedApplicationKey
implements Parcelable {
    private String mAlias;
    private byte[] mEncryptedKeyMaterial;
    private byte[] mMetadata;
    @NonNull
    public static final Parcelable.Creator<WrappedApplicationKey> CREATOR = new Parcelable.Creator<WrappedApplicationKey>(){

        @Override
        public WrappedApplicationKey createFromParcel(Parcel in) {
            return new WrappedApplicationKey(in);
        }

        public WrappedApplicationKey[] newArray(int length) {
            return new WrappedApplicationKey[length];
        }
    };

    private WrappedApplicationKey() {
    }

    @Deprecated
    public WrappedApplicationKey(@NonNull String alias, @NonNull byte[] encryptedKeyMaterial) {
        this.mAlias = Objects.requireNonNull(alias);
        this.mEncryptedKeyMaterial = Objects.requireNonNull(encryptedKeyMaterial);
    }

    @NonNull
    public String getAlias() {
        return this.mAlias;
    }

    @NonNull
    public byte[] getEncryptedKeyMaterial() {
        return this.mEncryptedKeyMaterial;
    }

    @Nullable
    public byte[] getMetadata() {
        return this.mMetadata;
    }

    @Override
    public void writeToParcel(Parcel out, int flags) {
        out.writeString(this.mAlias);
        out.writeByteArray(this.mEncryptedKeyMaterial);
        out.writeByteArray(this.mMetadata);
    }

    protected WrappedApplicationKey(Parcel in) {
        this.mAlias = in.readString();
        this.mEncryptedKeyMaterial = in.createByteArray();
        this.mMetadata = in.createByteArray();
    }

    @Override
    public int describeContents() {
        return 0;
    }

    public static class Builder {
        private WrappedApplicationKey mInstance = new WrappedApplicationKey();

        @NonNull
        public Builder setAlias(@NonNull String alias) {
            this.mInstance.mAlias = alias;
            return this;
        }

        @NonNull
        public Builder setEncryptedKeyMaterial(@NonNull byte[] encryptedKeyMaterial) {
            this.mInstance.mEncryptedKeyMaterial = encryptedKeyMaterial;
            return this;
        }

        @NonNull
        public Builder setMetadata(@Nullable byte[] metadata) {
            this.mInstance.mMetadata = metadata;
            return this;
        }

        @NonNull
        public WrappedApplicationKey build() {
            Objects.requireNonNull(this.mInstance.mAlias);
            Objects.requireNonNull(this.mInstance.mEncryptedKeyMaterial);
            return this.mInstance;
        }
    }
}

