/*
 * Decompiled with CFR 0.152.
 */
package android.security.keystore.recovery;

import android.annotation.NonNull;
import android.annotation.SystemApi;
import android.os.BadParcelableException;
import android.os.Parcel;
import android.os.Parcelable;
import android.security.keystore.recovery.KeyChainProtectionParams;
import android.security.keystore.recovery.RecoveryCertPath;
import android.security.keystore.recovery.WrappedApplicationKey;
import com.android.internal.util.Preconditions;
import java.security.cert.CertPath;
import java.security.cert.CertificateException;
import java.util.List;
import java.util.Objects;

@SystemApi
public class KeyChainSnapshot
implements Parcelable {
    private static final int DEFAULT_MAX_ATTEMPTS = 10;
    private static final long DEFAULT_COUNTER_ID = 1L;
    private int mSnapshotVersion;
    private int mMaxAttempts = 10;
    private long mCounterId = 1L;
    private byte[] mServerParams;
    private RecoveryCertPath mCertPath;
    private List<KeyChainProtectionParams> mKeyChainProtectionParams;
    private List<WrappedApplicationKey> mEntryRecoveryData;
    private byte[] mEncryptedRecoveryKeyBlob;
    @NonNull
    public static final Parcelable.Creator<KeyChainSnapshot> CREATOR = new Parcelable.Creator<KeyChainSnapshot>(){

        @Override
        public KeyChainSnapshot createFromParcel(Parcel in) {
            return new KeyChainSnapshot(in);
        }

        public KeyChainSnapshot[] newArray(int length) {
            return new KeyChainSnapshot[length];
        }
    };

    private KeyChainSnapshot() {
    }

    public int getSnapshotVersion() {
        return this.mSnapshotVersion;
    }

    public int getMaxAttempts() {
        return this.mMaxAttempts;
    }

    public long getCounterId() {
        return this.mCounterId;
    }

    @NonNull
    public byte[] getServerParams() {
        return this.mServerParams;
    }

    @NonNull
    public CertPath getTrustedHardwareCertPath() {
        try {
            return this.mCertPath.getCertPath();
        }
        catch (CertificateException e) {
            throw new BadParcelableException(e);
        }
    }

    @NonNull
    public List<KeyChainProtectionParams> getKeyChainProtectionParams() {
        return this.mKeyChainProtectionParams;
    }

    @NonNull
    public List<WrappedApplicationKey> getWrappedApplicationKeys() {
        return this.mEntryRecoveryData;
    }

    @NonNull
    public byte[] getEncryptedRecoveryKeyBlob() {
        return this.mEncryptedRecoveryKeyBlob;
    }

    @Override
    public void writeToParcel(Parcel out, int flags) {
        out.writeInt(this.mSnapshotVersion);
        out.writeTypedList(this.mKeyChainProtectionParams);
        out.writeByteArray(this.mEncryptedRecoveryKeyBlob);
        out.writeTypedList(this.mEntryRecoveryData);
        out.writeInt(this.mMaxAttempts);
        out.writeLong(this.mCounterId);
        out.writeByteArray(this.mServerParams);
        out.writeTypedObject(this.mCertPath, 0);
    }

    protected KeyChainSnapshot(Parcel in) {
        this.mSnapshotVersion = in.readInt();
        this.mKeyChainProtectionParams = in.createTypedArrayList(KeyChainProtectionParams.CREATOR);
        this.mEncryptedRecoveryKeyBlob = in.createByteArray();
        this.mEntryRecoveryData = in.createTypedArrayList(WrappedApplicationKey.CREATOR);
        this.mMaxAttempts = in.readInt();
        this.mCounterId = in.readLong();
        this.mServerParams = in.createByteArray();
        this.mCertPath = in.readTypedObject(RecoveryCertPath.CREATOR);
    }

    @Override
    public int describeContents() {
        return 0;
    }

    public static class Builder {
        private KeyChainSnapshot mInstance = new KeyChainSnapshot();

        @NonNull
        public Builder setSnapshotVersion(int snapshotVersion) {
            this.mInstance.mSnapshotVersion = snapshotVersion;
            return this;
        }

        @NonNull
        public Builder setMaxAttempts(int maxAttempts) {
            this.mInstance.mMaxAttempts = maxAttempts;
            return this;
        }

        @NonNull
        public Builder setCounterId(long counterId) {
            this.mInstance.mCounterId = counterId;
            return this;
        }

        @NonNull
        public Builder setServerParams(byte[] serverParams) {
            this.mInstance.mServerParams = serverParams;
            return this;
        }

        @NonNull
        public Builder setTrustedHardwareCertPath(@NonNull CertPath certPath) throws CertificateException {
            this.mInstance.mCertPath = RecoveryCertPath.createRecoveryCertPath(certPath);
            return this;
        }

        @NonNull
        public Builder setKeyChainProtectionParams(@NonNull List<KeyChainProtectionParams> keyChainProtectionParams) {
            this.mInstance.mKeyChainProtectionParams = keyChainProtectionParams;
            return this;
        }

        @NonNull
        public Builder setWrappedApplicationKeys(@NonNull List<WrappedApplicationKey> entryRecoveryData) {
            this.mInstance.mEntryRecoveryData = entryRecoveryData;
            return this;
        }

        @NonNull
        public Builder setEncryptedRecoveryKeyBlob(@NonNull byte[] encryptedRecoveryKeyBlob) {
            this.mInstance.mEncryptedRecoveryKeyBlob = encryptedRecoveryKeyBlob;
            return this;
        }

        @NonNull
        public KeyChainSnapshot build() {
            Preconditions.checkCollectionElementsNotNull(this.mInstance.mKeyChainProtectionParams, "keyChainProtectionParams");
            Preconditions.checkCollectionElementsNotNull(this.mInstance.mEntryRecoveryData, "entryRecoveryData");
            Objects.requireNonNull(this.mInstance.mEncryptedRecoveryKeyBlob);
            Objects.requireNonNull(this.mInstance.mServerParams);
            Objects.requireNonNull(this.mInstance.mCertPath);
            return this.mInstance;
        }
    }
}

