/*
 * Decompiled with CFR 0.152.
 */
package android.security.keystore.recovery;

import android.annotation.NonNull;
import android.annotation.SystemApi;
import android.os.Parcel;
import android.os.Parcelable;
import android.security.keystore.recovery.KeyDerivationParams;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.Arrays;
import java.util.Objects;

@SystemApi
public class KeyChainProtectionParams
implements Parcelable {
    public static final int TYPE_LOCKSCREEN = 100;
    public static final int UI_FORMAT_PIN = 1;
    public static final int UI_FORMAT_PASSWORD = 2;
    public static final int UI_FORMAT_PATTERN = 3;
    private Integer mUserSecretType;
    private Integer mLockScreenUiFormat;
    private KeyDerivationParams mKeyDerivationParams;
    private byte[] mSecret;
    @NonNull
    public static final Parcelable.Creator<KeyChainProtectionParams> CREATOR = new Parcelable.Creator<KeyChainProtectionParams>(){

        @Override
        public KeyChainProtectionParams createFromParcel(Parcel in) {
            return new KeyChainProtectionParams(in);
        }

        public KeyChainProtectionParams[] newArray(int length) {
            return new KeyChainProtectionParams[length];
        }
    };

    private KeyChainProtectionParams() {
    }

    public int getUserSecretType() {
        return this.mUserSecretType;
    }

    public int getLockScreenUiFormat() {
        return this.mLockScreenUiFormat;
    }

    @NonNull
    public KeyDerivationParams getKeyDerivationParams() {
        return this.mKeyDerivationParams;
    }

    @NonNull
    public byte[] getSecret() {
        return this.mSecret;
    }

    public void clearSecret() {
        Arrays.fill(this.mSecret, (byte)0);
    }

    @Override
    public void writeToParcel(Parcel out, int flags) {
        out.writeInt(this.mUserSecretType);
        out.writeInt(this.mLockScreenUiFormat);
        out.writeTypedObject(this.mKeyDerivationParams, flags);
        out.writeByteArray(this.mSecret);
    }

    protected KeyChainProtectionParams(Parcel in) {
        this.mUserSecretType = in.readInt();
        this.mLockScreenUiFormat = in.readInt();
        this.mKeyDerivationParams = in.readTypedObject(KeyDerivationParams.CREATOR);
        this.mSecret = in.createByteArray();
    }

    @Override
    public int describeContents() {
        return 0;
    }

    public static class Builder {
        private KeyChainProtectionParams mInstance = new KeyChainProtectionParams();

        @NonNull
        public Builder setUserSecretType(int userSecretType) {
            this.mInstance.mUserSecretType = userSecretType;
            return this;
        }

        @NonNull
        public Builder setLockScreenUiFormat(int lockScreenUiFormat) {
            this.mInstance.mLockScreenUiFormat = lockScreenUiFormat;
            return this;
        }

        @NonNull
        public Builder setKeyDerivationParams(@NonNull KeyDerivationParams keyDerivationParams) {
            this.mInstance.mKeyDerivationParams = keyDerivationParams;
            return this;
        }

        @NonNull
        public Builder setSecret(@NonNull byte[] secret) {
            this.mInstance.mSecret = secret;
            return this;
        }

        @NonNull
        public KeyChainProtectionParams build() {
            if (this.mInstance.mUserSecretType == null) {
                this.mInstance.mUserSecretType = 100;
            }
            Objects.requireNonNull(this.mInstance.mLockScreenUiFormat);
            Objects.requireNonNull(this.mInstance.mKeyDerivationParams);
            if (this.mInstance.mSecret == null) {
                this.mInstance.mSecret = new byte[0];
            }
            return this.mInstance;
        }
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface LockScreenUiFormat {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface UserSecretType {
    }
}

