/*
 * Decompiled with CFR 0.152.
 */
package android.security.keystore;

import android.annotation.FlaggedApi;
import android.annotation.NonNull;
import android.security.KeyStore2;
import android.security.KeyStoreException;
import android.security.keystore.KeyPermanentlyInvalidatedException;
import android.security.keystore2.AndroidKeyStoreKey;
import android.security.keystore2.AndroidKeyStoreProvider;
import android.security.keystore2.AndroidKeyStorePublicKey;
import android.system.keystore2.KeyDescriptor;
import android.util.Log;
import com.android.internal.annotations.GuardedBy;
import java.io.ByteArrayInputStream;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.security.Key;
import java.security.KeyPair;
import java.security.PublicKey;
import java.security.UnrecoverableKeyException;
import java.security.cert.Certificate;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;

@FlaggedApi(value="android.security.keystore_grant_api")
public class KeyStoreManager {
    private static final String TAG = "KeyStoreManager";
    private static final Object sInstanceLock = new Object();
    @GuardedBy(value={"sInstanceLock"})
    private static KeyStoreManager sInstance;
    private final KeyStore2 mKeyStore2 = KeyStore2.getInstance();
    public static final int MODULE_HASH = -1879047468;

    private KeyStoreManager() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static KeyStoreManager getInstance() {
        Object object = sInstanceLock;
        synchronized (object) {
            if (sInstance == null) {
                sInstance = new KeyStoreManager();
            }
            return sInstance;
        }
    }

    public long grantKeyAccess(@NonNull String alias, int uid) throws KeyStoreException, UnrecoverableKeyException {
        KeyDescriptor keyDescriptor = KeyStoreManager.createKeyDescriptorFromAlias(alias);
        int grantAccessVector = 260;
        KeyDescriptor result = null;
        try {
            result = this.mKeyStore2.grant(keyDescriptor, uid, 260);
        }
        catch (KeyStoreException e) {
            if (e.getNumericErrorCode() == 6) {
                throw new UnrecoverableKeyException("No key found by the given alias");
            }
            throw e;
        }
        if (result == null) {
            Log.e(TAG, "Received a null KeyDescriptor from grant");
            throw new KeyStoreException(4, "No ID was returned for the grant request for alias " + alias + " to uid " + uid);
        }
        if (result.domain != 1) {
            Log.e(TAG, "Received a result outside the grant domain: " + result.domain);
            throw new KeyStoreException(4, "Unable to obtain a grant ID for alias " + alias + " to uid " + uid);
        }
        return result.nspace;
    }

    public void revokeKeyAccess(@NonNull String alias, int uid) throws KeyStoreException, UnrecoverableKeyException {
        KeyDescriptor keyDescriptor = KeyStoreManager.createKeyDescriptorFromAlias(alias);
        try {
            this.mKeyStore2.ungrant(keyDescriptor, uid);
        }
        catch (KeyStoreException e) {
            if (e.getNumericErrorCode() == 6) {
                throw new UnrecoverableKeyException("No key found by the given alias");
            }
            throw e;
        }
    }

    @NonNull
    public Key getGrantedKeyFromId(long id2) throws UnrecoverableKeyException, KeyPermanentlyInvalidatedException {
        AndroidKeyStoreKey result = AndroidKeyStoreProvider.loadAndroidKeyStoreKeyFromKeystore(this.mKeyStore2, null, id2, 1);
        if (result == null) {
            throw new UnrecoverableKeyException("No key found by the given alias");
        }
        return result;
    }

    @NonNull
    public KeyPair getGrantedKeyPairFromId(long id2) throws UnrecoverableKeyException, KeyPermanentlyInvalidatedException {
        KeyDescriptor keyDescriptor = KeyStoreManager.createKeyDescriptorFromId(id2, 1);
        return AndroidKeyStoreProvider.loadAndroidKeyStoreKeyPairFromKeystore(this.mKeyStore2, keyDescriptor);
    }

    @NonNull
    public List<X509Certificate> getGrantedCertificateChainFromId(long id2) throws UnrecoverableKeyException, KeyPermanentlyInvalidatedException {
        KeyDescriptor keyDescriptor = KeyStoreManager.createKeyDescriptorFromId(id2, 1);
        KeyPair keyPair = AndroidKeyStoreProvider.loadAndroidKeyStoreKeyPairFromKeystore(this.mKeyStore2, keyDescriptor);
        PublicKey keyStoreKey = keyPair.getPublic();
        if (keyStoreKey instanceof AndroidKeyStorePublicKey) {
            AndroidKeyStorePublicKey androidKeyStorePublicKey = (AndroidKeyStorePublicKey)keyStoreKey;
            byte[] certBytes = androidKeyStorePublicKey.getCertificate();
            X509Certificate cert = KeyStoreManager.getCertificate(certBytes);
            if (cert == null) {
                return Collections.emptyList();
            }
            ArrayList<X509Certificate> result = new ArrayList<X509Certificate>();
            result.add(cert);
            byte[] certificateChain = androidKeyStorePublicKey.getCertificateChain();
            Collection<X509Certificate> certificates = KeyStoreManager.getCertificates(certificateChain);
            result.addAll(certificates);
            return result;
        }
        Log.e(TAG, "keyStoreKey is not of the expected type: " + keyStoreKey);
        return Collections.emptyList();
    }

    private static X509Certificate getCertificate(byte[] certificate) {
        X509Certificate result = null;
        if (certificate != null) {
            try {
                CertificateFactory certificateFactory = CertificateFactory.getInstance("X.509");
                result = (X509Certificate)certificateFactory.generateCertificate(new ByteArrayInputStream(certificate));
            }
            catch (Exception e) {
                Log.e(TAG, "Caught an exception parsing the certificate: ", e);
            }
        }
        return result;
    }

    private static Collection<X509Certificate> getCertificates(byte[] certificateChain) {
        if (certificateChain != null) {
            try {
                CertificateFactory certificateFactory = CertificateFactory.getInstance("X.509");
                Collection<? extends Certificate> certificates = certificateFactory.generateCertificates(new ByteArrayInputStream(certificateChain));
                if (certificates == null) {
                    Log.e(TAG, "Received null certificates from a non-null certificateChain");
                    return Collections.emptyList();
                }
                return certificates;
            }
            catch (Exception e) {
                Log.e(TAG, "Caught an exception parsing the certs: ", e);
            }
        }
        return Collections.emptyList();
    }

    @FlaggedApi(value="android.security.keystore2.attest_modules")
    @NonNull
    public byte[] getSupplementaryAttestationInfo(int tag) throws KeyStoreException {
        return this.mKeyStore2.getSupplementaryAttestationInfo(tag);
    }

    private static KeyDescriptor createKeyDescriptorFromAlias(String alias) {
        KeyDescriptor keyDescriptor = new KeyDescriptor();
        keyDescriptor.domain = 0;
        keyDescriptor.nspace = -1L;
        keyDescriptor.alias = alias;
        keyDescriptor.blob = null;
        return keyDescriptor;
    }

    private static KeyDescriptor createKeyDescriptorFromId(long id2, int domain) {
        KeyDescriptor keyDescriptor = new KeyDescriptor();
        keyDescriptor.domain = domain;
        keyDescriptor.nspace = id2;
        keyDescriptor.alias = null;
        keyDescriptor.blob = null;
        return keyDescriptor;
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface SupplementaryAttestationInfoTagEnum {
    }
}

