/*
 * Decompiled with CFR 0.152.
 */
package android.security.authenticationpolicy;

import android.os.Binder;
import android.os.IBinder;
import android.os.IInterface;
import android.os.Parcel;
import android.os.RemoteException;

public interface ISecureLockDeviceStatusListener
extends IInterface {
    public static final String DESCRIPTOR = "android.security.authenticationpolicy.ISecureLockDeviceStatusListener";

    public void onSecureLockDeviceEnabledStatusChanged(boolean var1) throws RemoteException;

    public void onSecureLockDeviceAvailableStatusChanged(int var1) throws RemoteException;

    public static abstract class Stub
    extends Binder
    implements ISecureLockDeviceStatusListener {
        static final int TRANSACTION_onSecureLockDeviceEnabledStatusChanged = 1;
        static final int TRANSACTION_onSecureLockDeviceAvailableStatusChanged = 2;

        public Stub() {
            this.attachInterface(this, ISecureLockDeviceStatusListener.DESCRIPTOR);
        }

        public static ISecureLockDeviceStatusListener asInterface(IBinder obj) {
            if (obj == null) {
                return null;
            }
            IInterface iin = obj.queryLocalInterface(ISecureLockDeviceStatusListener.DESCRIPTOR);
            if (iin != null && iin instanceof ISecureLockDeviceStatusListener) {
                return (ISecureLockDeviceStatusListener)iin;
            }
            return new Proxy(obj);
        }

        @Override
        public IBinder asBinder() {
            return this;
        }

        public static String getDefaultTransactionName(int transactionCode) {
            switch (transactionCode) {
                case 1: {
                    return "onSecureLockDeviceEnabledStatusChanged";
                }
                case 2: {
                    return "onSecureLockDeviceAvailableStatusChanged";
                }
            }
            return null;
        }

        @Override
        public String getTransactionName(int transactionCode) {
            return Stub.getDefaultTransactionName(transactionCode);
        }

        @Override
        public boolean onTransact(int code, Parcel data, Parcel reply, int flags) throws RemoteException {
            String descriptor = ISecureLockDeviceStatusListener.DESCRIPTOR;
            if (code >= 1 && code <= 0xFFFFFF) {
                data.enforceInterface(descriptor);
            }
            if (code == 1598968902) {
                reply.writeString(descriptor);
                return true;
            }
            switch (code) {
                case 1: {
                    boolean _arg0 = data.readBoolean();
                    data.enforceNoDataAvail();
                    this.onSecureLockDeviceEnabledStatusChanged(_arg0);
                    break;
                }
                case 2: {
                    int _arg0 = data.readInt();
                    data.enforceNoDataAvail();
                    this.onSecureLockDeviceAvailableStatusChanged(_arg0);
                    break;
                }
                default: {
                    return super.onTransact(code, data, reply, flags);
                }
            }
            return true;
        }

        @Override
        public int getMaxTransactionId() {
            return 1;
        }

        private static class Proxy
        implements ISecureLockDeviceStatusListener {
            private IBinder mRemote;

            Proxy(IBinder remote) {
                this.mRemote = remote;
            }

            @Override
            public IBinder asBinder() {
                return this.mRemote;
            }

            public String getInterfaceDescriptor() {
                return ISecureLockDeviceStatusListener.DESCRIPTOR;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onSecureLockDeviceEnabledStatusChanged(boolean enabled) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(ISecureLockDeviceStatusListener.DESCRIPTOR);
                    _data.writeBoolean(enabled);
                    boolean bl = this.mRemote.transact(1, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onSecureLockDeviceAvailableStatusChanged(int available) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(ISecureLockDeviceStatusListener.DESCRIPTOR);
                    _data.writeInt(available);
                    boolean bl = this.mRemote.transact(2, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }
        }
    }

    public static class Default
    implements ISecureLockDeviceStatusListener {
        @Override
        public void onSecureLockDeviceEnabledStatusChanged(boolean enabled) throws RemoteException {
        }

        @Override
        public void onSecureLockDeviceAvailableStatusChanged(int available) throws RemoteException {
        }

        @Override
        public IBinder asBinder() {
            return null;
        }
    }
}

