/*
 * Decompiled with CFR 0.152.
 */
package android.security.authenticationpolicy;

import android.annotation.FlaggedApi;
import android.annotation.NonNull;
import android.annotation.RequiresPermission;
import android.annotation.SystemApi;
import android.content.Context;
import android.os.Binder;
import android.os.Handler;
import android.os.RemoteException;
import android.os._Original_Build;
import android.proximity.IProximityResultCallback;
import android.security.authenticationpolicy.DisableSecureLockDeviceParams;
import android.security.authenticationpolicy.EnableSecureLockDeviceParams;
import android.security.authenticationpolicy.IAuthenticationPolicyService;
import android.security.authenticationpolicy.ISecureLockDeviceStatusListener;
import android.util.Log;
import android.util.Slog;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executor;

@SystemApi
@FlaggedApi(value="android.security.secure_lockdown")
public class AuthenticationPolicyManager {
    private static final String TAG = "AuthenticationPolicyManager";
    private static final boolean DEBUG = _Original_Build.IS_DEBUGGABLE;
    @NonNull
    private final IAuthenticationPolicyService mAuthenticationPolicyService;
    @NonNull
    private final Context mContext;
    private final ConcurrentHashMap<SecureLockDeviceStatusListener, ISecureLockDeviceStatusListener.Stub> mSecureLockDeviceStatusListeners = new ConcurrentHashMap();
    @SystemApi
    @FlaggedApi(value="android.security.secure_lockdown")
    public static final int ERROR_UNKNOWN = 0;
    @SystemApi
    @FlaggedApi(value="android.security.secure_lockdown")
    public static final int SUCCESS = 1;
    @SystemApi
    @FlaggedApi(value="android.security.secure_lockdown")
    public static final int ERROR_UNSUPPORTED = 2;
    @SystemApi
    @FlaggedApi(value="android.security.secure_lockdown")
    public static final int ERROR_INVALID_PARAMS = 3;
    @SystemApi
    @FlaggedApi(value="android.security.secure_lockdown")
    public static final int ERROR_NO_BIOMETRICS_ENROLLED = 4;
    @SystemApi
    @FlaggedApi(value="android.security.secure_lockdown")
    public static final int ERROR_INSUFFICIENT_BIOMETRICS = 5;
    @SystemApi
    @FlaggedApi(value="android.security.secure_lockdown")
    public static final int ERROR_ALREADY_ENABLED = 6;
    @SystemApi
    @FlaggedApi(value="android.security.secure_lockdown")
    public static final int ERROR_NOT_AUTHORIZED = 7;

    public AuthenticationPolicyManager(@NonNull Context context, @NonNull IAuthenticationPolicyService authenticationPolicyService) {
        this.mContext = context;
        this.mAuthenticationPolicyService = authenticationPolicyService;
    }

    @SystemApi
    @FlaggedApi(value="android.security.secure_lock_device")
    @RequiresPermission(value="android.permission.MANAGE_SECURE_LOCK_DEVICE")
    public void registerSecureLockDeviceStatusListener(final @NonNull Executor executor, final @NonNull SecureLockDeviceStatusListener listener) {
        Objects.requireNonNull(executor, "Executor cannot be null");
        Objects.requireNonNull(listener, "Listener cannot be null");
        if (this.mSecureLockDeviceStatusListeners.containsKey(listener)) {
            if (DEBUG) {
                Log.d(TAG, "registerSecureLockDeviceStatusListener: listener already registered");
            }
            return;
        }
        ISecureLockDeviceStatusListener.Stub stub = new ISecureLockDeviceStatusListener.Stub(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onSecureLockDeviceEnabledStatusChanged(boolean enabled) {
                if (!AuthenticationPolicyManager.this.mSecureLockDeviceStatusListeners.containsKey(listener)) {
                    if (DEBUG) {
                        Log.d(AuthenticationPolicyManager.TAG, "Listener " + listener + " no longer registered. Skipping onSecureLockDeviceEnabledStatusChanged(" + enabled + ")");
                    }
                    return;
                }
                long identity = Binder.clearCallingIdentity();
                try {
                    executor.execute(() -> listener.onSecureLockDeviceEnabledStatusChanged(enabled));
                }
                finally {
                    Binder.restoreCallingIdentity(identity);
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onSecureLockDeviceAvailableStatusChanged(int available) {
                if (!AuthenticationPolicyManager.this.mSecureLockDeviceStatusListeners.containsKey(listener)) {
                    if (DEBUG) {
                        Log.d(AuthenticationPolicyManager.TAG, "Listener " + listener + " no longer registered. Skipping onSecureLockDeviceAvailableStatusChanged(" + available + ")");
                    }
                    return;
                }
                long identity = Binder.clearCallingIdentity();
                try {
                    executor.execute(() -> listener.onSecureLockDeviceAvailableStatusChanged(available));
                }
                finally {
                    Binder.restoreCallingIdentity(identity);
                }
            }
        };
        this.mSecureLockDeviceStatusListeners.put(listener, stub);
        boolean serviceCallSuccessful = false;
        try {
            this.mAuthenticationPolicyService.registerSecureLockDeviceStatusListener(this.mContext.getUser(), stub);
            serviceCallSuccessful = true;
            if (DEBUG) {
                Log.d(TAG, "Registered listener: " + listener);
            }
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
        finally {
            if (!serviceCallSuccessful) {
                this.mSecureLockDeviceStatusListeners.remove(listener);
                Log.w(TAG, "Failed to register listener " + listener + "with service, removing from local map.");
            }
        }
    }

    @SystemApi
    @FlaggedApi(value="android.security.secure_lock_device")
    @RequiresPermission(value="android.permission.MANAGE_SECURE_LOCK_DEVICE")
    public void unregisterSecureLockDeviceStatusListener(@NonNull SecureLockDeviceStatusListener listener) {
        Objects.requireNonNull(listener, "Listener cannot be null");
        ISecureLockDeviceStatusListener.Stub stub = this.mSecureLockDeviceStatusListeners.remove(listener);
        if (stub == null) {
            Log.d(TAG, "unregisterSecureLockDeviceStatusListener: listener not registered");
            return;
        }
        try {
            this.mAuthenticationPolicyService.unregisterSecureLockDeviceStatusListener(stub);
            if (DEBUG) {
                Log.d(TAG, "Unregistered listener: " + listener);
            }
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @SystemApi
    @RequiresPermission(value="android.permission.MANAGE_SECURE_LOCK_DEVICE")
    @FlaggedApi(value="android.security.secure_lock_device")
    public int isSecureLockDeviceAvailable() {
        try {
            return this.mAuthenticationPolicyService.isSecureLockDeviceAvailable(this.mContext.getUser());
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @SystemApi
    @RequiresPermission(value="android.permission.MANAGE_SECURE_LOCK_DEVICE")
    @FlaggedApi(value="android.security.secure_lockdown")
    public int enableSecureLockDevice(@NonNull EnableSecureLockDeviceParams params) {
        try {
            return this.mAuthenticationPolicyService.enableSecureLockDevice(this.mContext.getUser(), params);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @SystemApi
    @RequiresPermission(value="android.permission.MANAGE_SECURE_LOCK_DEVICE")
    @FlaggedApi(value="android.security.secure_lockdown")
    public int disableSecureLockDevice(@NonNull DisableSecureLockDeviceParams params) {
        try {
            return this.mAuthenticationPolicyService.disableSecureLockDevice(this.mContext.getUser(), params);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @SystemApi
    @RequiresPermission(value="android.permission.MANAGE_SECURE_LOCK_DEVICE")
    @FlaggedApi(value="android.security.secure_lock_device")
    public boolean isSecureLockDeviceEnabled() {
        try {
            return this.mAuthenticationPolicyService.isSecureLockDeviceEnabled();
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @RequiresPermission(value="android.permission.USE_BIOMETRIC_INTERNAL")
    @FlaggedApi(value="android.hardware.biometrics.identity_check_watch")
    public void startWatchRangingForIdentityCheck(long authenticationRequestId, @NonNull IProximityResultCallback resultCallback, @NonNull Handler handler) {
        try {
            this.mAuthenticationPolicyService.startWatchRangingForIdentityCheck(authenticationRequestId, new ProximityResultCallbackWrapper(handler, resultCallback));
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @RequiresPermission(value="android.permission.USE_BIOMETRIC_INTERNAL")
    @FlaggedApi(value="android.hardware.biometrics.identity_check_watch")
    public void cancelWatchRangingForRequestId(long authenticationRequestId) {
        try {
            this.mAuthenticationPolicyService.cancelWatchRangingForRequestId(authenticationRequestId);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @SystemApi
    @FlaggedApi(value="android.security.secure_lock_device")
    public static interface SecureLockDeviceStatusListener {
        public void onSecureLockDeviceEnabledStatusChanged(boolean var1);

        public void onSecureLockDeviceAvailableStatusChanged(int var1);
    }

    private static class ProximityResultCallbackWrapper
    extends IProximityResultCallback.Stub {
        private final Handler mHandler;
        private final IProximityResultCallback mProximityResultCallback;

        ProximityResultCallbackWrapper(Handler handler, IProximityResultCallback proximityResultCallback) {
            this.mHandler = handler;
            this.mProximityResultCallback = proximityResultCallback;
        }

        @Override
        public void onError(int error) {
            this.mHandler.post(() -> {
                long id2 = Binder.clearCallingIdentity();
                try {
                    this.mProximityResultCallback.onError(error);
                }
                catch (RemoteException e) {
                    Slog.e(AuthenticationPolicyManager.TAG, "Remote exception thrown when proximity callback invoked " + e);
                }
                finally {
                    Binder.restoreCallingIdentity(id2);
                }
            });
        }

        @Override
        public void onSuccess(int result) {
            this.mHandler.post(() -> {
                long id2 = Binder.clearCallingIdentity();
                try {
                    this.mProximityResultCallback.onSuccess(result);
                }
                catch (RemoteException e) {
                    Slog.e(AuthenticationPolicyManager.TAG, "Remote exception thrown when proximity callback invoked " + e);
                }
                finally {
                    Binder.restoreCallingIdentity(id2);
                }
            });
        }
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface IsSecureLockDeviceAvailableRequestStatus {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface DisableSecureLockDeviceRequestStatus {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface EnableSecureLockDeviceRequestStatus {
    }
}

