/*
 * Decompiled with CFR 0.152.
 */
package android.security;

import android.annotation.NonNull;
import android.hardware.security.keymint.KeyParameter;
import android.os.Binder;
import android.os.RemoteException;
import android.os.ServiceSpecificException;
import android.os.StrictMode;
import android.security.CheckedRemoteRequest;
import android.security.KeyStore2;
import android.security.KeyStoreException;
import android.system.keystore2.IKeystoreOperation;
import android.util.Log;

public class KeyStoreOperation {
    static final String TAG = "KeyStoreOperation";
    private final IKeystoreOperation mOperation;
    private final Long mChallenge;
    private final KeyParameter[] mParameters;

    public KeyStoreOperation(@NonNull IKeystoreOperation operation, Long challenge, KeyParameter[] parameters) {
        Binder.allowBlocking(operation.asBinder());
        this.mOperation = operation;
        this.mChallenge = challenge;
        this.mParameters = parameters;
    }

    public Long getChallenge() {
        return this.mChallenge;
    }

    public KeyParameter[] getParameters() {
        return this.mParameters;
    }

    private <R> R handleExceptions(@NonNull CheckedRemoteRequest<R> request) throws KeyStoreException {
        try {
            return request.execute();
        }
        catch (ServiceSpecificException e) {
            switch (e.errorCode) {
                case 19: {
                    throw new IllegalThreadStateException("Cannot update the same operation concurrently.");
                }
            }
            throw KeyStore2.getKeyStoreException(e.errorCode, e.getMessage());
        }
        catch (RemoteException e) {
            Log.e(TAG, "Remote exception while advancing a KeyStoreOperation.", e);
            throw new KeyStoreException(-28, "", e.getMessage());
        }
    }

    public void updateAad(@NonNull byte[] input) throws KeyStoreException {
        StrictMode.noteSlowCall("updateAad");
        this.handleExceptions(() -> {
            this.mOperation.updateAad(input);
            return 0;
        });
    }

    public byte[] update(@NonNull byte[] input) throws KeyStoreException {
        StrictMode.noteSlowCall("update");
        return this.handleExceptions(() -> this.mOperation.update(input));
    }

    public byte[] finish(byte[] input, byte[] signature) throws KeyStoreException {
        StrictMode.noteSlowCall("finish");
        return this.handleExceptions(() -> this.mOperation.finish(input, signature));
    }

    public void abort() throws KeyStoreException {
        StrictMode.noteSlowCall("abort");
        this.handleExceptions(() -> {
            this.mOperation.abort();
            return 0;
        });
    }
}

