/*
 * Decompiled with CFR 0.152.
 */
package android.safetycenter;

import android.annotation.NonNull;
import android.annotation.Nullable;
import android.annotation.RequiresPermission;
import android.annotation.SystemApi;
import android.annotation.TargetApi;
import android.content.Context;
import android.os.Binder;
import android.os.RemoteException;
import android.permission.jarjar.com.android.internal.annotations.GuardedBy;
import android.permission.jarjar.com.android.modules.utils.build.SdkLevel;
import android.safetycenter.IOnSafetyCenterDataChangedListener;
import android.safetycenter.ISafetyCenterManager;
import android.safetycenter.SafetyCenterData;
import android.safetycenter.SafetyCenterErrorDetails;
import android.safetycenter.SafetyEvent;
import android.safetycenter.SafetySourceData;
import android.safetycenter.SafetySourceErrorDetails;
import android.safetycenter.config.SafetyCenterConfig;
import android.util.ArrayMap;
import com.android.layoutlib.androidx.annotation.RequiresApi;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.Executor;

@SystemApi
@RequiresApi(value=33)
public class SafetyCenterManager {
    public static final String ACTION_SAFETY_CENTER_ENABLED_CHANGED = "android.safetycenter.action.SAFETY_CENTER_ENABLED_CHANGED";
    public static final String ACTION_REFRESH_SAFETY_SOURCES = "android.safetycenter.action.REFRESH_SAFETY_SOURCES";
    public static final String EXTRA_REFRESH_SAFETY_SOURCE_IDS = "android.safetycenter.extra.REFRESH_SAFETY_SOURCE_IDS";
    public static final String EXTRA_REFRESH_SAFETY_SOURCES_REQUEST_TYPE = "android.safetycenter.extra.REFRESH_SAFETY_SOURCES_REQUEST_TYPE";
    public static final String EXTRA_REFRESH_SAFETY_SOURCES_BROADCAST_ID = "android.safetycenter.extra.REFRESH_SAFETY_SOURCES_BROADCAST_ID";
    public static final String EXTRA_SAFETY_SOURCE_ISSUE_ID = "android.safetycenter.extra.SAFETY_SOURCE_ISSUE_ID";
    public static final String EXTRA_SAFETY_SOURCE_ID = "android.safetycenter.extra.SAFETY_SOURCE_ID";
    public static final String EXTRA_SAFETY_SOURCE_USER_HANDLE = "android.safetycenter.extra.SAFETY_SOURCE_USER_HANDLE";
    @RequiresApi(value=34)
    public static final String EXTRA_SAFETY_SOURCES_GROUP_ID = "android.safetycenter.extra.SAFETY_SOURCES_GROUP_ID";
    public static final int EXTRA_REFRESH_REQUEST_TYPE_FETCH_FRESH_DATA = 0;
    public static final int EXTRA_REFRESH_REQUEST_TYPE_GET_DATA = 1;
    public static final int REFRESH_REASON_PAGE_OPEN = 100;
    public static final int REFRESH_REASON_RESCAN_BUTTON_CLICK = 200;
    public static final int REFRESH_REASON_DEVICE_REBOOT = 300;
    public static final int REFRESH_REASON_DEVICE_LOCALE_CHANGE = 400;
    public static final int REFRESH_REASON_SAFETY_CENTER_ENABLED = 500;
    public static final int REFRESH_REASON_OTHER = 600;
    @RequiresApi(value=34)
    public static final int REFRESH_REASON_PERIODIC = 700;
    private final Object mListenersLock = new Object();
    @GuardedBy(value={"mListenersLock"})
    private final Map<OnSafetyCenterDataChangedListener, ListenerDelegate> mListenersToDelegates = new ArrayMap<OnSafetyCenterDataChangedListener, ListenerDelegate>();
    @NonNull
    private final Context mContext;
    @NonNull
    private final ISafetyCenterManager mService;

    public SafetyCenterManager(@NonNull Context context, @NonNull ISafetyCenterManager service) {
        this.mContext = context;
        this.mService = service;
    }

    @RequiresPermission(anyOf={"android.permission.READ_SAFETY_CENTER_STATUS", "android.permission.SEND_SAFETY_CENTER_UPDATE"})
    public boolean isSafetyCenterEnabled() {
        try {
            return this.mService.isSafetyCenterEnabled();
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @RequiresPermission(value="android.permission.SEND_SAFETY_CENTER_UPDATE")
    public void setSafetySourceData(@NonNull String safetySourceId, @Nullable SafetySourceData safetySourceData, @NonNull SafetyEvent safetyEvent) {
        Objects.requireNonNull(safetySourceId, "safetySourceId cannot be null");
        Objects.requireNonNull(safetyEvent, "safetyEvent cannot be null");
        try {
            this.mService.setSafetySourceData(safetySourceId, safetySourceData, safetyEvent, this.mContext.getPackageName(), this.mContext.getUser().getIdentifier());
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @RequiresPermission(value="android.permission.SEND_SAFETY_CENTER_UPDATE")
    @Nullable
    public SafetySourceData getSafetySourceData(@NonNull String safetySourceId) {
        Objects.requireNonNull(safetySourceId, "safetySourceId cannot be null");
        try {
            return this.mService.getSafetySourceData(safetySourceId, this.mContext.getPackageName(), this.mContext.getUser().getIdentifier());
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @RequiresPermission(value="android.permission.SEND_SAFETY_CENTER_UPDATE")
    public void reportSafetySourceError(@NonNull String safetySourceId, @NonNull SafetySourceErrorDetails safetySourceErrorDetails) {
        Objects.requireNonNull(safetySourceId, "safetySourceId cannot be null");
        Objects.requireNonNull(safetySourceErrorDetails, "safetySourceErrorDetails cannot be null");
        try {
            this.mService.reportSafetySourceError(safetySourceId, safetySourceErrorDetails, this.mContext.getPackageName(), this.mContext.getUser().getIdentifier());
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @RequiresPermission(value="android.permission.MANAGE_SAFETY_CENTER")
    public void refreshSafetySources(int refreshReason) {
        try {
            this.mService.refreshSafetySources(refreshReason, this.mContext.getUser().getIdentifier());
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @RequiresPermission(value="android.permission.MANAGE_SAFETY_CENTER")
    @RequiresApi(value=34)
    public void refreshSafetySources(int refreshReason, @NonNull List<String> safetySourceIds) {
        if (!SdkLevel.isAtLeastU()) {
            throw new UnsupportedOperationException("Method not supported on versions lower than UPSIDE_DOWN_CAKE");
        }
        Objects.requireNonNull(safetySourceIds, "safetySourceIds cannot be null");
        try {
            this.mService.refreshSpecificSafetySources(refreshReason, this.mContext.getUser().getIdentifier(), safetySourceIds);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @RequiresPermission(value="android.permission.MANAGE_SAFETY_CENTER")
    @Nullable
    public SafetyCenterConfig getSafetyCenterConfig() {
        try {
            return this.mService.getSafetyCenterConfig();
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @RequiresPermission(value="android.permission.MANAGE_SAFETY_CENTER")
    @NonNull
    public SafetyCenterData getSafetyCenterData() {
        try {
            return this.mService.getSafetyCenterData(this.mContext.getPackageName(), this.mContext.getUser().getIdentifier());
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @RequiresPermission(value="android.permission.MANAGE_SAFETY_CENTER")
    public void addOnSafetyCenterDataChangedListener(@NonNull Executor executor, @NonNull OnSafetyCenterDataChangedListener listener) {
        Objects.requireNonNull(executor, "executor cannot be null");
        Objects.requireNonNull(listener, "listener cannot be null");
        Object object = this.mListenersLock;
        synchronized (object) {
            if (this.mListenersToDelegates.containsKey(listener)) {
                return;
            }
            ListenerDelegate delegate = new ListenerDelegate(executor, listener);
            try {
                this.mService.addOnSafetyCenterDataChangedListener(delegate, this.mContext.getPackageName(), this.mContext.getUser().getIdentifier());
            }
            catch (RemoteException e) {
                throw e.rethrowFromSystemServer();
            }
            this.mListenersToDelegates.put(listener, delegate);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @RequiresPermission(value="android.permission.MANAGE_SAFETY_CENTER")
    public void removeOnSafetyCenterDataChangedListener(@NonNull OnSafetyCenterDataChangedListener listener) {
        Objects.requireNonNull(listener, "listener cannot be null");
        Object object = this.mListenersLock;
        synchronized (object) {
            ListenerDelegate delegate = this.mListenersToDelegates.get(listener);
            if (delegate == null) {
                return;
            }
            try {
                this.mService.removeOnSafetyCenterDataChangedListener(delegate, this.mContext.getUser().getIdentifier());
            }
            catch (RemoteException e) {
                throw e.rethrowFromSystemServer();
            }
            delegate.markAsRemoved();
            this.mListenersToDelegates.remove(listener);
        }
    }

    @RequiresPermission(value="android.permission.MANAGE_SAFETY_CENTER")
    public void dismissSafetyCenterIssue(@NonNull String safetyCenterIssueId) {
        Objects.requireNonNull(safetyCenterIssueId, "safetyCenterIssueId cannot be null");
        try {
            this.mService.dismissSafetyCenterIssue(safetyCenterIssueId, this.mContext.getUser().getIdentifier());
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @RequiresPermission(value="android.permission.MANAGE_SAFETY_CENTER")
    public void executeSafetyCenterIssueAction(@NonNull String safetyCenterIssueId, @NonNull String safetyCenterIssueActionId) {
        Objects.requireNonNull(safetyCenterIssueId, "safetyCenterIssueId cannot be null");
        Objects.requireNonNull(safetyCenterIssueActionId, "safetyCenterIssueActionId cannot be null");
        try {
            this.mService.executeSafetyCenterIssueAction(safetyCenterIssueId, safetyCenterIssueActionId, this.mContext.getUser().getIdentifier());
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @RequiresPermission(value="android.permission.MANAGE_SAFETY_CENTER")
    public void clearAllSafetySourceDataForTests() {
        try {
            this.mService.clearAllSafetySourceDataForTests();
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @RequiresPermission(value="android.permission.MANAGE_SAFETY_CENTER")
    public void setSafetyCenterConfigForTests(@NonNull SafetyCenterConfig safetyCenterConfig) {
        Objects.requireNonNull(safetyCenterConfig, "safetyCenterConfig cannot be null");
        try {
            this.mService.setSafetyCenterConfigForTests(safetyCenterConfig);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @RequiresPermission(value="android.permission.MANAGE_SAFETY_CENTER")
    public void clearSafetyCenterConfigForTests() {
        try {
            this.mService.clearSafetyCenterConfigForTests();
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    private static class ListenerDelegate
    extends IOnSafetyCenterDataChangedListener.Stub {
        @NonNull
        private final Executor mExecutor;
        @NonNull
        private final OnSafetyCenterDataChangedListener mOriginalListener;
        private volatile boolean mRemoved = false;

        private ListenerDelegate(@NonNull Executor executor, @NonNull OnSafetyCenterDataChangedListener originalListener) {
            this.mExecutor = executor;
            this.mOriginalListener = originalListener;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onSafetyCenterDataChanged(@NonNull SafetyCenterData safetyCenterData) {
            Objects.requireNonNull(safetyCenterData, "safetyCenterData cannot be null");
            long identity = Binder.clearCallingIdentity();
            try {
                this.mExecutor.execute(() -> {
                    if (this.mRemoved) {
                        return;
                    }
                    this.mOriginalListener.onSafetyCenterDataChanged(safetyCenterData);
                });
            }
            finally {
                Binder.restoreCallingIdentity(identity);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onError(@NonNull SafetyCenterErrorDetails safetyCenterErrorDetails) {
            Objects.requireNonNull(safetyCenterErrorDetails, "safetyCenterErrorDetails cannot be null");
            long identity = Binder.clearCallingIdentity();
            try {
                this.mExecutor.execute(() -> {
                    if (this.mRemoved) {
                        return;
                    }
                    this.mOriginalListener.onError(safetyCenterErrorDetails);
                });
            }
            finally {
                Binder.restoreCallingIdentity(identity);
            }
        }

        public void markAsRemoved() {
            this.mRemoved = true;
        }
    }

    public static interface OnSafetyCenterDataChangedListener {
        public void onSafetyCenterDataChanged(@NonNull SafetyCenterData var1);

        default public void onError(@NonNull SafetyCenterErrorDetails errorDetails) {
        }
    }

    @Retention(value=RetentionPolicy.SOURCE)
    @TargetApi(value=34)
    public static @interface RefreshReason {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface RefreshRequestType {
    }
}

