/*
 * Decompiled with CFR 0.152.
 */
package android.ranging.uwb;

import android.annotation.FlaggedApi;
import android.annotation.NonNull;
import android.os.Parcel;
import android.os.Parcelable;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.util.Objects;
import java.util.Random;

@FlaggedApi(value="com.android.x.ranging.com.android.ranging.flags.ranging_stack_enabled")
public class UwbComplexChannel
implements Parcelable {
    public static final int UWB_CHANNEL_5 = 5;
    public static final int UWB_CHANNEL_6 = 6;
    public static final int UWB_CHANNEL_8 = 8;
    public static final int UWB_CHANNEL_9 = 9;
    public static final int UWB_CHANNEL_10 = 10;
    public static final int UWB_CHANNEL_12 = 12;
    public static final int UWB_CHANNEL_13 = 13;
    public static final int UWB_CHANNEL_14 = 14;
    public static final int UWB_PREAMBLE_CODE_INDEX_9 = 9;
    public static final int UWB_PREAMBLE_CODE_INDEX_10 = 10;
    public static final int UWB_PREAMBLE_CODE_INDEX_11 = 11;
    public static final int UWB_PREAMBLE_CODE_INDEX_12 = 12;
    public static final int UWB_PREAMBLE_CODE_INDEX_25 = 25;
    public static final int UWB_PREAMBLE_CODE_INDEX_26 = 26;
    public static final int UWB_PREAMBLE_CODE_INDEX_27 = 27;
    public static final int UWB_PREAMBLE_CODE_INDEX_28 = 28;
    public static final int UWB_PREAMBLE_CODE_INDEX_29 = 29;
    public static final int UWB_PREAMBLE_CODE_INDEX_30 = 30;
    public static final int UWB_PREAMBLE_CODE_INDEX_31 = 31;
    public static final int UWB_PREAMBLE_CODE_INDEX_32 = 32;
    private static final int[] PREAMBLE_INDEXES_BPRF = new int[]{9, 10, 11, 12};
    private final int mChannel;
    private final int mPreambleIndex;
    @NonNull
    public static final Parcelable.Creator<UwbComplexChannel> CREATOR = new Parcelable.Creator<UwbComplexChannel>(){

        @Override
        public UwbComplexChannel createFromParcel(Parcel in) {
            return new UwbComplexChannel(in);
        }

        public UwbComplexChannel[] newArray(int size) {
            return new UwbComplexChannel[size];
        }
    };

    private UwbComplexChannel(Builder builder) {
        this.mChannel = builder.mChannel;
        this.mPreambleIndex = builder.mPreambleIndex;
    }

    private UwbComplexChannel(@NonNull Parcel in) {
        this.mChannel = in.readInt();
        this.mPreambleIndex = in.readInt();
    }

    public int getChannel() {
        return this.mChannel;
    }

    public int getPreambleIndex() {
        return this.mPreambleIndex;
    }

    @Override
    public int describeContents() {
        return 0;
    }

    @Override
    public void writeToParcel(@NonNull Parcel dest, int flags) {
        dest.writeInt(this.mChannel);
        dest.writeInt(this.mPreambleIndex);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof UwbComplexChannel)) {
            return false;
        }
        UwbComplexChannel other = (UwbComplexChannel)o;
        return this.mChannel == other.mChannel && this.mPreambleIndex == other.mPreambleIndex;
    }

    public int hashCode() {
        return Objects.hash(this.mChannel, this.mPreambleIndex);
    }

    public String toString() {
        return "UwbComplexChannel{ mChannel=" + this.mChannel + ", mPreambleIndex=" + this.mPreambleIndex + " }";
    }

    public static class Builder {
        private int mChannel = 5;
        private int mPreambleIndex = PREAMBLE_INDEXES_BPRF[new Random().nextInt(PREAMBLE_INDEXES_BPRF.length)];

        @NonNull
        public Builder setChannel(int channel) {
            this.mChannel = channel;
            return this;
        }

        @NonNull
        public Builder setPreambleIndex(int preambleIndex) {
            this.mPreambleIndex = preambleIndex;
            return this;
        }

        @NonNull
        public UwbComplexChannel build() {
            return new UwbComplexChannel(this);
        }
    }

    @Retention(value=RetentionPolicy.SOURCE)
    @Target(value={ElementType.TYPE_USE})
    public static @interface UwbPreambleCodeIndex {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    @Target(value={ElementType.TYPE_USE})
    public static @interface UwbChannel {
    }
}

