/*
 * Decompiled with CFR 0.152.
 */
package android.ranging;

import android.annotation.FlaggedApi;
import android.annotation.NonNull;
import android.annotation.RequiresPermission;
import android.content.AttributionSource;
import android.os.CancellationSignal;
import android.os.RemoteException;
import android.ranging.IRangingAdapter;
import android.ranging.RangingConfig;
import android.ranging.RangingData;
import android.ranging.RangingDevice;
import android.ranging.RangingPreference;
import android.ranging.RangingSessionManager;
import android.ranging.SessionHandle;
import android.ranging.oob.DeviceHandle;
import android.ranging.oob.OobHandle;
import android.ranging.oob.OobInitiatorRangingConfig;
import android.ranging.oob.OobResponderRangingConfig;
import android.ranging.oob.TransportHandle;
import android.ranging.raw.RawResponderRangingConfig;
import android.util.Log;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.util.ArrayList;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;

@FlaggedApi(value="com.android.x.ranging.com.android.ranging.flags.ranging_stack_enabled")
public class RangingSession
implements AutoCloseable {
    private static final String TAG = "RangingSession";
    private final AttributionSource mAttributionSource;
    private final SessionHandle mSessionHandle;
    private final IRangingAdapter mRangingAdapter;
    private final RangingSessionManager mRangingSessionManager;
    private final Callback mCallback;
    private final Executor mExecutor;
    private final Map<RangingDevice, TransportHandle> mTransportHandles = new ConcurrentHashMap<RangingDevice, TransportHandle>();

    public RangingSession(RangingSessionManager rangingSessionManager, AttributionSource attributionSource, SessionHandle sessionHandle, IRangingAdapter rangingAdapter, Callback callback, Executor executor) {
        this.mRangingSessionManager = rangingSessionManager;
        this.mAttributionSource = attributionSource;
        this.mSessionHandle = sessionHandle;
        this.mRangingAdapter = rangingAdapter;
        this.mCallback = callback;
        this.mExecutor = executor;
    }

    @RequiresPermission(value="android.permission.RANGING")
    @NonNull
    public CancellationSignal start(@NonNull RangingPreference rangingPreference) {
        if (rangingPreference.getRangingParams().getRangingSessionType() == 1) {
            this.mRangingSessionManager.registerOobSendDataListener();
            this.setupTransportHandles(rangingPreference);
        }
        Log.v(TAG, "Start ranging - " + this.mSessionHandle);
        try {
            this.mRangingAdapter.startRanging(this.mAttributionSource, this.mSessionHandle, rangingPreference, this.mRangingSessionManager);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
        CancellationSignal cancellationSignal = new CancellationSignal();
        cancellationSignal.setOnCancelListener(this::close);
        return cancellationSignal;
    }

    private void setupTransportHandles(RangingPreference rangingPreference) {
        ArrayList<DeviceHandle> deviceHandleList = new ArrayList<DeviceHandle>();
        if (rangingPreference.getRangingParams() instanceof OobInitiatorRangingConfig) {
            deviceHandleList.addAll(((OobInitiatorRangingConfig)rangingPreference.getRangingParams()).getDeviceHandles());
        } else if (rangingPreference.getRangingParams() instanceof OobResponderRangingConfig) {
            deviceHandleList.add(((OobResponderRangingConfig)rangingPreference.getRangingParams()).getDeviceHandle());
        }
        for (DeviceHandle deviceHandle : deviceHandleList) {
            TransportHandleReceiveCallback receiveCallback = new TransportHandleReceiveCallback(deviceHandle.getRangingDevice());
            deviceHandle.getTransportHandle().registerReceiveCallback(Executors.newCachedThreadPool(), receiveCallback);
            this.mTransportHandles.put(deviceHandle.getRangingDevice(), deviceHandle.getTransportHandle());
        }
    }

    @RequiresPermission(value="android.permission.RANGING")
    public void addDeviceToRangingSession(@NonNull RangingConfig deviceRangingParams) {
        Log.v(TAG, " Add device - " + this.mSessionHandle);
        try {
            if (deviceRangingParams instanceof RawResponderRangingConfig) {
                this.mRangingAdapter.addRawDevice(this.mSessionHandle, (RawResponderRangingConfig)deviceRangingParams);
            } else {
                this.mCallback.onOpenFailed(3);
            }
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @RequiresPermission(value="android.permission.RANGING")
    public void removeDeviceFromRangingSession(@NonNull RangingDevice rangingDevice) {
        Log.v(TAG, " Remove device - " + this.mSessionHandle);
        try {
            this.mRangingAdapter.removeDevice(this.mSessionHandle, rangingDevice);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @RequiresPermission(value="android.permission.RANGING")
    public void reconfigureRangingInterval(int intervalSkipCount) {
        Log.v(TAG, " Reconfiguring ranging interval - " + this.mSessionHandle);
        try {
            this.mRangingAdapter.reconfigureRangingInterval(this.mSessionHandle, intervalSkipCount);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @RequiresPermission(value="android.permission.RANGING")
    public void stop() {
        Log.v(TAG, "Stop ranging - " + this.mSessionHandle);
        try {
            this.mRangingAdapter.stopRanging(this.mSessionHandle);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    public void onOpened() {
        this.mExecutor.execute(this.mCallback::onOpened);
    }

    public void onOpenFailed(int reason) {
        this.mExecutor.execute(() -> this.mCallback.onOpenFailed(reason));
    }

    public void onStarted(RangingDevice peer, int technology) {
        this.mExecutor.execute(() -> this.mCallback.onStarted(peer, technology));
    }

    public void onResults(RangingDevice peer, RangingData data) {
        this.mExecutor.execute(() -> this.mCallback.onResults(peer, data));
    }

    public void onStopped(RangingDevice peer, int technology) {
        this.mExecutor.execute(() -> this.mCallback.onStopped(peer, technology));
    }

    public void onClosed(int reason) {
        this.mExecutor.execute(() -> this.mCallback.onClosed(reason));
    }

    void sendOobData(RangingDevice toDevice, byte[] data) {
        if (!this.mTransportHandles.containsKey(toDevice)) {
            Log.e(TAG, "TransportHandle not found for session: " + this.mSessionHandle + ", device: " + toDevice);
        }
        this.mTransportHandles.get(toDevice).sendData(data);
    }

    @Override
    @RequiresPermission(value="android.permission.RANGING")
    public void close() {
        this.stop();
    }

    public String toString() {
        return "RangingSession{ mSessionHandle=" + this.mSessionHandle + ", mRangingAdapter=" + this.mRangingAdapter + ", mRangingSessionManager=" + this.mRangingSessionManager + ", mCallback=" + this.mCallback + ", mExecutor=" + this.mExecutor + ", mTransportHandles=" + this.mTransportHandles + " }";
    }

    public static interface Callback {
        public static final int REASON_UNKNOWN = 0;
        public static final int REASON_LOCAL_REQUEST = 1;
        public static final int REASON_REMOTE_REQUEST = 2;
        public static final int REASON_UNSUPPORTED = 3;
        public static final int REASON_SYSTEM_POLICY = 4;
        public static final int REASON_NO_PEERS_FOUND = 5;

        public void onOpened();

        public void onOpenFailed(int var1);

        public void onStarted(@NonNull RangingDevice var1, int var2);

        public void onResults(@NonNull RangingDevice var1, @NonNull RangingData var2);

        public void onStopped(@NonNull RangingDevice var1, int var2);

        public void onClosed(int var1);

        @Retention(value=RetentionPolicy.SOURCE)
        @Target(value={ElementType.TYPE_USE})
        public static @interface Reason {
        }
    }

    class TransportHandleReceiveCallback
    implements TransportHandle.ReceiveCallback {
        private final OobHandle mOobHandle;

        TransportHandleReceiveCallback(RangingDevice device) {
            this.mOobHandle = new OobHandle(RangingSession.this.mSessionHandle, device);
        }

        @Override
        public void onReceiveData(byte[] data) {
            RangingSession.this.mRangingSessionManager.oobDataReceived(this.mOobHandle, data);
        }

        @Override
        public void onSendFailed() {
        }

        @Override
        public void onDisconnect() {
            RangingSession.this.mRangingSessionManager.deviceOobDisconnected(this.mOobHandle);
        }

        @Override
        public void onReconnect() {
            RangingSession.this.mRangingSessionManager.deviceOobReconnected(this.mOobHandle);
        }

        @Override
        public void onClose() {
            RangingSession.this.mRangingSessionManager.deviceOobClosed(this.mOobHandle);
        }
    }
}

