/*
 * Decompiled with CFR 0.152.
 */
package android.ranging;

import android.annotation.FlaggedApi;
import android.annotation.NonNull;
import android.annotation.Nullable;
import android.annotation.RequiresNoPermission;
import android.content.AttributionSource;
import android.content.Context;
import android.ranging.CapabilitiesListener;
import android.ranging.IRangingAdapter;
import android.ranging.RangingCapabilities;
import android.ranging.RangingSession;
import android.ranging.RangingSessionManager;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.util.Objects;
import java.util.concurrent.Executor;

@FlaggedApi(value="com.android.x.ranging.com.android.ranging.flags.ranging_stack_enabled")
public class RangingManager {
    private static final String TAG = "RangingManager";
    private final Context mContext;
    private final IRangingAdapter mRangingAdapter;
    private final CapabilitiesListener mCapabilitiesListener;
    private final RangingSessionManager mRangingSessionManager;
    public static final int UWB = 0;
    public static final int BLE_CS = 1;
    public static final int WIFI_NAN_RTT = 2;
    public static final int BLE_RSSI = 3;

    public RangingManager(@NonNull Context context, @NonNull IRangingAdapter adapter) {
        this.mContext = context;
        this.mRangingAdapter = adapter;
        this.mCapabilitiesListener = new CapabilitiesListener(adapter);
        this.mRangingSessionManager = new RangingSessionManager(adapter);
    }

    @RequiresNoPermission
    @NonNull
    public void registerCapabilitiesCallback(@NonNull Executor executor, @NonNull RangingCapabilitiesCallback callback) {
        Objects.requireNonNull(executor, "Executor cannot be null");
        Objects.requireNonNull(callback, "Capabilities callback cannot be null");
        this.mCapabilitiesListener.register(executor, callback);
    }

    @RequiresNoPermission
    @NonNull
    public void unregisterCapabilitiesCallback(@NonNull RangingCapabilitiesCallback callback) {
        Objects.requireNonNull(callback, "Capabilities callback cannot be null");
        this.mCapabilitiesListener.unregister(callback);
    }

    @RequiresNoPermission
    @Nullable
    public RangingSession createRangingSession(@NonNull Executor executor, @NonNull RangingSession.Callback callback) {
        Objects.requireNonNull(executor, "Executor cannot be null");
        Objects.requireNonNull(callback, "Callback cannot be null");
        return this.createRangingSessionInternal(this.mContext.getAttributionSource(), callback, executor);
    }

    private RangingSession createRangingSessionInternal(AttributionSource attributionSource, RangingSession.Callback callback, Executor executor) {
        return this.mRangingSessionManager.createRangingSessionInstance(attributionSource, callback, executor);
    }

    public static interface RangingCapabilitiesCallback {
        public void onRangingCapabilities(@NonNull RangingCapabilities var1);
    }

    @Retention(value=RetentionPolicy.SOURCE)
    @Target(value={ElementType.TYPE_USE})
    public static @interface RangingTechnology {
    }
}

