/*
 * Decompiled with CFR 0.152.
 */
package android.provider.internal.modules.utils.ravenwood;

import android.ravenwood.annotation.RavenwoodKeepWholeClass;
import java.util.Objects;

@RavenwoodKeepWholeClass
public class RavenwoodHelper {
    private RavenwoodHelper() {
    }

    private static void throwIfCalledOnDevice() {
        if (!RavenwoodHelper.isRunningOnRavenwood()) {
            throw new UnsupportedOperationException("This method can only be used on Ravenwood");
        }
    }

    public static boolean isRunningOnRavenwood() {
        return System.getProperty("android.ravenwood.version") != null;
    }

    public static String getRavenwoodRuntimePath() {
        RavenwoodHelper.throwIfCalledOnDevice();
        return Objects.requireNonNull(System.getProperty("android.ravenwood.runtime_path"), "Ravenwood runtime path not set. (called outside of Ravenwood?)");
    }

    public static String getRavenwoodAconfigStoragePath() {
        RavenwoodHelper.throwIfCalledOnDevice();
        return RavenwoodHelper.getRavenwoodRuntimePath() + "/aconfig";
    }

    public static class RavenwoodInternal {
        public static final String RAVENWOOD_VERSION_JAVA_SYSPROP = "android.ravenwood.version";
        public static final String RAVENWOOD_RUNTIME_PATH_JAVA_SYSPROP = "android.ravenwood.runtime_path";

        private RavenwoodInternal() {
        }
    }
}

