/*
 * Decompiled with CFR 0.152.
 */
package android.provider;

import android.annotation.FlaggedApi;
import android.annotation.NonNull;
import android.annotation.Nullable;
import android.annotation.RequiresPermission;
import android.annotation.SuppressLint;
import android.annotation.SystemApi;
import android.content.ContentResolver;
import android.database.ContentObserver;
import android.net.Uri;
import android.provider.DeviceConfigDataStore;
import android.provider.DeviceConfig_Delegate;
import android.provider.SettingsConfigDataStore;
import android.provider.WritableFlags;
import android.provider.WritableNamespaces;
import android.provider.internal.modules.utils.build.SdkLevel;
import android.ravenwood.annotation.RavenwoodKeepWholeClass;
import android.ravenwood.annotation.RavenwoodRedirect;
import android.ravenwood.annotation.RavenwoodRedirectionClass;
import android.ravenwood.annotation.RavenwoodThrow;
import android.util.ArrayMap;
import android.util.ArraySet;
import android.util.Log;
import android.util.Pair;
import android.util.Slog;
import com.android.internal.annotations.GuardedBy;
import com.android.tools.layoutlib.annotations.LayoutlibDelegate;
import java.io.PrintWriter;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.concurrent.Executor;

@SystemApi
@RavenwoodKeepWholeClass
@RavenwoodRedirectionClass(value="DeviceConfig_host")
public class DeviceConfig {
    public static final String SERVICE_NAME = "device_config_updatable";
    @SystemApi
    public static final String NAMESPACE_ACCESSIBILITY = "accessibility";
    @SystemApi
    public static final String NAMESPACE_ACTIVITY_MANAGER = "activity_manager";
    @SystemApi(client=SystemApi.Client.MODULE_LIBRARIES)
    public static final String NAMESPACE_ACTIVITY_MANAGER_COMPONENT_ALIAS = "activity_manager_ca";
    @SystemApi
    public static final String NAMESPACE_AUTO_PIN_CONFIRMATION = "auto_pin_confirmation";
    @SystemApi
    public static final String NAMESPACE_ACTIVITY_MANAGER_NATIVE_BOOT = "activity_manager_native_boot";
    @SystemApi(client=SystemApi.Client.MODULE_LIBRARIES)
    public static final String NAMESPACE_ALARM_MANAGER = "alarm_manager";
    @SystemApi
    public static final String NAMESPACE_APP_COMPAT = "app_compat";
    @SystemApi
    public static final String NAMESPACE_APP_HIBERNATION = "app_hibernation";
    @SystemApi
    public static final String NAMESPACE_APPSEARCH = "appsearch";
    @SystemApi(client=SystemApi.Client.MODULE_LIBRARIES)
    public static final String NAMESPACE_APP_STANDBY = "app_standby";
    @SystemApi(client=SystemApi.Client.MODULE_LIBRARIES)
    public static final String NAMESPACE_APP_CLONING = "app_cloning";
    @SystemApi
    public static final String NAMESPACE_ATTENTION_MANAGER_SERVICE = "attention_manager_service";
    @SystemApi
    public static final String NAMESPACE_AUTOFILL = "autofill";
    @SystemApi
    public static final String NAMESPACE_BATTERY_SAVER = "battery_saver";
    @SystemApi(client=SystemApi.Client.MODULE_LIBRARIES)
    public static final String NAMESPACE_BATTERY_STATS = "battery_stats";
    @SystemApi
    public static final String NAMESPACE_BLOBSTORE = "blobstore";
    @SystemApi
    public static final String NAMESPACE_BLUETOOTH = "bluetooth";
    @SystemApi
    public static final String NAMESPACE_CORE_EXPERIMENTS_TEAM_INTERNAL = "core_experiments_team_internal";
    @SystemApi
    public static final String NAMESPACE_CAMERA_NATIVE = "camera_native";
    @SystemApi
    public static final String NAMESPACE_CELLULAR_SECURITY = "cellular_security";
    @SystemApi
    public static final String NAMESPACE_CLIPBOARD = "clipboard";
    @SystemApi
    public static final String NAMESPACE_CONNECTIVITY = "connectivity";
    @SystemApi
    public static final String NAMESPACE_CAPTIVEPORTALLOGIN = "captive_portal_login";
    @SystemApi
    public static final String NAMESPACE_EDGETPU_NATIVE = "edgetpu_native";
    @SystemApi
    public static final String NAMESPACE_HEALTH_FITNESS = "health_fitness";
    @SystemApi
    public static final String NAMESPACE_TETHERING = "tethering";
    @SystemApi
    public static final String NAMESPACE_NEARBY = "nearby";
    @SystemApi
    public static final String NAMESPACE_CONTENT_CAPTURE = "content_capture";
    @SystemApi
    public static final String NAMESPACE_CREDENTIAL = "credential_manager";
    @SystemApi(client=SystemApi.Client.MODULE_LIBRARIES)
    public static final String NAMESPACE_DEVICE_IDLE = "device_idle";
    @Deprecated
    @SystemApi
    public static final String NAMESPACE_DEX_BOOT = "dex_boot";
    @SystemApi
    public static final String NAMESPACE_DISPLAY_MANAGER = "display_manager";
    @SystemApi
    public static final String NAMESPACE_GAME_DRIVER = "game_driver";
    @SystemApi
    public static final String NAMESPACE_HDMI_CONTROL = "hdmi_control";
    @SystemApi
    public static final String NAMESPACE_INPUT_NATIVE_BOOT = "input_native_boot";
    @SystemApi
    public static final String NAMESPACE_INTELLIGENCE_ATTENTION = "intelligence_attention";
    @SystemApi(client=SystemApi.Client.MODULE_LIBRARIES)
    public static final String NAMESPACE_INTELLIGENCE_CONTENT_SUGGESTIONS = "intelligence_content_suggestions";
    @SystemApi
    public static final String NAMESPACE_JOB_SCHEDULER = "jobscheduler";
    @SystemApi
    public static final String NAMESPACE_LMKD_NATIVE = "lmkd_native";
    @SystemApi
    public static final String NAMESPACE_LOCATION = "location";
    @SystemApi
    public static final String NAMESPACE_MEDIA = "media";
    @SystemApi
    public static final String NAMESPACE_MEDIA_NATIVE = "media_native";
    @SystemApi(client=SystemApi.Client.MODULE_LIBRARIES)
    public static final String NAMESPACE_MGLRU_NATIVE = "mglru_native";
    @SystemApi
    @FlaggedApi(value="android.provider.flags.mmd_device_config")
    public static final String NAMESPACE_MM = "mm";
    @SystemApi
    @FlaggedApi(value="android.provider.flags.mmd_device_config")
    public static final String NAMESPACE_MMD_NATIVE = "mmd_native";
    @SystemApi
    public static final String NAMESPACE_NETD_NATIVE = "netd_native";
    @SystemApi
    public static final String NAMESPACE_NNAPI_NATIVE = "nnapi_native";
    @SystemApi
    public static final String NAMESPACE_ON_DEVICE_PERSONALIZATION = "on_device_personalization";
    @SystemApi
    public static final String NAMESPACE_PACKAGE_MANAGER_SERVICE = "package_manager_service";
    @SystemApi
    public static final String NAMESPACE_PROFCOLLECT_NATIVE_BOOT = "profcollect_native_boot";
    @SystemApi
    public static final String NAMESPACE_REBOOT_READINESS = "reboot_readiness";
    @SystemApi(client=SystemApi.Client.MODULE_LIBRARIES)
    public static final String NAMESPACE_REMOTE_KEY_PROVISIONING_NATIVE = "remote_key_provisioning_native";
    @SystemApi
    public static final String NAMESPACE_ROLLBACK = "rollback";
    @SystemApi
    public static final String NAMESPACE_ROLLBACK_BOOT = "rollback_boot";
    @SystemApi(client=SystemApi.Client.MODULE_LIBRARIES)
    public static final String NAMESPACE_ROTATION_RESOLVER = "rotation_resolver";
    @SystemApi
    public static final String NAMESPACE_RUNTIME = "runtime";
    @SystemApi
    public static final String NAMESPACE_RUNTIME_NATIVE = "runtime_native";
    @SystemApi
    public static final String NAMESPACE_RUNTIME_NATIVE_BOOT = "runtime_native_boot";
    @SystemApi
    public static final String NAMESPACE_SCHEDULER = "scheduler";
    @SystemApi
    public static final String NAMESPACE_SDK_SANDBOX = "sdk_sandbox";
    @SystemApi(client=SystemApi.Client.MODULE_LIBRARIES)
    public static final String NAMESPACE_SETTINGS_STATS = "settings_stats";
    @SystemApi
    public static final String NAMESPACE_STATSD_JAVA = "statsd_java";
    @SystemApi
    public static final String NAMESPACE_STATSD_JAVA_BOOT = "statsd_java_boot";
    @SystemApi
    public static final String NAMESPACE_STATSD_NATIVE = "statsd_native";
    @SystemApi
    public static final String NAMESPACE_STATSD_NATIVE_BOOT = "statsd_native_boot";
    @Deprecated
    @SystemApi
    public static final String NAMESPACE_STORAGE = "storage";
    @SystemApi
    public static final String NAMESPACE_STORAGE_NATIVE_BOOT = "storage_native_boot";
    @SystemApi
    public static final String NAMESPACE_ADSERVICES = "adservices";
    @SystemApi
    public static final String NAMESPACE_SURFACE_FLINGER_NATIVE_BOOT = "surface_flinger_native_boot";
    @SystemApi
    public static final String NAMESPACE_SWCODEC_NATIVE = "swcodec_native";
    @SystemApi
    public static final String NAMESPACE_SYSTEMUI = "systemui";
    @SystemApi
    public static final String NAMESPACE_SYSTEM_TIME = "system_time";
    @SystemApi(client=SystemApi.Client.MODULE_LIBRARIES)
    public static final String NAMESPACE_TARE = "tare";
    @SystemApi
    public static final String NAMESPACE_TELEPHONY = "telephony";
    @SystemApi
    public static final String NAMESPACE_TEXTCLASSIFIER = "textclassifier";
    @SystemApi(client=SystemApi.Client.MODULE_LIBRARIES)
    public static final String NAMESPACE_CONTACTS_PROVIDER = "contacts_provider";
    @SystemApi(client=SystemApi.Client.MODULE_LIBRARIES)
    public static final String NAMESPACE_SETTINGS_UI = "settings_ui";
    @SystemApi
    public static final String NAMESPACE_ANDROID = "android";
    @SystemApi(client=SystemApi.Client.MODULE_LIBRARIES)
    public static final String NAMESPACE_WINDOW_MANAGER = "window_manager";
    @SystemApi
    public static final String NAMESPACE_WINDOW_MANAGER_NATIVE_BOOT = "window_manager_native_boot";
    @SystemApi
    public static final String NAMESPACE_SELECTION_TOOLBAR = "selection_toolbar";
    @SystemApi(client=SystemApi.Client.MODULE_LIBRARIES)
    public static final String NAMESPACE_VOICE_INTERACTION = "voice_interaction";
    @SystemApi(client=SystemApi.Client.MODULE_LIBRARIES)
    public static final String NAMESPACE_DEVICE_POLICY_MANAGER = "device_policy_manager";
    @NonNull
    private static final List<String> PUBLIC_NAMESPACES = Arrays.asList("textclassifier", "runtime", "statsd_java", "statsd_java_boot", "selection_toolbar", "autofill", "device_policy_manager", "content_capture");
    @SystemApi
    public static final String NAMESPACE_PRIVACY = "privacy";
    @SystemApi
    public static final String NAMESPACE_BIOMETRICS = "biometrics";
    @SystemApi
    public static final String NAMESPACE_PERMISSIONS = "permissions";
    @SystemApi
    public static final String NAMESPACE_OTA = "ota";
    @SystemApi(client=SystemApi.Client.MODULE_LIBRARIES)
    public static final String NAMESPACE_WIDGET = "widget";
    @SystemApi(client=SystemApi.Client.MODULE_LIBRARIES)
    public static final String NAMESPACE_CONNECTIVITY_THERMAL_POWER_MANAGER = "connectivity_thermal_power_manager";
    @SystemApi(client=SystemApi.Client.MODULE_LIBRARIES)
    public static final String NAMESPACE_CONFIGURATION = "configuration";
    @SystemApi(client=SystemApi.Client.MODULE_LIBRARIES)
    public static final String NAMESPACE_LATENCY_TRACKER = "latency_tracker";
    @SystemApi(client=SystemApi.Client.MODULE_LIBRARIES)
    @SuppressLint(value={"IntentName"})
    public static final String NAMESPACE_INTERACTION_JANK_MONITOR = "interaction_jank_monitor";
    @SystemApi(client=SystemApi.Client.MODULE_LIBRARIES)
    public static final String NAMESPACE_GAME_OVERLAY = "game_overlay";
    @SystemApi(client=SystemApi.Client.MODULE_LIBRARIES)
    public static final String NAMESPACE_VIRTUALIZATION_FRAMEWORK_NATIVE = "virtualization_framework_native";
    @SystemApi
    public static final String NAMESPACE_CONSTRAIN_DISPLAY_APIS = "constrain_display_apis";
    @SystemApi
    public static final String NAMESPACE_APP_COMPAT_OVERRIDES = "app_compat_overrides";
    @SystemApi
    public static final String NAMESPACE_UWB = "uwb";
    @SystemApi
    public static final String NAMESPACE_AMBIENT_CONTEXT_MANAGER_SERVICE = "ambient_context_manager_service";
    @SystemApi
    public static final String NAMESPACE_WEARABLE_SENSING = "wearable_sensing";
    @SystemApi(client=SystemApi.Client.MODULE_LIBRARIES)
    public static final String NAMESPACE_VENDOR_SYSTEM_NATIVE = "vendor_system_native";
    @SystemApi(client=SystemApi.Client.MODULE_LIBRARIES)
    public static final String NAMESPACE_VENDOR_SYSTEM_NATIVE_BOOT = "vendor_system_native_boot";
    @SystemApi(client=SystemApi.Client.MODULE_LIBRARIES)
    public static final String NAMESPACE_MEMORY_SAFETY_NATIVE_BOOT = "memory_safety_native_boot";
    @SystemApi(client=SystemApi.Client.MODULE_LIBRARIES)
    public static final String NAMESPACE_MEMORY_SAFETY_NATIVE = "memory_safety_native";
    @SystemApi(client=SystemApi.Client.MODULE_LIBRARIES)
    public static final String NAMESPACE_WEAR = "wear";
    @SystemApi
    public static final String NAMESPACE_INPUT_METHOD_MANAGER = "input_method_manager";
    @SystemApi
    public static final String NAMESPACE_BACKUP_AND_RESTORE = "backup_and_restore";
    @SystemApi(client=SystemApi.Client.MODULE_LIBRARIES)
    public static final String NAMESPACE_ARC_APP_COMPAT = "arc_app_compat";
    @SystemApi
    public static final String NAMESPACE_REMOTE_AUTH = "remote_auth";
    @SystemApi(client=SystemApi.Client.MODULE_LIBRARIES)
    public static final String NAMESPACE_TETHERING_NATIVE = "tethering_u_or_later_native";
    @SystemApi
    public static final String NAMESPACE_NFC = "nfc";
    @SystemApi
    public static final int SYNC_DISABLED_MODE_NONE = 0;
    @SystemApi
    public static final int SYNC_DISABLED_MODE_PERSISTENT = 1;
    @SystemApi
    public static final int SYNC_DISABLED_MODE_UNTIL_REBOOT = 2;
    @SystemApi(client=SystemApi.Client.PRIVILEGED_APPS)
    @FlaggedApi(value="android.provider.flags.dump_improvements")
    public static final String DUMP_ARG_NAMESPACE = "--namespace";
    private static final Object sLock = new Object();
    @GuardedBy(value={"sLock"})
    private static ArrayMap<OnPropertiesChangedListener, Pair<String, Executor>> sListeners = new ArrayMap();
    @GuardedBy(value={"sLock"})
    private static Map<String, Pair<ContentObserver, Integer>> sNamespaces = new HashMap<String, Pair<ContentObserver, Integer>>();
    private static final String TAG = "DeviceConfig";
    private static final boolean DEBUG = Log.isLoggable("DeviceConfig", 3);
    private static final DeviceConfigDataStore sDataStore = DeviceConfig.newDataStore();
    private static final String DEVICE_CONFIG_OVERRIDES_NAMESPACE = "device_config_overrides";

    @RavenwoodRedirect
    private static DeviceConfigDataStore newDataStore() {
        return new SettingsConfigDataStore();
    }

    private DeviceConfig() {
    }

    @SystemApi
    @Nullable
    public static String getProperty_Original(@NonNull String namespace, @NonNull String name) {
        return DeviceConfig.getProperties(namespace, name).getString(name, null);
    }

    @LayoutlibDelegate
    public static String getProperty(String string2, String string3) {
        return DeviceConfig_Delegate.getProperty(string2, string3);
    }

    @SystemApi
    @NonNull
    @RequiresPermission(value="android.permission.READ_DEVICE_CONFIG")
    public static Properties getProperties(@NonNull String namespace, String ... names) {
        Properties properties = DeviceConfig.getPropertiesWithoutOverrides(namespace, names);
        if (SdkLevel.isAtLeastV()) {
            DeviceConfig.applyOverrides(properties);
        }
        return properties;
    }

    @NonNull
    private static Properties getPropertiesWithoutOverrides(@NonNull String namespace, String ... names) {
        return sDataStore.getProperties(namespace, names);
    }

    private static void applyOverrides(@NonNull Properties properties) {
        Properties overrides = DeviceConfig.getPropertiesWithoutOverrides(DEVICE_CONFIG_OVERRIDES_NAMESPACE, new String[0]);
        String prefix = properties.getNamespace() + ':';
        int prefixLength = prefix.length();
        for (Map.Entry<String, String> override : overrides.getMap().entrySet()) {
            String fullKey = override.getKey();
            String value = override.getValue();
            if (value == null || !fullKey.startsWith(prefix)) continue;
            properties.setString(fullKey.substring(prefixLength), value);
        }
    }

    @SystemApi
    @NonNull
    public static Set<Properties> getAllProperties() {
        Map<String, String> properties = sDataStore.getAllProperties();
        HashMap propertyMaps = new HashMap();
        for (String flag : properties.keySet()) {
            String value;
            String[] namespaceAndFlag = flag.split("/");
            String namespace = namespaceAndFlag[0];
            String flagName = namespaceAndFlag[1];
            String override = DeviceConfig.getProperty(DEVICE_CONFIG_OVERRIDES_NAMESPACE, namespace + ":" + flagName);
            String string2 = value = override != null ? override : properties.get(flag);
            if (!propertyMaps.containsKey(namespace)) {
                propertyMaps.put(namespace, new HashMap());
            }
            ((Map)propertyMaps.get(namespace)).put(flagName, value);
        }
        HashSet<Properties> result = new HashSet<Properties>();
        for (Map.Entry entry : propertyMaps.entrySet()) {
            result.add(new Properties((String)entry.getKey(), (Map)entry.getValue()));
        }
        return result;
    }

    @SystemApi
    @RequiresPermission(value="android.permission.READ_DEVICE_CONFIG")
    @Nullable
    public static String getString_Original(@NonNull String namespace, @NonNull String name, @Nullable String defaultValue) {
        String value = DeviceConfig.getProperty(namespace, name);
        return value != null ? value : defaultValue;
    }

    @LayoutlibDelegate
    public static String getString(String string2, String string3, String string4) {
        return DeviceConfig_Delegate.getString(string2, string3, string4);
    }

    @SystemApi
    public static boolean getBoolean_Original(@NonNull String namespace, @NonNull String name, boolean defaultValue) {
        String value = DeviceConfig.getProperty(namespace, name);
        return value != null ? Boolean.parseBoolean(value) : defaultValue;
    }

    @LayoutlibDelegate
    public static boolean getBoolean(String string2, String string3, boolean bl) {
        return DeviceConfig_Delegate.getBoolean(string2, string3, bl);
    }

    @SystemApi
    @RequiresPermission(value="android.permission.READ_DEVICE_CONFIG")
    public static int getInt_Original(@NonNull String namespace, @NonNull String name, int defaultValue) {
        String value = DeviceConfig.getProperty(namespace, name);
        if (value == null) {
            return defaultValue;
        }
        try {
            return Integer.parseInt(value);
        }
        catch (NumberFormatException e) {
            Slog.e(TAG, "Parsing integer failed for " + namespace + ":" + name);
            return defaultValue;
        }
    }

    @LayoutlibDelegate
    public static int getInt(String string2, String string3, int n) {
        return DeviceConfig_Delegate.getInt(string2, string3, n);
    }

    @SystemApi
    @RequiresPermission(value="android.permission.READ_DEVICE_CONFIG")
    public static long getLong_Original(@NonNull String namespace, @NonNull String name, long defaultValue) {
        String value = DeviceConfig.getProperty(namespace, name);
        if (value == null) {
            return defaultValue;
        }
        try {
            return Long.parseLong(value);
        }
        catch (NumberFormatException e) {
            Slog.e(TAG, "Parsing long failed for " + namespace + ":" + name);
            return defaultValue;
        }
    }

    @LayoutlibDelegate
    public static long getLong(String string2, String string3, long l) {
        return DeviceConfig_Delegate.getLong(string2, string3, l);
    }

    @SystemApi
    @RequiresPermission(value="android.permission.READ_DEVICE_CONFIG")
    public static float getFloat_Original(@NonNull String namespace, @NonNull String name, float defaultValue) {
        String value = DeviceConfig.getProperty(namespace, name);
        if (value == null) {
            return defaultValue;
        }
        try {
            return Float.parseFloat(value);
        }
        catch (NumberFormatException e) {
            Slog.e(TAG, "Parsing float failed for " + namespace + ":" + name);
            return defaultValue;
        }
    }

    @LayoutlibDelegate
    public static float getFloat(String string2, String string3, float f) {
        return DeviceConfig_Delegate.getFloat(string2, string3, f);
    }

    @SystemApi
    @RequiresPermission(value="android.permission.WRITE_DEVICE_CONFIG")
    public static boolean setLocalOverride(@NonNull String namespace, @NonNull String name, @NonNull String value) {
        return DeviceConfig.setProperty(DEVICE_CONFIG_OVERRIDES_NAMESPACE, namespace + ":" + name, value, false);
    }

    @SystemApi
    @RequiresPermission(value="android.permission.WRITE_DEVICE_CONFIG")
    public static void clearAllLocalOverrides() {
        Properties overrides = DeviceConfig.getProperties(DEVICE_CONFIG_OVERRIDES_NAMESPACE, new String[0]);
        for (String overrideName : overrides.getKeyset()) {
            DeviceConfig.deleteProperty(DEVICE_CONFIG_OVERRIDES_NAMESPACE, overrideName);
        }
    }

    @SystemApi
    @RequiresPermission(value="android.permission.WRITE_DEVICE_CONFIG")
    public static void clearLocalOverride(@NonNull String namespace, @NonNull String name) {
        DeviceConfig.deleteProperty(DEVICE_CONFIG_OVERRIDES_NAMESPACE, namespace + ":" + name);
    }

    @SystemApi
    @NonNull
    public static Map<String, Map<String, String>> getUnderlyingValuesForOverriddenFlags() {
        Properties overrides = DeviceConfig.getProperties(DEVICE_CONFIG_OVERRIDES_NAMESPACE, new String[0]);
        HashMap<String, Map<String, String>> result = new HashMap<String, Map<String, String>>();
        for (Map.Entry<String, String> entry : overrides.getPropertyValues().entrySet()) {
            String[] namespaceAndFlag = entry.getKey().split(":");
            String namespace = namespaceAndFlag[0];
            String flag = namespaceAndFlag[1];
            String actualValue = DeviceConfig.getPropertiesWithoutOverrides(namespace, flag).getString(flag, null);
            if (result.get(namespace) != null) {
                result.get(namespace).put(flag, actualValue);
                continue;
            }
            HashMap<String, String> innerMap = new HashMap<String, String>();
            innerMap.put(flag, actualValue);
            result.put(namespace, innerMap);
        }
        return result;
    }

    @SystemApi
    @RequiresPermission(anyOf={"android.permission.WRITE_DEVICE_CONFIG", "android.permission.WRITE_ALLOWLISTED_DEVICE_CONFIG"})
    public static boolean setProperty(@NonNull String namespace, @NonNull String name, @Nullable String value, boolean makeDefault) {
        return sDataStore.setProperty(namespace, name, value, makeDefault);
    }

    @SystemApi
    @RequiresPermission(anyOf={"android.permission.WRITE_DEVICE_CONFIG", "android.permission.WRITE_ALLOWLISTED_DEVICE_CONFIG"})
    public static boolean setProperties(@NonNull Properties properties) throws BadConfigException {
        return sDataStore.setProperties(properties);
    }

    @SystemApi
    @RequiresPermission(anyOf={"android.permission.WRITE_DEVICE_CONFIG", "android.permission.WRITE_ALLOWLISTED_DEVICE_CONFIG"})
    public static boolean deleteProperty(@NonNull String namespace, @NonNull String name) {
        return sDataStore.deleteProperty(namespace, name);
    }

    @SystemApi
    @RavenwoodThrow
    @RequiresPermission(anyOf={"android.permission.WRITE_DEVICE_CONFIG", "android.permission.WRITE_ALLOWLISTED_DEVICE_CONFIG"})
    public static void resetToDefaults(int resetMode, @Nullable String namespace) {
        sDataStore.resetToDefaults(resetMode, namespace);
    }

    @SystemApi
    @RequiresPermission(anyOf={"android.permission.WRITE_DEVICE_CONFIG", "android.permission.READ_WRITE_SYNC_DISABLED_MODE_CONFIG"})
    public static void setSyncDisabledMode(int syncDisabledMode) {
        sDataStore.setSyncDisabledMode(syncDisabledMode);
    }

    @SystemApi
    @RequiresPermission(anyOf={"android.permission.WRITE_DEVICE_CONFIG", "android.permission.READ_WRITE_SYNC_DISABLED_MODE_CONFIG"})
    public static int getSyncDisabledMode() {
        return sDataStore.getSyncDisabledMode();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SystemApi
    public static void addOnPropertiesChangedListener(@NonNull String namespace, @NonNull Executor executor, @NonNull OnPropertiesChangedListener onPropertiesChangedListener) {
        Object object = sLock;
        synchronized (object) {
            Pair<String, Executor> oldNamespace = sListeners.get(onPropertiesChangedListener);
            if (oldNamespace == null) {
                sListeners.put(onPropertiesChangedListener, new Pair<String, Executor>(namespace, executor));
                DeviceConfig.incrementNamespace(namespace);
            } else if (namespace.equals(oldNamespace.first)) {
                sListeners.put(onPropertiesChangedListener, new Pair<String, Executor>(namespace, executor));
            } else {
                DeviceConfig.decrementNamespace((String)DeviceConfig.sListeners.get((Object)onPropertiesChangedListener).first);
                sListeners.put(onPropertiesChangedListener, new Pair<String, Executor>(namespace, executor));
                DeviceConfig.incrementNamespace(namespace);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SystemApi(client=SystemApi.Client.PRIVILEGED_APPS)
    @FlaggedApi(value="android.provider.flags.dump_improvements")
    public static void dump(@NonNull PrintWriter printWriter, @NonNull String dumpPrefix, @Nullable String[] args) {
        String namespace;
        if (DEBUG) {
            Slog.d(TAG, "dump(): args=" + Arrays.toString(args));
        }
        Objects.requireNonNull(printWriter, "printWriter cannot be null");
        Comparator comparator = (o1, o2) -> o1.toString().compareTo(o2.toString());
        TreeMap<String, TreeSet<OnPropertiesChangedListener>> listenersByNamespace = new TreeMap<String, TreeSet<OnPropertiesChangedListener>>();
        ArraySet<OnPropertiesChangedListener> uniqueListeners = new ArraySet<OnPropertiesChangedListener>();
        String filter = null;
        if (args.length > 0) {
            switch (args[0]) {
                case "--namespace": {
                    if (args.length < 2) {
                        throw new IllegalArgumentException("argument --namespace requires an extra argument");
                    }
                    filter = args[1];
                    if (!DEBUG) break;
                    Slog.d(TAG, "dump(): setting filter as " + filter);
                    break;
                }
                default: {
                    Slog.w(TAG, "dump(): ignoring invalid arguments: " + Arrays.toString(args));
                }
            }
        }
        Iterator iterator = sLock;
        synchronized (iterator) {
            int listenersSize = sListeners.size();
            for (int i = 0; i < listenersSize; ++i) {
                namespace = (String)DeviceConfig.sListeners.valueAt((int)i).first;
                if (filter != null && !namespace.contains(filter)) continue;
                OnPropertiesChangedListener listener = sListeners.keyAt(i);
                TreeSet<OnPropertiesChangedListener> listeners = (TreeSet<OnPropertiesChangedListener>)listenersByNamespace.get(namespace);
                if (listeners == null) {
                    listeners = new TreeSet<OnPropertiesChangedListener>(comparator);
                    listenersByNamespace.put(namespace, listeners);
                }
                listeners.add(listener);
                uniqueListeners.add(listener);
            }
        }
        printWriter.printf("%s%d listeners for %d namespaces:\n", dumpPrefix, uniqueListeners.size(), listenersByNamespace.size());
        for (Map.Entry entry : listenersByNamespace.entrySet()) {
            namespace = (String)entry.getKey();
            Set listeners = (Set)entry.getValue();
            printWriter.printf("%s%s: %d listeners\n", dumpPrefix, namespace, listeners.size());
            for (OnPropertiesChangedListener listener : listeners) {
                printWriter.printf("%s%s%s\n", dumpPrefix, dumpPrefix, listener);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SystemApi
    public static void removeOnPropertiesChangedListener(@NonNull OnPropertiesChangedListener onPropertiesChangedListener) {
        Objects.requireNonNull(onPropertiesChangedListener);
        Object object = sLock;
        synchronized (object) {
            if (sListeners.containsKey(onPropertiesChangedListener)) {
                DeviceConfig.decrementNamespace((String)DeviceConfig.sListeners.get((Object)onPropertiesChangedListener).first);
                sListeners.remove(onPropertiesChangedListener);
            }
        }
    }

    @SystemApi
    @RavenwoodThrow
    @RequiresPermission(value="android.permission.MONITOR_DEVICE_CONFIG_ACCESS")
    public static void setMonitorCallback(@NonNull ContentResolver resolver, @NonNull Executor executor, @NonNull MonitorCallback callback) {
        sDataStore.setMonitorCallback(resolver, executor, callback);
    }

    @SystemApi
    @RavenwoodThrow
    @RequiresPermission(value="android.permission.MONITOR_DEVICE_CONFIG_ACCESS")
    public static void clearMonitorCallback(@NonNull ContentResolver resolver) {
        sDataStore.clearMonitorCallback(resolver);
    }

    @GuardedBy(value={"sLock"})
    private static void incrementNamespace(@NonNull String namespace) {
        Objects.requireNonNull(namespace);
        Pair<ContentObserver, Integer> namespaceCount = sNamespaces.get(namespace);
        if (namespaceCount != null) {
            sNamespaces.put(namespace, new Pair<ContentObserver, Integer>((ContentObserver)namespaceCount.first, (Integer)namespaceCount.second + 1));
        } else {
            ContentObserver contentObserver = new ContentObserver(null){

                @Override
                public void onChange(boolean selfChange, Uri uri) {
                    if (uri != null) {
                        DeviceConfig.handleChange(uri);
                    }
                }
            };
            sDataStore.registerContentObserver(namespace, true, contentObserver);
            sNamespaces.put(namespace, new Pair<1, Integer>(contentObserver, 1));
        }
    }

    @GuardedBy(value={"sLock"})
    private static void decrementNamespace(@NonNull String namespace) {
        Objects.requireNonNull(namespace);
        Pair<ContentObserver, Integer> namespaceCount = sNamespaces.get(namespace);
        if (namespaceCount == null) {
            return;
        }
        if ((Integer)namespaceCount.second > 1) {
            sNamespaces.put(namespace, new Pair<ContentObserver, Integer>((ContentObserver)namespaceCount.first, (Integer)namespaceCount.second - 1));
        } else {
            sDataStore.unregisterContentObserver((ContentObserver)namespaceCount.first);
            sNamespaces.remove(namespace);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void handleChange(@NonNull Uri uri) {
        Properties properties;
        Objects.requireNonNull(uri);
        List<String> pathSegments = uri.getPathSegments();
        String namespace = pathSegments.get(1);
        if (pathSegments.size() > 2) {
            String[] keys = new String[pathSegments.size() - 2];
            for (int i = 2; i < pathSegments.size(); ++i) {
                keys[i - 2] = pathSegments.get(i);
            }
            try {
                properties = DeviceConfig.getProperties(namespace, keys);
            }
            catch (SecurityException e) {
                Slog.e(TAG, "OnPropertyChangedListener update failed: permission violation.");
                return;
            }
            for (String key : keys) {
                properties.setString(key, properties.getString(key, null));
            }
        } else {
            properties = new Properties.Builder(namespace).build();
        }
        Object object = sLock;
        synchronized (object) {
            for (int i = 0; i < sListeners.size(); ++i) {
                if (!namespace.equals(DeviceConfig.sListeners.valueAt((int)i).first)) continue;
                OnPropertiesChangedListener listener = sListeners.keyAt(i);
                ((Executor)DeviceConfig.sListeners.valueAt((int)i).second).execute(() -> listener.onPropertiesChanged(properties));
            }
        }
    }

    @SystemApi
    @NonNull
    public static List<String> getPublicNamespaces() {
        return PUBLIC_NAMESPACES;
    }

    @SystemApi
    @NonNull
    public static Set<String> getAdbWritableFlags() {
        return WritableFlags.ALLOWLIST;
    }

    @SystemApi
    @FlaggedApi(value="android.provider.flags.device_config_writable_namespaces_api")
    @NonNull
    public static Set<String> getAdbWritableNamespaces() {
        return WritableNamespaces.ALLOWLIST;
    }

    @SystemApi
    public static class Properties {
        private final String mNamespace;
        private final HashMap<String, String> mMap;
        private Set<String> mKeyset;

        @SystemApi(client=SystemApi.Client.MODULE_LIBRARIES)
        public Properties(@NonNull String namespace, @Nullable Map<String, String> keyValueMap) {
            Objects.requireNonNull(namespace);
            this.mNamespace = namespace;
            this.mMap = new HashMap();
            if (keyValueMap != null) {
                this.mMap.putAll(keyValueMap);
            }
        }

        @NonNull
        public String getNamespace() {
            return this.mNamespace;
        }

        @NonNull
        public Set<String> getKeyset() {
            if (this.mKeyset == null) {
                this.mKeyset = Collections.unmodifiableSet(this.mMap.keySet());
            }
            return this.mKeyset;
        }

        @Nullable
        public String getString(@NonNull String name, @Nullable String defaultValue) {
            Objects.requireNonNull(name);
            String value = this.mMap.get(name);
            return value != null ? value : defaultValue;
        }

        @Nullable
        private String setString(@NonNull String name, @Nullable String value) {
            Objects.requireNonNull(name);
            this.mKeyset = null;
            return this.mMap.put(name, value);
        }

        @NonNull
        private Map<String, String> getMap() {
            return this.mMap;
        }

        public boolean getBoolean(@NonNull String name, boolean defaultValue) {
            Objects.requireNonNull(name);
            String value = this.mMap.get(name);
            return value != null ? Boolean.parseBoolean(value) : defaultValue;
        }

        public int getInt(@NonNull String name, int defaultValue) {
            Objects.requireNonNull(name);
            String value = this.mMap.get(name);
            if (value == null) {
                return defaultValue;
            }
            try {
                return Integer.parseInt(value);
            }
            catch (NumberFormatException e) {
                Slog.e(DeviceConfig.TAG, "Parsing int failed for " + name);
                return defaultValue;
            }
        }

        public long getLong(@NonNull String name, long defaultValue) {
            Objects.requireNonNull(name);
            String value = this.mMap.get(name);
            if (value == null) {
                return defaultValue;
            }
            try {
                return Long.parseLong(value);
            }
            catch (NumberFormatException e) {
                Slog.e(DeviceConfig.TAG, "Parsing long failed for " + name);
                return defaultValue;
            }
        }

        public float getFloat(@NonNull String name, float defaultValue) {
            Objects.requireNonNull(name);
            String value = this.mMap.get(name);
            if (value == null) {
                return defaultValue;
            }
            try {
                return Float.parseFloat(value);
            }
            catch (NumberFormatException e) {
                Slog.e(DeviceConfig.TAG, "Parsing float failed for " + name);
                return defaultValue;
            }
        }

        @NonNull
        public Map<String, String> getPropertyValues() {
            return Collections.unmodifiableMap(this.mMap);
        }

        public static class Builder {
            @NonNull
            private final String mNamespace;
            @NonNull
            private final Map<String, String> mKeyValues = new HashMap<String, String>();

            public Builder(@NonNull String namespace) {
                this.mNamespace = namespace;
            }

            @NonNull
            public Builder setString(@NonNull String name, @Nullable String value) {
                this.mKeyValues.put(name, value);
                return this;
            }

            @NonNull
            public Builder setBoolean(@NonNull String name, boolean value) {
                this.mKeyValues.put(name, Boolean.toString(value));
                return this;
            }

            @NonNull
            public Builder setInt(@NonNull String name, int value) {
                this.mKeyValues.put(name, Integer.toString(value));
                return this;
            }

            @NonNull
            public Builder setLong(@NonNull String name, long value) {
                this.mKeyValues.put(name, Long.toString(value));
                return this;
            }

            @NonNull
            public Builder setFloat(@NonNull String name, float value) {
                this.mKeyValues.put(name, Float.toString(value));
                return this;
            }

            @NonNull
            public Properties build() {
                return new Properties(this.mNamespace, this.mKeyValues);
            }
        }
    }

    @SystemApi
    public static interface OnPropertiesChangedListener {
        public void onPropertiesChanged(@NonNull Properties var1);
    }

    @SystemApi
    public static interface MonitorCallback {
        @SystemApi
        public void onNamespaceUpdate(@NonNull String var1);

        @SystemApi
        public void onDeviceConfigAccess(@NonNull String var1, @NonNull String var2);
    }

    @SystemApi
    public static class BadConfigException
    extends Exception {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    @Target(value={ElementType.TYPE_PARAMETER, ElementType.TYPE_USE})
    public static @interface SyncDisabledMode {
    }
}

