/*
 * Decompiled with CFR 0.152.
 */
package android.provider;

import android.annotation.FlaggedApi;
import android.annotation.NonNull;
import android.annotation.RequiresPermission;
import android.annotation.SystemApi;
import android.content.Context;
import android.os.Bundle;
import android.provider.BlockedNumberContract;
import android.telecom.Log;

@SystemApi
@FlaggedApi(value="com.android.server.telecom.flags.telecom_mainline_blocked_numbers_manager")
public class BlockedNumbersManager {
    private static final String LOG_TAG = BlockedNumbersManager.class.getSimpleName();
    private Context mContext;
    @SystemApi
    @FlaggedApi(value="com.android.server.telecom.flags.telecom_mainline_blocked_numbers_manager")
    public static final String ACTION_BLOCK_SUPPRESSION_STATE_CHANGED = "android.provider.action.BLOCK_SUPPRESSION_STATE_CHANGED";
    @SystemApi
    @FlaggedApi(value="com.android.server.telecom.flags.telecom_mainline_blocked_numbers_manager")
    public static final String ENHANCED_SETTING_KEY_BLOCK_UNREGISTERED = "block_numbers_not_in_contacts_setting";
    @SystemApi
    @FlaggedApi(value="com.android.server.telecom.flags.telecom_mainline_blocked_numbers_manager")
    public static final String ENHANCED_SETTING_KEY_BLOCK_PRIVATE = "block_private_number_calls_setting";
    @SystemApi
    @FlaggedApi(value="com.android.server.telecom.flags.telecom_mainline_blocked_numbers_manager")
    public static final String ENHANCED_SETTING_KEY_BLOCK_PAYPHONE = "block_payphone_calls_setting";
    @SystemApi
    @FlaggedApi(value="com.android.server.telecom.flags.telecom_mainline_blocked_numbers_manager")
    public static final String ENHANCED_SETTING_KEY_BLOCK_UNKNOWN = "block_unknown_calls_setting";
    @SystemApi
    @FlaggedApi(value="com.android.server.telecom.flags.telecom_mainline_blocked_numbers_manager")
    public static final String ENHANCED_SETTING_KEY_SHOW_EMERGENCY_CALL_NOTIFICATION = "show_emergency_call_notification";
    @SystemApi
    @FlaggedApi(value="com.android.server.telecom.flags.telecom_mainline_blocked_numbers_manager")
    public static final String ENHANCED_SETTING_KEY_BLOCK_UNAVAILABLE = "block_unavailable_calls_setting";

    public BlockedNumbersManager(Context context) {
        this.mContext = context;
    }

    @SystemApi
    @RequiresPermission(allOf={"android.permission.READ_BLOCKED_NUMBERS", "android.permission.WRITE_BLOCKED_NUMBERS"})
    @FlaggedApi(value="com.android.server.telecom.flags.telecom_mainline_blocked_numbers_manager")
    public void notifyEmergencyContact() {
        this.verifyBlockedNumbersPermission();
        try {
            Log.i(LOG_TAG, "notifyEmergencyContact; caller=%s", this.mContext.getOpPackageName());
            this.mContext.getContentResolver().call(BlockedNumberContract.AUTHORITY_URI, "notify_emergency_contact", null, null);
        }
        catch (IllegalArgumentException | NullPointerException ex) {
            Log.w(null, "notifyEmergencyContact: provider not ready.", new Object[0]);
        }
    }

    @SystemApi
    @RequiresPermission(allOf={"android.permission.READ_BLOCKED_NUMBERS", "android.permission.WRITE_BLOCKED_NUMBERS"})
    @FlaggedApi(value="com.android.server.telecom.flags.telecom_mainline_blocked_numbers_manager")
    public void endBlockSuppression() {
        this.verifyBlockedNumbersPermission();
        String caller = this.mContext.getOpPackageName();
        Log.i(LOG_TAG, "endBlockSuppression: caller=%s", caller);
        this.mContext.getContentResolver().call(BlockedNumberContract.AUTHORITY_URI, "end_block_suppression", null, null);
    }

    @SystemApi
    @RequiresPermission(allOf={"android.permission.READ_BLOCKED_NUMBERS", "android.permission.WRITE_BLOCKED_NUMBERS"})
    @FlaggedApi(value="com.android.server.telecom.flags.telecom_mainline_blocked_numbers_manager")
    public int shouldSystemBlockNumber(@NonNull String phoneNumber, int numberPresentation, boolean isNumberInContacts) {
        this.verifyBlockedNumbersPermission();
        try {
            String caller = this.mContext.getOpPackageName();
            Bundle extras = new Bundle();
            extras.putInt("extra_call_presentation", numberPresentation);
            extras.putBoolean("extra_contact_exist", isNumberInContacts);
            Bundle res = this.mContext.getContentResolver().call(BlockedNumberContract.AUTHORITY_URI, "should_system_block_number", phoneNumber, extras);
            int blockResult = res != null ? res.getInt("block_status", 0) : 0;
            Log.d(LOG_TAG, "shouldSystemBlockNumber: number=%s, caller=%s, result=%s", Log.piiHandle(phoneNumber), caller, BlockedNumberContract.SystemContract.blockStatusToString(blockResult));
            return blockResult;
        }
        catch (IllegalArgumentException | NullPointerException ex) {
            Log.w(null, "shouldSystemBlockNumber: provider not ready.", new Object[0]);
            return 0;
        }
    }

    @SystemApi
    @RequiresPermission(allOf={"android.permission.READ_BLOCKED_NUMBERS", "android.permission.WRITE_BLOCKED_NUMBERS"})
    @FlaggedApi(value="com.android.server.telecom.flags.telecom_mainline_blocked_numbers_manager")
    @NonNull
    public BlockSuppressionStatus getBlockSuppressionStatus() {
        this.verifyBlockedNumbersPermission();
        Bundle res = this.mContext.getContentResolver().call(BlockedNumberContract.AUTHORITY_URI, "get_block_suppression_status", null, null);
        BlockSuppressionStatus blockSuppressionStatus = new BlockSuppressionStatus(res.getBoolean("blocking_suppressed", false), res.getLong("blocking_suppressed_until_timestamp", 0L));
        Log.d(LOG_TAG, "getBlockSuppressionStatus: caller=%s, status=%s", this.mContext.getOpPackageName(), blockSuppressionStatus);
        return blockSuppressionStatus;
    }

    @SystemApi
    @RequiresPermission(allOf={"android.permission.READ_BLOCKED_NUMBERS", "android.permission.WRITE_BLOCKED_NUMBERS"})
    @FlaggedApi(value="com.android.server.telecom.flags.telecom_mainline_blocked_numbers_manager")
    public boolean shouldShowEmergencyCallNotification() {
        this.verifyBlockedNumbersPermission();
        try {
            Bundle res = this.mContext.getContentResolver().call(BlockedNumberContract.AUTHORITY_URI, "should_show_emergency_call_notification", null, null);
            return res != null && res.getBoolean(ENHANCED_SETTING_KEY_SHOW_EMERGENCY_CALL_NOTIFICATION, false);
        }
        catch (IllegalArgumentException | NullPointerException ex) {
            Log.w(null, "shouldShowEmergencyCallNotification: provider not ready.", new Object[0]);
            return false;
        }
    }

    @SystemApi
    @RequiresPermission(allOf={"android.permission.READ_BLOCKED_NUMBERS", "android.permission.WRITE_BLOCKED_NUMBERS"})
    @FlaggedApi(value="com.android.server.telecom.flags.telecom_mainline_blocked_numbers_manager")
    public boolean getBlockedNumberSetting(@NonNull String key) {
        this.verifyBlockedNumbersPermission();
        Bundle extras = new Bundle();
        extras.putString("extra_enhanced_setting_key", key);
        try {
            Bundle res = this.mContext.getContentResolver().call(BlockedNumberContract.AUTHORITY_URI, "get_enhanced_block_setting", null, extras);
            return res != null && res.getBoolean("enhanced_setting_enabled", false);
        }
        catch (IllegalArgumentException | NullPointerException ex) {
            Log.w(null, "getEnhancedBlockSetting: provider not ready.", new Object[0]);
            return false;
        }
    }

    @SystemApi
    @RequiresPermission(allOf={"android.permission.READ_BLOCKED_NUMBERS", "android.permission.WRITE_BLOCKED_NUMBERS"})
    @FlaggedApi(value="com.android.server.telecom.flags.telecom_mainline_blocked_numbers_manager")
    public void setBlockedNumberSetting(@NonNull String key, boolean value) {
        this.verifyBlockedNumbersPermission();
        Bundle extras = new Bundle();
        extras.putString("extra_enhanced_setting_key", key);
        extras.putBoolean("extra_enhanced_setting_value", value);
        this.mContext.getContentResolver().call(BlockedNumberContract.AUTHORITY_URI, "set_enhanced_block_setting", null, extras);
    }

    private void verifyBlockedNumbersPermission() {
        this.mContext.enforceCallingOrSelfPermission("android.permission.READ_BLOCKED_NUMBERS", "Caller does not have the android.permission.READ_BLOCKED_NUMBERS permission");
        this.mContext.enforceCallingOrSelfPermission("android.permission.WRITE_BLOCKED_NUMBERS", "Caller does not have the android.permission.WRITE_BLOCKED_NUMBERS permission");
    }

    @SystemApi
    @FlaggedApi(value="com.android.server.telecom.flags.telecom_mainline_blocked_numbers_manager")
    public static class BlockSuppressionStatus {
        private boolean mIsSuppressed;
        private long mUntilTimestampMillis;

        BlockSuppressionStatus(boolean isSuppressed, long untilTimestampMillis) {
            this.mIsSuppressed = isSuppressed;
            this.mUntilTimestampMillis = untilTimestampMillis;
        }

        public String toString() {
            return "[BlockSuppressionStatus; isSuppressed=" + this.mIsSuppressed + ", until=" + this.mUntilTimestampMillis + "]";
        }

        public boolean getIsSuppressed() {
            return this.mIsSuppressed;
        }

        public long getUntilTimestampMillis() {
            return this.mUntilTimestampMillis;
        }
    }
}

