/*
 * Decompiled with CFR 0.152.
 */
package android.preference;

import android.annotation.Nullable;
import android.annotation.SystemApi;
import android.app.Activity;
import android.compat.annotation.UnsupportedAppUsage;
import android.content.Context;
import android.content.DialogInterface;
import android.content.Intent;
import android.content.SharedPreferences;
import android.content.pm.ActivityInfo;
import android.content.pm.PackageManager;
import android.content.pm.ResolveInfo;
import android.content.res.XmlResourceParser;
import android.os.Bundle;
import android.preference.Preference;
import android.preference.PreferenceDataStore;
import android.preference.PreferenceFragment;
import android.preference.PreferenceInflater;
import android.preference.PreferenceScreen;
import android.util.Log;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;

@Deprecated
public class PreferenceManager {
    private static final String TAG = "PreferenceManager";
    public static final String METADATA_KEY_PREFERENCES = "android.preference";
    public static final String KEY_HAS_SET_DEFAULT_VALUES = "_has_set_default_values";
    @Nullable
    private Activity mActivity;
    @Nullable
    @UnsupportedAppUsage(maxTargetSdk=28, trackingBug=115609023L)
    private PreferenceFragment mFragment;
    private Context mContext;
    private long mNextId = 0L;
    private int mNextRequestCode;
    @Nullable
    @UnsupportedAppUsage
    private SharedPreferences mSharedPreferences;
    @Nullable
    private PreferenceDataStore mPreferenceDataStore;
    @Nullable
    private SharedPreferences.Editor mEditor;
    private boolean mNoCommit;
    private String mSharedPreferencesName;
    private int mSharedPreferencesMode;
    private static final int STORAGE_DEFAULT = 0;
    private static final int STORAGE_DEVICE_PROTECTED = 1;
    private static final int STORAGE_CREDENTIAL_PROTECTED = 2;
    private int mStorage = 0;
    @Nullable
    private PreferenceScreen mPreferenceScreen;
    @Nullable
    private List<OnActivityResultListener> mActivityResultListeners;
    @Nullable
    private List<OnActivityStopListener> mActivityStopListeners;
    @Nullable
    @UnsupportedAppUsage
    private List<OnActivityDestroyListener> mActivityDestroyListeners;
    @Nullable
    private List<DialogInterface> mPreferencesScreens;
    @UnsupportedAppUsage
    private OnPreferenceTreeClickListener mOnPreferenceTreeClickListener;

    @UnsupportedAppUsage
    public PreferenceManager(Activity activity, int firstRequestCode) {
        this.mActivity = activity;
        this.mNextRequestCode = firstRequestCode;
        this.init(activity);
    }

    @UnsupportedAppUsage
    PreferenceManager(Context context) {
        this.init(context);
    }

    private void init(Context context) {
        this.mContext = context;
        this.setSharedPreferencesName(PreferenceManager.getDefaultSharedPreferencesName(context));
    }

    @UnsupportedAppUsage(maxTargetSdk=28, trackingBug=115609023L)
    void setFragment(PreferenceFragment fragment) {
        this.mFragment = fragment;
    }

    @Nullable
    @UnsupportedAppUsage
    PreferenceFragment getFragment() {
        return this.mFragment;
    }

    public void setPreferenceDataStore(PreferenceDataStore dataStore) {
        this.mPreferenceDataStore = dataStore;
    }

    @Nullable
    public PreferenceDataStore getPreferenceDataStore() {
        return this.mPreferenceDataStore;
    }

    private List<ResolveInfo> queryIntentActivities(Intent queryIntent) {
        return this.mContext.getPackageManager().queryIntentActivities(queryIntent, 128);
    }

    @UnsupportedAppUsage
    PreferenceScreen inflateFromIntent(Intent queryIntent, PreferenceScreen rootPreferences) {
        List<ResolveInfo> activities = this.queryIntentActivities(queryIntent);
        HashSet<String> inflatedRes = new HashSet<String>();
        for (int i = activities.size() - 1; i >= 0; --i) {
            Context context;
            String uniqueResId;
            ActivityInfo activityInfo = activities.get((int)i).activityInfo;
            Bundle metaData = activityInfo.metaData;
            if (metaData == null || !metaData.containsKey(METADATA_KEY_PREFERENCES) || inflatedRes.contains(uniqueResId = activityInfo.packageName + ":" + activityInfo.metaData.getInt(METADATA_KEY_PREFERENCES))) continue;
            inflatedRes.add(uniqueResId);
            try {
                context = this.mContext.createPackageContext(activityInfo.packageName, 0);
            }
            catch (PackageManager.NameNotFoundException e) {
                Log.w(TAG, "Could not create context for " + activityInfo.packageName + ": " + Log.getStackTraceString(e));
                continue;
            }
            PreferenceInflater inflater = new PreferenceInflater(context, this);
            XmlResourceParser parser = activityInfo.loadXmlMetaData(context.getPackageManager(), METADATA_KEY_PREFERENCES);
            rootPreferences = (PreferenceScreen)inflater.inflate(parser, rootPreferences, true);
            parser.close();
        }
        rootPreferences.onAttachedToHierarchy(this);
        return rootPreferences;
    }

    @UnsupportedAppUsage
    public PreferenceScreen inflateFromResource(Context context, int resId, PreferenceScreen rootPreferences) {
        this.setNoCommit(true);
        PreferenceInflater inflater = new PreferenceInflater(context, this);
        rootPreferences = (PreferenceScreen)inflater.inflate(resId, rootPreferences, true);
        rootPreferences.onAttachedToHierarchy(this);
        this.setNoCommit(false);
        return rootPreferences;
    }

    public PreferenceScreen createPreferenceScreen(Context context) {
        PreferenceScreen preferenceScreen = new PreferenceScreen(context, null);
        preferenceScreen.onAttachedToHierarchy(this);
        return preferenceScreen;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    long getNextId() {
        PreferenceManager preferenceManager = this;
        synchronized (preferenceManager) {
            return this.mNextId++;
        }
    }

    public String getSharedPreferencesName() {
        return this.mSharedPreferencesName;
    }

    public void setSharedPreferencesName(String sharedPreferencesName) {
        this.mSharedPreferencesName = sharedPreferencesName;
        this.mSharedPreferences = null;
    }

    public int getSharedPreferencesMode() {
        return this.mSharedPreferencesMode;
    }

    public void setSharedPreferencesMode(int sharedPreferencesMode) {
        this.mSharedPreferencesMode = sharedPreferencesMode;
        this.mSharedPreferences = null;
    }

    public void setStorageDefault() {
        this.mStorage = 0;
        this.mSharedPreferences = null;
    }

    public void setStorageDeviceProtected() {
        this.mStorage = 1;
        this.mSharedPreferences = null;
    }

    @SystemApi
    public void setStorageCredentialProtected() {
        this.mStorage = 2;
        this.mSharedPreferences = null;
    }

    public boolean isStorageDefault() {
        return this.mStorage == 0;
    }

    public boolean isStorageDeviceProtected() {
        return this.mStorage == 1;
    }

    @SystemApi
    public boolean isStorageCredentialProtected() {
        return this.mStorage == 2;
    }

    public SharedPreferences getSharedPreferences() {
        if (this.mPreferenceDataStore != null) {
            return null;
        }
        if (this.mSharedPreferences == null) {
            Context storageContext;
            switch (this.mStorage) {
                case 1: {
                    storageContext = this.mContext.createDeviceProtectedStorageContext();
                    break;
                }
                case 2: {
                    storageContext = this.mContext.createCredentialProtectedStorageContext();
                    break;
                }
                default: {
                    storageContext = this.mContext;
                }
            }
            this.mSharedPreferences = storageContext.getSharedPreferences(this.mSharedPreferencesName, this.mSharedPreferencesMode);
        }
        return this.mSharedPreferences;
    }

    public static SharedPreferences getDefaultSharedPreferences(Context context) {
        return context.getSharedPreferences(PreferenceManager.getDefaultSharedPreferencesName(context), PreferenceManager.getDefaultSharedPreferencesMode());
    }

    public static String getDefaultSharedPreferencesName(Context context) {
        return context.getPackageName() + "_preferences";
    }

    private static int getDefaultSharedPreferencesMode() {
        return 0;
    }

    @Nullable
    @UnsupportedAppUsage
    PreferenceScreen getPreferenceScreen() {
        return this.mPreferenceScreen;
    }

    @UnsupportedAppUsage
    boolean setPreferences(PreferenceScreen preferenceScreen) {
        if (preferenceScreen != this.mPreferenceScreen) {
            this.mPreferenceScreen = preferenceScreen;
            return true;
        }
        return false;
    }

    @Nullable
    public Preference findPreference(CharSequence key) {
        if (this.mPreferenceScreen == null) {
            return null;
        }
        return this.mPreferenceScreen.findPreference(key);
    }

    public static void setDefaultValues(Context context, int resId, boolean readAgain) {
        PreferenceManager.setDefaultValues(context, PreferenceManager.getDefaultSharedPreferencesName(context), PreferenceManager.getDefaultSharedPreferencesMode(), resId, readAgain);
    }

    public static void setDefaultValues(Context context, String sharedPreferencesName, int sharedPreferencesMode, int resId, boolean readAgain) {
        SharedPreferences defaultValueSp = context.getSharedPreferences(KEY_HAS_SET_DEFAULT_VALUES, 0);
        if (readAgain || !defaultValueSp.getBoolean(KEY_HAS_SET_DEFAULT_VALUES, false)) {
            PreferenceManager pm = new PreferenceManager(context);
            pm.setSharedPreferencesName(sharedPreferencesName);
            pm.setSharedPreferencesMode(sharedPreferencesMode);
            pm.inflateFromResource(context, resId, null);
            SharedPreferences.Editor editor = defaultValueSp.edit().putBoolean(KEY_HAS_SET_DEFAULT_VALUES, true);
            try {
                editor.apply();
            }
            catch (AbstractMethodError unused) {
                editor.commit();
            }
        }
    }

    @UnsupportedAppUsage
    SharedPreferences.Editor getEditor() {
        if (this.mPreferenceDataStore != null) {
            return null;
        }
        if (this.mNoCommit) {
            if (this.mEditor == null) {
                this.mEditor = this.getSharedPreferences().edit();
            }
            return this.mEditor;
        }
        return this.getSharedPreferences().edit();
    }

    @UnsupportedAppUsage
    boolean shouldCommit() {
        return !this.mNoCommit;
    }

    @UnsupportedAppUsage
    private void setNoCommit(boolean noCommit) {
        if (!noCommit && this.mEditor != null) {
            try {
                this.mEditor.apply();
            }
            catch (AbstractMethodError unused) {
                this.mEditor.commit();
            }
        }
        this.mNoCommit = noCommit;
    }

    @Nullable
    @UnsupportedAppUsage
    Activity getActivity() {
        return this.mActivity;
    }

    Context getContext() {
        return this.mContext;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @UnsupportedAppUsage
    void registerOnActivityResultListener(OnActivityResultListener listener) {
        PreferenceManager preferenceManager = this;
        synchronized (preferenceManager) {
            if (this.mActivityResultListeners == null) {
                this.mActivityResultListeners = new ArrayList<OnActivityResultListener>();
            }
            if (!this.mActivityResultListeners.contains(listener)) {
                this.mActivityResultListeners.add(listener);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @UnsupportedAppUsage
    void unregisterOnActivityResultListener(OnActivityResultListener listener) {
        PreferenceManager preferenceManager = this;
        synchronized (preferenceManager) {
            if (this.mActivityResultListeners != null) {
                this.mActivityResultListeners.remove(listener);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @UnsupportedAppUsage
    void dispatchActivityResult(int requestCode, int resultCode, Intent data) {
        ArrayList<OnActivityResultListener> list;
        PreferenceManager preferenceManager = this;
        synchronized (preferenceManager) {
            if (this.mActivityResultListeners == null) {
                return;
            }
            list = new ArrayList<OnActivityResultListener>(this.mActivityResultListeners);
        }
        int N2 = list.size();
        for (int i = 0; i < N2 && !((OnActivityResultListener)list.get(i)).onActivityResult(requestCode, resultCode, data); ++i) {
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @UnsupportedAppUsage
    public void registerOnActivityStopListener(OnActivityStopListener listener) {
        PreferenceManager preferenceManager = this;
        synchronized (preferenceManager) {
            if (this.mActivityStopListeners == null) {
                this.mActivityStopListeners = new ArrayList<OnActivityStopListener>();
            }
            if (!this.mActivityStopListeners.contains(listener)) {
                this.mActivityStopListeners.add(listener);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @UnsupportedAppUsage
    public void unregisterOnActivityStopListener(OnActivityStopListener listener) {
        PreferenceManager preferenceManager = this;
        synchronized (preferenceManager) {
            if (this.mActivityStopListeners != null) {
                this.mActivityStopListeners.remove(listener);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @UnsupportedAppUsage
    void dispatchActivityStop() {
        ArrayList<OnActivityStopListener> list;
        PreferenceManager preferenceManager = this;
        synchronized (preferenceManager) {
            if (this.mActivityStopListeners == null) {
                return;
            }
            list = new ArrayList<OnActivityStopListener>(this.mActivityStopListeners);
        }
        int N2 = list.size();
        for (int i = 0; i < N2; ++i) {
            ((OnActivityStopListener)list.get(i)).onActivityStop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @UnsupportedAppUsage
    void registerOnActivityDestroyListener(OnActivityDestroyListener listener) {
        PreferenceManager preferenceManager = this;
        synchronized (preferenceManager) {
            if (this.mActivityDestroyListeners == null) {
                this.mActivityDestroyListeners = new ArrayList<OnActivityDestroyListener>();
            }
            if (!this.mActivityDestroyListeners.contains(listener)) {
                this.mActivityDestroyListeners.add(listener);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @UnsupportedAppUsage
    void unregisterOnActivityDestroyListener(OnActivityDestroyListener listener) {
        PreferenceManager preferenceManager = this;
        synchronized (preferenceManager) {
            if (this.mActivityDestroyListeners != null) {
                this.mActivityDestroyListeners.remove(listener);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @UnsupportedAppUsage
    void dispatchActivityDestroy() {
        ArrayList<OnActivityDestroyListener> list = null;
        PreferenceManager preferenceManager = this;
        synchronized (preferenceManager) {
            if (this.mActivityDestroyListeners != null) {
                list = new ArrayList<OnActivityDestroyListener>(this.mActivityDestroyListeners);
            }
        }
        if (list != null) {
            int N2 = list.size();
            for (int i = 0; i < N2; ++i) {
                ((OnActivityDestroyListener)list.get(i)).onActivityDestroy();
            }
        }
        this.dismissAllScreens();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @UnsupportedAppUsage
    int getNextRequestCode() {
        PreferenceManager preferenceManager = this;
        synchronized (preferenceManager) {
            return this.mNextRequestCode++;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addPreferencesScreen(DialogInterface screen) {
        PreferenceManager preferenceManager = this;
        synchronized (preferenceManager) {
            if (this.mPreferencesScreens == null) {
                this.mPreferencesScreens = new ArrayList<DialogInterface>();
            }
            this.mPreferencesScreens.add(screen);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void removePreferencesScreen(DialogInterface screen) {
        PreferenceManager preferenceManager = this;
        synchronized (preferenceManager) {
            if (this.mPreferencesScreens == null) {
                return;
            }
            this.mPreferencesScreens.remove(screen);
        }
    }

    void dispatchNewIntent(Intent intent) {
        this.dismissAllScreens();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void dismissAllScreens() {
        ArrayList<DialogInterface> screensToDismiss;
        PreferenceManager preferenceManager = this;
        synchronized (preferenceManager) {
            if (this.mPreferencesScreens == null) {
                return;
            }
            screensToDismiss = new ArrayList<DialogInterface>(this.mPreferencesScreens);
            this.mPreferencesScreens.clear();
        }
        for (int i = screensToDismiss.size() - 1; i >= 0; --i) {
            screensToDismiss.get(i).dismiss();
        }
    }

    void setOnPreferenceTreeClickListener(OnPreferenceTreeClickListener listener) {
        this.mOnPreferenceTreeClickListener = listener;
    }

    @Nullable
    OnPreferenceTreeClickListener getOnPreferenceTreeClickListener() {
        return this.mOnPreferenceTreeClickListener;
    }

    @Deprecated
    public static interface OnActivityResultListener {
        public boolean onActivityResult(int var1, int var2, Intent var3);
    }

    @Deprecated
    public static interface OnActivityStopListener {
        public void onActivityStop();
    }

    @Deprecated
    public static interface OnActivityDestroyListener {
        public void onActivityDestroy();
    }

    @Deprecated
    public static interface OnPreferenceTreeClickListener {
        public boolean onPreferenceTreeClick(PreferenceScreen var1, Preference var2);
    }
}

