/*
 * Decompiled with CFR 0.152.
 */
package android.os.vibrator.persistence;

import android.annotation.FlaggedApi;
import android.annotation.NonNull;
import android.annotation.Nullable;
import android.annotation.SystemApi;
import android.os.VibrationEffect;
import android.os.Vibrator;
import android.os.VibratorInfo;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

@SystemApi
@FlaggedApi(value="android.os.vibrator.vibration_xml_apis")
public class ParsedVibration {
    private final ArrayList<VibrationEffect> mEffects;

    public ParsedVibration(@NonNull List<VibrationEffect> effects) {
        this.mEffects = new ArrayList<VibrationEffect>(effects);
    }

    public ParsedVibration(@NonNull VibrationEffect effect) {
        this.mEffects = new ArrayList(1);
        this.mEffects.add(effect);
    }

    @SystemApi
    @FlaggedApi(value="android.os.vibrator.vibration_xml_apis")
    @Nullable
    public VibrationEffect resolve(@NonNull Vibrator vibrator) {
        return this.resolve(vibrator.getInfo());
    }

    @Nullable
    public VibrationEffect resolve(@NonNull VibratorInfo info) {
        for (int i = 0; i < this.mEffects.size(); ++i) {
            VibrationEffect effect = this.mEffects.get(i);
            if (!info.areVibrationFeaturesSupported(effect)) continue;
            return effect;
        }
        return null;
    }

    public boolean equals(@Nullable Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ParsedVibration)) {
            return false;
        }
        ParsedVibration other = (ParsedVibration)o;
        return this.mEffects.equals(other.mEffects);
    }

    public int hashCode() {
        return Objects.hashCode(this.mEffects);
    }

    public String toString() {
        return "ParsedVibration{effects=" + this.mEffects + '}';
    }
}

