/*
 * Decompiled with CFR 0.152.
 */
package android.os.vibrator;

import android.annotation.FlaggedApi;
import android.annotation.NonNull;
import android.os.Parcel;
import android.os.Parcelable;
import java.util.Objects;

@FlaggedApi(value="android.os.vibrator.normalized_pwle_effects")
public class VibratorEnvelopeEffectInfo
implements Parcelable {
    private final int mMaxSize;
    private final long mMinControlPointDurationMillis;
    private final long mMaxControlPointDurationMillis;
    @NonNull
    public static final Parcelable.Creator<VibratorEnvelopeEffectInfo> CREATOR = new Parcelable.Creator<VibratorEnvelopeEffectInfo>(){

        @Override
        public VibratorEnvelopeEffectInfo createFromParcel(Parcel in) {
            return new VibratorEnvelopeEffectInfo(in);
        }

        public VibratorEnvelopeEffectInfo[] newArray(int size) {
            return new VibratorEnvelopeEffectInfo[size];
        }
    };

    VibratorEnvelopeEffectInfo(Parcel in) {
        this.mMaxSize = in.readInt();
        this.mMinControlPointDurationMillis = in.readLong();
        this.mMaxControlPointDurationMillis = in.readLong();
    }

    public VibratorEnvelopeEffectInfo(int maxSize, long minControlPointDurationMillis, long maxControlPointDurationMillis) {
        this.mMaxSize = maxSize;
        this.mMinControlPointDurationMillis = minControlPointDurationMillis;
        this.mMaxControlPointDurationMillis = maxControlPointDurationMillis;
    }

    @Override
    public void writeToParcel(@NonNull Parcel dest, int flags) {
        dest.writeInt(this.mMaxSize);
        dest.writeLong(this.mMinControlPointDurationMillis);
        dest.writeLong(this.mMaxControlPointDurationMillis);
    }

    @Override
    public int describeContents() {
        return 0;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof VibratorEnvelopeEffectInfo)) {
            return false;
        }
        VibratorEnvelopeEffectInfo other = (VibratorEnvelopeEffectInfo)o;
        return this.mMaxSize == other.mMaxSize && this.mMinControlPointDurationMillis == other.mMinControlPointDurationMillis && this.mMaxControlPointDurationMillis == other.mMaxControlPointDurationMillis;
    }

    public int hashCode() {
        return Objects.hash(this.mMaxSize, this.mMinControlPointDurationMillis, this.mMaxControlPointDurationMillis);
    }

    public String toString() {
        return "VibratorEnvelopeEffectInfo{, mMaxSize=" + this.mMaxSize + ", mMinControlPointDurationMillis=" + this.mMinControlPointDurationMillis + ", mMaxControlPointDurationMillis=" + this.mMaxControlPointDurationMillis + '}';
    }

    public long getMaxDurationMillis() {
        return (long)this.mMaxSize * this.mMaxControlPointDurationMillis;
    }

    public int getMaxSize() {
        return this.mMaxSize;
    }

    public long getMinControlPointDurationMillis() {
        return this.mMinControlPointDurationMillis;
    }

    public long getMaxControlPointDurationMillis() {
        return this.mMaxControlPointDurationMillis;
    }
}

