/*
 * Decompiled with CFR 0.152.
 */
package android.os.image;

import android.annotation.EnforcePermission;
import android.annotation.RequiresNoPermission;
import android.app.ActivityThread;
import android.gsi.AvbPublicKey;
import android.gsi.GsiProgress;
import android.os.Binder;
import android.os.IBinder;
import android.os.IInterface;
import android.os.Parcel;
import android.os.ParcelFileDescriptor;
import android.os.PermissionEnforcer;
import android.os.RemoteException;

public interface IDynamicSystemService
extends IInterface {
    public static final String DESCRIPTOR = "android.os.image.IDynamicSystemService";

    @EnforcePermission(value="android.permission.MANAGE_DYNAMIC_SYSTEM")
    public boolean startInstallation(String var1) throws RemoteException;

    @EnforcePermission(value="android.permission.MANAGE_DYNAMIC_SYSTEM")
    public int createPartition(String var1, long var2, boolean var4) throws RemoteException;

    @EnforcePermission(value="android.permission.MANAGE_DYNAMIC_SYSTEM")
    public boolean closePartition() throws RemoteException;

    @EnforcePermission(value="android.permission.MANAGE_DYNAMIC_SYSTEM")
    public boolean finishInstallation() throws RemoteException;

    @EnforcePermission(value="android.permission.MANAGE_DYNAMIC_SYSTEM")
    public GsiProgress getInstallationProgress() throws RemoteException;

    @EnforcePermission(value="android.permission.MANAGE_DYNAMIC_SYSTEM")
    public boolean abort() throws RemoteException;

    @RequiresNoPermission
    public boolean isInUse() throws RemoteException;

    @RequiresNoPermission
    public boolean isInstalled() throws RemoteException;

    @EnforcePermission(value="android.permission.MANAGE_DYNAMIC_SYSTEM")
    public boolean isEnabled() throws RemoteException;

    @EnforcePermission(value="android.permission.MANAGE_DYNAMIC_SYSTEM")
    public boolean remove() throws RemoteException;

    @EnforcePermission(value="android.permission.MANAGE_DYNAMIC_SYSTEM")
    public boolean setEnable(boolean var1, boolean var2) throws RemoteException;

    @EnforcePermission(value="android.permission.MANAGE_DYNAMIC_SYSTEM")
    public boolean setAshmem(ParcelFileDescriptor var1, long var2) throws RemoteException;

    @EnforcePermission(value="android.permission.MANAGE_DYNAMIC_SYSTEM")
    public boolean submitFromAshmem(long var1) throws RemoteException;

    @EnforcePermission(value="android.permission.MANAGE_DYNAMIC_SYSTEM")
    public boolean getAvbPublicKey(AvbPublicKey var1) throws RemoteException;

    @EnforcePermission(value="android.permission.MANAGE_DYNAMIC_SYSTEM")
    public long suggestScratchSize() throws RemoteException;

    @EnforcePermission(value="android.permission.MANAGE_DYNAMIC_SYSTEM")
    public String getActiveDsuSlot() throws RemoteException;

    public static abstract class Stub
    extends Binder
    implements IDynamicSystemService {
        private final PermissionEnforcer mEnforcer;
        static final int TRANSACTION_startInstallation = 1;
        static final int TRANSACTION_createPartition = 2;
        static final int TRANSACTION_closePartition = 3;
        static final int TRANSACTION_finishInstallation = 4;
        static final int TRANSACTION_getInstallationProgress = 5;
        static final int TRANSACTION_abort = 6;
        static final int TRANSACTION_isInUse = 7;
        static final int TRANSACTION_isInstalled = 8;
        static final int TRANSACTION_isEnabled = 9;
        static final int TRANSACTION_remove = 10;
        static final int TRANSACTION_setEnable = 11;
        static final int TRANSACTION_setAshmem = 12;
        static final int TRANSACTION_submitFromAshmem = 13;
        static final int TRANSACTION_getAvbPublicKey = 14;
        static final int TRANSACTION_suggestScratchSize = 15;
        static final int TRANSACTION_getActiveDsuSlot = 16;

        public Stub(PermissionEnforcer enforcer) {
            this.attachInterface(this, IDynamicSystemService.DESCRIPTOR);
            if (enforcer == null) {
                throw new IllegalArgumentException("enforcer cannot be null");
            }
            this.mEnforcer = enforcer;
        }

        @Deprecated
        public Stub() {
            this(PermissionEnforcer.fromContext(ActivityThread.currentSystemContext()));
        }

        public static IDynamicSystemService asInterface(IBinder obj) {
            if (obj == null) {
                return null;
            }
            IInterface iin = obj.queryLocalInterface(IDynamicSystemService.DESCRIPTOR);
            if (iin != null && iin instanceof IDynamicSystemService) {
                return (IDynamicSystemService)iin;
            }
            return new Proxy(obj);
        }

        @Override
        public IBinder asBinder() {
            return this;
        }

        public static String getDefaultTransactionName(int transactionCode) {
            switch (transactionCode) {
                case 1: {
                    return "startInstallation";
                }
                case 2: {
                    return "createPartition";
                }
                case 3: {
                    return "closePartition";
                }
                case 4: {
                    return "finishInstallation";
                }
                case 5: {
                    return "getInstallationProgress";
                }
                case 6: {
                    return "abort";
                }
                case 7: {
                    return "isInUse";
                }
                case 8: {
                    return "isInstalled";
                }
                case 9: {
                    return "isEnabled";
                }
                case 10: {
                    return "remove";
                }
                case 11: {
                    return "setEnable";
                }
                case 12: {
                    return "setAshmem";
                }
                case 13: {
                    return "submitFromAshmem";
                }
                case 14: {
                    return "getAvbPublicKey";
                }
                case 15: {
                    return "suggestScratchSize";
                }
                case 16: {
                    return "getActiveDsuSlot";
                }
            }
            return null;
        }

        @Override
        public String getTransactionName(int transactionCode) {
            return Stub.getDefaultTransactionName(transactionCode);
        }

        @Override
        public boolean onTransact(int code, Parcel data, Parcel reply, int flags) throws RemoteException {
            String descriptor = IDynamicSystemService.DESCRIPTOR;
            if (code >= 1 && code <= 0xFFFFFF) {
                data.enforceInterface(descriptor);
            }
            if (code == 1598968902) {
                reply.writeString(descriptor);
                return true;
            }
            switch (code) {
                case 1: {
                    String _arg0 = data.readString();
                    data.enforceNoDataAvail();
                    boolean _result = this.startInstallation(_arg0);
                    reply.writeNoException();
                    reply.writeBoolean(_result);
                    break;
                }
                case 2: {
                    String _arg0 = data.readString();
                    long _arg1 = data.readLong();
                    boolean _arg2 = data.readBoolean();
                    data.enforceNoDataAvail();
                    int _result = this.createPartition(_arg0, _arg1, _arg2);
                    reply.writeNoException();
                    reply.writeInt(_result);
                    break;
                }
                case 3: {
                    boolean _result = this.closePartition();
                    reply.writeNoException();
                    reply.writeBoolean(_result);
                    break;
                }
                case 4: {
                    boolean _result = this.finishInstallation();
                    reply.writeNoException();
                    reply.writeBoolean(_result);
                    break;
                }
                case 5: {
                    GsiProgress _result = this.getInstallationProgress();
                    reply.writeNoException();
                    reply.writeTypedObject(_result, 1);
                    break;
                }
                case 6: {
                    boolean _result = this.abort();
                    reply.writeNoException();
                    reply.writeBoolean(_result);
                    break;
                }
                case 7: {
                    boolean _result = this.isInUse();
                    reply.writeNoException();
                    reply.writeBoolean(_result);
                    break;
                }
                case 8: {
                    boolean _result = this.isInstalled();
                    reply.writeNoException();
                    reply.writeBoolean(_result);
                    break;
                }
                case 9: {
                    boolean _result = this.isEnabled();
                    reply.writeNoException();
                    reply.writeBoolean(_result);
                    break;
                }
                case 10: {
                    boolean _result = this.remove();
                    reply.writeNoException();
                    reply.writeBoolean(_result);
                    break;
                }
                case 11: {
                    boolean _arg0 = data.readBoolean();
                    boolean _arg1 = data.readBoolean();
                    data.enforceNoDataAvail();
                    boolean _result = this.setEnable(_arg0, _arg1);
                    reply.writeNoException();
                    reply.writeBoolean(_result);
                    break;
                }
                case 12: {
                    ParcelFileDescriptor _arg0 = data.readTypedObject(ParcelFileDescriptor.CREATOR);
                    long _arg1 = data.readLong();
                    data.enforceNoDataAvail();
                    boolean _result = this.setAshmem(_arg0, _arg1);
                    reply.writeNoException();
                    reply.writeBoolean(_result);
                    break;
                }
                case 13: {
                    long _arg0 = data.readLong();
                    data.enforceNoDataAvail();
                    boolean _result = this.submitFromAshmem(_arg0);
                    reply.writeNoException();
                    reply.writeBoolean(_result);
                    break;
                }
                case 14: {
                    AvbPublicKey _arg0 = new AvbPublicKey();
                    data.enforceNoDataAvail();
                    boolean _result = this.getAvbPublicKey(_arg0);
                    reply.writeNoException();
                    reply.writeBoolean(_result);
                    reply.writeTypedObject(_arg0, 1);
                    break;
                }
                case 15: {
                    long _result = this.suggestScratchSize();
                    reply.writeNoException();
                    reply.writeLong(_result);
                    break;
                }
                case 16: {
                    String _result = this.getActiveDsuSlot();
                    reply.writeNoException();
                    reply.writeString(_result);
                    break;
                }
                default: {
                    return super.onTransact(code, data, reply, flags);
                }
            }
            return true;
        }

        protected void startInstallation_enforcePermission() throws SecurityException {
            this.mEnforcer.enforcePermission("android.permission.MANAGE_DYNAMIC_SYSTEM", Stub.getCallingPid(), Stub.getCallingUid());
        }

        protected void createPartition_enforcePermission() throws SecurityException {
            this.mEnforcer.enforcePermission("android.permission.MANAGE_DYNAMIC_SYSTEM", Stub.getCallingPid(), Stub.getCallingUid());
        }

        protected void closePartition_enforcePermission() throws SecurityException {
            this.mEnforcer.enforcePermission("android.permission.MANAGE_DYNAMIC_SYSTEM", Stub.getCallingPid(), Stub.getCallingUid());
        }

        protected void finishInstallation_enforcePermission() throws SecurityException {
            this.mEnforcer.enforcePermission("android.permission.MANAGE_DYNAMIC_SYSTEM", Stub.getCallingPid(), Stub.getCallingUid());
        }

        protected void getInstallationProgress_enforcePermission() throws SecurityException {
            this.mEnforcer.enforcePermission("android.permission.MANAGE_DYNAMIC_SYSTEM", Stub.getCallingPid(), Stub.getCallingUid());
        }

        protected void abort_enforcePermission() throws SecurityException {
            this.mEnforcer.enforcePermission("android.permission.MANAGE_DYNAMIC_SYSTEM", Stub.getCallingPid(), Stub.getCallingUid());
        }

        protected void isEnabled_enforcePermission() throws SecurityException {
            this.mEnforcer.enforcePermission("android.permission.MANAGE_DYNAMIC_SYSTEM", Stub.getCallingPid(), Stub.getCallingUid());
        }

        protected void remove_enforcePermission() throws SecurityException {
            this.mEnforcer.enforcePermission("android.permission.MANAGE_DYNAMIC_SYSTEM", Stub.getCallingPid(), Stub.getCallingUid());
        }

        protected void setEnable_enforcePermission() throws SecurityException {
            this.mEnforcer.enforcePermission("android.permission.MANAGE_DYNAMIC_SYSTEM", Stub.getCallingPid(), Stub.getCallingUid());
        }

        protected void setAshmem_enforcePermission() throws SecurityException {
            this.mEnforcer.enforcePermission("android.permission.MANAGE_DYNAMIC_SYSTEM", Stub.getCallingPid(), Stub.getCallingUid());
        }

        protected void submitFromAshmem_enforcePermission() throws SecurityException {
            this.mEnforcer.enforcePermission("android.permission.MANAGE_DYNAMIC_SYSTEM", Stub.getCallingPid(), Stub.getCallingUid());
        }

        protected void getAvbPublicKey_enforcePermission() throws SecurityException {
            this.mEnforcer.enforcePermission("android.permission.MANAGE_DYNAMIC_SYSTEM", Stub.getCallingPid(), Stub.getCallingUid());
        }

        protected void suggestScratchSize_enforcePermission() throws SecurityException {
            this.mEnforcer.enforcePermission("android.permission.MANAGE_DYNAMIC_SYSTEM", Stub.getCallingPid(), Stub.getCallingUid());
        }

        protected void getActiveDsuSlot_enforcePermission() throws SecurityException {
            this.mEnforcer.enforcePermission("android.permission.MANAGE_DYNAMIC_SYSTEM", Stub.getCallingPid(), Stub.getCallingUid());
        }

        @Override
        public int getMaxTransactionId() {
            return 15;
        }

        private static class Proxy
        implements IDynamicSystemService {
            private IBinder mRemote;

            Proxy(IBinder remote) {
                this.mRemote = remote;
            }

            @Override
            public IBinder asBinder() {
                return this.mRemote;
            }

            public String getInterfaceDescriptor() {
                return IDynamicSystemService.DESCRIPTOR;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean startInstallation(String dsuSlot) throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IDynamicSystemService.DESCRIPTOR);
                    _data.writeString(dsuSlot);
                    boolean _status = this.mRemote.transact(1, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readBoolean();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public int createPartition(String name, long size, boolean readOnly) throws RemoteException {
                int _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IDynamicSystemService.DESCRIPTOR);
                    _data.writeString(name);
                    _data.writeLong(size);
                    _data.writeBoolean(readOnly);
                    boolean _status = this.mRemote.transact(2, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readInt();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean closePartition() throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IDynamicSystemService.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(3, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readBoolean();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean finishInstallation() throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IDynamicSystemService.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(4, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readBoolean();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public GsiProgress getInstallationProgress() throws RemoteException {
                GsiProgress _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IDynamicSystemService.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(5, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readTypedObject(GsiProgress.CREATOR);
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean abort() throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IDynamicSystemService.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(6, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readBoolean();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean isInUse() throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IDynamicSystemService.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(7, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readBoolean();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean isInstalled() throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IDynamicSystemService.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(8, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readBoolean();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean isEnabled() throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IDynamicSystemService.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(9, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readBoolean();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean remove() throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IDynamicSystemService.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(10, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readBoolean();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean setEnable(boolean enable, boolean oneShot) throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IDynamicSystemService.DESCRIPTOR);
                    _data.writeBoolean(enable);
                    _data.writeBoolean(oneShot);
                    boolean _status = this.mRemote.transact(11, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readBoolean();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean setAshmem(ParcelFileDescriptor fd, long size) throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IDynamicSystemService.DESCRIPTOR);
                    _data.writeTypedObject(fd, 0);
                    _data.writeLong(size);
                    boolean _status = this.mRemote.transact(12, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readBoolean();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean submitFromAshmem(long bytes) throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IDynamicSystemService.DESCRIPTOR);
                    _data.writeLong(bytes);
                    boolean _status = this.mRemote.transact(13, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readBoolean();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean getAvbPublicKey(AvbPublicKey dst) throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IDynamicSystemService.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(14, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readBoolean();
                    if (0 != _reply.readInt()) {
                        dst.readFromParcel(_reply);
                    }
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public long suggestScratchSize() throws RemoteException {
                long _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IDynamicSystemService.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(15, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readLong();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public String getActiveDsuSlot() throws RemoteException {
                String _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IDynamicSystemService.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(16, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readString();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }
        }
    }

    public static class Default
    implements IDynamicSystemService {
        @Override
        public boolean startInstallation(String dsuSlot) throws RemoteException {
            return false;
        }

        @Override
        public int createPartition(String name, long size, boolean readOnly) throws RemoteException {
            return 0;
        }

        @Override
        public boolean closePartition() throws RemoteException {
            return false;
        }

        @Override
        public boolean finishInstallation() throws RemoteException {
            return false;
        }

        @Override
        public GsiProgress getInstallationProgress() throws RemoteException {
            return null;
        }

        @Override
        public boolean abort() throws RemoteException {
            return false;
        }

        @Override
        public boolean isInUse() throws RemoteException {
            return false;
        }

        @Override
        public boolean isInstalled() throws RemoteException {
            return false;
        }

        @Override
        public boolean isEnabled() throws RemoteException {
            return false;
        }

        @Override
        public boolean remove() throws RemoteException {
            return false;
        }

        @Override
        public boolean setEnable(boolean enable, boolean oneShot) throws RemoteException {
            return false;
        }

        @Override
        public boolean setAshmem(ParcelFileDescriptor fd, long size) throws RemoteException {
            return false;
        }

        @Override
        public boolean submitFromAshmem(long bytes) throws RemoteException {
            return false;
        }

        @Override
        public boolean getAvbPublicKey(AvbPublicKey dst) throws RemoteException {
            return false;
        }

        @Override
        public long suggestScratchSize() throws RemoteException {
            return 0L;
        }

        @Override
        public String getActiveDsuSlot() throws RemoteException {
            return null;
        }

        @Override
        public IBinder asBinder() {
            return null;
        }
    }
}

