/*
 * Decompiled with CFR 0.152.
 */
package android.os.ext;

import android.annotation.NonNull;
import android.os.SystemProperties;
import android.os.ext.util.SdkLevel;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public class SdkExtensions {
    public static final int AD_SERVICES = 1000000;
    private static final int R_EXTENSION_INT = SystemProperties.getInt("build.version.extensions.r", 0);
    private static final int S_EXTENSION_INT = SystemProperties.getInt("build.version.extensions.s", 0);
    private static final int T_EXTENSION_INT = SystemProperties.getInt("build.version.extensions.t", 0);
    private static final int U_EXTENSION_INT = SystemProperties.getInt("build.version.extensions.u", 0);
    private static final int V_EXTENSION_INT = SystemProperties.getInt("build.version.extensions.v", 0);
    private static final int B_EXTENSION_INT = SystemProperties.getInt("build.version.extensions.b", 0);
    private static final int AD_SERVICES_EXTENSION_INT = SystemProperties.getInt("build.version.extensions.ad_services", 0);
    private static final Map<Integer, Integer> ALL_EXTENSION_INTS;

    private SdkExtensions() {
    }

    public static int getExtensionVersion(int extension) {
        if (extension < 30) {
            throw new IllegalArgumentException("not a valid extension: " + extension);
        }
        if (extension == 30) {
            return R_EXTENSION_INT;
        }
        if (extension == 31) {
            return S_EXTENSION_INT;
        }
        if (extension == 33) {
            return T_EXTENSION_INT;
        }
        if (extension == 34) {
            return U_EXTENSION_INT;
        }
        if (extension == 35) {
            return V_EXTENSION_INT;
        }
        if (extension == 36) {
            return B_EXTENSION_INT;
        }
        if (extension == 1000000) {
            return AD_SERVICES_EXTENSION_INT;
        }
        return 0;
    }

    @NonNull
    public static Map<Integer, Integer> getAllExtensionVersions() {
        return ALL_EXTENSION_INTS;
    }

    static {
        HashMap<Integer, Integer> extensions = new HashMap<Integer, Integer>();
        extensions.put(30, R_EXTENSION_INT);
        if (SdkLevel.isAtLeastS()) {
            extensions.put(31, S_EXTENSION_INT);
        }
        if (SdkLevel.isAtLeastT()) {
            extensions.put(33, T_EXTENSION_INT);
            extensions.put(1000000, AD_SERVICES_EXTENSION_INT);
        }
        if (SdkLevel.isAtLeastU()) {
            extensions.put(34, U_EXTENSION_INT);
        }
        if (SdkLevel.isAtLeastV()) {
            extensions.put(35, V_EXTENSION_INT);
        }
        if (SdkLevel.isAtLeastB()) {
            extensions.put(36, B_EXTENSION_INT);
        }
        ALL_EXTENSION_INTS = Collections.unmodifiableMap(extensions);
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface Extension {
    }
}

