/*
 * Decompiled with CFR 0.152.
 */
package android.os.connectivity;

import android.annotation.FlaggedApi;
import android.annotation.NonNull;
import android.annotation.Nullable;
import android.annotation.SystemApi;
import android.os.Parcel;
import android.os.Parcelable;
import android.ravenwood.annotation.RavenwoodKeepWholeClass;
import java.util.Arrays;
import java.util.Objects;

@SystemApi
@RavenwoodKeepWholeClass
public class WifiBatteryStats
implements Parcelable {
    private final long mLoggingDurationMillis;
    private final long mKernelActiveTimeMillis;
    private final long mNumPacketsTx;
    private final long mNumBytesTx;
    private final long mNumPacketsRx;
    private final long mNumBytesRx;
    private final long mSleepTimeMillis;
    private final long mScanTimeMillis;
    private final long mIdleTimeMillis;
    private final long mRxTimeMillis;
    private final long mTxTimeMillis;
    private final long mEnergyConsumedMaMillis;
    private final long mAppScanRequestCount;
    private final long[] mTimeInStateMillis;
    private final long[] mTimeInSupplicantStateMillis;
    private final long[] mTimeInRxSignalStrengthLevelMillis;
    private final long mMonitoredRailChargeConsumedMaMillis;
    @NonNull
    public static final Parcelable.Creator<WifiBatteryStats> CREATOR = new Parcelable.Creator<WifiBatteryStats>(){

        @Override
        public WifiBatteryStats createFromParcel(Parcel in) {
            long loggingDurationMillis = in.readLong();
            long kernelActiveTimeMillis = in.readLong();
            long numPacketsTx = in.readLong();
            long numBytesTx = in.readLong();
            long numPacketsRx = in.readLong();
            long numBytesRx = in.readLong();
            long sleepTimeMillis = in.readLong();
            long scanTimeMillis = in.readLong();
            long idleTimeMillis = in.readLong();
            long rxTimeMillis = in.readLong();
            long txTimeMillis = in.readLong();
            long energyConsumedMaMillis = in.readLong();
            long appScanRequestCount = in.readLong();
            long[] timeInStateMillis = in.createLongArray();
            long[] timeInRxSignalStrengthLevelMillis = in.createLongArray();
            long[] timeInSupplicantStateMillis = in.createLongArray();
            long monitoredRailChargeConsumedMaMillis = in.readLong();
            return new WifiBatteryStats(loggingDurationMillis, kernelActiveTimeMillis, numPacketsTx, numBytesTx, numPacketsRx, numBytesRx, sleepTimeMillis, scanTimeMillis, idleTimeMillis, rxTimeMillis, txTimeMillis, energyConsumedMaMillis, appScanRequestCount, timeInStateMillis, timeInRxSignalStrengthLevelMillis, timeInSupplicantStateMillis, monitoredRailChargeConsumedMaMillis);
        }

        public WifiBatteryStats[] newArray(int size) {
            return new WifiBatteryStats[size];
        }
    };

    @Override
    public int describeContents() {
        return 0;
    }

    @Override
    public void writeToParcel(@NonNull Parcel out, int flags) {
        out.writeLong(this.mLoggingDurationMillis);
        out.writeLong(this.mKernelActiveTimeMillis);
        out.writeLong(this.mNumPacketsTx);
        out.writeLong(this.mNumBytesTx);
        out.writeLong(this.mNumPacketsRx);
        out.writeLong(this.mNumBytesRx);
        out.writeLong(this.mSleepTimeMillis);
        out.writeLong(this.mScanTimeMillis);
        out.writeLong(this.mIdleTimeMillis);
        out.writeLong(this.mRxTimeMillis);
        out.writeLong(this.mTxTimeMillis);
        out.writeLong(this.mEnergyConsumedMaMillis);
        out.writeLong(this.mAppScanRequestCount);
        out.writeLongArray(this.mTimeInStateMillis);
        out.writeLongArray(this.mTimeInRxSignalStrengthLevelMillis);
        out.writeLongArray(this.mTimeInSupplicantStateMillis);
        out.writeLong(this.mMonitoredRailChargeConsumedMaMillis);
    }

    public boolean equals(@Nullable Object other) {
        if (!(other instanceof WifiBatteryStats)) {
            return false;
        }
        if (other == this) {
            return true;
        }
        WifiBatteryStats otherStats = (WifiBatteryStats)other;
        return this.mLoggingDurationMillis == otherStats.mLoggingDurationMillis && this.mKernelActiveTimeMillis == otherStats.mKernelActiveTimeMillis && this.mNumPacketsTx == otherStats.mNumPacketsTx && this.mNumBytesTx == otherStats.mNumBytesTx && this.mNumPacketsRx == otherStats.mNumPacketsRx && this.mNumBytesRx == otherStats.mNumBytesRx && this.mSleepTimeMillis == otherStats.mSleepTimeMillis && this.mScanTimeMillis == otherStats.mScanTimeMillis && this.mIdleTimeMillis == otherStats.mIdleTimeMillis && this.mRxTimeMillis == otherStats.mRxTimeMillis && this.mTxTimeMillis == otherStats.mTxTimeMillis && this.mEnergyConsumedMaMillis == otherStats.mEnergyConsumedMaMillis && this.mAppScanRequestCount == otherStats.mAppScanRequestCount && Arrays.equals(this.mTimeInStateMillis, otherStats.mTimeInStateMillis) && Arrays.equals(this.mTimeInSupplicantStateMillis, otherStats.mTimeInSupplicantStateMillis) && Arrays.equals(this.mTimeInRxSignalStrengthLevelMillis, otherStats.mTimeInRxSignalStrengthLevelMillis) && this.mMonitoredRailChargeConsumedMaMillis == otherStats.mMonitoredRailChargeConsumedMaMillis;
    }

    public int hashCode() {
        return Objects.hash(this.mLoggingDurationMillis, this.mKernelActiveTimeMillis, this.mNumPacketsTx, this.mNumBytesTx, this.mNumPacketsRx, this.mNumBytesRx, this.mSleepTimeMillis, this.mScanTimeMillis, this.mIdleTimeMillis, this.mRxTimeMillis, this.mTxTimeMillis, this.mEnergyConsumedMaMillis, this.mAppScanRequestCount, Arrays.hashCode(this.mTimeInStateMillis), Arrays.hashCode(this.mTimeInSupplicantStateMillis), Arrays.hashCode(this.mTimeInRxSignalStrengthLevelMillis), this.mMonitoredRailChargeConsumedMaMillis);
    }

    @FlaggedApi(value="com.android.server.power.optimization.streamlined_connectivity_battery_stats")
    public WifiBatteryStats(long loggingDurationMillis, long kernelActiveTimeMillis, long numPacketsTx, long numBytesTx, long numPacketsRx, long numBytesRx, long sleepTimeMillis, long scanTimeMillis, long idleTimeMillis, long rxTimeMillis, long txTimeMillis, long energyConsumedMaMillis, long appScanRequestCount, @NonNull long[] timeInStateMillis, @NonNull long[] timeInRxSignalStrengthLevelMillis, @NonNull long[] timeInSupplicantStateMillis, long monitoredRailChargeConsumedMaMillis) {
        this.mLoggingDurationMillis = loggingDurationMillis;
        this.mKernelActiveTimeMillis = kernelActiveTimeMillis;
        this.mNumPacketsTx = numPacketsTx;
        this.mNumBytesTx = numBytesTx;
        this.mNumPacketsRx = numPacketsRx;
        this.mNumBytesRx = numBytesRx;
        this.mSleepTimeMillis = sleepTimeMillis;
        this.mScanTimeMillis = scanTimeMillis;
        this.mIdleTimeMillis = idleTimeMillis;
        this.mRxTimeMillis = rxTimeMillis;
        this.mTxTimeMillis = txTimeMillis;
        this.mEnergyConsumedMaMillis = energyConsumedMaMillis;
        this.mAppScanRequestCount = appScanRequestCount;
        this.mTimeInStateMillis = Arrays.copyOfRange(timeInStateMillis, 0, Math.min(timeInStateMillis.length, 8));
        this.mTimeInRxSignalStrengthLevelMillis = Arrays.copyOfRange(timeInRxSignalStrengthLevelMillis, 0, Math.min(timeInRxSignalStrengthLevelMillis.length, 5));
        this.mTimeInSupplicantStateMillis = Arrays.copyOfRange(timeInSupplicantStateMillis, 0, Math.min(timeInSupplicantStateMillis.length, 13));
        this.mMonitoredRailChargeConsumedMaMillis = monitoredRailChargeConsumedMaMillis;
    }

    public long getLoggingDurationMillis() {
        return this.mLoggingDurationMillis;
    }

    public long getKernelActiveTimeMillis() {
        return this.mKernelActiveTimeMillis;
    }

    public long getNumPacketsTx() {
        return this.mNumPacketsTx;
    }

    public long getNumBytesTx() {
        return this.mNumBytesTx;
    }

    public long getNumPacketsRx() {
        return this.mNumPacketsRx;
    }

    public long getNumBytesRx() {
        return this.mNumBytesRx;
    }

    public long getSleepTimeMillis() {
        return this.mSleepTimeMillis;
    }

    public long getScanTimeMillis() {
        return this.mScanTimeMillis;
    }

    public long getIdleTimeMillis() {
        return this.mIdleTimeMillis;
    }

    public long getRxTimeMillis() {
        return this.mRxTimeMillis;
    }

    public long getTxTimeMillis() {
        return this.mTxTimeMillis;
    }

    public long getEnergyConsumedMaMillis() {
        return this.mEnergyConsumedMaMillis;
    }

    public long getAppScanRequestCount() {
        return this.mAppScanRequestCount;
    }

    public long getMonitoredRailChargeConsumedMaMillis() {
        return this.mMonitoredRailChargeConsumedMaMillis;
    }
}

