/*
 * Decompiled with CFR 0.152.
 */
package android.os;

import android.annotation.NonNull;
import android.os.Parcel;
import android.os.Parcelable;
import android.ravenwood.annotation.RavenwoodKeepWholeClass;
import java.util.ArrayList;
import java.util.List;

@RavenwoodKeepWholeClass
public class WakeLockStats
implements Parcelable {
    private final List<WakeLock> mWakeLocks;
    private final List<WakeLock> mAggregatedWakeLocks;
    @NonNull
    public static final Parcelable.Creator<WakeLockStats> CREATOR = new Parcelable.Creator<WakeLockStats>(){

        @Override
        public WakeLockStats createFromParcel(Parcel in) {
            return new WakeLockStats(in);
        }

        public WakeLockStats[] newArray(int size) {
            return new WakeLockStats[size];
        }
    };

    public WakeLockStats(@NonNull List<WakeLock> wakeLocks, @NonNull List<WakeLock> aggregatedWakeLocks) {
        this.mWakeLocks = wakeLocks;
        this.mAggregatedWakeLocks = aggregatedWakeLocks;
    }

    @NonNull
    public List<WakeLock> getWakeLocks() {
        return this.mWakeLocks;
    }

    @NonNull
    public List<WakeLock> getAggregatedWakeLocks() {
        return this.mAggregatedWakeLocks;
    }

    private WakeLockStats(Parcel in) {
        int wakelockSize = in.readInt();
        this.mWakeLocks = new ArrayList<WakeLock>(wakelockSize);
        for (int i = 0; i < wakelockSize; ++i) {
            this.mWakeLocks.add(new WakeLock(in));
        }
        int aggregatedWakelockSize = in.readInt();
        this.mAggregatedWakeLocks = new ArrayList<WakeLock>(aggregatedWakelockSize);
        for (int i = 0; i < aggregatedWakelockSize; ++i) {
            this.mAggregatedWakeLocks.add(new WakeLock(in));
        }
    }

    @Override
    public void writeToParcel(@NonNull Parcel out, int flags) {
        int wakelockSize = this.mWakeLocks.size();
        out.writeInt(wakelockSize);
        for (int i = 0; i < wakelockSize; ++i) {
            WakeLock stats = this.mWakeLocks.get(i);
            stats.writeToParcel(out);
        }
        int aggregatedWakelockSize = this.mAggregatedWakeLocks.size();
        out.writeInt(aggregatedWakelockSize);
        for (int i = 0; i < aggregatedWakelockSize; ++i) {
            WakeLock stats = this.mAggregatedWakeLocks.get(i);
            stats.writeToParcel(out);
        }
    }

    @Override
    public int describeContents() {
        return 0;
    }

    public String toString() {
        return "WakeLockStats{mWakeLocks: [" + this.mWakeLocks + "], mAggregatedWakeLocks: [" + this.mAggregatedWakeLocks + "]" + '}';
    }

    public static class WakeLock {
        public static final String NAME_AGGREGATED = "wakelockstats_aggregated";
        public final int uid;
        @NonNull
        public final String name;
        public final boolean isAggregated;
        @NonNull
        public final WakeLockData totalWakeLockData;
        @NonNull
        public final WakeLockData backgroundWakeLockData;

        public WakeLock(int uid, @NonNull String name, boolean isAggregated, @NonNull WakeLockData totalWakeLockData, @NonNull WakeLockData backgroundWakeLockData) {
            this.uid = uid;
            this.name = name;
            this.isAggregated = isAggregated;
            this.totalWakeLockData = totalWakeLockData;
            this.backgroundWakeLockData = backgroundWakeLockData;
        }

        public static boolean isDataValid(WakeLockData totalWakeLockData, WakeLockData backgroundWakeLockData) {
            return totalWakeLockData.totalTimeHeldMs > 0L && totalWakeLockData.isDataValid() && backgroundWakeLockData.isDataValid() && totalWakeLockData.timesAcquired >= backgroundWakeLockData.timesAcquired && totalWakeLockData.totalTimeHeldMs >= backgroundWakeLockData.totalTimeHeldMs && totalWakeLockData.timeHeldMs >= backgroundWakeLockData.timeHeldMs;
        }

        private WakeLock(Parcel in) {
            this.uid = in.readInt();
            this.name = in.readString();
            this.isAggregated = in.readBoolean();
            this.totalWakeLockData = new WakeLockData(in);
            this.backgroundWakeLockData = new WakeLockData(in);
        }

        private void writeToParcel(Parcel out) {
            out.writeInt(this.uid);
            out.writeString(this.name);
            out.writeBoolean(this.isAggregated);
            this.totalWakeLockData.writeToParcel(out);
            this.backgroundWakeLockData.writeToParcel(out);
        }

        public String toString() {
            return "WakeLock{uid=" + this.uid + ", name='" + this.name + '\'' + ", isAggregated=" + this.isAggregated + ", totalWakeLockData=" + this.totalWakeLockData + ", backgroundWakeLockData=" + this.backgroundWakeLockData + '}';
        }
    }

    public static class WakeLockData {
        public static final WakeLockData EMPTY = new WakeLockData(0, 0L, 0L);
        public final int timesAcquired;
        public final long totalTimeHeldMs;
        public final long timeHeldMs;

        public WakeLockData(int timesAcquired, long totalTimeHeldMs, long timeHeldMs) {
            this.timesAcquired = timesAcquired;
            this.totalTimeHeldMs = totalTimeHeldMs;
            this.timeHeldMs = timeHeldMs;
        }

        public boolean isDataValid() {
            boolean isDataReasonable = this.timesAcquired > 0 && this.totalTimeHeldMs > 0L && this.timeHeldMs >= 0L && this.totalTimeHeldMs >= this.timeHeldMs;
            return this.isEmpty() || isDataReasonable;
        }

        private boolean isEmpty() {
            return this.timesAcquired == 0 && this.totalTimeHeldMs == 0L && this.timeHeldMs == 0L;
        }

        private WakeLockData(Parcel in) {
            this.timesAcquired = in.readInt();
            this.totalTimeHeldMs = in.readLong();
            this.timeHeldMs = in.readLong();
        }

        private void writeToParcel(Parcel out) {
            out.writeInt(this.timesAcquired);
            out.writeLong(this.totalTimeHeldMs);
            out.writeLong(this.timeHeldMs);
        }

        public String toString() {
            return "WakeLockData{timesAcquired=" + this.timesAcquired + ", totalTimeHeldMs=" + this.totalTimeHeldMs + ", timeHeldMs=" + this.timeHeldMs + "}";
        }
    }
}

