/*
 * Decompiled with CFR 0.152.
 */
package android.os;

import android.annotation.NonNull;
import android.annotation.Nullable;
import android.os.BatteryConsumer;
import android.os.BatteryStats;
import android.os.BatteryUsageStats;
import android.os.PowerComponents;
import android.os.UserHandle;
import android.ravenwood.annotation.RavenwoodKeepWholeClass;
import android.text.TextUtils;
import com.android.modules.utils.TypedXmlPullParser;
import com.android.modules.utils.TypedXmlSerializer;
import java.io.IOException;
import java.io.PrintWriter;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import org.xmlpull.v1.XmlPullParserException;

@RavenwoodKeepWholeClass
public class UidBatteryConsumer
extends BatteryConsumer {
    static final int CONSUMER_TYPE_UID = 1;
    public static final int STATE_FOREGROUND = 0;
    public static final int STATE_BACKGROUND = 1;
    static final int COLUMN_INDEX_UID = 1;
    static final int COLUMN_INDEX_PACKAGE_WITH_HIGHEST_DRAIN = 2;
    static final int COLUMN_COUNT = 3;

    UidBatteryConsumer(BatteryConsumer.BatteryConsumerData data) {
        super(data);
    }

    private UidBatteryConsumer(@NonNull Builder builder) {
        super(builder.mData, builder.mPowerComponentsBuilder.build());
    }

    public int getUid() {
        return this.mData.getInt(1);
    }

    @Nullable
    public String getPackageWithHighestDrain() {
        return this.mData.getString(2);
    }

    @Deprecated
    public long getTimeInStateMs(int state) {
        switch (state) {
            case 1: {
                return this.getTimeInProcessStateMs(2) + this.getTimeInProcessStateMs(3);
            }
            case 0: {
                return this.getTimeInProcessStateMs(1);
            }
        }
        return 0L;
    }

    public long getTimeInProcessStateMs(int state) {
        BatteryConsumer.Key key;
        if (state != 0 && (key = this.getKey(18, state)) != null) {
            return this.getUsageDurationMillis(key);
        }
        return 0L;
    }

    @Override
    public void dump(PrintWriter pw, boolean skipEmptyComponents) {
        pw.print("UID ");
        UserHandle.formatUid(pw, this.getUid());
        pw.print(": ");
        pw.print(BatteryStats.formatCharge(this.getConsumedPower()));
        StringBuilder sb = new StringBuilder();
        this.appendProcessStateData(sb, 1, skipEmptyComponents);
        this.appendProcessStateData(sb, 2, skipEmptyComponents);
        this.appendProcessStateData(sb, 3, skipEmptyComponents);
        this.appendProcessStateData(sb, 4, skipEmptyComponents);
        pw.println(sb);
        pw.print("      ");
        this.mPowerComponents.dump(pw, 0, 0, skipEmptyComponents);
        if (this.mData.layout.powerStateDataIncluded || this.mData.layout.screenStateDataIncluded) {
            for (int powerState = 0; powerState < 3; ++powerState) {
                if (this.mData.layout.powerStateDataIncluded && powerState == 0) continue;
                for (int screenState = 0; screenState < 3; ++screenState) {
                    double consumedPower;
                    if (this.mData.layout.screenStateDataIncluded && screenState == 0 || (consumedPower = this.mPowerComponents.getConsumedPower(-1, -1, screenState, powerState)) == 0.0) continue;
                    pw.print("      (");
                    if (powerState != 0) {
                        pw.print(BatteryConsumer.powerStateToString(powerState));
                    }
                    if (screenState != 0) {
                        if (powerState != 0) {
                            pw.print(", ");
                        }
                        pw.print("screen ");
                        pw.print(BatteryConsumer.screenStateToString(screenState));
                    }
                    pw.print(") ");
                    this.mPowerComponents.dump(pw, screenState, powerState, skipEmptyComponents);
                }
            }
        }
    }

    private void appendProcessStateData(StringBuilder sb, int processState, boolean skipEmptyComponents) {
        long durationMs;
        BatteryConsumer.Dimensions dimensions = new BatteryConsumer.Dimensions(-1, processState);
        double power = this.mPowerComponents.getConsumedPower(dimensions);
        BatteryConsumer.Key key = this.getKey(18, processState);
        long l = durationMs = key != null ? this.mPowerComponents.getUsageDurationMillis(key) : 0L;
        if (power == 0.0 && durationMs == 0L && skipEmptyComponents) {
            return;
        }
        sb.append(" ").append(UidBatteryConsumer.processStateToString(processState)).append(": ").append(BatteryStats.formatCharge(power));
        if (durationMs != 0L) {
            sb.append(" (");
            BatteryStats.formatTimeMsNoSpace(sb, durationMs);
            sb.append(")");
        }
    }

    void writeToXml(TypedXmlSerializer serializer) throws IOException {
        if (this.getConsumedPower() == 0.0) {
            return;
        }
        serializer.startTag(null, "uid");
        serializer.attributeInt(null, "uid", this.getUid());
        String packageWithHighestDrain = this.getPackageWithHighestDrain();
        if (!TextUtils.isEmpty(packageWithHighestDrain)) {
            serializer.attribute(null, "highest_drain_package", packageWithHighestDrain);
        }
        this.mPowerComponents.writeToXml(serializer);
        serializer.endTag(null, "uid");
    }

    static void createFromXml(TypedXmlPullParser parser, BatteryUsageStats.Builder builder) throws XmlPullParserException, IOException {
        int uid = parser.getAttributeInt(null, "uid");
        Builder consumerBuilder = builder.getOrCreateUidBatteryConsumerBuilder(uid);
        int eventType = parser.getEventType();
        if (eventType != 2 || !parser.getName().equals("uid")) {
            throw new XmlPullParserException("Invalid XML parser state");
        }
        consumerBuilder.setPackageWithHighestDrain(parser.getAttributeValue(null, "highest_drain_package"));
        while (!(eventType == 3 && parser.getName().equals("uid") || eventType == 1)) {
            if (eventType == 2 && parser.getName().equals("power_components")) {
                PowerComponents.parseXml(parser, consumerBuilder.mPowerComponentsBuilder);
            }
            eventType = parser.next();
        }
    }

    @RavenwoodKeepWholeClass
    public static class Builder
    extends BatteryConsumer.BaseBuilder<Builder> {
        private static final String PACKAGE_NAME_UNINITIALIZED = "";
        private final BatteryStats.Uid mBatteryStatsUid;
        private final int mUid;
        private final boolean mIsVirtualUid;
        private String mPackageWithHighestDrain = "";
        private boolean mExcludeFromBatteryUsageStats;

        public Builder(BatteryConsumer.BatteryConsumerData data, @NonNull BatteryStats.Uid batteryStatsUid, double minConsumedPowerThreshold) {
            this(data, batteryStatsUid, batteryStatsUid.getUid(), minConsumedPowerThreshold);
        }

        public Builder(BatteryConsumer.BatteryConsumerData data, int uid, double minConsumedPowerThreshold) {
            this(data, null, uid, minConsumedPowerThreshold);
        }

        private Builder(BatteryConsumer.BatteryConsumerData data, @Nullable BatteryStats.Uid batteryStatsUid, int uid, double minConsumedPowerThreshold) {
            super(data, 1, minConsumedPowerThreshold);
            this.mBatteryStatsUid = batteryStatsUid;
            this.mUid = uid;
            this.mIsVirtualUid = this.mUid == 1090;
            data.putLong(1, this.mUid);
        }

        @NonNull
        public BatteryStats.Uid getBatteryStatsUid() {
            if (this.mBatteryStatsUid == null) {
                throw new IllegalStateException("UidBatteryConsumer.Builder was initialized without a BatteryStats.Uid");
            }
            return this.mBatteryStatsUid;
        }

        public int getUid() {
            return this.mUid;
        }

        public boolean isVirtualUid() {
            return this.mIsVirtualUid;
        }

        @NonNull
        public Builder setPackageWithHighestDrain(@Nullable String packageName) {
            this.mPackageWithHighestDrain = TextUtils.nullIfEmpty(packageName);
            return this;
        }

        @Deprecated
        @NonNull
        public Builder setTimeInStateMs(int state, long timeInStateMs) {
            switch (state) {
                case 0: {
                    this.setTimeInProcessStateMs(1, timeInStateMs);
                    break;
                }
                case 1: {
                    this.setTimeInProcessStateMs(2, timeInStateMs);
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Unsupported state: " + state);
                }
            }
            return this;
        }

        @Deprecated
        @NonNull
        public Builder setTimeInProcessStateMs(int state, long timeInProcessStateMs) {
            BatteryConsumer.Key key = this.getKey(18, state);
            if (key != null) {
                this.mData.putLong(key.mDurationColumnIndex, timeInProcessStateMs);
            }
            return this;
        }

        public Builder excludeFromBatteryUsageStats() {
            this.mExcludeFromBatteryUsageStats = true;
            return this;
        }

        public Builder add(UidBatteryConsumer consumer) {
            this.mPowerComponentsBuilder.addPowerAndDuration(consumer.mPowerComponents);
            if (this.mPackageWithHighestDrain == PACKAGE_NAME_UNINITIALIZED) {
                this.mPackageWithHighestDrain = consumer.getPackageWithHighestDrain();
            } else if (!TextUtils.equals(this.mPackageWithHighestDrain, consumer.getPackageWithHighestDrain())) {
                this.mPackageWithHighestDrain = null;
            }
            return this;
        }

        public boolean isExcludedFromBatteryUsageStats() {
            return this.mExcludeFromBatteryUsageStats;
        }

        @NonNull
        public UidBatteryConsumer build() {
            if (this.mPackageWithHighestDrain == PACKAGE_NAME_UNINITIALIZED) {
                this.mPackageWithHighestDrain = null;
            }
            if (this.mPackageWithHighestDrain != null) {
                this.mData.putString(2, this.mPackageWithHighestDrain);
            }
            return new UidBatteryConsumer(this);
        }
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface State {
    }
}

