/*
 * Decompiled with CFR 0.152.
 */
package android.os;

import android.annotation.FlaggedApi;
import android.annotation.NonNull;
import android.os.Bundle;
import android.os.ISecurityStateManager;
import android.os.RemoteException;
import java.util.Objects;

@FlaggedApi(value="android.os.security_state_service")
public class SecurityStateManager {
    public static final String KEY_SYSTEM_SPL = "system_spl";
    public static final String KEY_VENDOR_SPL = "vendor_spl";
    public static final String KEY_KERNEL_VERSION = "kernel_version";
    private final ISecurityStateManager mService;

    public SecurityStateManager(ISecurityStateManager service) {
        this.mService = Objects.requireNonNull(service, "missing ISecurityStateManager");
    }

    @FlaggedApi(value="android.os.security_state_service")
    @NonNull
    public Bundle getGlobalSecurityState() {
        try {
            return this.mService.getGlobalSecurityState();
        }
        catch (RemoteException re) {
            throw re.rethrowFromSystemServer();
        }
    }
}

