/*
 * Decompiled with CFR 0.152.
 */
package android.os;

import android.annotation.FlaggedApi;
import android.annotation.NonNull;
import android.annotation.Nullable;
import android.os.Parcel;
import android.os.Parcelable;
import android.os.profiling.Flags;
import android.text.TextUtils;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.Objects;

@FlaggedApi(value="android.os.profiling.telemetry_apis")
public class ProfilingResult
implements Parcelable {
    final int mErrorCode;
    @Nullable
    final String mResultFilePath;
    @Nullable
    final String mTag;
    @Nullable
    final String mErrorMessage;
    final int mTriggerType;
    public static final int ERROR_NONE = 0;
    public static final int ERROR_FAILED_RATE_LIMIT_SYSTEM = 1;
    public static final int ERROR_FAILED_RATE_LIMIT_PROCESS = 2;
    public static final int ERROR_FAILED_PROFILING_IN_PROGRESS = 3;
    public static final int ERROR_FAILED_EXECUTING = 4;
    public static final int ERROR_FAILED_POST_PROCESSING = 5;
    public static final int ERROR_FAILED_NO_DISK_SPACE = 6;
    public static final int ERROR_FAILED_INVALID_REQUEST = 7;
    public static final int ERROR_UNKNOWN = 8;
    @NonNull
    public static final Parcelable.Creator<ProfilingResult> CREATOR = new Parcelable.Creator<ProfilingResult>(){

        @Override
        public ProfilingResult createFromParcel(Parcel in) {
            return new ProfilingResult(in);
        }

        public ProfilingResult[] newArray(int size) {
            return new ProfilingResult[size];
        }
    };

    public ProfilingResult(int errorCode, String resultFilePath, String tag, String errorMessage, int triggerType) {
        this.mErrorCode = errorCode;
        this.mResultFilePath = resultFilePath;
        this.mTag = tag;
        this.mErrorMessage = errorMessage;
        this.mTriggerType = triggerType;
    }

    public ProfilingResult(@NonNull Parcel in) {
        this.mErrorCode = in.readInt();
        this.mResultFilePath = in.readString();
        this.mTag = in.readString();
        this.mErrorMessage = in.readString();
        this.mTriggerType = in.readInt();
    }

    @Override
    public void writeToParcel(@NonNull Parcel dest, int flags) {
        dest.writeInt(this.mErrorCode);
        dest.writeString(this.mResultFilePath);
        dest.writeString(this.mTag);
        dest.writeString(this.mErrorMessage);
        dest.writeInt(this.mTriggerType);
    }

    @Override
    public int describeContents() {
        return 0;
    }

    public int getErrorCode() {
        return this.mErrorCode;
    }

    @Nullable
    public String getResultFilePath() {
        return this.mResultFilePath;
    }

    @Nullable
    public String getTag() {
        return this.mTag;
    }

    @Nullable
    public String getErrorMessage() {
        return this.mErrorMessage;
    }

    @FlaggedApi(value="android.os.profiling.system_triggered_profiling_new")
    public int getTriggerType() {
        return this.mTriggerType;
    }

    public boolean equals(@Nullable Object other) {
        if (other == null || !(other instanceof ProfilingResult)) {
            return false;
        }
        ProfilingResult o = (ProfilingResult)other;
        if (Flags.systemTriggeredProfilingNew() && this.mTriggerType != o.getTriggerType()) {
            return false;
        }
        return this.mErrorCode == o.getErrorCode() && TextUtils.equals(this.mResultFilePath, o.getResultFilePath()) && TextUtils.equals(this.mTag, o.getTag()) && TextUtils.equals(this.mErrorMessage, o.getErrorMessage());
    }

    public int hashCode() {
        return Objects.hash(this.mErrorCode, this.mResultFilePath, this.mTag, this.mErrorMessage, this.mTriggerType);
    }

    @Retention(value=RetentionPolicy.SOURCE)
    static @interface ErrorCode {
    }
}

