/*
 * Decompiled with CFR 0.152.
 */
package android.os;

import android.annotation.NonNull;
import android.annotation.Nullable;
import android.annotation.SuppressLint;
import android.annotation.SystemApi;
import android.graphics.Bitmap;
import android.os.PersistableBundle;
import android.text.TextUtils;

@SystemApi
@SuppressLint(value={"PackageLayering"})
public class NewUserRequest {
    @Nullable
    private final String mName;
    private final boolean mAdmin;
    private final boolean mEphemeral;
    @NonNull
    private final String mUserType;
    private final Bitmap mUserIcon;
    private final String mAccountName;
    private final String mAccountType;
    private final PersistableBundle mAccountOptions;

    private NewUserRequest(Builder builder) {
        this.mName = builder.mName;
        this.mAdmin = builder.mAdmin;
        this.mEphemeral = builder.mEphemeral;
        this.mUserType = builder.mUserType;
        this.mUserIcon = builder.mUserIcon;
        this.mAccountName = builder.mAccountName;
        this.mAccountType = builder.mAccountType;
        this.mAccountOptions = builder.mAccountOptions;
    }

    @Nullable
    public String getName() {
        return this.mName;
    }

    public boolean isEphemeral() {
        return this.mEphemeral;
    }

    public boolean isAdmin() {
        return this.mAdmin;
    }

    int getFlags() {
        int flags = 0;
        if (this.isAdmin()) {
            flags |= 2;
        }
        if (this.isEphemeral()) {
            flags |= 0x100;
        }
        return flags;
    }

    @NonNull
    public String getUserType() {
        return this.mUserType;
    }

    @Nullable
    public Bitmap getUserIcon() {
        return this.mUserIcon;
    }

    @Nullable
    public String getAccountName() {
        return this.mAccountName;
    }

    @Nullable
    public String getAccountType() {
        return this.mAccountType;
    }

    @SuppressLint(value={"NullableCollection"})
    @Nullable
    public PersistableBundle getAccountOptions() {
        return this.mAccountOptions;
    }

    public String toString() {
        return "NewUserRequest{mName='" + this.mName + '\'' + ", mAdmin=" + this.mAdmin + ", mEphemeral=" + this.mEphemeral + ", mUserType='" + this.mUserType + '\'' + ", mAccountName='" + this.mAccountName + '\'' + ", mAccountType='" + this.mAccountType + '\'' + ", mAccountOptions=" + this.mAccountOptions + '}';
    }

    @SuppressLint(value={"PackageLayering"})
    public static class Builder {
        private String mName;
        private boolean mAdmin;
        private boolean mEphemeral;
        private String mUserType = "android.os.usertype.full.SECONDARY";
        private Bitmap mUserIcon;
        private String mAccountName;
        private String mAccountType;
        private PersistableBundle mAccountOptions;

        @NonNull
        public Builder setName(@Nullable String name) {
            this.mName = name;
            return this;
        }

        @NonNull
        public Builder setAdmin() {
            this.mAdmin = true;
            return this;
        }

        @NonNull
        public Builder setEphemeral() {
            this.mEphemeral = true;
            return this;
        }

        @NonNull
        public Builder setUserType(@NonNull String type) {
            this.mUserType = type;
            return this;
        }

        @NonNull
        public Builder setUserIcon(@Nullable Bitmap userIcon) {
            this.mUserIcon = userIcon;
            return this;
        }

        @NonNull
        public Builder setAccountName(@Nullable String accountName) {
            this.mAccountName = accountName;
            return this;
        }

        @NonNull
        public Builder setAccountType(@Nullable String accountType) {
            this.mAccountType = accountType;
            return this;
        }

        @NonNull
        public Builder setAccountOptions(@Nullable PersistableBundle accountOptions) {
            this.mAccountOptions = accountOptions;
            return this;
        }

        @NonNull
        public NewUserRequest build() {
            this.checkIfPropertiesAreCompatible();
            return new NewUserRequest(this);
        }

        private void checkIfPropertiesAreCompatible() {
            if (this.mUserType == null) {
                throw new IllegalStateException("Usertype cannot be null");
            }
            if (this.mAdmin && !this.mUserType.equals("android.os.usertype.full.SECONDARY")) {
                throw new IllegalStateException("Admin user can't be of type: " + this.mUserType);
            }
            if (TextUtils.isEmpty(this.mAccountName) != TextUtils.isEmpty(this.mAccountType)) {
                throw new IllegalStateException("Account name and account type should be provided together.");
            }
        }
    }
}

