/*
 * Decompiled with CFR 0.152.
 */
package android.os;

import android.annotation.NonNull;
import android.annotation.Nullable;
import android.annotation.SuppressLint;
import android.compat.annotation.UnsupportedAppUsage;
import android.icu.util.ULocale;
import android.os.Parcel;
import android.os.Parcelable;
import android.ravenwood.annotation.RavenwoodKeepWholeClass;
import com.android.internal.annotations.GuardedBy;
import com.android.layoutlib.bridge.android.AndroidLocale;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Locale;

@RavenwoodKeepWholeClass
public class LocaleList
implements Parcelable {
    private final Locale[] mList;
    @NonNull
    private final String mStringRepresentation;
    private static final Locale[] sEmptyList = new Locale[0];
    private static final LocaleList sEmptyLocaleList = new LocaleList(new Locale[0]);
    @NonNull
    public static final Parcelable.Creator<LocaleList> CREATOR = new Parcelable.Creator<LocaleList>(){

        @Override
        public LocaleList createFromParcel(Parcel source) {
            return LocaleList.forLanguageTags(source.readString8());
        }

        public LocaleList[] newArray(int size) {
            return new LocaleList[size];
        }
    };
    private static final String STRING_EN_XA = "en-XA";
    private static final String STRING_AR_XB = "ar-XB";
    private static final Locale LOCALE_EN_XA = new Locale("en", "XA");
    private static final Locale LOCALE_AR_XB = new Locale("ar", "XB");
    private static final int NUM_PSEUDO_LOCALES = 2;
    private static final Locale EN_LATN = Locale.forLanguageTag("en-Latn");
    private static final Object sLock = new Object();
    @GuardedBy(value={"sLock"})
    private static LocaleList sLastExplicitlySetLocaleList = null;
    @GuardedBy(value={"sLock"})
    private static LocaleList sDefaultLocaleList = null;
    @GuardedBy(value={"sLock"})
    private static LocaleList sDefaultAdjustedLocaleList = null;
    @GuardedBy(value={"sLock"})
    private static Locale sLastDefaultLocale = null;

    public Locale get(int index) {
        return 0 <= index && index < this.mList.length ? this.mList[index] : null;
    }

    public boolean isEmpty() {
        return this.mList.length == 0;
    }

    public int size() {
        return this.mList.length;
    }

    public int indexOf(Locale locale) {
        for (int i = 0; i < this.mList.length; ++i) {
            if (!((Object)this.mList[i]).equals(locale)) continue;
            return i;
        }
        return -1;
    }

    public boolean equals(@Nullable Object other) {
        if (other == this) {
            return true;
        }
        if (!(other instanceof LocaleList)) {
            return false;
        }
        Locale[] otherList = ((LocaleList)other).mList;
        if (this.mList.length != otherList.length) {
            return false;
        }
        for (int i = 0; i < this.mList.length; ++i) {
            if (((Object)this.mList[i]).equals(otherList[i])) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        int result = 1;
        for (int i = 0; i < this.mList.length; ++i) {
            result = 31 * result + ((Object)this.mList[i]).hashCode();
        }
        return result;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("[");
        for (int i = 0; i < this.mList.length; ++i) {
            sb.append(this.mList[i]);
            if (i >= this.mList.length - 1) continue;
            sb.append(',');
        }
        sb.append("]");
        return sb.toString();
    }

    @Override
    public int describeContents() {
        return 0;
    }

    @Override
    public void writeToParcel(Parcel dest, int parcelableFlags) {
        dest.writeString8(this.mStringRepresentation);
    }

    @NonNull
    public String toLanguageTags() {
        return this.mStringRepresentation;
    }

    @NonNull
    public Locale[] getIntersection(@NonNull LocaleList other) {
        ArrayList<Locale> intersection = new ArrayList<Locale>();
        block0: for (Locale l1 : this.mList) {
            for (Locale l2 : other.mList) {
                if (!LocaleList.matchesLanguageAndScript(l2, l1)) continue;
                intersection.add(l1);
                continue block0;
            }
        }
        return intersection.toArray(new Locale[0]);
    }

    public LocaleList(Locale ... list) {
        if (list.length == 0) {
            this.mList = sEmptyList;
            this.mStringRepresentation = "";
        } else {
            ArrayList<Locale> localeList = new ArrayList<Locale>();
            HashSet<Locale> seenLocales = new HashSet<Locale>();
            StringBuilder sb = new StringBuilder();
            for (int i = 0; i < list.length; ++i) {
                Locale l = list[i];
                if (l == null) {
                    throw new NullPointerException("list[" + i + "] is null");
                }
                if (seenLocales.contains(l)) continue;
                Locale localeClone = (Locale)l.clone();
                localeList.add(localeClone);
                sb.append(localeClone.toLanguageTag());
                if (i < list.length - 1) {
                    sb.append(',');
                }
                seenLocales.add(localeClone);
            }
            this.mList = localeList.toArray(new Locale[localeList.size()]);
            this.mStringRepresentation = sb.toString();
        }
    }

    public LocaleList(@NonNull Locale topLocale, LocaleList otherLocales) {
        int i;
        if (topLocale == null) {
            throw new NullPointerException("topLocale is null");
        }
        int inputLength = otherLocales == null ? 0 : otherLocales.mList.length;
        int topLocaleIndex = -1;
        for (int i2 = 0; i2 < inputLength; ++i2) {
            if (!((Object)topLocale).equals(otherLocales.mList[i2])) continue;
            topLocaleIndex = i2;
            break;
        }
        int outputLength = inputLength + (topLocaleIndex == -1 ? 1 : 0);
        Locale[] localeList = new Locale[outputLength];
        localeList[0] = (Locale)topLocale.clone();
        if (topLocaleIndex == -1) {
            for (i = 0; i < inputLength; ++i) {
                localeList[i + 1] = (Locale)otherLocales.mList[i].clone();
            }
        } else {
            for (i = 0; i < topLocaleIndex; ++i) {
                localeList[i + 1] = (Locale)otherLocales.mList[i].clone();
            }
            for (i = topLocaleIndex + 1; i < inputLength; ++i) {
                localeList[i] = (Locale)otherLocales.mList[i].clone();
            }
        }
        StringBuilder sb = new StringBuilder();
        for (int i3 = 0; i3 < outputLength; ++i3) {
            sb.append(localeList[i3].toLanguageTag());
            if (i3 >= outputLength - 1) continue;
            sb.append(',');
        }
        this.mList = localeList;
        this.mStringRepresentation = sb.toString();
    }

    @NonNull
    public static LocaleList getEmptyLocaleList() {
        return sEmptyLocaleList;
    }

    @NonNull
    public static LocaleList forLanguageTags(@Nullable String list) {
        if (list == null || list.equals("")) {
            return LocaleList.getEmptyLocaleList();
        }
        String[] tags = list.split(",");
        Locale[] localeArray = new Locale[tags.length];
        for (int i = 0; i < localeArray.length; ++i) {
            localeArray[i] = Locale.forLanguageTag(tags[i]);
        }
        return new LocaleList(localeArray);
    }

    private static String getLikelyScript(Locale locale) {
        String script = locale.getScript();
        if (!script.isEmpty()) {
            return script;
        }
        return ULocale.addLikelySubtags(ULocale.forLocale(locale)).getScript();
    }

    private static boolean isPseudoLocale(String locale) {
        return STRING_EN_XA.equals(locale) || STRING_AR_XB.equals(locale);
    }

    public static boolean isPseudoLocale(Locale locale) {
        return ((Object)LOCALE_EN_XA).equals(locale) || ((Object)LOCALE_AR_XB).equals(locale);
    }

    public static boolean isPseudoLocale(@Nullable ULocale locale) {
        return LocaleList.isPseudoLocale(locale != null ? locale.toLocale() : null);
    }

    public static boolean matchesLanguageAndScript(@SuppressLint(value={"UseIcu"}) @NonNull Locale supported, @SuppressLint(value={"UseIcu"}) @NonNull Locale desired) {
        if (((Object)supported).equals(desired)) {
            return true;
        }
        if (!supported.getLanguage().equals(desired.getLanguage())) {
            return false;
        }
        if (LocaleList.isPseudoLocale(supported) || LocaleList.isPseudoLocale(desired)) {
            return false;
        }
        String supportedScr = LocaleList.getLikelyScript(supported);
        if (supportedScr.isEmpty()) {
            String supportedRegion = supported.getCountry();
            return supportedRegion.isEmpty() || supportedRegion.equals(desired.getCountry());
        }
        String desiredScr = LocaleList.getLikelyScript(desired);
        return supportedScr.equals(desiredScr);
    }

    private int findFirstMatchIndex(Locale supportedLocale) {
        for (int idx = 0; idx < this.mList.length; ++idx) {
            if (!LocaleList.matchesLanguageAndScript(supportedLocale, this.mList[idx])) continue;
            return idx;
        }
        return Integer.MAX_VALUE;
    }

    private int computeFirstMatchIndex(Collection<String> supportedLocales, boolean assumeEnglishIsSupported) {
        if (this.mList.length == 1) {
            return 0;
        }
        if (this.mList.length == 0) {
            return -1;
        }
        int bestIndex = Integer.MAX_VALUE;
        if (assumeEnglishIsSupported) {
            int idx = this.findFirstMatchIndex(EN_LATN);
            if (idx == 0) {
                return 0;
            }
            if (idx < bestIndex) {
                bestIndex = idx;
            }
        }
        for (String languageTag : supportedLocales) {
            Locale supportedLocale = Locale.forLanguageTag(languageTag);
            int idx = this.findFirstMatchIndex(supportedLocale);
            if (idx == 0) {
                return 0;
            }
            if (idx >= bestIndex) continue;
            bestIndex = idx;
        }
        if (bestIndex == Integer.MAX_VALUE) {
            return 0;
        }
        return bestIndex;
    }

    private Locale computeFirstMatch(Collection<String> supportedLocales, boolean assumeEnglishIsSupported) {
        int bestIndex = this.computeFirstMatchIndex(supportedLocales, assumeEnglishIsSupported);
        return bestIndex == -1 ? null : this.mList[bestIndex];
    }

    @Nullable
    public Locale getFirstMatch(String[] supportedLocales) {
        return this.computeFirstMatch(Arrays.asList(supportedLocales), false);
    }

    public int getFirstMatchIndex(String[] supportedLocales) {
        return this.computeFirstMatchIndex(Arrays.asList(supportedLocales), false);
    }

    @Nullable
    public Locale getFirstMatchWithEnglishSupported(String[] supportedLocales) {
        return this.computeFirstMatch(Arrays.asList(supportedLocales), true);
    }

    public int getFirstMatchIndexWithEnglishSupported(Collection<String> supportedLocales) {
        return this.computeFirstMatchIndex(supportedLocales, true);
    }

    public int getFirstMatchIndexWithEnglishSupported(String[] supportedLocales) {
        return this.getFirstMatchIndexWithEnglishSupported(Arrays.asList(supportedLocales));
    }

    public static boolean isPseudoLocalesOnly(@Nullable String[] supportedLocales) {
        if (supportedLocales == null) {
            return true;
        }
        if (supportedLocales.length > 3) {
            return false;
        }
        for (String locale : supportedLocales) {
            if (locale.isEmpty() || LocaleList.isPseudoLocale(locale)) continue;
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NonNull
    public static LocaleList getDefault() {
        Locale defaultLocale = AndroidLocale.getDefault();
        Object object = sLock;
        synchronized (object) {
            if (!((Object)defaultLocale).equals(sLastDefaultLocale)) {
                sLastDefaultLocale = defaultLocale;
                if (sDefaultLocaleList != null && ((Object)defaultLocale).equals(sDefaultLocaleList.get(0))) {
                    return sDefaultLocaleList;
                }
                sDefaultAdjustedLocaleList = sDefaultLocaleList = new LocaleList(defaultLocale, sLastExplicitlySetLocaleList);
            }
            return sDefaultLocaleList;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NonNull
    public static LocaleList getAdjustedDefault() {
        LocaleList.getDefault();
        Object object = sLock;
        synchronized (object) {
            return sDefaultAdjustedLocaleList;
        }
    }

    public static void setDefault(@NonNull LocaleList locales) {
        LocaleList.setDefault(locales, 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @UnsupportedAppUsage(maxTargetSdk=30, trackingBug=170729553L)
    public static void setDefault(@NonNull LocaleList locales, int localeIndex) {
        if (locales == null) {
            throw new NullPointerException("locales is null");
        }
        if (locales.isEmpty()) {
            throw new IllegalArgumentException("locales is empty");
        }
        Object object = sLock;
        synchronized (object) {
            sLastDefaultLocale = locales.get(localeIndex);
            Locale.setDefault(sLastDefaultLocale);
            sLastExplicitlySetLocaleList = locales;
            sDefaultLocaleList = locales;
            sDefaultAdjustedLocaleList = localeIndex == 0 ? sDefaultLocaleList : new LocaleList(sLastDefaultLocale, sDefaultLocaleList);
        }
    }
}

